/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.net.URL;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.ITestContext;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.wso2.am.admin.clients.webapp.WebAppAdminClient;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class AdvancedWebAppDeploymentConfig
extends APIManagerLifecycleBaseTest {
    private static final Log log = LogFactory.getLog(AdvancedWebAppDeploymentConfig.class);
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private String apiEndPointUrl;
    private String providerName;
    private WebAppAdminClient webAppAdminClient;
    private String apiId;
    private String applicationID;
    private String accessToken;
    private String gatewaySessionCookie;

    @BeforeTest(alwaysRun=true)
    public void deployWebApps(ITestContext ctx) throws Exception {
        super.init();
        this.initialize(ctx);
    }

    @AfterTest(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        this.restAPIStore.deleteApplication(this.applicationID);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.apiId, this.restAPIPublisher);
        this.restAPIPublisher.deleteAPI(this.apiId);
    }

    private void initialize(ITestContext ctx) throws Exception {
        this.apiEndPointUrl = this.backEndServerUrl.getWebAppURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        this.providerName = this.user.getUserName();
        this.createAPIs(ctx);
    }

    private void createAPIs(ITestContext ctx) throws Exception {
        HttpResponse applicationResponse = this.restAPIStore.createApplication("ApplicationTest", "Test Application", "50PerMin", ApplicationDTO.TokenTypeEnum.JWT);
        this.applicationID = applicationResponse.getData();
        APIRequest apiRequest = new APIRequest("APITest", "{version}/api", new URL(this.apiEndPointUrl));
        apiRequest.setVersion("1.0.0");
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setTier("Unlimited");
        apiRequest.setTags("testTag1, testTag2, testTag3");
        apiRequest.setVisibility(APIDTO.VisibilityEnum.PUBLIC.getValue());
        APIOperationsDTO apiOperationsDTO1 = new APIOperationsDTO();
        apiOperationsDTO1.setVerb("GET");
        apiOperationsDTO1.setTarget("/");
        apiOperationsDTO1.setAuthType("Application & Application User");
        apiOperationsDTO1.setThrottlingPolicy("Unlimited");
        APIOperationsDTO apiOperationsDTO2 = new APIOperationsDTO();
        apiOperationsDTO2.setVerb("GET");
        apiOperationsDTO2.setTarget("/customers/{id}");
        apiOperationsDTO2.setAuthType("Application & Application User");
        apiOperationsDTO2.setThrottlingPolicy("Unlimited");
        ArrayList<APIOperationsDTO> operationsDTOS = new ArrayList<APIOperationsDTO>();
        operationsDTOS.add(apiOperationsDTO1);
        operationsDTOS.add(apiOperationsDTO2);
        apiRequest.setOperationsDTOS(operationsDTOS);
        this.apiId = this.createPublishAndSubscribeToAPIUsingRest(apiRequest, this.restAPIPublisher, this.restAPIStore, this.applicationID, "Unlimited");
        this.waitForAPIDeploymentSync(this.user.getUserName(), "APITest", "1.0.0", "\"isApiExists\":true");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("password");
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.applicationID, "36000", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        this.accessToken = applicationKeyDTO.getToken().getAccessToken();
        ctx.setAttribute("accessToken", (Object)this.accessToken);
        System.setProperty("ApplicationTest-accessToken", this.accessToken);
        ctx.setAttribute("apiId", (Object)this.apiId);
        ctx.setAttribute("applicationID", (Object)this.applicationID);
    }
}

