/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import com.google.gson.Gson;
import java.net.URL;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleAction;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.bean.SubscriptionRequest;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class DAOTestCase
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(DAOTestCase.class);
    private String apiId;
    private String applicationId;
    private String providerName;
    private ArrayList<String> grantTypes;

    @Factory(dataProvider="userModeDataProvider")
    public DAOTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.providerName = this.user.getUserName();
        this.grantTypes = new ArrayList();
        this.grantTypes.add("client_credentials");
    }

    @Test(groups={"wso2.am"}, description="API Life cycle test case")
    public void testDAOTestCase() throws Exception {
        String applicaitionName = "DAOTestAPI-Application";
        String apiName = "DAOTestAPI";
        String apiContext = "DAOTestAPI";
        String tags = "youtube, video, media";
        String url = "http://gdata.youtube.com/feeds/api/standardfeeds";
        String description = "This is test API create by API manager integration test";
        String APIVersion = "1.0.0";
        APIRequest apiRequest = new APIRequest(apiName, apiContext, new URL(url));
        apiRequest.setTags(tags);
        apiRequest.setDescription(description);
        apiRequest.setVersion(APIVersion);
        apiRequest.setProvider(this.providerName);
        HttpResponse addAPIResponse = this.restAPIPublisher.addAPI(apiRequest);
        this.apiId = addAPIResponse.getData();
        this.restAPIPublisher.deleteAPI(this.apiId);
        this.apiId = this.restAPIPublisher.addAPI(apiRequest).getData();
        HttpResponse response = this.restAPIPublisher.getAPI(this.apiId);
        Gson g = new Gson();
        APIDTO apidto = (APIDTO)g.fromJson(response.getData(), APIDTO.class);
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, APILifeCycleAction.PUBLISH.getAction());
        Assert.assertEquals((String)apidto.getName(), (String)apiName, (String)"API Name mismatch");
        Assert.assertTrue((boolean)apidto.getContext().contains(apiContext), (String)"API context mismatch");
        Assert.assertEquals((String)apidto.getVersion(), (String)APIVersion, (String)"API version mismatch");
        Assert.assertEquals((String)apidto.getProvider(), (String)this.providerName, (String)"Provider Name mismatch");
        for (String tag : apidto.getTags()) {
            Assert.assertTrue((boolean)tags.contains(tag), (String)"API tag data mismatched");
        }
        Assert.assertEquals((String)apidto.getDescription(), (String)description, (String)"API description mismatch");
        ApplicationDTO applicationDTO = this.restAPIStore.addApplication(applicaitionName, "50PerMin", "", "this-is-test");
        this.applicationId = applicationDTO.getApplicationId();
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest(apiName, this.storeContext.getContextTenant().getContextUser().getUserName());
        subscriptionRequest.setApplicationName(applicaitionName);
        this.restAPIStore.subscribeToAPI(subscriptionRequest);
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.applicationId, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, this.grantTypes);
        Assert.assertNotNull((Object)applicationKeyDTO.getToken().getAccessToken());
        this.waitForAPIDeploymentSync(apiRequest.getProvider(), apiRequest.getName(), apiRequest.getVersion(), "\"isApiExists\":true");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIStore.deleteApplication(this.applicationId);
        this.restAPIPublisher.deleteAPI(this.apiId);
        super.cleanUp();
    }
}

