/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import com.google.gson.Gson;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.DocumentDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APIDTO;
import org.wso2.am.integration.test.impl.RestAPIPublisherImpl;
import org.wso2.am.integration.test.impl.RestAPIStoreImpl;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.admin.client.UserManagementClient;
import org.wso2.carbon.user.mgt.stub.UserAdminUserAdminException;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class DevPortalVisibilityTestCase
extends APIManagerLifecycleBaseTest {
    private static final Log log = LogFactory.getLog(DevPortalVisibilityTestCase.class);
    private String contextUsername = "admin";
    private final String EMAIL_DOMAIN = "@gm.co";
    private final String AT = "@";
    private final String INTERNAL_CREATOR = "Internal/creator";
    private final String INTERNAL_PUBLISHER = "Internal/publisher";
    private final String INTERNAL_SUBSCRIBER = "Internal/subscriber";
    private final String USER_PASSWORD = "123123";
    private final String[] OLD_ROLE_LIST = new String[]{"Internal/publisher", "Internal/creator", "Internal/subscriber", "Internal/everyone", "role1"};
    private String DEV_USER_A = "dusera";
    private String DEV_USER_B = "duserb";
    private String DEV_USER_C = "duserc";
    private String PUB_SUB_USER = "pbsbusr";
    private String DEV_USER_A_ROLE = "rolex";
    private String DEV_USER_B_ROLE = "roley";
    private final String[] PUB_SUB_USER_ROLES = new String[]{"Internal/publisher", "Internal/creator", "Internal/subscriber", "Internal/everyone"};
    private final String EP_URL = "http://gdata.youtube.com/feeds/api/standardfeeds";
    UserManagementClient userManagementClient1;
    private RestAPIPublisherImpl pubSubUserPublisher;
    private RestAPIStoreImpl pubSubUserStore;
    private RestAPIStoreImpl devUser1;
    private RestAPIStoreImpl devUser2;
    private RestAPIStoreImpl devUser3;
    private String APINAME = "VisA";
    private String CONTEXT = "ctx9";
    private String VERSION = "1";
    private String apiId;
    private final String STORE_BASE_PATH = "api/am/devportal/v2/apis/";

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}, {TestUserMode.SUPER_TENANT_USER_STORE_USER}, {TestUserMode.SUPER_TENANT_EMAIL_USER}, {TestUserMode.TENANT_EMAIL_USER}};
    }

    @Factory(dataProvider="userModeDataProvider")
    public DevPortalVisibilityTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass
    public void initTestCase() throws APIManagerIntegrationTestException, XPathExpressionException, RemoteException, UserAdminUserAdminException {
        super.init(this.userMode);
        this.publisherURLHttp = this.publisherUrls.getWebAppURLHttp();
        this.storeURLHttp = this.storeUrls.getWebAppURLHttp();
        this.contextUsername = this.keyManagerContext.getContextTenant().getContextUser().getUserName();
        this.userManagementClient1 = new UserManagementClient(this.keyManagerContext.getContextUrls().getBackEndUrl(), this.keyManagerContext.getContextTenant().getTenantAdmin().getUserName(), this.keyManagerContext.getContextTenant().getTenantAdmin().getPassword());
        if (TestUserMode.TENANT_EMAIL_USER.equals((Object)this.userMode) || TestUserMode.SUPER_TENANT_EMAIL_USER.equals((Object)this.userMode)) {
            this.DEV_USER_A = this.DEV_USER_A + "@gm.co" + "@" + this.keyManagerContext.getContextTenant().getContextUser().getUserDomain();
            this.DEV_USER_B = this.DEV_USER_B + "@gm.co" + "@" + this.keyManagerContext.getContextTenant().getContextUser().getUserDomain();
            this.DEV_USER_C = this.DEV_USER_C + "@gm.co" + "@" + this.keyManagerContext.getContextTenant().getContextUser().getUserDomain();
            this.PUB_SUB_USER = this.PUB_SUB_USER + "@gm.co" + "@" + this.keyManagerContext.getContextTenant().getContextUser().getUserDomain();
        } else if (TestUserMode.SUPER_TENANT_USER_STORE_USER.equals((Object)this.userMode)) {
            this.DEV_USER_A = "secondary/" + this.DEV_USER_A;
            this.DEV_USER_B = "secondary/" + this.DEV_USER_B;
            this.DEV_USER_C = "secondary/" + this.DEV_USER_C;
            this.PUB_SUB_USER = "secondary/" + this.PUB_SUB_USER;
            this.DEV_USER_A_ROLE = "secondary/" + this.DEV_USER_A_ROLE;
            this.DEV_USER_B_ROLE = "secondary/" + this.DEV_USER_B_ROLE;
        }
        this.userManagementClient1.addRole(this.DEV_USER_A_ROLE, new String[0], new String[0]);
        this.userManagementClient1.addRole(this.DEV_USER_B_ROLE, new String[0], new String[0]);
        this.userManagementClient1.addUser(this.DEV_USER_A, "123123", new String[]{"Internal/subscriber", this.DEV_USER_A_ROLE}, this.DEV_USER_A);
        this.userManagementClient1.addUser(this.DEV_USER_B, "123123", new String[]{"Internal/subscriber", this.DEV_USER_B_ROLE}, this.DEV_USER_B);
        this.userManagementClient1.addUser(this.DEV_USER_C, "123123", new String[]{"Internal/subscriber"}, this.DEV_USER_C);
        this.userManagementClient1.addUser(this.PUB_SUB_USER, "123123", new String[]{"Internal/publisher", "Internal/subscriber", "Internal/creator"}, this.PUB_SUB_USER);
        this.pubSubUserPublisher = new RestAPIPublisherImpl(this.PUB_SUB_USER, "123123", this.keyManagerContext.getContextTenant().getDomain(), this.publisherURLHttps);
        this.pubSubUserStore = new RestAPIStoreImpl(this.PUB_SUB_USER, "123123", this.keyManagerContext.getContextTenant().getDomain(), this.storeURLHttps);
        this.devUser1 = new RestAPIStoreImpl(this.DEV_USER_A, "123123", this.keyManagerContext.getContextTenant().getDomain(), this.storeURLHttps);
        this.devUser2 = new RestAPIStoreImpl(this.DEV_USER_B, "123123", this.keyManagerContext.getContextTenant().getDomain(), this.storeURLHttps);
        this.devUser3 = new RestAPIStoreImpl(this.DEV_USER_C, "123123", this.keyManagerContext.getContextTenant().getDomain(), this.storeURLHttps);
    }

    @Test(groups={"wso2.am"}, description="This test case tests the retrieval of API which was added without dev portal visibility")
    public void testAnonymousUserAccessDevPortalAPI() throws Exception {
        APIRequest apiRequest = new APIRequest(this.APINAME, this.CONTEXT, new URL("http://gdata.youtube.com/feeds/api/standardfeeds"));
        apiRequest.setVersion(this.VERSION);
        this.apiId = this.createAndPublishAPIUsingRest(apiRequest, this.pubSubUserPublisher, false);
        this.waitForAPIDeploymentSync(this.contextUsername, this.APINAME, this.VERSION, "\"isApiExists\":true");
        HttpResponse response = this.pubSubUserPublisher.getAPI(this.apiId);
        Gson g = new Gson();
        org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO apidto = (org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO)g.fromJson(response.getData(), org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO.class);
        Assert.assertEquals((String)apidto.getId(), (String)this.apiId, (String)"API Id is not equal");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-WSO2-Tenant", MultitenantUtils.getTenantDomain((String)this.contextUsername));
        HttpResponse resp = HTTPSClientUtils.doGet((String)(this.storeURLHttps + "api/am/devportal/v2/apis/" + this.apiId), headers);
        log.info((Object)("Response " + resp.getData()));
        Assert.assertEquals((int)resp.getResponseCode(), (int)200, (String)"Public API cannot be accessed by anonymous user");
    }

    @Test(groups={"wso2.am"}, description="This test case tests the retrieval of API which was added with dev portal visibility.", dependsOnMethods={"testAnonymousUserAccessDevPortalAPI"})
    public void testRestrictedDevPortalAPIAccess() throws Exception {
        HttpResponse response = this.pubSubUserPublisher.getAPI(this.apiId);
        Gson g = new Gson();
        org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO apidto = (org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO)g.fromJson(response.getData(), org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO.class);
        apidto.setVisibility(APIDTO.VisibilityEnum.RESTRICTED);
        ArrayList<String> visibleRoles = new ArrayList<String>();
        visibleRoles.add(this.DEV_USER_A_ROLE);
        apidto.setVisibleRoles(visibleRoles);
        this.pubSubUserPublisher.updateAPI(apidto);
        this.waitForAPIDeploymentSync(this.contextUsername, this.APINAME, this.VERSION, "\"isApiExists\":true");
        response = this.pubSubUserPublisher.getAPI(this.apiId);
        g = new Gson();
        apidto = (org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO)g.fromJson(response.getData(), org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO.class);
        Assert.assertEquals((String)((String)apidto.getVisibleRoles().get(0)), (String)this.DEV_USER_A_ROLE, (String)"API visibility not updated.");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-WSO2-Tenant", MultitenantUtils.getTenantDomain((String)this.contextUsername));
        HttpResponse resp = HTTPSClientUtils.doGet((String)(this.storeURLHttps + "api/am/devportal/v2/apis/" + this.apiId), headers);
        log.info((Object)("Response " + resp.getData()));
        Assert.assertEquals((int)resp.getResponseCode(), (int)404, (String)"Restricted API can be accessed by anonymous user");
        APIDTO result = this.devUser1.getAPI(this.apiId);
        Assert.assertTrue((boolean)StringUtils.isNotEmpty((String)result.getId()), (String)("Restricted API not visible for the user with role " + this.DEV_USER_A_ROLE));
        headers = new HashMap();
        headers.put("Authorization", "Bearer " + this.devUser2.getAccessToken());
        resp = HTTPSClientUtils.doGet((String)(this.storeURLHttps + "api/am/devportal/v2/apis/" + this.apiId), headers);
        log.info((Object)("Response " + resp.getData()));
        Assert.assertEquals((int)resp.getResponseCode(), (int)404, (String)("Restricted API can be accessed by user with " + this.DEV_USER_B_ROLE + " role"));
        headers = new HashMap();
        headers.put("Authorization", "Bearer " + this.pubSubUserStore.getAccessToken());
        resp = HTTPSClientUtils.doGet((String)(this.storeURLHttps + "api/am/devportal/v2/apis/" + this.apiId), headers);
        log.info((Object)("Response " + resp.getData()));
        Assert.assertEquals((int)resp.getResponseCode(), (int)200, (String)"Restricted API not visible for publisher user");
    }

    @Test(groups={"wso2.am"}, description="This test case tests the accessibility of documents on dev portal for restricted APIs", dependsOnMethods={"testRestrictedDevPortalAPIAccess"})
    public void testRestrictedDevPortalDocumentAccess() throws Exception {
        DocumentDTO body = new DocumentDTO();
        body.setName("DocName");
        body.setSourceType(DocumentDTO.SourceTypeEnum.INLINE);
        body.setType(DocumentDTO.TypeEnum.HOWTO);
        body.setSummary("this is doc summary");
        body.setVisibility(DocumentDTO.VisibilityEnum.API_LEVEL);
        HttpResponse docResp = this.pubSubUserPublisher.addDocument(this.apiId, body);
        String docId = docResp.getData();
        Assert.assertEquals((int)docResp.getResponseCode(), (int)200, (String)"Document creation faild for publisher");
        String docContent = "Sample content";
        this.pubSubUserPublisher.addContentDocument(this.apiId, docId, docContent);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-WSO2-Tenant", MultitenantUtils.getTenantDomain((String)this.contextUsername));
        HttpResponse resp = HTTPSClientUtils.doGet((String)(this.storeURLHttps + "api/am/devportal/v2/apis/" + this.apiId + "/documents/" + docId), headers);
        log.info((Object)("Response " + resp.getData()));
        Assert.assertEquals((int)resp.getResponseCode(), (int)404, (String)"Restricted API doc can be accessed by anonymous user");
        resp = HTTPSClientUtils.doGet((String)(this.storeURLHttps + "api/am/devportal/v2/apis/" + this.apiId + "/documents/" + docId + "/content"), headers);
        log.info((Object)("Response " + resp.getData()));
        Assert.assertEquals((int)resp.getResponseCode(), (int)404, (String)"Restricted API doc content can be accessed by anonymous user");
        headers = new HashMap();
        headers.put("Authorization", "Bearer " + this.devUser1.getAccessToken());
        resp = HTTPSClientUtils.doGet((String)(this.storeURLHttps + "api/am/devportal/v2/apis/" + this.apiId + "/documents/" + docId), headers);
        log.info((Object)("Response " + resp.getData()));
        Assert.assertEquals((int)resp.getResponseCode(), (int)200, (String)("Restricted API doc cannot be accessed by user with role " + this.DEV_USER_A_ROLE));
        resp = HTTPSClientUtils.doGet((String)(this.storeURLHttps + "api/am/devportal/v2/apis/" + this.apiId + "/documents/" + docId + "/content"), headers);
        log.info((Object)("Response " + resp.getData()));
        Assert.assertEquals((int)resp.getResponseCode(), (int)200, (String)("Restricted API doc content cannot be accessed by user with role " + this.DEV_USER_A_ROLE));
        headers = new HashMap();
        headers.put("Authorization", "Bearer " + this.devUser2.getAccessToken());
        resp = HTTPSClientUtils.doGet((String)(this.storeURLHttps + "api/am/devportal/v2/apis/" + this.apiId + "/documents/" + docId), headers);
        log.info((Object)("Response " + resp.getData()));
        Assert.assertEquals((int)resp.getResponseCode(), (int)404, (String)("Restricted API doc can be accessed by user with role " + this.DEV_USER_B_ROLE));
        resp = HTTPSClientUtils.doGet((String)(this.storeURLHttps + "api/am/devportal/v2/apis/" + this.apiId + "/documents/" + docId + "/content"), headers);
        log.info((Object)("Response " + resp.getData()));
        Assert.assertEquals((int)resp.getResponseCode(), (int)404, (String)("Restricted API doc content can be accessed by user with role " + this.DEV_USER_B_ROLE));
        headers = new HashMap();
        headers.put("Authorization", "Bearer " + this.pubSubUserStore.getAccessToken());
        resp = HTTPSClientUtils.doGet((String)(this.storeURLHttps + "api/am/devportal/v2/apis/" + this.apiId + "/documents/" + docId), headers);
        log.info((Object)("Response " + resp.getData()));
        Assert.assertEquals((int)resp.getResponseCode(), (int)200, (String)"Restricted API doc not visible for publisher user");
        resp = HTTPSClientUtils.doGet((String)(this.storeURLHttps + "api/am/devportal/v2/apis/" + this.apiId + "/documents/" + docId + "/content"), headers);
        log.info((Object)("Response " + resp.getData()));
        Assert.assertEquals((int)resp.getResponseCode(), (int)200, (String)"Restricted API doc content not visible for publisher user");
    }

    @Test(groups={"wso2.am"}, description="This test case tests the accessibility of openapi spec on dev portal for restricted APIs", dependsOnMethods={"testRestrictedDevPortalAPIAccess"})
    public void testRestrictedDevPortalOpenAPISpecAccess() throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-WSO2-Tenant", MultitenantUtils.getTenantDomain((String)this.contextUsername));
        HttpResponse resp = HTTPSClientUtils.doGet((String)(this.storeURLHttps + "api/am/devportal/v2/apis/" + this.apiId + "/swagger"), headers);
        log.info((Object)("Response " + resp.getData()));
        Assert.assertEquals((int)resp.getResponseCode(), (int)404, (String)"Restricted API definition can be accessed by anonymous user");
        headers = new HashMap();
        headers.put("Authorization", "Bearer " + this.devUser1.getAccessToken());
        resp = HTTPSClientUtils.doGet((String)(this.storeURLHttps + "api/am/devportal/v2/apis/" + this.apiId + "/swagger"), headers);
        log.info((Object)("Response " + resp.getData()));
        Assert.assertEquals((int)resp.getResponseCode(), (int)200, (String)("Restricted API definition cannot be accessed by user with role " + this.DEV_USER_A_ROLE));
        headers = new HashMap();
        headers.put("Authorization", "Bearer " + this.devUser2.getAccessToken());
        resp = HTTPSClientUtils.doGet((String)(this.storeURLHttps + "api/am/devportal/v2/apis/" + this.apiId + "/swagger"), headers);
        log.info((Object)("Response " + resp.getData()));
        Assert.assertEquals((int)resp.getResponseCode(), (int)404, (String)("Restricted API definition can be accessed by user with " + this.DEV_USER_B_ROLE + " role"));
        headers = new HashMap();
        headers.put("Authorization", "Bearer " + this.pubSubUserStore.getAccessToken());
        resp = HTTPSClientUtils.doGet((String)(this.storeURLHttps + "api/am/devportal/v2/apis/" + this.apiId + "/swagger"), headers);
        log.info((Object)("Response " + resp.getData()));
        Assert.assertEquals((int)resp.getResponseCode(), (int)200, (String)"Restricted API definition not visible for publisher user");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIPublisher.deleteAPI(this.apiId);
        if (TestUserMode.SUPER_TENANT_EMAIL_USER.equals((Object)this.userMode) || TestUserMode.TENANT_EMAIL_USER.equals((Object)this.userMode)) {
            this.userManagementClient1.updateRolesOfUser(this.user.getUserNameWithoutDomain(), this.OLD_ROLE_LIST);
        }
        this.userManagementClient1.deleteUser(this.DEV_USER_A);
        this.userManagementClient1.deleteUser(this.DEV_USER_B);
        this.userManagementClient1.deleteUser(this.DEV_USER_C);
        this.userManagementClient1.deleteUser(this.PUB_SUB_USER);
        this.userManagementClient1.deleteRole(this.DEV_USER_A_ROLE);
        this.userManagementClient1.deleteRole(this.DEV_USER_B_ROLE);
        super.cleanUp();
    }
}

