/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.net.URL;
import java.util.ArrayList;
import javax.ws.rs.core.Response;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleAction;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.carbon.automation.engine.context.TestUserMode;

public class HttpPATCHSupportTestCase
extends APIMIntegrationBaseTest {
    private String apiId;
    private String applicationId;

    @Factory(dataProvider="userModeDataProvider")
    public HttpPATCHSupportTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String gatewaySessionCookie = this.createSession(this.gatewayContextMgt);
    }

    @Test(groups={"wso2.am"}, description="Check functionality of HTTP PATCH support for APIM")
    public void testHttpPatchSupport() throws Exception {
        String apiName = "HttpPatchAPI";
        String apiContext = "patchTestContext";
        String url = this.getGatewayURLNhttp() + "httpPatchSupportContext";
        String providerName = this.user.getUserName();
        String apiVersion = "1.0.0";
        String applicationName = "HttpPatchSupportAPP";
        APIRequest apiRequest = new APIRequest(apiName, apiContext, new URL(url));
        apiRequest.setVersion(apiVersion);
        apiRequest.setProvider(providerName);
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setTier("Unlimited");
        APIOperationsDTO apiOperationsDTO = new APIOperationsDTO();
        apiOperationsDTO.setVerb("PATCH");
        apiOperationsDTO.setTarget("/*");
        ArrayList<APIOperationsDTO> operationsDTOS = new ArrayList<APIOperationsDTO>();
        operationsDTOS.add(apiOperationsDTO);
        apiRequest.setOperationsDTOS(operationsDTOS);
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse serviceResponse = this.restAPIPublisher.addAPI(apiRequest);
        this.apiId = serviceResponse.getData();
        this.createAPIRevisionAndDeployUsingRest(this.apiId, this.restAPIPublisher);
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, APILifeCycleAction.PUBLISH.getAction(), null);
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse applicationResponse = this.restAPIStore.createApplication(applicationName, "Test Application", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
        this.applicationId = applicationResponse.getData();
        this.waitForAPIDeploymentSync(providerName, apiName, apiVersion, "\"isApiExists\":true");
        this.restAPIStore.createSubscription(this.apiId, this.applicationId, "Unlimited");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.applicationId, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        String accessToken = applicationKeyDTO.getToken().getAccessToken();
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpPatch request = new HttpPatch(this.getAPIInvocationURLHttp(apiContext, apiVersion));
        request.setHeader("Accept", "application/json");
        request.setHeader("Authorization", "Bearer " + accessToken);
        StringEntity payload = new StringEntity("{\"first\":\"Greg\"}", "UTF-8");
        payload.setContentType("application/json");
        request.setEntity((HttpEntity)payload);
        HttpResponse httpResponsePatch = client.execute((HttpUriRequest)request);
        Assert.assertEquals((int)httpResponsePatch.getStatusLine().getStatusCode(), (int)Response.Status.OK.getStatusCode(), (String)"The response code is not 200 OK");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIStore.deleteApplication(this.applicationId);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.apiId, this.restAPIPublisher);
        this.restAPIPublisher.deleteAPI(this.apiId);
        super.cleanUp();
    }
}

