/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.test.utils.base.APIMIntegrationConstants;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.bean.APIResourceBean;
import org.wso2.am.integration.test.utils.bean.APIThrottlingTier;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.common.TestConfigurationProvider;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.ALL})
public class InvalidAuthTokenLargePayloadTestCase
extends APIManagerLifecycleBaseTest {
    private final Log log = LogFactory.getLog(InvalidAuthTokenLargePayloadTestCase.class);
    private final String API_NAME = "InvalidAuthTokenLargePayloadAPIName";
    private final String API_CONTEXT = "InvalidAuthTokenLargePayloadContext";
    private final String DESCRIPTION = "This is test API create by API manager integration test";
    private final String API_VERSION = "1.0.0";
    private final String APP_NAME = "InvalidAuthTokenLargePayloadApp";
    private APICreationRequestBean apiCreationRequestBean;
    private List<APIResourceBean> resList;
    private String endpointUrl;
    private Map<String, String> requestHeaders = new HashMap<String, String>();
    private String tierCollection;
    private String testFile1KBFilePath;
    private String testFile100KBFilePath;
    private String testFile1MBFilePath;
    private String apiId;
    private String applicationId;

    @Factory(dataProvider="userModeDataProvider")
    public InvalidAuthTokenLargePayloadTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String providerName = this.user.getUserName();
        this.publisherURLHttp = this.getPublisherURLHttp();
        this.storeURLHttp = this.getStoreURLHttp();
        this.endpointUrl = this.backEndServerUrl.getWebAppURLHttp() + "am/sample/calculator/v1/api";
        this.tierCollection = "Bronze,Gold,Silver,Unlimited";
        String testArtifactPath = TestConfigurationProvider.getResourceLocation() + File.separator + "artifacts" + File.separator + "AM" + File.separator + "testFiles";
        this.testFile1KBFilePath = testArtifactPath + File.separator + "test1kb.db";
        this.testFile100KBFilePath = testArtifactPath + File.separator + "test100kb.db";
        this.testFile1MBFilePath = testArtifactPath + File.separator + "test1Mb.db";
        HttpResponse applicationResponse = this.restAPIStore.createApplication("InvalidAuthTokenLargePayloadApp", "Test Application", APIThrottlingTier.UNLIMITED.getState(), ApplicationDTO.TokenTypeEnum.JWT);
        Assert.assertEquals((int)applicationResponse.getResponseCode(), (int)200, (String)"Response code is not as expected");
        this.applicationId = applicationResponse.getData();
        this.apiCreationRequestBean = new APICreationRequestBean("InvalidAuthTokenLargePayloadAPIName", "InvalidAuthTokenLargePayloadContext", "1.0.0", providerName, new URL(this.endpointUrl));
        this.apiCreationRequestBean.setDescription("This is test API create by API manager integration test");
        this.apiCreationRequestBean.setTiersCollection(this.tierCollection);
        this.resList = new ArrayList<APIResourceBean>();
        APIResourceBean resource = new APIResourceBean("POST", APIMIntegrationConstants.ResourceAuthTypes.APPLICATION_AND_APPLICATION_USER.getAuthType(), "20KPerMin", "/post");
        this.resList.add(resource);
        this.apiCreationRequestBean.setResourceBeanList(this.resList);
        ArrayList<APIOperationsDTO> apiOperationsDTOS = new ArrayList<APIOperationsDTO>();
        APIOperationsDTO apiOperationsDTO = new APIOperationsDTO();
        apiOperationsDTO.setVerb("POST");
        apiOperationsDTO.setAuthType(APIMIntegrationConstants.ResourceAuthTypes.APPLICATION_AND_APPLICATION_USER.getAuthType());
        apiOperationsDTO.setThrottlingPolicy("20KPerMin");
        apiOperationsDTO.setTarget("/post");
        apiOperationsDTOS.add(apiOperationsDTO);
        APIRequest apiRequest = new APIRequest("InvalidAuthTokenLargePayloadAPIName", "InvalidAuthTokenLargePayloadContext", new URL(this.endpointUrl));
        apiRequest.setVersion("1.0.0");
        apiRequest.setProvider(providerName);
        apiRequest.setTiersCollection(this.tierCollection);
        apiRequest.setOperationsDTOS(apiOperationsDTOS);
        apiRequest.setDescription("This is test API create by API manager integration test");
        this.apiId = this.createPublishAndSubscribeToAPIUsingRest(apiRequest, this.restAPIPublisher, this.restAPIStore, this.applicationId, "Gold");
    }

    @Test(groups={"wso2.am"}, description="Subscribe and invoke api")
    public void testApiInvocation() throws Exception {
        HttpResponse response;
        this.requestHeaders.put("Authorization", "Bearer invalid_token_key");
        this.requestHeaders.put("Content-Type", ContentType.APPLICATION_JSON.toString());
        String invokeURL = this.getAPIInvocationURLHttp("InvalidAuthTokenLargePayloadContext", "1.0.0") + "/post";
        try {
            response = this.uploadFile(invokeURL, new File(this.testFile1KBFilePath), this.requestHeaders);
            Assert.fail((String)"Resource cannot be access with wrong access token");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains(String.valueOf(401)));
        }
        try {
            response = this.uploadFile(invokeURL, new File(this.testFile100KBFilePath), this.requestHeaders);
            Assert.fail((String)"Resource cannot be access with wrong access token");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains(String.valueOf(401)));
        }
        try {
            response = this.uploadFile(invokeURL, new File(this.testFile1MBFilePath), this.requestHeaders);
            Assert.fail((String)"Resource cannot be access with wrong access token");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains(String.valueOf(401)));
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIStore.deleteApplication(this.applicationId);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.apiId, this.restAPIPublisher);
        this.restAPIPublisher.deleteAPI(this.apiId);
        super.cleanUp();
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse uploadFile(String endpointUrl, File fileName, Map<String, String> headers) throws IOException {
        String temp;
        URL url = new URL(endpointUrl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        FileBody fileBody = new FileBody(fileName);
        MultipartEntity multipartEntity = new MultipartEntity(HttpMultipartMode.STRICT);
        multipartEntity.addPart("file", (ContentBody)fileBody);
        connection.setRequestProperty("Content-Type", multipartEntity.getContentType().getValue());
        if (headers != null && headers.size() > 0) {
            for (String string : headers.keySet()) {
                if (string == null) continue;
                connection.setRequestProperty(string, headers.get(string));
            }
            for (String key : headers.keySet()) {
                connection.setRequestProperty(key, headers.get(key));
            }
        }
        try (OutputStream out = connection.getOutputStream();){
            multipartEntity.writeTo(out);
        }
        int n = connection.getResponseCode();
        BufferedReader read = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        StringBuilder responseMsg = new StringBuilder();
        while ((temp = read.readLine()) != null) {
            responseMsg.append(temp);
        }
        HttpResponse response = new HttpResponse(responseMsg.toString(), n);
        return response;
    }
}

