/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import com.google.gson.Gson;
import java.net.URL;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class NewCopyWithDefaultVersion
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(NewCopyWithDefaultVersion.class);
    private APIPublisherRestClient apiPublisher;
    private String API_NAME = "DefaultVersionAPITest";
    private String apiContext = "DefaultVersionAPI";
    private String version = "1.0.0";
    private static String newVersion = "2.0.0";
    private String TAGS = "testtag1, testtag2";
    private String providerName;
    private String visibility = "public";
    private String description = "Test Description";
    private String tier = "Gold";
    private String resTier = "10KPerMin";
    private String endPointType = "http";
    private String resourceMethodAuthType = "Application & Application User";
    private String uriTemplate = "customers/{id}/";
    private String apiId;
    private String defaultApiId;

    @Factory(dataProvider="userModeDataProvider")
    public NewCopyWithDefaultVersion(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
    }

    @Test(groups={"webapp"}, description="New Copy with Default Version")
    public void setDefaultVersionToNewcopy() throws Exception {
        String gatewayUrl = this.gatewayContextWrk.getContextTenant().getDomain().equals("carbon.super") ? this.gatewayUrlsWrk.getWebAppURLNhttp() : this.gatewayUrlsWrk.getWebAppURLNhttp() + "t/" + this.gatewayContextWrk.getContextTenant().getDomain() + "/";
        String endpointUrl = gatewayUrl + "jaxrs_basic/services/customers/customerservice";
        this.providerName = this.publisherContext.getContextTenant().getContextUser().getUserName();
        APIRequest apiRequest = new APIRequest(this.API_NAME, this.apiContext, new URL(endpointUrl));
        apiRequest.setTags(this.TAGS);
        apiRequest.setDescription(this.description);
        apiRequest.setVersion(this.version);
        apiRequest.setProvider(this.providerName);
        apiRequest.setEndpointType(this.endPointType);
        apiRequest.setResourceMethodAuthType(this.resourceMethodAuthType);
        apiRequest.setTier(this.tier);
        apiRequest.setResourceMethodThrottlingTier(this.resTier);
        apiRequest.setUriTemplate(this.uriTemplate);
        apiRequest.setVisibility(this.visibility);
        HttpResponse serviceResponse = this.restAPIPublisher.addAPI(apiRequest);
        this.apiId = serviceResponse.getData();
        Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)Response.Status.CREATED.getStatusCode(), (String)"Invalid Response Code");
        HttpResponse apiCopyResponse = this.restAPIPublisher.copyAPI(newVersion, this.apiId, Boolean.valueOf(true));
        this.defaultApiId = apiCopyResponse.getData();
        Assert.assertEquals((int)apiCopyResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response Code Mismatch");
        HttpResponse newVersionApi = this.restAPIPublisher.getAPI(this.defaultApiId);
        Gson gson = new Gson();
        APIDTO apidto = (APIDTO)gson.fromJson(newVersionApi.getData(), APIDTO.class);
        boolean version = apidto.isIsDefaultVersion();
        Assert.assertEquals((boolean)version, (boolean)true, (String)"Copied API is not the default version");
        Assert.assertEquals((String)apidto.getName(), (String)this.API_NAME, (String)"API name is mismatched");
        Assert.assertEquals((String)apidto.getVersion(), (String)newVersion, (String)"API Version is mismatched");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIPublisher.deleteAPI(this.apiId);
        this.restAPIPublisher.deleteAPI(this.defaultApiId);
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }
}

