/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import com.google.gson.Gson;
import java.net.URL;
import java.util.ArrayList;
import javax.ws.rs.core.Response;
import org.json.JSONArray;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.CommentDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.CommentListDTO;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleAction;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class PublisherCommentTest
extends APIMIntegrationBaseTest {
    private String apiId;

    @Factory(dataProvider="userModeDataProvider")
    public PublisherCommentTest(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}, {TestUserMode.SUPER_TENANT_USER_STORE_USER}, {TestUserMode.SUPER_TENANT_EMAIL_USER}, {TestUserMode.TENANT_EMAIL_USER}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
    }

    @Test(groups={"wso2.am"}, description="Comment Rating Test case")
    public void testPublisherCommentTest() throws Exception {
        String APIName = "CommentRatingAPI";
        String APIContext = "commentRating";
        String tags = "youtube, video, media";
        String url = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice";
        String description = "This is test API create by API manager integration test";
        String providerName = this.user.getUserName();
        String APIVersion = "1.0.0";
        APIRequest apiRequest = new APIRequest(APIName, APIContext, new URL(url));
        apiRequest.setTags(tags);
        apiRequest.setDescription(description);
        apiRequest.setVersion(APIVersion);
        apiRequest.setProvider(providerName);
        HttpResponse serviceResponse = this.restAPIPublisher.addAPI(apiRequest);
        this.apiId = serviceResponse.getData();
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, APILifeCycleAction.PUBLISH.getAction(), null);
        HttpResponse serviceGetResponse = this.restAPIPublisher.getAPI(this.apiId);
        String apiData = serviceGetResponse.getData();
        JSONObject apiObject = new JSONObject(apiData);
        JSONArray tagsList = (JSONArray)apiObject.get("tags");
        for (int i = 0; i < tagsList.length(); ++i) {
            Assert.assertTrue((boolean)tags.contains(tagsList.getString(i)), (String)"API tag data mismatched");
        }
        ArrayList<String> rootComments = new ArrayList<String>();
        Integer i = 1;
        while (i < 3) {
            Object addRootCommentResponse = this.restAPIPublisher.addComment(this.apiId, "This is root comment " + i.toString(), "general", null);
            Assert.assertNotNull((Object)addRootCommentResponse, (String)"Error adding comment");
            Assert.assertEquals((int)addRootCommentResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched");
            Object getCommentsGson = new Gson();
            CommentDTO addedRootCommentDTO = (CommentDTO)getCommentsGson.fromJson(addRootCommentResponse.getData().replace("publisher", "PUBLISHER"), CommentDTO.class);
            String rootCommentId = addedRootCommentDTO.getId();
            Assert.assertNotNull((Object)rootCommentId, (String)"Comment Id is null");
            rootComments.add(rootCommentId);
            Thread.sleep(1000L);
            addRootCommentResponse = i;
            i = i + 1;
            getCommentsGson = i;
        }
        String rootCommentIdToAddReplies = (String)rootComments.get(0);
        ArrayList<String> replies = new ArrayList<String>();
        Integer i2 = 1;
        while (i2 < 4) {
            Object addReplyCommentResponse = this.restAPIPublisher.addComment(this.apiId, "This is a reply " + i2.toString(), "general", rootCommentIdToAddReplies);
            Assert.assertNotNull((Object)addReplyCommentResponse, (String)"Error adding comment");
            Assert.assertEquals((int)addReplyCommentResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched");
            Object getCommentsGson = new Gson();
            CommentDTO addedCommentDTO = (CommentDTO)getCommentsGson.fromJson(addReplyCommentResponse.getData().replace("publisher", "PUBLISHER"), CommentDTO.class);
            String replyCommentId = addedCommentDTO.getId();
            Assert.assertNotNull((Object)replyCommentId, (String)"Comment Id is null");
            replies.add(replyCommentId);
            Thread.sleep(1000L);
            addReplyCommentResponse = i2;
            i2 = i2 + 1;
            getCommentsGson = i2;
        }
        HttpResponse getCommentWithRepliesResponse = this.restAPIPublisher.getComment(rootCommentIdToAddReplies, this.apiId, this.gatewayContextWrk.getContextTenant().getDomain(), false, Integer.valueOf(3), Integer.valueOf(0));
        Assert.assertEquals((int)getCommentWithRepliesResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Error retrieving comment");
        Gson getCommentWithRepliesGson = new Gson();
        CommentDTO commentWithRepliesCommentDTO = (CommentDTO)getCommentWithRepliesGson.fromJson(getCommentWithRepliesResponse.getData().replace("publisher", "PUBLISHER"), CommentDTO.class);
        Assert.assertEquals((String)commentWithRepliesCommentDTO.getContent(), (String)"This is root comment 1", (String)"Comments do not match");
        Assert.assertEquals((String)commentWithRepliesCommentDTO.getCategory(), (String)"general", (String)"Comments do not match");
        Assert.assertEquals((Object)commentWithRepliesCommentDTO.getEntryPoint(), (Object)CommentDTO.EntryPointEnum.PUBLISHER, (String)"Comments do not match");
        for (CommentDTO reply : commentWithRepliesCommentDTO.getReplies().getList()) {
            Assert.assertEquals((String)reply.getCategory(), (String)"general", (String)"Comments do not match");
            Assert.assertEquals((Object)reply.getEntryPoint(), (Object)CommentDTO.EntryPointEnum.PUBLISHER, (String)"Comments do not match");
            Assert.assertEquals((String)reply.getParentCommentId(), (String)rootCommentIdToAddReplies, (String)"Comments do not match");
            Assert.assertEquals((boolean)replies.contains(reply.getId()), (boolean)true, (String)"Comments do not match");
        }
        Assert.assertEquals((int)commentWithRepliesCommentDTO.getReplies().getList().size(), (int)3, (String)"Replies limit does not match");
        HttpResponse getCommentToVerifyPagination = this.restAPIPublisher.getComment(rootCommentIdToAddReplies, this.apiId, this.gatewayContextWrk.getContextTenant().getDomain(), false, Integer.valueOf(3), Integer.valueOf(1));
        Assert.assertEquals((int)getCommentToVerifyPagination.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Error retrieving comment");
        Gson getCommentToVerifyPaginationGson = new Gson();
        CommentDTO getCommentToVerifyPaginationCommentDTO = (CommentDTO)getCommentToVerifyPaginationGson.fromJson(getCommentToVerifyPagination.getData().replace("publisher", "PUBLISHER"), CommentDTO.class);
        Assert.assertEquals((int)getCommentToVerifyPaginationCommentDTO.getReplies().getList().size(), (int)2, (String)"Replies limit does not match");
        Assert.assertEquals((String)((CommentDTO)getCommentToVerifyPaginationCommentDTO.getReplies().getList().get(0)).getContent(), (String)"This is a reply 2", (String)"Offset value does not captured");
        Assert.assertEquals((String)((CommentDTO)getCommentToVerifyPaginationCommentDTO.getReplies().getList().get(1)).getContent(), (String)"This is a reply 3", (String)"Offset value does not captured");
        HttpResponse getCommentsResponse = this.restAPIPublisher.getComments(this.apiId, this.gatewayContextWrk.getContextTenant().getDomain(), false, Integer.valueOf(5), Integer.valueOf(0));
        Assert.assertEquals((int)getCommentsResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Error retrieving comment");
        Gson getCommentsGson = new Gson();
        CommentListDTO commentListDTO = (CommentListDTO)getCommentsGson.fromJson(getCommentsResponse.getData().replace("publisher", "PUBLISHER"), CommentListDTO.class);
        Assert.assertEquals((int)commentListDTO.getCount(), (int)2, (String)"Root comments count do not match");
        for (CommentDTO rootCommentDTO : commentListDTO.getList()) {
            Assert.assertEquals((String)rootCommentDTO.getCategory(), (String)"general", (String)"Comments do not match");
            Assert.assertEquals((Object)rootCommentDTO.getEntryPoint(), (Object)CommentDTO.EntryPointEnum.PUBLISHER, (String)"Comments do not match");
            Assert.assertEquals((String)rootCommentDTO.getParentCommentId(), null, (String)"Comments do not match");
            Assert.assertEquals((boolean)rootComments.contains(rootCommentDTO.getId()), (boolean)true, (String)"Comments do not match");
        }
        HttpResponse getRootCommentsToVerifyPagination = this.restAPIPublisher.getComments(this.apiId, this.gatewayContextWrk.getContextTenant().getDomain(), false, Integer.valueOf(3), Integer.valueOf(1));
        Assert.assertEquals((int)getRootCommentsToVerifyPagination.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Error retrieving comment");
        Gson getRootCommentsToVerifyPaginationGson = new Gson();
        CommentListDTO getRootCommentsToVerifyPaginationCommentDTO = (CommentListDTO)getRootCommentsToVerifyPaginationGson.fromJson(getRootCommentsToVerifyPagination.getData().replace("publisher", "PUBLISHER"), CommentListDTO.class);
        Assert.assertEquals((int)getRootCommentsToVerifyPaginationCommentDTO.getList().size(), (int)1, (String)"Comments limit does not match");
        Assert.assertEquals((String)((CommentDTO)getRootCommentsToVerifyPaginationCommentDTO.getList().get(0)).getContent(), (String)"This is root comment 1", (String)"Offset value does not captured");
        HttpResponse getRepliesResponse = this.restAPIPublisher.getReplies(rootCommentIdToAddReplies, this.apiId, this.gatewayContextWrk.getContextTenant().getDomain(), false, Integer.valueOf(5), Integer.valueOf(0));
        Assert.assertEquals((int)getRepliesResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Error retrieving comment");
        Gson getRepliesGson = new Gson();
        CommentListDTO replyListDTO = (CommentListDTO)getRepliesGson.fromJson(getRepliesResponse.getData().replace("publisher", "PUBLISHER"), CommentListDTO.class);
        Assert.assertEquals((int)replyListDTO.getCount(), (int)3, (String)"Replies count do not match");
        for (CommentDTO replyDTO : replyListDTO.getList()) {
            Assert.assertEquals((String)replyDTO.getCategory(), (String)"general", (String)"Comments do not match");
            Assert.assertEquals((Object)replyDTO.getEntryPoint(), (Object)CommentDTO.EntryPointEnum.PUBLISHER, (String)"Comments do not match");
            Assert.assertEquals((String)replyDTO.getParentCommentId(), (String)rootCommentIdToAddReplies, (String)"Comments do not match");
            Assert.assertEquals((boolean)replies.contains(replyDTO.getId()), (boolean)true, (String)"Comments do not match");
        }
        HttpResponse getRepliesToVerifyPagination = this.restAPIPublisher.getReplies(rootCommentIdToAddReplies, this.apiId, this.gatewayContextWrk.getContextTenant().getDomain(), false, Integer.valueOf(3), Integer.valueOf(1));
        Assert.assertEquals((int)getRepliesToVerifyPagination.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Error retrieving comment");
        Gson getRepliesToVerifyPaginationGson = new Gson();
        CommentListDTO getRepliesToVerifyPaginationCommenListDTO = (CommentListDTO)getRepliesToVerifyPaginationGson.fromJson(getRepliesToVerifyPagination.getData().replace("publisher", "PUBLISHER"), CommentListDTO.class);
        Assert.assertEquals((int)getRepliesToVerifyPaginationCommenListDTO.getList().size(), (int)2, (String)"Comments limit does not match");
        Assert.assertEquals((String)((CommentDTO)getRepliesToVerifyPaginationCommenListDTO.getList().get(0)).getContent(), (String)"This is a reply 2", (String)"Offset value does not captured");
        Assert.assertEquals((String)((CommentDTO)getRepliesToVerifyPaginationCommenListDTO.getList().get(1)).getContent(), (String)"This is a reply 3", (String)"Offset value does not captured");
        HttpResponse editCommentResponse = this.restAPIPublisher.editComment(rootCommentIdToAddReplies, this.apiId, "Edited root comment", "general");
        Assert.assertNotNull((Object)editCommentResponse, (String)"Error adding comment");
        Assert.assertEquals((int)editCommentResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched");
        Gson editCommentGson = new Gson();
        CommentDTO editCommentDTO = (CommentDTO)editCommentGson.fromJson(editCommentResponse.getData().replace("publisher", "PUBLISHER"), CommentDTO.class);
        Assert.assertEquals((String)editCommentDTO.getContent(), (String)"Edited root comment");
        Assert.assertEquals((String)editCommentDTO.getCategory(), (String)"general");
        Assert.assertNotEquals((Object)editCommentDTO.getUpdatedTime(), null);
        String updatedTime = editCommentDTO.getUpdatedTime();
        Thread.sleep(1000L);
        editCommentResponse = this.restAPIPublisher.editComment(rootCommentIdToAddReplies, this.apiId, "Edited root comment", "bug fix");
        Assert.assertNotNull((Object)editCommentResponse, (String)"Error adding comment");
        Assert.assertEquals((int)editCommentResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched");
        editCommentGson = new Gson();
        editCommentDTO = (CommentDTO)editCommentGson.fromJson(editCommentResponse.getData().replace("publisher", "PUBLISHER"), CommentDTO.class);
        Assert.assertEquals((String)editCommentDTO.getContent(), (String)"Edited root comment");
        Assert.assertEquals((String)editCommentDTO.getCategory(), (String)"bug fix");
        Assert.assertNotEquals((Object)editCommentDTO.getUpdatedTime(), null);
        Assert.assertNotEquals((Object)editCommentDTO.getUpdatedTime(), (Object)updatedTime);
        updatedTime = editCommentDTO.getUpdatedTime();
        Thread.sleep(1000L);
        editCommentResponse = this.restAPIPublisher.editComment(rootCommentIdToAddReplies, this.apiId, "Edited root comment 1", "general bug fix");
        Assert.assertNotNull((Object)editCommentResponse, (String)"Error adding comment");
        Assert.assertEquals((int)editCommentResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched");
        editCommentGson = new Gson();
        editCommentDTO = (CommentDTO)editCommentGson.fromJson(editCommentResponse.getData().replace("publisher", "PUBLISHER"), CommentDTO.class);
        Assert.assertEquals((String)editCommentDTO.getContent(), (String)"Edited root comment 1");
        Assert.assertEquals((String)editCommentDTO.getCategory(), (String)"general bug fix");
        Assert.assertNotEquals((Object)editCommentDTO.getUpdatedTime(), null);
        Assert.assertNotEquals((Object)editCommentDTO.getUpdatedTime(), (Object)updatedTime);
        updatedTime = editCommentDTO.getUpdatedTime();
        Thread.sleep(1000L);
        editCommentResponse = this.restAPIPublisher.editComment(rootCommentIdToAddReplies, this.apiId, "Edited root comment 1", "general bug fix");
        Assert.assertEquals((String)editCommentResponse.getData(), null);
        Assert.assertEquals((int)editCommentResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched");
        editCommentResponse = this.restAPIPublisher.getComment(rootCommentIdToAddReplies, this.apiId, this.gatewayContextWrk.getContextTenant().getDomain(), false, Integer.valueOf(3), Integer.valueOf(0));
        Assert.assertEquals((int)getCommentWithRepliesResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Error retrieving comment");
        editCommentGson = new Gson();
        editCommentDTO = (CommentDTO)editCommentGson.fromJson(editCommentResponse.getData().replace("publisher", "PUBLISHER"), CommentDTO.class);
        Assert.assertEquals((String)editCommentDTO.getContent(), (String)"Edited root comment 1");
        Assert.assertEquals((String)editCommentDTO.getCategory(), (String)"general bug fix");
        Assert.assertNotEquals((Object)editCommentDTO.getUpdatedTime(), null);
        Assert.assertEquals((String)editCommentDTO.getUpdatedTime(), (String)updatedTime);
        HttpResponse deleteResponse = this.restAPIPublisher.removeComment(rootCommentIdToAddReplies, this.apiId);
        Assert.assertEquals((int)deleteResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched");
        for (String reply : replies) {
            HttpResponse replyResponse = this.restAPIPublisher.getComment(reply, this.apiId, this.gatewayContextWrk.getContextTenant().getDomain(), false, Integer.valueOf(3), Integer.valueOf(0));
            Assert.assertEquals((int)replyResponse.getResponseCode(), (int)Response.Status.NOT_FOUND.getStatusCode(), (String)"Error retrieving comment");
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIPublisher.deleteAPI(this.apiId);
        super.cleanUp();
    }
}

