/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.publisher;

import java.net.URL;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.ApiException;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIM519CreateAnAPIThroughTheRestAPIWithoutLoggingInTestCase
extends APIMIntegrationBaseTest {
    private String apiProviderName;
    private String apiProductionEndPointUrl;

    @Factory(dataProvider="userModeDataProvider")
    public APIM519CreateAnAPIThroughTheRestAPIWithoutLoggingInTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String apiProductionEndpointPostfixUrl = "jaxrs_basic/services/customers/customerservice/customers/123";
        String publisherURLHttp = this.publisherUrls.getWebAppURLHttp();
        this.apiProductionEndPointUrl = this.gatewayUrlsWrk.getWebAppURLHttp() + apiProductionEndpointPostfixUrl;
        this.apiProviderName = this.publisherContext.getContextTenant().getContextUser().getUserName();
    }

    @Test(groups={"wso2.am"}, description="Create an API Through the Publisher Rest API")
    public void testCreateAnAPIThroughThePublisherRest() throws Exception {
        String apiNameTest = "APIM519PublisherTest";
        String apiContextTest = "apim519PublisherTestAPI";
        String apiVersion = "1.0.0";
        String apiDescription = "This is Test API Created by API Manager Integration Test";
        String apiTag = "tag519-1, tag519-2, tag519-3";
        APIRequest apiCreationRequestBean = new APIRequest(apiNameTest, apiContextTest, new URL(this.apiProductionEndPointUrl));
        apiCreationRequestBean.setVersion(apiVersion);
        try {
            HttpResponse apiCreationResponse = this.restAPIPublisher.addAPI(apiCreationRequestBean);
            Assert.assertFalse((String)"API created without login in", (boolean)false);
        }
        catch (ApiException e) {
            Assert.assertEquals((long)e.getCode(), (long)Response.Status.UNAUTHORIZED.getStatusCode());
        }
    }
}

