/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.publisher;

import java.net.URL;
import javax.ws.rs.core.Response;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.DocumentDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.DocumentListDTO;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIM627AddDocumentationToAnAPIWithDocTypeOtherThroughPublisherRestAPITestCase
extends APIMIntegrationBaseTest {
    private final String apiName = "APIM627PublisherTest";
    private final String apiVersion = "1.0.0";
    private String apiProvider;
    private String apiEndPointUrl;
    private String apiId;
    private String inlineTypeDocumentId;
    private String urlTypeDocumentId;
    private String summary = "This is summary of the documentation";
    private String category = "Other";

    @Factory(dataProvider="userModeDataProvider")
    public APIM627AddDocumentationToAnAPIWithDocTypeOtherThroughPublisherRestAPITestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String gatewayUrl = "carbon.super".equals(this.gatewayContextWrk.getContextTenant().getDomain()) ? this.gatewayUrlsWrk.getWebAppURLNhttp() : this.gatewayUrlsWrk.getWebAppURLNhttp() + "t/" + this.gatewayContextWrk.getContextTenant().getDomain() + "/";
        this.apiEndPointUrl = gatewayUrl + "jaxrs_basic/services/customers/customerservice";
        this.apiProvider = this.publisherContext.getContextTenant().getContextUser().getUserName();
    }

    @Test(groups={"wso2.am"}, description="Add Documentation To An API With Type Other And Source Inline through the publisher rest API ")
    public void testAddDocumentToAnAPIOtherInline() throws Exception {
        String apiContext = "apim627PublisherTestAPI";
        String apiDescription = "This is Test API Created by API Manager Integration Test";
        String apiTags = "tag627-1, tag628-2";
        String docName = "APIM627PublisherTestHowTo-Inline-summary";
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean("APIM627PublisherTest", apiContext, "1.0.0", this.apiProvider, new URL(this.apiEndPointUrl));
        apiCreationRequestBean.setTags(apiTags);
        apiCreationRequestBean.setDescription(apiDescription);
        apiCreationRequestBean.setTiersCollection("Gold,Bronze");
        apiCreationRequestBean.setDefaultVersion("default_version");
        apiCreationRequestBean.setDefaultVersionChecked("default_version");
        apiCreationRequestBean.setBizOwner("api620b");
        apiCreationRequestBean.setBizOwnerMail("api620b@ee.com");
        apiCreationRequestBean.setTechOwner("api620t");
        apiCreationRequestBean.setTechOwnerMail("api620t@ww.com");
        APIDTO apiCreationResponse = this.restAPIPublisher.addAPI(apiCreationRequestBean);
        String status = apiCreationResponse.getLifeCycleStatus();
        this.apiId = apiCreationResponse.getId();
        Assert.assertTrue((boolean)APILifeCycleState.CREATED.getState().equalsIgnoreCase(status), (String)"Status of the APIM627PublisherTestis not a valid status");
        HttpResponse apiResponsePublisher = this.restAPIPublisher.getAPI(this.apiId);
        Assert.assertEquals((int)apiResponsePublisher.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"APIM627PublisherTest is not visible in publisher");
        DocumentDTO documentDTO = new DocumentDTO();
        documentDTO.setName(docName);
        documentDTO.setType(DocumentDTO.TypeEnum.OTHER);
        documentDTO.setSourceType(DocumentDTO.SourceTypeEnum.INLINE);
        documentDTO.setSummary(this.summary);
        documentDTO.setVisibility(DocumentDTO.VisibilityEnum.API_LEVEL);
        documentDTO.setOtherTypeName(this.category);
        HttpResponse documentationResponse = this.restAPIPublisher.addDocument(this.apiId, documentDTO);
        Assert.assertEquals((int)documentationResponse.getResponseCode(), (int)200, (String)"Error while add documentation to API");
        this.inlineTypeDocumentId = documentationResponse.getData();
    }

    @Test(groups={"wso2.am"}, description="Add Documentation To An API With Type HowTo And Source Url through the publisher rest API ", dependsOnMethods={"testAddDocumentToAnAPIOtherInline"})
    public void testAddDocumentToAnAPIOtherUrl() throws Exception {
        String docName = "APIM628PublisherTestHowTo-Url-summary";
        String docUrl = "https://docs.wso2.com/display/AM191/Published+APIs";
        DocumentDTO documentDTO = new DocumentDTO();
        documentDTO.setName(docName);
        documentDTO.setType(DocumentDTO.TypeEnum.OTHER);
        documentDTO.setSourceType(DocumentDTO.SourceTypeEnum.URL);
        documentDTO.setSummary(this.summary);
        documentDTO.setVisibility(DocumentDTO.VisibilityEnum.API_LEVEL);
        documentDTO.setOtherTypeName(this.category);
        documentDTO.setSourceUrl(docUrl);
        HttpResponse documentationResponse = this.restAPIPublisher.addDocument(this.apiId, documentDTO);
        Assert.assertEquals((int)documentationResponse.getResponseCode(), (int)200, (String)"Error while add documentation to API");
        this.urlTypeDocumentId = documentationResponse.getData();
    }

    @Test(groups={"wso2.am"}, description="Remove API Documentation from the API through the publisher rest API ", dependsOnMethods={"testAddDocumentToAnAPIOtherInline"})
    public void testRemoveDocumentationOtherTheAPI() throws Exception {
        HttpResponse docRemoveResponse = this.restAPIPublisher.removeDocumentation(this.apiId, this.inlineTypeDocumentId);
        Assert.assertEquals((int)Response.Status.OK.getStatusCode(), (int)docRemoveResponse.getResponseCode(), (String)"Error when removingdocumentation");
        this.restAPIPublisher.removeDocumentation(this.apiId, this.urlTypeDocumentId);
        DocumentListDTO docResponse = this.restAPIPublisher.getDocuments(this.apiId);
        Assert.assertTrue((boolean)docResponse.getList().isEmpty(), (String)"Documentations not removed properly");
    }

    @AfterClass(alwaysRun=true)
    public void destroyAPIs() throws Exception {
        this.restAPIPublisher.deleteAPI(this.apiId);
        super.cleanUp();
    }
}

