/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.rest;

import java.net.URL;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.store.api.v1.dto.APIListDTO;
import org.wso2.am.integration.test.utils.bean.APILifeCycleAction;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class SearchPaginatedAPIsWithMultipleStatusTestCase
extends APIManagerLifecycleBaseTest {
    private final int apiCount = 24;
    private static final String PROVIDER = "admin";
    private static final String API_NAME_PREFIX = "YoutubeFeeds";
    private static final String API_CONTEXT_PREFIX = "youtube";
    private static final String API_VERSION = "1.0.0";
    private static final String API_URL = "http://gdata.youtube.com/feeds/api/standardfeeds";
    private static final int PAGINATED_COUNT = 10;

    @Factory(dataProvider="userModeDataProvider")
    public SearchPaginatedAPIsWithMultipleStatusTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
    }

    @Test(groups={"wso2.am"}, description="check paginated API count")
    public void testPaginationWithMultipleStatus() throws Exception {
        for (int i = 0; i < 24; ++i) {
            APIRequest apiRequest = new APIRequest(API_NAME_PREFIX + i, API_CONTEXT_PREFIX + i, new URL(API_URL));
            apiRequest.setVersion(API_VERSION);
            apiRequest.setProvider(PROVIDER);
            HttpResponse addApiResponse = this.restAPIPublisher.addAPI(apiRequest);
            String apiId = addApiResponse.getData();
            if (i % 2 == 0) {
                this.restAPIPublisher.changeAPILifeCycleStatus(apiId, APILifeCycleAction.PUBLISH.getAction());
            }
            Thread.sleep(500L);
        }
        int returnApiCount = 0;
        for (int i = 0; i < 25; ++i) {
            APIListDTO apiListDTO = this.restAPIStore.searchPaginatedAPIs(10, 0, "carbon.super", API_NAME_PREFIX);
            Assert.assertNotNull((Object)apiListDTO, (String)"Unable to retrieve the requested APIs");
            returnApiCount = apiListDTO.getCount();
            if (returnApiCount == 10) break;
            Thread.sleep(5000L);
        }
        Assert.assertEquals((int)returnApiCount, (int)10);
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanUp();
    }
}

