/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.restapi;

import java.net.URL;
import java.util.ArrayList;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.gateway.api.v2.dto.APIArtifactDTO;
import org.wso2.am.integration.clients.gateway.api.v2.dto.EndpointsDTO;
import org.wso2.am.integration.clients.gateway.api.v2.dto.LocalEntryDTO;
import org.wso2.am.integration.clients.gateway.api.v2.dto.SequencesDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.MediationInfoDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.MediationListDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.MediationPolicyDTO;
import org.wso2.am.integration.test.impl.RestAPIGatewayImpl;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleAction;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class GatewayRestAPITestCase
extends APIMIntegrationBaseTest {
    private String apiId;

    @Factory(dataProvider="userModeDataProvider")
    public GatewayRestAPITestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}, {TestUserMode.SUPER_TENANT_USER_STORE_USER}, {TestUserMode.SUPER_TENANT_EMAIL_USER}, {TestUserMode.TENANT_EMAIL_USER}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
    }

    @Test(groups={"wso2.am"}, description="Comment Rating Test case")
    public void testGatewayRestAPI() throws Exception {
        String name = "GatewayRestAPITestCase";
        String context = "GatewayRestAPITestCase";
        String url = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice";
        String providerName = this.user.getUserName();
        String version = "1.0.0";
        APIRequest apiRequest = new APIRequest(name, context, new URL(url));
        apiRequest.setVersion(version);
        apiRequest.setProvider(providerName);
        HttpResponse serviceResponse = this.restAPIPublisher.addAPI(apiRequest);
        this.apiId = serviceResponse.getData();
        MediationListDTO mediationListDTO = this.restAPIPublisher.retrieveMediationPolicies();
        ArrayList<MediationPolicyDTO> mediationPolicyDTOS = new ArrayList<MediationPolicyDTO>();
        if (mediationListDTO.getList() != null) {
            for (MediationInfoDTO mediationInfoDTO : mediationListDTO.getList()) {
                MediationPolicyDTO mediationPolicyDTO = new MediationPolicyDTO();
                MediationInfoDTO selectedMediationInfo = null;
                if (mediationInfoDTO.getType().equals((Object)MediationInfoDTO.TypeEnum.IN) && "log_in_message".equals(mediationInfoDTO.getName())) {
                    selectedMediationInfo = mediationInfoDTO;
                }
                if (mediationInfoDTO.getType().equals((Object)MediationInfoDTO.TypeEnum.OUT) && "log_out_message".equals(mediationInfoDTO.getName())) {
                    selectedMediationInfo = mediationInfoDTO;
                }
                if (mediationInfoDTO.getType().equals((Object)MediationInfoDTO.TypeEnum.FAULT) && "debug_json_fault".equals(mediationInfoDTO.getName())) {
                    selectedMediationInfo = mediationInfoDTO;
                }
                if (selectedMediationInfo == null) continue;
                mediationPolicyDTO.setId(mediationInfoDTO.getId());
                mediationPolicyDTO.setName(mediationInfoDTO.getName());
                mediationPolicyDTO.setType(mediationInfoDTO.getType().getValue());
                mediationPolicyDTO.setShared(Boolean.valueOf(true));
                mediationPolicyDTOS.add(mediationPolicyDTO);
            }
        }
        APIDTO api = this.restAPIPublisher.getAPIByID(this.apiId);
        api.setMediationPolicies(mediationPolicyDTOS);
        this.restAPIPublisher.updateAPI(api);
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, APILifeCycleAction.PUBLISH.getAction(), null);
        this.createAPIRevisionAndDeployUsingRest(this.apiId, this.restAPIPublisher);
        this.waitForAPIDeploymentSync(this.user.getUserName(), name, version, "\"isApiExists\":true");
        RestAPIGatewayImpl restAPIGateway = new RestAPIGatewayImpl(this.user.getUserName(), this.user.getPassword(), this.user.getUserDomain());
        APIArtifactDTO apiArtifactDTO = restAPIGateway.retrieveAPI(name, version);
        Assert.assertNotNull((Object)apiArtifactDTO);
        Assert.assertNotNull((Object)apiArtifactDTO.getApi());
        Assert.assertTrue((boolean)apiArtifactDTO.getApi().contains("GatewayRestAPITestCase"));
        Assert.assertTrue((boolean)apiArtifactDTO.getApi().contains(this.apiId));
        LocalEntryDTO localEntryDTO = restAPIGateway.retrieveLocalEntries(name, version);
        Assert.assertNotNull((Object)localEntryDTO);
        Assert.assertNotNull((Object)localEntryDTO.getLocalEntries());
        Assert.assertEquals((int)localEntryDTO.getLocalEntries().size(), (int)1);
        Assert.assertTrue((boolean)((String)localEntryDTO.getLocalEntries().get(0)).contains(this.apiId));
        EndpointsDTO endpointsDTO = restAPIGateway.retrieveEndpoints(name, version);
        Assert.assertNotNull((Object)endpointsDTO);
        Assert.assertNotNull((Object)endpointsDTO.getEndpoints());
        Assert.assertEquals((int)endpointsDTO.getEndpoints().size(), (int)2);
        Assert.assertTrue((boolean)((String)endpointsDTO.getEndpoints().get(0)).contains("production"));
        Assert.assertTrue((boolean)((String)endpointsDTO.getEndpoints().get(1)).contains("sandbox"));
        Assert.assertTrue((boolean)((String)endpointsDTO.getEndpoints().get(0)).contains(url));
        Assert.assertTrue((boolean)((String)endpointsDTO.getEndpoints().get(1)).contains(url));
        SequencesDTO sequencesDTO = restAPIGateway.retrieveSequences(name, version);
        Assert.assertNotNull((Object)sequencesDTO);
        Assert.assertNotNull((Object)sequencesDTO.getSequences());
        Assert.assertEquals((int)sequencesDTO.getSequences().size(), (int)3);
        for (String sequence : sequencesDTO.getSequences()) {
            if (sequence.contains("--In")) {
                Assert.assertTrue((boolean)sequence.contains("IN_MESSAGE"));
            }
            if (sequence.contains("--Out")) {
                Assert.assertTrue((boolean)sequence.contains("OUT_MESSAGE"));
            }
            if (!sequence.contains("--Fault")) continue;
            Assert.assertTrue((boolean)sequence.contains("ERROR_MESSAGE"));
            Assert.assertTrue((boolean)sequence.contains("Correlation_Id"));
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIPublisher.deleteAPI(this.apiId);
        super.cleanUp();
    }
}

