/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.restapi.admin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.admin.ApiException;
import org.wso2.am.integration.clients.admin.ApiResponse;
import org.wso2.am.integration.clients.admin.api.dto.EnvironmentDTO;
import org.wso2.am.integration.clients.admin.api.dto.EnvironmentListDTO;
import org.wso2.am.integration.clients.admin.api.dto.VHostDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIProductDTO;
import org.wso2.am.integration.test.helpers.AdminApiTestHelper;
import org.wso2.am.integration.test.impl.ApiProductTestHelper;
import org.wso2.am.integration.test.impl.ApiTestHelper;
import org.wso2.am.integration.test.impl.DtoFactory;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APIRevisionDeployUndeployRequest;
import org.wso2.am.integration.test.utils.bean.APIRevisionRequest;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class EnvironmentTestCase
extends APIMIntegrationBaseTest {
    private EnvironmentDTO environmentDTO;
    private AdminApiTestHelper adminApiTestHelper;
    private ApiTestHelper apiTestHelper;
    private ApiProductTestHelper apiProductTestHelper;
    private String apiOneId;
    private String apiTwoId;
    private String apiProductId;
    private String apiOneRevisionId;
    private String apiTwoRevisionId;
    private String apiProductRevisionId;
    private static final String TIER_UNLIMITED = "Unlimited";
    private static final String TIER_GOLD = "Gold";

    @Factory(dataProvider="userModeDataProvider")
    public EnvironmentTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.apiTestHelper = new ApiTestHelper(this.restAPIPublisher, this.restAPIStore, this.getAMResourceLocation(), this.keyManagerContext.getContextTenant().getDomain(), this.keyManagerHTTPSURL, this.user);
        this.apiProductTestHelper = new ApiProductTestHelper(this.restAPIPublisher, this.restAPIStore);
        this.adminApiTestHelper = new AdminApiTestHelper();
    }

    @Test(groups={"wso2.am"}, description="Test add gateway environment")
    public void testAddGatewayEnvironment() throws Exception {
        String name = "us-region";
        String displayName = "US Region";
        String description = "Gateway environment deployed in US region";
        ArrayList<VHostDTO> vHostDTOList = new ArrayList<VHostDTO>();
        vHostDTOList.add(DtoFactory.createVhostDTO((String)"us.mg.wso2.com", (String)"", (Integer)80, (Integer)443, (Integer)9099, (Integer)8099));
        vHostDTOList.add(DtoFactory.createVhostDTO((String)"foods.com", (String)"zfoods", (Integer)8280, (Integer)8243, (Integer)9099, (Integer)8099));
        this.environmentDTO = DtoFactory.createEnvironmentDTO((String)name, (String)displayName, (String)description, (boolean)false, vHostDTOList);
        ApiResponse addedEnvironments = this.restAPIAdmin.addEnvironment(this.environmentDTO);
        Assert.assertEquals((int)addedEnvironments.getStatusCode(), (int)201);
        EnvironmentDTO addedEnvironmentDTO = (EnvironmentDTO)addedEnvironments.getData();
        String environmentId = addedEnvironmentDTO.getId();
        Assert.assertNotNull((Object)environmentId, (String)"The environment ID cannot be null or empty");
        this.environmentDTO.setId(environmentId);
        this.adminApiTestHelper.verifyEnvironmentDTO(this.environmentDTO, addedEnvironmentDTO);
        EnvironmentDTO configuredGatewayEnvironment = this.getConfiguredGatewayEnvironment();
        try {
            this.restAPIAdmin.addEnvironment(configuredGatewayEnvironment);
        }
        catch (ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)400);
        }
    }

    @Test(groups={"wso2.am"}, description="Test get all gateway environments", dependsOnMethods={"testAddGatewayEnvironment"})
    public void testGetGatewayEnvironments() throws Exception {
        ApiResponse retrievedEnvs = this.restAPIAdmin.getEnvironments();
        Assert.assertEquals((int)retrievedEnvs.getStatusCode(), (int)200);
        EnvironmentListDTO environmentListDTO = (EnvironmentListDTO)retrievedEnvs.getData();
        List environmentDTOS = environmentListDTO.getList();
        Assert.assertNotNull((Object)environmentDTOS, (String)"Environment list can not be null");
        EnvironmentDTO configuredGatewayEnvironment = this.getConfiguredGatewayEnvironment();
        for (EnvironmentDTO environment : environmentDTOS) {
            if (configuredGatewayEnvironment.getName().equals(environment.getName())) {
                this.adminApiTestHelper.verifyEnvironmentDTO(configuredGatewayEnvironment, environment);
                continue;
            }
            this.adminApiTestHelper.verifyEnvironmentDTO(this.environmentDTO, environment);
        }
    }

    @Test(groups={"wso2.am"}, description="Test deploy API revision with a Vhost", dependsOnMethods={"testGetGatewayEnvironments"})
    public void testDeployApiRevisionWithVhost() throws Exception {
        this.addApiAndProductRevision();
        ArrayList<APIRevisionDeployUndeployRequest> apiRevisionDeployRequestList = new ArrayList<APIRevisionDeployUndeployRequest>();
        APIRevisionDeployUndeployRequest apiRevisionDeployRequest = new APIRevisionDeployUndeployRequest();
        apiRevisionDeployRequest.setName("Default");
        apiRevisionDeployRequest.setVhost("localhost");
        apiRevisionDeployRequest.setDisplayOnDevportal(true);
        apiRevisionDeployRequestList.add(apiRevisionDeployRequest);
        HttpResponse apiRevisionsDeployResponse = this.restAPIPublisher.deployAPIRevision(this.apiOneId, this.apiOneRevisionId, apiRevisionDeployRequestList);
        Assert.assertEquals((int)apiRevisionsDeployResponse.getResponseCode(), (int)201, (String)("Unable to deploy API Revisions:" + apiRevisionsDeployResponse.getData()));
        apiRevisionDeployRequestList = new ArrayList();
        apiRevisionDeployRequest = new APIRevisionDeployUndeployRequest();
        apiRevisionDeployRequest.setName("Default");
        apiRevisionDeployRequest.setVhost("localhost");
        apiRevisionDeployRequest.setDisplayOnDevportal(true);
        apiRevisionDeployRequestList.add(apiRevisionDeployRequest);
        apiRevisionDeployRequest = new APIRevisionDeployUndeployRequest();
        apiRevisionDeployRequest.setName("us-region");
        apiRevisionDeployRequest.setVhost("foods.com");
        apiRevisionDeployRequest.setDisplayOnDevportal(true);
        apiRevisionDeployRequestList.add(apiRevisionDeployRequest);
        apiRevisionsDeployResponse = this.restAPIPublisher.deployAPIRevision(this.apiTwoId, this.apiTwoRevisionId, apiRevisionDeployRequestList);
        Assert.assertEquals((int)apiRevisionsDeployResponse.getResponseCode(), (int)201, (String)("Unable to deploy API Revisions:" + apiRevisionsDeployResponse.getData()));
        apiRevisionDeployRequestList = new ArrayList();
        apiRevisionDeployRequest = new APIRevisionDeployUndeployRequest();
        apiRevisionDeployRequest.setName("us-region");
        apiRevisionDeployRequest.setVhost("us.mg.wso2.com");
        apiRevisionDeployRequest.setDisplayOnDevportal(true);
        apiRevisionDeployRequestList.add(apiRevisionDeployRequest);
        apiRevisionsDeployResponse = this.restAPIPublisher.deployAPIProductRevision(this.apiProductId, this.apiProductRevisionId, apiRevisionDeployRequestList);
        Assert.assertEquals((int)apiRevisionsDeployResponse.getResponseCode(), (int)201, (String)("Unable to deploy API Product Revisions:" + apiRevisionsDeployResponse.getData()));
    }

    @Test(groups={"wso2.am"}, description="Test update gateway environment", dependsOnMethods={"testDeployApiRevisionWithVhost"})
    public void testUpdateEnvironment() throws Exception {
        this.environmentDTO.setDisplayName("US Gateway Environment");
        this.environmentDTO.setDescription("This is a updated test gateway environment");
        ArrayList<VHostDTO> vHostDTOList = new ArrayList<VHostDTO>();
        vHostDTOList.add(DtoFactory.createVhostDTO((String)"updated.wso2.com", (String)"", (Integer)7080, (Integer)7443, (Integer)7099, (Integer)8099));
        this.environmentDTO.setVhosts(vHostDTOList);
        ApiResponse updatedEnvironment = this.restAPIAdmin.updateEnvironment(this.environmentDTO.getId(), this.environmentDTO);
        EnvironmentDTO updatedEnvironmentDTO = (EnvironmentDTO)updatedEnvironment.getData();
        Assert.assertEquals((int)updatedEnvironment.getStatusCode(), (int)200);
        this.adminApiTestHelper.verifyEnvironmentDTO(this.environmentDTO, updatedEnvironmentDTO);
        EnvironmentDTO configuredGatewayEnvironment = this.getConfiguredGatewayEnvironment();
        try {
            this.restAPIAdmin.updateEnvironment(configuredGatewayEnvironment.getId(), configuredGatewayEnvironment);
        }
        catch (ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)400);
        }
    }

    @Test(groups={"wso2.am"}, description="Test delete environment", dependsOnMethods={"testUpdateEnvironment"})
    public void testDeleteEnvironment() throws Exception {
        ApiResponse apiResponse = this.restAPIAdmin.deleteEnvironment(this.environmentDTO.getId());
        Assert.assertEquals((int)apiResponse.getStatusCode(), (int)200);
        EnvironmentDTO configuredGatewayEnvironment = this.getConfiguredGatewayEnvironment();
        try {
            this.restAPIAdmin.deleteEnvironment(configuredGatewayEnvironment.getId());
        }
        catch (ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)400);
        }
        try {
            apiResponse = this.restAPIAdmin.deleteEnvironment(UUID.randomUUID().toString());
        }
        catch (ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)404);
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanUp();
    }

    private EnvironmentDTO getConfiguredGatewayEnvironment() {
        VHostDTO vhostDTO = DtoFactory.createVhostDTO((String)"localhost", (String)"", (Integer)8780, (Integer)8743, (Integer)9099, (Integer)8099);
        EnvironmentDTO configuredEnv = DtoFactory.createEnvironmentDTO((String)"Default", (String)"Default", (String)"This is a hybrid gateway that handles both production and sandbox token traffic.", (boolean)true, Collections.singletonList(vhostDTO));
        configuredEnv.setId("Default");
        return configuredEnv;
    }

    private void addApiAndProductRevision() throws Exception {
        ArrayList<APIDTO> apisToBeUsed = new ArrayList<APIDTO>();
        APIDTO apiOne = this.apiTestHelper.createApiOne(this.getBackendEndServiceEndPointHttp("wildcard/resources"));
        APIDTO apiTwo = this.apiTestHelper.createApiTwo(this.getBackendEndServiceEndPointHttp("wildcard/resources"));
        apisToBeUsed.add(apiOne);
        apisToBeUsed.add(apiTwo);
        String provider = UUID.randomUUID().toString();
        String name = UUID.randomUUID().toString();
        String context = "/" + UUID.randomUUID().toString();
        String tenantDomain = this.gatewayContextMgt.getContextTenant().getDomain();
        if (this.userMode != TestUserMode.SUPER_TENANT_ADMIN) {
            provider = provider + "@" + tenantDomain;
        }
        List<String> policies = Arrays.asList(TIER_UNLIMITED, TIER_GOLD);
        APIProductDTO apiProductDTO = this.apiProductTestHelper.createAPIProductInPublisher(provider, name, context, apisToBeUsed, policies);
        this.waitForAPIDeployment();
        this.apiProductTestHelper.verfiyApiProductInPublisher(apiProductDTO);
        APIRevisionRequest apiRevisionRequest = new APIRevisionRequest();
        apiRevisionRequest.setApiUUID(apiProductDTO.getId());
        this.apiOneId = apiOne.getId();
        apiRevisionRequest.setApiUUID(this.apiOneId);
        HttpResponse apiRevisionResponse = this.restAPIPublisher.addAPIRevision(apiRevisionRequest);
        this.apiOneRevisionId = this.extractRevisionId(apiRevisionResponse);
        this.apiTwoId = apiTwo.getId();
        apiRevisionRequest.setApiUUID(this.apiTwoId);
        apiRevisionResponse = this.restAPIPublisher.addAPIRevision(apiRevisionRequest);
        this.apiTwoRevisionId = this.extractRevisionId(apiRevisionResponse);
        this.apiProductId = apiProductDTO.getId();
        apiRevisionRequest.setApiUUID(this.apiProductId);
        apiRevisionResponse = this.restAPIPublisher.addAPIProductRevision(apiRevisionRequest);
        this.apiProductRevisionId = this.extractRevisionId(apiRevisionResponse);
    }

    private String extractRevisionId(HttpResponse httpResponse) throws JSONException {
        Assert.assertEquals((int)httpResponse.getResponseCode(), (int)201, (String)("Create API Response Code is invalid." + httpResponse.getData()));
        JSONObject jsonObject = new JSONObject(httpResponse.getData());
        return jsonObject.getString("id");
    }
}

