/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.restapi.admin.throttlingpolicy;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.admin.ApiException;
import org.wso2.am.integration.clients.admin.ApiResponse;
import org.wso2.am.integration.clients.admin.api.dto.AdvancedThrottlePolicyDTO;
import org.wso2.am.integration.clients.admin.api.dto.BandwidthLimitDTO;
import org.wso2.am.integration.clients.admin.api.dto.ConditionalGroupDTO;
import org.wso2.am.integration.clients.admin.api.dto.HeaderConditionDTO;
import org.wso2.am.integration.clients.admin.api.dto.IPConditionDTO;
import org.wso2.am.integration.clients.admin.api.dto.JWTClaimsConditionDTO;
import org.wso2.am.integration.clients.admin.api.dto.QueryParameterConditionDTO;
import org.wso2.am.integration.clients.admin.api.dto.RequestCountLimitDTO;
import org.wso2.am.integration.clients.admin.api.dto.ThrottleConditionDTO;
import org.wso2.am.integration.clients.admin.api.dto.ThrottleLimitDTO;
import org.wso2.am.integration.test.helpers.AdminApiTestHelper;
import org.wso2.am.integration.test.impl.DtoFactory;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;

public class AdvancedThrottlingPolicyTestCase
extends APIMIntegrationBaseTest {
    private String displayName = "Test Policy";
    private String description = "This is a test advanced throttle policy";
    private String timeUnit = "min";
    private Integer unitTime = 1;
    private AdvancedThrottlePolicyDTO requestCountPolicyDTO;
    private AdvancedThrottlePolicyDTO bandwidthPolicyDTO;
    private AdvancedThrottlePolicyDTO conditionalGroupsPolicyDTO;
    private AdminApiTestHelper adminApiTestHelper;

    @Factory(dataProvider="userModeDataProvider")
    public AdvancedThrottlingPolicyTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.adminApiTestHelper = new AdminApiTestHelper();
    }

    @Test(groups={"wso2.am"}, description="Test add advanced throttling policy with request count limit")
    public void testAddPolicyWithRequestCountLimit() throws Exception {
        String policyName = "TestPolicyOne";
        Long requestCount = 50L;
        ArrayList conditionalGroups = new ArrayList();
        RequestCountLimitDTO requestCountLimit = DtoFactory.createRequestCountLimitDTO((String)this.timeUnit, (Integer)this.unitTime, (Long)requestCount);
        ThrottleLimitDTO defaultLimit = DtoFactory.createThrottleLimitDTO((ThrottleLimitDTO.TypeEnum)ThrottleLimitDTO.TypeEnum.REQUESTCOUNTLIMIT, (RequestCountLimitDTO)requestCountLimit, null);
        this.requestCountPolicyDTO = DtoFactory.createAdvancedThrottlePolicyDTO((String)policyName, (String)this.displayName, (String)this.description, (boolean)false, (ThrottleLimitDTO)defaultLimit, conditionalGroups);
        ApiResponse addedPolicy = this.restAPIAdmin.addAdvancedThrottlingPolicy(this.requestCountPolicyDTO);
        Assert.assertEquals((int)addedPolicy.getStatusCode(), (int)201);
        AdvancedThrottlePolicyDTO addedPolicyDTO = (AdvancedThrottlePolicyDTO)addedPolicy.getData();
        String policyId = addedPolicyDTO.getPolicyId();
        Assert.assertNotNull((Object)policyId, (String)"The policy ID cannot be null or empty");
        this.requestCountPolicyDTO.setPolicyId(policyId);
        this.requestCountPolicyDTO.setIsDeployed(Boolean.valueOf(true));
        this.adminApiTestHelper.verifyAdvancedThrottlePolicyDTO(this.requestCountPolicyDTO, addedPolicyDTO);
    }

    @Test(groups={"wso2.am"}, description="Test add advanced throttling policy with bandwidth limit", dependsOnMethods={"testAddPolicyWithRequestCountLimit"})
    public void testAddPolicyWithBandwidthLimit() throws Exception {
        String policyName = "TestPolicyTwo";
        Long dataAmount = 2L;
        String dataUnit = "KB";
        ArrayList conditionalGroups = new ArrayList();
        BandwidthLimitDTO bandwidthLimit = DtoFactory.createBandwidthLimitDTO((String)this.timeUnit, (Integer)this.unitTime, (Long)dataAmount, (String)dataUnit);
        ThrottleLimitDTO defaultLimit = DtoFactory.createThrottleLimitDTO((ThrottleLimitDTO.TypeEnum)ThrottleLimitDTO.TypeEnum.BANDWIDTHLIMIT, null, (BandwidthLimitDTO)bandwidthLimit);
        this.bandwidthPolicyDTO = DtoFactory.createAdvancedThrottlePolicyDTO((String)policyName, (String)this.displayName, (String)this.description, (boolean)false, (ThrottleLimitDTO)defaultLimit, conditionalGroups);
        ApiResponse addedPolicy = this.restAPIAdmin.addAdvancedThrottlingPolicy(this.bandwidthPolicyDTO);
        Assert.assertEquals((int)addedPolicy.getStatusCode(), (int)201);
        AdvancedThrottlePolicyDTO addedPolicyDTO = (AdvancedThrottlePolicyDTO)addedPolicy.getData();
        String policyId = addedPolicyDTO.getPolicyId();
        Assert.assertNotNull((Object)policyId, (String)"The policy ID cannot be null or empty");
        this.bandwidthPolicyDTO.setPolicyId(policyId);
        this.bandwidthPolicyDTO.setIsDeployed(Boolean.valueOf(true));
        this.adminApiTestHelper.verifyAdvancedThrottlePolicyDTO(this.bandwidthPolicyDTO, addedPolicyDTO);
    }

    @Test(groups={"wso2.am"}, description="Test add advanced throttling policy with conditional groups", dependsOnMethods={"testAddPolicyWithBandwidthLimit"})
    public void testAddPolicyWithConditionalGroups() throws Exception {
        String policyName = "TestPolicyThree";
        Long requestCount = 50L;
        ArrayList<ConditionalGroupDTO> conditionalGroups = new ArrayList<ConditionalGroupDTO>();
        RequestCountLimitDTO requestCountLimit = DtoFactory.createRequestCountLimitDTO((String)this.timeUnit, (Integer)this.unitTime, (Long)requestCount);
        ThrottleLimitDTO defaultLimit = DtoFactory.createThrottleLimitDTO((ThrottleLimitDTO.TypeEnum)ThrottleLimitDTO.TypeEnum.REQUESTCOUNTLIMIT, (RequestCountLimitDTO)requestCountLimit, null);
        conditionalGroups.add(this.createConditionalGroup(defaultLimit));
        this.conditionalGroupsPolicyDTO = DtoFactory.createAdvancedThrottlePolicyDTO((String)policyName, (String)this.displayName, (String)this.description, (boolean)false, (ThrottleLimitDTO)defaultLimit, conditionalGroups);
        ApiResponse addedPolicy = this.restAPIAdmin.addAdvancedThrottlingPolicy(this.conditionalGroupsPolicyDTO);
        Assert.assertEquals((int)addedPolicy.getStatusCode(), (int)201);
        AdvancedThrottlePolicyDTO addedPolicyDTO = (AdvancedThrottlePolicyDTO)addedPolicy.getData();
        String policyId = addedPolicyDTO.getPolicyId();
        Assert.assertNotNull((Object)policyId, (String)"The policy ID cannot be null or empty");
        this.conditionalGroupsPolicyDTO.setPolicyId(policyId);
        this.conditionalGroupsPolicyDTO.setIsDeployed(Boolean.valueOf(true));
        this.adminApiTestHelper.verifyAdvancedThrottlePolicyDTO(this.conditionalGroupsPolicyDTO, addedPolicyDTO);
    }

    @Test(groups={"wso2.am"}, description="Test get and update advanced throttling policy", dependsOnMethods={"testAddPolicyWithConditionalGroups"})
    public void testGetAndUpdatePolicy() throws Exception {
        String policyId = this.requestCountPolicyDTO.getPolicyId();
        ApiResponse retrievedPolicy = this.restAPIAdmin.getAdvancedThrottlingPolicy(policyId);
        AdvancedThrottlePolicyDTO retrievedPolicyDTO = (AdvancedThrottlePolicyDTO)retrievedPolicy.getData();
        Assert.assertEquals((int)retrievedPolicy.getStatusCode(), (int)200);
        this.adminApiTestHelper.verifyAdvancedThrottlePolicyDTO(this.requestCountPolicyDTO, retrievedPolicyDTO);
        String updatedDescription = "This is a updated test advanced throttle policy";
        this.requestCountPolicyDTO.setDescription(updatedDescription);
        ApiResponse updatedPolicy = this.restAPIAdmin.updateAdvancedThrottlingPolicy(policyId, this.requestCountPolicyDTO);
        AdvancedThrottlePolicyDTO updatedPolicyDTO = (AdvancedThrottlePolicyDTO)updatedPolicy.getData();
        Assert.assertEquals((int)updatedPolicy.getStatusCode(), (int)200);
        this.adminApiTestHelper.verifyAdvancedThrottlePolicyDTO(this.requestCountPolicyDTO, updatedPolicyDTO);
    }

    @Test(groups={"wso2.am"}, description="Test delete advanced throttling policy", dependsOnMethods={"testGetAndUpdatePolicy"})
    public void testDeletePolicy() throws Exception {
        ApiResponse apiResponse = this.restAPIAdmin.deleteAdvancedThrottlingPolicy(this.requestCountPolicyDTO.getPolicyId());
        Assert.assertEquals((int)apiResponse.getStatusCode(), (int)200);
    }

    @Test(groups={"wso2.am"}, description="Test add advanced throttling policy with existing policy name", dependsOnMethods={"testDeletePolicy"})
    public void testAddPolicyWithExistingPolicyName() {
        try {
            this.restAPIAdmin.addAdvancedThrottlingPolicy(this.bandwidthPolicyDTO);
        }
        catch (ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)409);
        }
    }

    @Test(groups={"wso2.am"}, description="Test delete advanced throttling policy with non existing policy ID", dependsOnMethods={"testAddPolicyWithExistingPolicyName"})
    public void testDeletePolicyWithNonExistingPolicyId() {
        try {
            this.restAPIAdmin.deleteAdvancedThrottlingPolicy(UUID.randomUUID().toString() + UUID.randomUUID().toString());
        }
        catch (ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)404);
        }
    }

    public ConditionalGroupDTO createConditionalGroup(ThrottleLimitDTO limit) {
        String conditionalGroupDescription = "This is a test conditional group";
        List<ThrottleConditionDTO> conditions = this.createThrottlingConditions();
        return DtoFactory.createConditionalGroupDTO((String)conditionalGroupDescription, conditions, (ThrottleLimitDTO)limit);
    }

    public List<ThrottleConditionDTO> createThrottlingConditions() {
        ArrayList<ThrottleConditionDTO> throttleConditions = new ArrayList<ThrottleConditionDTO>();
        String specificIP = "10.100.1.22";
        IPConditionDTO ipConditionDTO = DtoFactory.createIPConditionDTO((IPConditionDTO.IpConditionTypeEnum)IPConditionDTO.IpConditionTypeEnum.IPSPECIFIC, (String)specificIP, null, null);
        ThrottleConditionDTO ipCondition = DtoFactory.createThrottleConditionDTO((ThrottleConditionDTO.TypeEnum)ThrottleConditionDTO.TypeEnum.IPCONDITION, (boolean)false, null, (IPConditionDTO)ipConditionDTO, null, null);
        throttleConditions.add(ipCondition);
        String headerName = "Host";
        String headerValue = "10.100.7.77";
        HeaderConditionDTO headerConditionDTO = DtoFactory.createHeaderConditionDTO((String)headerName, (String)headerValue);
        ThrottleConditionDTO headerCondition = DtoFactory.createThrottleConditionDTO((ThrottleConditionDTO.TypeEnum)ThrottleConditionDTO.TypeEnum.HEADERCONDITION, (boolean)false, (HeaderConditionDTO)headerConditionDTO, null, null, null);
        throttleConditions.add(headerCondition);
        String claimUrl = "claimUrl";
        String attribute = "claimAttribute";
        QueryParameterConditionDTO queryParameterConditionDTO = DtoFactory.createQueryParameterConditionDTO((String)claimUrl, (String)attribute);
        ThrottleConditionDTO queryParameterCondition = DtoFactory.createThrottleConditionDTO((ThrottleConditionDTO.TypeEnum)ThrottleConditionDTO.TypeEnum.QUERYPARAMETERCONDITION, (boolean)false, null, null, null, (QueryParameterConditionDTO)queryParameterConditionDTO);
        throttleConditions.add(queryParameterCondition);
        String parameterName = "name";
        String parameterValue = "admin";
        JWTClaimsConditionDTO jwtClaimsConditionDTO = DtoFactory.createJWTClaimsConditionDTO((String)parameterName, (String)parameterValue);
        ThrottleConditionDTO jwtClaimsCondition = DtoFactory.createThrottleConditionDTO((ThrottleConditionDTO.TypeEnum)ThrottleConditionDTO.TypeEnum.JWTCLAIMSCONDITION, (boolean)false, null, null, (JWTClaimsConditionDTO)jwtClaimsConditionDTO, null);
        throttleConditions.add(jwtClaimsCondition);
        return throttleConditions;
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIAdmin.deleteAdvancedThrottlingPolicy(this.bandwidthPolicyDTO.getPolicyId());
        this.restAPIAdmin.deleteAdvancedThrottlingPolicy(this.conditionalGroupsPolicyDTO.getPolicyId());
    }
}

