/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.restapi.admin.throttlingpolicy;

import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.admin.ApiException;
import org.wso2.am.integration.clients.admin.ApiResponse;
import org.wso2.am.integration.clients.admin.api.dto.ApplicationThrottlePolicyDTO;
import org.wso2.am.integration.clients.admin.api.dto.BandwidthLimitDTO;
import org.wso2.am.integration.clients.admin.api.dto.RequestCountLimitDTO;
import org.wso2.am.integration.clients.admin.api.dto.ThrottleLimitDTO;
import org.wso2.am.integration.test.helpers.AdminApiTestHelper;
import org.wso2.am.integration.test.impl.DtoFactory;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;

public class ApplicationThrottlingPolicyTestCase
extends APIMIntegrationBaseTest {
    private String displayName = "Test Policy";
    private String description = "This is a test application throttle policy";
    private String timeUnit = "min";
    private Integer unitTime = 1;
    private ApplicationThrottlePolicyDTO requestCountPolicyDTO;
    private ApplicationThrottlePolicyDTO bandwidthPolicyDTO;
    private AdminApiTestHelper adminApiTestHelper;

    @Factory(dataProvider="userModeDataProvider")
    public ApplicationThrottlingPolicyTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.adminApiTestHelper = new AdminApiTestHelper();
    }

    @Test(groups={"wso2.am"}, description="Test add application throttling policy with request count limit")
    public void testAddPolicyWithRequestCountLimit() throws Exception {
        String policyName = "TestPolicyOne";
        Long requestCount = 50L;
        RequestCountLimitDTO requestCountLimit = DtoFactory.createRequestCountLimitDTO((String)this.timeUnit, (Integer)this.unitTime, (Long)requestCount);
        ThrottleLimitDTO defaultLimit = DtoFactory.createThrottleLimitDTO((ThrottleLimitDTO.TypeEnum)ThrottleLimitDTO.TypeEnum.REQUESTCOUNTLIMIT, (RequestCountLimitDTO)requestCountLimit, null);
        this.requestCountPolicyDTO = DtoFactory.createApplicationThrottlePolicyDTO((String)policyName, (String)this.displayName, (String)this.description, (boolean)false, (ThrottleLimitDTO)defaultLimit);
        ApiResponse addedPolicy = this.restAPIAdmin.addApplicationThrottlingPolicy(this.requestCountPolicyDTO);
        Assert.assertEquals((int)addedPolicy.getStatusCode(), (int)201);
        ApplicationThrottlePolicyDTO addedPolicyDTO = (ApplicationThrottlePolicyDTO)addedPolicy.getData();
        String policyId = addedPolicyDTO.getPolicyId();
        Assert.assertNotNull((Object)policyId, (String)"The policy ID cannot be null or empty");
        this.requestCountPolicyDTO.setPolicyId(policyId);
        this.requestCountPolicyDTO.setIsDeployed(Boolean.valueOf(true));
        this.adminApiTestHelper.verifyApplicationThrottlePolicyDTO(this.requestCountPolicyDTO, addedPolicyDTO);
    }

    @Test(groups={"wso2.am"}, description="Test add application throttling policy with bandwidth limit", dependsOnMethods={"testAddPolicyWithRequestCountLimit"})
    public void testAddPolicyWithBandwidthLimit() throws Exception {
        String policyName = "TestPolicyTwo";
        Long dataAmount = 2L;
        String dataUnit = "KB";
        BandwidthLimitDTO bandwidthLimit = DtoFactory.createBandwidthLimitDTO((String)this.timeUnit, (Integer)this.unitTime, (Long)dataAmount, (String)dataUnit);
        ThrottleLimitDTO defaultLimit = DtoFactory.createThrottleLimitDTO((ThrottleLimitDTO.TypeEnum)ThrottleLimitDTO.TypeEnum.BANDWIDTHLIMIT, null, (BandwidthLimitDTO)bandwidthLimit);
        this.bandwidthPolicyDTO = DtoFactory.createApplicationThrottlePolicyDTO((String)policyName, (String)this.displayName, (String)this.description, (boolean)false, (ThrottleLimitDTO)defaultLimit);
        ApiResponse addedPolicy = this.restAPIAdmin.addApplicationThrottlingPolicy(this.bandwidthPolicyDTO);
        Assert.assertEquals((int)addedPolicy.getStatusCode(), (int)201);
        ApplicationThrottlePolicyDTO addedPolicyDTO = (ApplicationThrottlePolicyDTO)addedPolicy.getData();
        String policyId = addedPolicyDTO.getPolicyId();
        Assert.assertNotNull((Object)policyId, (String)"The policy ID cannot be null or empty");
        this.bandwidthPolicyDTO.setPolicyId(policyId);
        this.bandwidthPolicyDTO.setIsDeployed(Boolean.valueOf(true));
        this.adminApiTestHelper.verifyApplicationThrottlePolicyDTO(this.bandwidthPolicyDTO, addedPolicyDTO);
    }

    @Test(groups={"wso2.am"}, description="Test get and update application throttling policy", dependsOnMethods={"testAddPolicyWithBandwidthLimit"})
    public void testGetAndUpdatePolicy() throws Exception {
        String policyId = this.requestCountPolicyDTO.getPolicyId();
        ApiResponse retrievedPolicy = this.restAPIAdmin.getApplicationThrottlingPolicy(policyId);
        ApplicationThrottlePolicyDTO retrievedPolicyDTO = (ApplicationThrottlePolicyDTO)retrievedPolicy.getData();
        Assert.assertEquals((int)retrievedPolicy.getStatusCode(), (int)200);
        this.adminApiTestHelper.verifyApplicationThrottlePolicyDTO(this.requestCountPolicyDTO, retrievedPolicyDTO);
        String updatedDescription = "This is a updated test application throttle policy";
        this.requestCountPolicyDTO.setDescription(updatedDescription);
        ApiResponse updatedPolicy = this.restAPIAdmin.updateApplicationThrottlingPolicy(policyId, this.requestCountPolicyDTO);
        ApplicationThrottlePolicyDTO updatedPolicyDTO = (ApplicationThrottlePolicyDTO)updatedPolicy.getData();
        Assert.assertEquals((int)updatedPolicy.getStatusCode(), (int)200);
        this.adminApiTestHelper.verifyApplicationThrottlePolicyDTO(this.requestCountPolicyDTO, updatedPolicyDTO);
    }

    @Test(groups={"wso2.am"}, description="Test delete application throttling policy", dependsOnMethods={"testGetAndUpdatePolicy"})
    public void testDeletePolicy() throws Exception {
        ApiResponse apiResponse = this.restAPIAdmin.deleteApplicationThrottlingPolicy(this.requestCountPolicyDTO.getPolicyId());
        Assert.assertEquals((int)apiResponse.getStatusCode(), (int)200);
    }

    @Test(groups={"wso2.am"}, description="Test add application throttling policy with existing policy name", dependsOnMethods={"testDeletePolicy"})
    public void testAddPolicyWithExistingPolicyName() {
        try {
            this.restAPIAdmin.addApplicationThrottlingPolicy(this.bandwidthPolicyDTO);
        }
        catch (ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)409);
        }
    }

    @Test(groups={"wso2.am"}, description="Test delete application throttling policy with non existing policy ID", dependsOnMethods={"testAddPolicyWithExistingPolicyName"})
    public void testDeletePolicyWithNonExistingPolicyId() {
        try {
            this.restAPIAdmin.deleteApplicationThrottlingPolicy(UUID.randomUUID().toString() + UUID.randomUUID().toString());
        }
        catch (ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)404);
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIAdmin.deleteApplicationThrottlingPolicy(this.bandwidthPolicyDTO.getPolicyId());
    }
}

