/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.restapi.admin.throttlingpolicy;

import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.admin.ApiException;
import org.wso2.am.integration.clients.admin.ApiResponse;
import org.wso2.am.integration.clients.admin.api.dto.CustomRuleDTO;
import org.wso2.am.integration.test.helpers.AdminApiTestHelper;
import org.wso2.am.integration.test.impl.DtoFactory;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;

public class CustomThrottlingPolicyTestCase
extends APIMIntegrationBaseTest {
    private String policyId;
    private CustomRuleDTO customRuleDTO;
    private AdminApiTestHelper adminApiTestHelper;

    @Factory(dataProvider="userModeDataProvider")
    public CustomThrottlingPolicyTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.adminApiTestHelper = new AdminApiTestHelper();
    }

    @Test(groups={"wso2.am"}, description="Test add custom throttling policy")
    public void testAddPolicy() {
        block2: {
            String policyName = "TestPolicy";
            String description = "This is a test custom throttle policy";
            String siddhiQuery = "FROM RequestStream\nSELECT userId, ( userId == 'admin@carbon.super' ) AS isEligible, str:concat('admin@carbon.super','') as throttleKey\nINSERT INTO EligibilityStream; \n\nFROM EligibilityStream[isEligible==true]#throttler:timeBatch(1 min) \nSELECT throttleKey, (count(userId) >= 10) as isThrottled, expiryTimeStamp group by throttleKey \nINSERT ALL EVENTS into ResultStream;";
            String keyTemplate = "$userId";
            this.customRuleDTO = DtoFactory.createCustomThrottlePolicyDTO((String)policyName, (String)description, (boolean)false, (String)siddhiQuery, (String)keyTemplate);
            try {
                ApiResponse addedPolicy = this.restAPIAdmin.addCustomThrottlingPolicy(this.customRuleDTO);
                Assert.assertEquals((int)addedPolicy.getStatusCode(), (int)201);
                CustomRuleDTO addedPolicyDTO = (CustomRuleDTO)addedPolicy.getData();
                this.policyId = addedPolicyDTO.getPolicyId();
                Assert.assertNotNull((Object)this.policyId, (String)"The policy ID cannot be null or empty");
                this.customRuleDTO.setPolicyId(this.policyId);
                this.customRuleDTO.setIsDeployed(Boolean.valueOf(true));
                this.adminApiTestHelper.verifyCustomThrottlePolicyDTO(this.customRuleDTO, addedPolicyDTO);
            }
            catch (ApiException e) {
                if (this.userMode != TestUserMode.TENANT_ADMIN) break block2;
                Assert.assertEquals((int)e.getCode(), (int)403);
            }
        }
    }

    @Test(groups={"wso2.am"}, description="Test get custom throttling policy", dependsOnMethods={"testAddPolicy"})
    public void testGetPolicy() {
        block3: {
            if (this.userMode == TestUserMode.TENANT_ADMIN) {
                this.policyId = UUID.randomUUID().toString() + UUID.randomUUID().toString();
            }
            try {
                ApiResponse retrievedPolicy = this.restAPIAdmin.getCustomThrottlingPolicy(this.policyId);
                CustomRuleDTO retrievedPolicyDTO = (CustomRuleDTO)retrievedPolicy.getData();
                Assert.assertEquals((int)retrievedPolicy.getStatusCode(), (int)200);
                this.adminApiTestHelper.verifyCustomThrottlePolicyDTO(this.customRuleDTO, retrievedPolicyDTO);
            }
            catch (ApiException e) {
                if (this.userMode != TestUserMode.TENANT_ADMIN) break block3;
                Assert.assertEquals((int)e.getCode(), (int)403);
            }
        }
    }

    @Test(groups={"wso2.am"}, description="Test update custom throttling policy", dependsOnMethods={"testGetPolicy"})
    public void testUpdatePolicy() {
        block2: {
            try {
                String updatedDescription = "This is a updated test custom throttle policy";
                this.customRuleDTO.setDescription(updatedDescription);
                ApiResponse updatedPolicy = this.restAPIAdmin.updateCustomThrottlingPolicy(this.policyId, this.customRuleDTO);
                CustomRuleDTO updatedPolicyDTO = (CustomRuleDTO)updatedPolicy.getData();
                Assert.assertEquals((int)updatedPolicy.getStatusCode(), (int)200);
                this.adminApiTestHelper.verifyCustomThrottlePolicyDTO(this.customRuleDTO, updatedPolicyDTO);
            }
            catch (ApiException e) {
                if (this.userMode != TestUserMode.TENANT_ADMIN) break block2;
                Assert.assertEquals((int)e.getCode(), (int)403);
            }
        }
    }

    @Test(groups={"wso2.am"}, description="Test add custom throttling policy with existing policy name", dependsOnMethods={"testUpdatePolicy"})
    public void testAddPolicyWithExistingPolicyName() {
        try {
            this.restAPIAdmin.addCustomThrottlingPolicy(this.customRuleDTO);
        }
        catch (ApiException e) {
            if (this.userMode == TestUserMode.TENANT_ADMIN) {
                Assert.assertEquals((int)e.getCode(), (int)403);
            }
            Assert.assertEquals((int)e.getCode(), (int)409);
        }
    }

    @Test(groups={"wso2.am"}, description="Test delete custom throttling policy", dependsOnMethods={"testAddPolicyWithExistingPolicyName"})
    public void testDeletePolicy() {
        block2: {
            try {
                ApiResponse apiResponse = this.restAPIAdmin.deleteCustomThrottlingPolicy(this.policyId);
                Assert.assertEquals((int)apiResponse.getStatusCode(), (int)200);
            }
            catch (ApiException e) {
                if (this.userMode != TestUserMode.TENANT_ADMIN) break block2;
                Assert.assertEquals((int)e.getCode(), (int)403);
            }
        }
    }

    @Test(groups={"wso2.am"}, description="Test delete custom throttling policy with non existing policy ID", dependsOnMethods={"testDeletePolicy"})
    public void testDeletePolicyWithNonExistentPolicyId() {
        try {
            this.restAPIAdmin.deleteCustomThrottlingPolicy(UUID.randomUUID().toString() + UUID.randomUUID().toString());
        }
        catch (ApiException e) {
            if (this.userMode == TestUserMode.TENANT_ADMIN) {
                Assert.assertEquals((int)e.getCode(), (int)403);
            }
            Assert.assertEquals((int)e.getCode(), (int)404);
        }
    }
}

