/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.streamingapis.serversentevents.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import javax.ws.rs.sse.InboundSseEvent;
import javax.ws.rs.sse.SseEventSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleSseReceiver
implements SseEventSource {
    private static final String DATA = "data:";
    private static final String REQUEST_IS_THROTTLED_SEGMENT = "request is throttled";
    private static final String MEDIA_TYPE_SSE = "text/event-stream";
    private final Log log = LogFactory.getLog(SimpleSseReceiver.class);
    private final WebTarget target;
    private String bearerToken;
    private AtomicInteger receivedDataEventsCount;
    private Consumer<Boolean> throttledResponseProcessor;

    public SimpleSseReceiver(WebTarget target, String bearerToken) {
        this.target = target;
        this.bearerToken = bearerToken;
        this.receivedDataEventsCount = new AtomicInteger(0);
    }

    public void registerThrottledResponseConsumer(Consumer<Boolean> consumer) {
        this.throttledResponseProcessor = consumer;
    }

    public void register(Consumer<InboundSseEvent> consumer) {
    }

    public void register(Consumer<InboundSseEvent> consumer, Consumer<Throwable> consumer1) {
    }

    public void register(Consumer<InboundSseEvent> consumer, Consumer<Throwable> consumer1, Runnable runnable) {
    }

    public void open() {
        Invocation.Builder builder = this.target.request(new String[]{MEDIA_TYPE_SSE}).header("Authorization", (Object)("Bearer " + this.bearerToken));
        Response response = builder.get();
        if (response.getStatus() == 204) {
            return;
        }
        this.process(response);
    }

    private void process(Response response) {
        InputStream inputStream = (InputStream)response.getEntity();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            String line = reader.readLine();
            while (line != null) {
                if (line.startsWith(DATA)) {
                    this.log.info((Object)("Received data - " + line));
                    this.receivedDataEventsCount.incrementAndGet();
                } else if (line.contains(REQUEST_IS_THROTTLED_SEGMENT)) {
                    this.processThrottledResponse();
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            this.log.error((Object)"Failed to read the response.", (Throwable)e);
        }
    }

    private void processThrottledResponse() {
        if (this.throttledResponseProcessor != null) {
            this.throttledResponseProcessor.accept(true);
        }
        this.log.info((Object)"Throttled out");
    }

    public boolean isOpen() {
        return false;
    }

    public boolean close(long l, TimeUnit timeUnit) {
        return true;
    }

    public int getReceivedDataEventsCount() {
        return this.receivedDataEventsCount.get();
    }

    public void setReceivedDataEventsCount(int receivedDataEventsCount) {
        this.receivedDataEventsCount.set(receivedDataEventsCount);
    }
}

