/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.streamingapis.serversentevents.server;

import java.io.IOException;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.servlets.EventSource;
import org.eclipse.jetty.servlets.EventSourceServlet;

@WebServlet(urlPatterns={"/memory"}, initParams={@WebInitParam(name="heartBeatPeriod", value="5")}, asyncSupported=true)
public class SseServlet
extends EventSourceServlet {
    private final Log log = LogFactory.getLog(SseServlet.class);
    private AtomicInteger eventsSent = new AtomicInteger(0);

    public int getEventsSent() {
        return this.eventsSent.get();
    }

    public void setEventsSent(int eventsSent) {
        this.eventsSent.set(eventsSent);
    }

    protected EventSource newEventSource(HttpServletRequest httpServletRequest) {
        return new EventSource(){

            public void onOpen(EventSource.Emitter emitter) throws IOException {
                SseServlet.this.log.info((Object)"SSE Servlet opened");
                while (true) {
                    SseServlet.this.log.info((Object)"Propagating event...");
                    try {
                        Thread.sleep(3000L);
                        emitter.data("new server event " + new Date().toString());
                        SseServlet.this.eventsSent.incrementAndGet();
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }

            public void onClose() {
                SseServlet.this.log.info((Object)"SSE Servlet closed");
            }
        };
    }
}

