/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.streamingapis.websub;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.Servlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.WebsubSubscriptionConfigurationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APIListDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SubscriptionDTO;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleAction;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.am.integration.tests.streamingapis.StreamingApiTestUtils;
import org.wso2.am.integration.tests.streamingapis.websub.WebSubAPITestCase;
import org.wso2.am.integration.tests.streamingapis.websub.client.WebhookSender;
import org.wso2.am.integration.tests.streamingapis.websub.server.CallbackServerServlet;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.engine.exceptions.AutomationFrameworkException;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;
import org.wso2.carbon.automation.test.utils.common.TestConfigurationProvider;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.utils.mgt.ServerConfigurationManager;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class LeaseTimeSubscriptionTestCase
extends APIMIntegrationBaseTest {
    private final Log log = LogFactory.getLog(WebSubAPITestCase.class);
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final int TOPIC_PORT = 9521;
    private final String DEFAULT_TOPIC = "_default";
    private final String SUBSCRIBE = "subscribe";
    private final String UNSUBSCRIBE = "unsubscribe";
    private String apiName = "WebSubAPI";
    private String applicationName = "WebSubApplication";
    private String apiContext = "websub";
    private String apiVersion = "1.0.0";
    private String webSubEventPublisherSource = TestConfigurationProvider.getResourceLocation() + File.separator + "artifacts" + File.separator + "AM" + File.separator + "configFiles" + File.separator + "streamingAPIs" + File.separator + "webSubTest" + File.separator;
    private String webSubRequestEventPublisherSource = "WebSub_Req_Logger.xml";
    private String webSubThrottleOutEventPublisherSource = "WebSub_Throttle_Out_Logger.xml";
    private String webSubEventPublisherTarget = FrameworkPathUtil.getCarbonHome() + File.separator + "repository" + File.separator + "deployment" + File.separator + "server" + File.separator + "eventpublishers" + File.separator;
    private ServerConfigurationManager serverConfigurationManager;
    private String provider;
    private APIRequest apiRequest;
    private int callbackReceiverPort;
    private String serverHost;
    private String apiId;
    private String appId;
    private String topicSecret;
    private String apiEndpoint;
    private WebhookSender webhookSender;
    private CallbackServerServlet callbackServerServlet;
    private Server callbackServer;

    @Factory(dataProvider="userModeDataProvider")
    public LeaseTimeSubscriptionTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.serverConfigurationManager = new ServerConfigurationManager(this.gatewayContextWrk);
        this.serverConfigurationManager.applyConfigurationWithoutRestart(new File(this.webSubEventPublisherSource + this.webSubRequestEventPublisherSource), new File(this.webSubEventPublisherTarget + this.webSubRequestEventPublisherSource), false);
        this.serverConfigurationManager.applyConfigurationWithoutRestart(new File(this.webSubEventPublisherSource + this.webSubThrottleOutEventPublisherSource), new File(this.webSubEventPublisherTarget + this.webSubThrottleOutEventPublisherSource), false);
        this.serverHost = InetAddress.getLocalHost().getHostName();
        int lowerPortLimit = 8080;
        int upperPortLimit = 8090;
        this.callbackReceiverPort = StreamingApiTestUtils.getAvailablePort(lowerPortLimit, upperPortLimit, this.serverHost);
        if (this.callbackReceiverPort == -1) {
            throw new APIManagerIntegrationTestException("No available port in the range " + lowerPortLimit + "-" + upperPortLimit + " was found");
        }
        this.log.info((Object)("Selected port " + this.callbackReceiverPort + " to start callback receiver"));
        this.initializeCallbackReceiver(this.callbackReceiverPort);
        Thread.sleep(5000L);
    }

    @Test(description="Publish WebSub API")
    public void testPublishWebSubApi() throws Exception {
        this.provider = this.user.getUserName();
        URI endpointUri = new URI("http://" + this.serverHost + ":" + this.callbackReceiverPort + "/receiver");
        this.apiRequest = new APIRequest(this.apiName, this.apiContext, endpointUri, endpointUri);
        this.apiRequest.setVersion(this.apiVersion);
        this.apiRequest.setTiersCollection("AsyncWHUnlimited");
        this.apiRequest.setProvider(this.provider);
        this.apiRequest.setType("WEBSUB");
        HttpResponse addAPIResponse = this.restAPIPublisher.addAPI(this.apiRequest);
        this.apiId = addAPIResponse.getData();
        this.createAPIRevisionAndDeployUsingRest(this.apiId, this.restAPIPublisher);
        APIDTO apiDto = this.restAPIPublisher.getAPIByID(this.apiId);
        this.topicSecret = UUID.randomUUID().toString();
        WebsubSubscriptionConfigurationDTO websubSubscriptionConfig = new WebsubSubscriptionConfigurationDTO();
        websubSubscriptionConfig.setSecret(this.topicSecret);
        websubSubscriptionConfig.setSigningAlgorithm("SHA1");
        websubSubscriptionConfig.setSignatureHeader("x-hub-signature");
        apiDto.setWebsubSubscriptionConfiguration(websubSubscriptionConfig);
        this.restAPIPublisher.updateAPI(apiDto, this.apiId);
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, APILifeCycleAction.PUBLISH.getAction(), null);
        this.waitForAPIDeploymentSync(this.user.getUserName(), this.apiName, this.apiVersion, "\"isApiExists\":true");
        APIIdentifier apiIdentifier = new APIIdentifier(this.provider, this.apiName, this.apiVersion);
        this.apiEndpoint = TestUserMode.SUPER_TENANT_ADMIN.equals((Object)this.userMode) || TestUserMode.SUPER_TENANT_USER.equals((Object)this.userMode) ? this.getSuperTenantAPIInvocationURLHttp(this.apiContext, this.apiVersion) : this.getAPIInvocationURLHttp(this.apiContext, this.apiVersion);
        org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO apiPublisherAllAPIs = this.restAPIPublisher.getAllAPIs();
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)apiIdentifier, (org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO)apiPublisherAllAPIs), (String)"Published API is visible in API Publisher.");
        APIListDTO restAPIStoreAllAPIs = TestUserMode.SUPER_TENANT_ADMIN == this.userMode ? this.restAPIStore.getAllAPIs() : this.restAPIStore.getAllAPIs(this.user.getUserDomain());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailableInStore((APIIdentifier)apiIdentifier, (APIListDTO)restAPIStoreAllAPIs), (String)"Published API is visible in API Store.");
    }

    @Test(description="Create Application and subscribe", dependsOnMethods={"testPublishWebSubApi"})
    public void testWebSubApiApplicationSubscription() throws Exception {
        HttpResponse applicationResponse = this.restAPIStore.createApplication(this.applicationName, "", "Unlimited", ApplicationDTO.TokenTypeEnum.OAUTH);
        this.appId = applicationResponse.getData();
        SubscriptionDTO subscriptionDTO = this.restAPIStore.subscribeToAPI(this.apiId, this.appId, "AsyncWHUnlimited");
        Assert.assertEquals((Object)subscriptionDTO.getStatus(), (Object)SubscriptionDTO.StatusEnum.UNBLOCKED);
    }

    @Test(description="Invoke the WebSub API", dependsOnMethods={"testWebSubApiApplicationSubscription"})
    public void testInvokeWebSubApi() throws Exception {
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("password");
        grantTypes.add("refresh_token");
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.appId, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        String accessToken = applicationKeyDTO.getToken().getAccessToken();
        String callbackUrl = "http://" + this.serverHost + ":" + this.callbackReceiverPort + "/receiver";
        LeaseTimeSubscriptionTestCase.handleCallbackSubscription("subscribe", this.apiEndpoint, callbackUrl, "_default", this.topicSecret, "15", accessToken);
        this.initializeWebhookSender(this.topicSecret);
        Thread.sleep(5000L);
        this.webhookSender.send();
        Thread.sleep(5000L);
        int sent = this.webhookSender.getWebhooksSent();
        int received = this.callbackServerServlet.getCallbacksReceived();
        Assert.assertEquals((int)sent, (int)1);
        Assert.assertEquals((int)received, (int)2);
        Thread.sleep(10000L);
        this.webhookSender.send();
        sent = this.webhookSender.getWebhooksSent();
        received = this.callbackServerServlet.getCallbacksReceived();
        Assert.assertEquals((int)sent, (int)2);
        Assert.assertEquals((int)received, (int)2);
        LeaseTimeSubscriptionTestCase.handleCallbackSubscription("unsubscribe", this.apiEndpoint, callbackUrl, "_default", this.topicSecret, "15", accessToken);
        this.callbackServerServlet.setCallbacksReceived(0);
        this.webhookSender.setWebhooksSent(0);
    }

    private void initializeCallbackReceiver(int port) {
        Server server = new Server(port);
        final ServletHandler servletHandler = new ServletHandler();
        server.setHandler((Handler)servletHandler);
        this.callbackServerServlet = new CallbackServerServlet();
        this.callbackServer = server;
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ServletHolder servletHolder = new ServletHolder((Servlet)LeaseTimeSubscriptionTestCase.this.callbackServerServlet);
                    servletHandler.addServletWithMapping(servletHolder, "/receiver");
                    LeaseTimeSubscriptionTestCase.this.callbackServer.start();
                }
                catch (Exception e) {
                    LeaseTimeSubscriptionTestCase.this.log.error((Object)"Failed to start the callback server");
                }
            }
        });
    }

    private void initializeWebhookSender(String secret) {
        String payloadUrl = this.apiEndpoint.replaceAll(":([0-9]+)/", ":9521/") + "/webhooks_events_receiver_resource?topic=" + "_default";
        this.webhookSender = new WebhookSender(payloadUrl, secret);
    }

    private static void handleCallbackSubscription(String hubMode, String webSubApiUrl, String callbackUrl, String hubTopic, String hubSecret, String hubLeaseSeconds, String bearerToken) throws UnsupportedEncodingException, MalformedURLException, AutomationFrameworkException {
        String encodedUrl = URLEncoder.encode(callbackUrl, StandardCharsets.UTF_8.toString());
        String url = webSubApiUrl + "?hub.callback=" + encodedUrl + "&hub.mode=" + hubMode + "&hub.secret=" + hubSecret + "&hub.lease_seconds=" + hubLeaseSeconds + "&hub.topic=" + hubTopic;
        HttpRequestUtil.doPost((URL)new URL(url), (String)"", Collections.singletonMap("Authorization", "Bearer " + bearerToken));
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.serverConfigurationManager.restoreToLastConfiguration(false);
        this.callbackServer.stop();
        this.executorService.shutdownNow();
        super.cleanUp();
    }
}

