/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.streamingapis.websub.client;

import java.net.URL;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.am.integration.tests.streamingapis.StreamingApiTestUtils;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class WebhookSender {
    private final Log log = LogFactory.getLog(WebhookSender.class);
    private String payloadUrl;
    private String secretKey;
    private AtomicInteger webhooksSent = new AtomicInteger(0);

    public WebhookSender(String payloadUrl, String secret) {
        this.payloadUrl = payloadUrl;
        this.secretKey = secret;
    }

    public int getWebhooksSent() {
        return this.webhooksSent.get();
    }

    public void setWebhooksSent(int webhooksSent) {
        this.webhooksSent.set(webhooksSent);
    }

    public void send() throws Exception {
        String body = "{\"Hello\" : \"World\"}";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        headers.put("x-hub-signature", this.generateXHubSignature(body));
        HttpResponse response = HttpRequestUtil.doPost((URL)new URL(this.payloadUrl), (String)body, headers);
        if (response.getResponseCode() == 200) {
            this.webhooksSent.incrementAndGet();
            this.log.info((Object)"Webhook sent successfully");
        } else {
            this.log.error((Object)"Webhook was not successfully sent");
        }
    }

    private String generateXHubSignature(String body) throws InvalidKeyException, NoSuchAlgorithmException {
        return "sha1=" + StreamingApiTestUtils.calculateRFC2104HMAC(body, this.secretKey);
    }
}

