/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.throttling;

import com.google.gson.Gson;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.admin.ApiResponse;
import org.wso2.am.integration.clients.admin.api.dto.AdvancedThrottlePolicyDTO;
import org.wso2.am.integration.clients.admin.api.dto.ApplicationThrottlePolicyDTO;
import org.wso2.am.integration.clients.admin.api.dto.ConditionalGroupDTO;
import org.wso2.am.integration.clients.admin.api.dto.HeaderConditionDTO;
import org.wso2.am.integration.clients.admin.api.dto.IPConditionDTO;
import org.wso2.am.integration.clients.admin.api.dto.JWTClaimsConditionDTO;
import org.wso2.am.integration.clients.admin.api.dto.QueryParameterConditionDTO;
import org.wso2.am.integration.clients.admin.api.dto.RequestCountLimitDTO;
import org.wso2.am.integration.clients.admin.api.dto.SubscriptionThrottlePolicyDTO;
import org.wso2.am.integration.clients.admin.api.dto.ThrottleConditionDTO;
import org.wso2.am.integration.clients.admin.api.dto.ThrottleLimitDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SubscriptionDTO;
import org.wso2.am.integration.test.impl.DtoFactory;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class JWTRequestCountThrottlingTestCase
extends APIMIntegrationBaseTest {
    private final String appPolicyName = "AppPolicyWithRequestCount";
    private final String subPolicyName = "SubPolicyWithRequestCount";
    private final String apiPolicyName1 = "APIPolicyWithRequestCount1";
    private final String apiPolicyName2 = "APIPolicyWithRequestCount2";
    private String appPolicyId;
    private String subPolicyId;
    private String apiPolicyId1;
    private String apiPolicyId2;
    private String apiId;
    private String gatewayUrl;
    private String appId1;
    private String appId2;
    private String appId3;
    private String appId4;
    ApplicationKeyDTO applicationKeyDTOOfAPILevelTest;
    private static final Log log = LogFactory.getLog(JWTRequestCountThrottlingTestCase.class);

    @Factory(dataProvider="userModeDataProvider")
    public JWTRequestCountThrottlingTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        RequestCountLimitDTO requestCountLimit3PerMin = DtoFactory.createRequestCountLimitDTO((String)"min", (Integer)1, (Long)3L);
        RequestCountLimitDTO appLimit = DtoFactory.createRequestCountLimitDTO((String)"min", (Integer)1, (Long)5L);
        ThrottleLimitDTO defaultLimit = DtoFactory.createThrottleLimitDTO((ThrottleLimitDTO.TypeEnum)ThrottleLimitDTO.TypeEnum.REQUESTCOUNTLIMIT, (RequestCountLimitDTO)requestCountLimit3PerMin, null);
        ThrottleLimitDTO appLimitDTO = DtoFactory.createThrottleLimitDTO((ThrottleLimitDTO.TypeEnum)ThrottleLimitDTO.TypeEnum.REQUESTCOUNTLIMIT, (RequestCountLimitDTO)appLimit, null);
        ApplicationThrottlePolicyDTO requestCountPolicyDTO = DtoFactory.createApplicationThrottlePolicyDTO((String)"AppPolicyWithRequestCount", (String)"", (String)"", (boolean)false, (ThrottleLimitDTO)appLimitDTO);
        ApiResponse addedApplicationPolicy = this.restAPIAdmin.addApplicationThrottlingPolicy(requestCountPolicyDTO);
        Assert.assertEquals((int)addedApplicationPolicy.getStatusCode(), (int)201);
        ApplicationThrottlePolicyDTO addedApplicationPolicyDTO = (ApplicationThrottlePolicyDTO)addedApplicationPolicy.getData();
        this.appPolicyId = addedApplicationPolicyDTO.getPolicyId();
        Assert.assertNotNull((Object)this.appPolicyId, (String)"The policy ID cannot be null or empty");
        SubscriptionThrottlePolicyDTO requestCountSubscriptionPolicyDTO = DtoFactory.createSubscriptionThrottlePolicyDTO((String)"SubPolicyWithRequestCount", (String)"", (String)"", (boolean)false, (ThrottleLimitDTO)defaultLimit, (int)-1, (int)-1, (int)100, (String)"min", new ArrayList(), (boolean)true, (String)"", (int)0);
        ApiResponse addedSubscriptionPolicy = this.restAPIAdmin.addSubscriptionThrottlingPolicy(requestCountSubscriptionPolicyDTO);
        Assert.assertEquals((int)addedSubscriptionPolicy.getStatusCode(), (int)201);
        SubscriptionThrottlePolicyDTO addedSubscriptionPolicyDTO = (SubscriptionThrottlePolicyDTO)addedSubscriptionPolicy.getData();
        this.subPolicyId = addedSubscriptionPolicyDTO.getPolicyId();
        Assert.assertNotNull((Object)this.subPolicyId, (String)"The policy ID cannot be null or empty");
        AdvancedThrottlePolicyDTO requestCountAdvancedPolicyDTO = DtoFactory.createAdvancedThrottlePolicyDTO((String)"APIPolicyWithRequestCount1", (String)"", (String)"", (boolean)false, (ThrottleLimitDTO)defaultLimit, new ArrayList());
        ApiResponse addedApiPolicy1 = this.restAPIAdmin.addAdvancedThrottlingPolicy(requestCountAdvancedPolicyDTO);
        Assert.assertEquals((int)addedApiPolicy1.getStatusCode(), (int)201);
        AdvancedThrottlePolicyDTO addedAdvancedPolicyDTO = (AdvancedThrottlePolicyDTO)addedApiPolicy1.getData();
        this.apiPolicyId1 = addedAdvancedPolicyDTO.getPolicyId();
        Assert.assertNotNull((Object)this.apiPolicyId1, (String)"The policy ID cannot be null or empty");
        RequestCountLimitDTO requestCountLimit10000PerMin = DtoFactory.createRequestCountLimitDTO((String)"min", (Integer)1, (Long)10L);
        ThrottleLimitDTO defaultLimit2 = DtoFactory.createThrottleLimitDTO((ThrottleLimitDTO.TypeEnum)ThrottleLimitDTO.TypeEnum.REQUESTCOUNTLIMIT, (RequestCountLimitDTO)requestCountLimit10000PerMin, null);
        AdvancedThrottlePolicyDTO requestCountAdvancedPolicyDTO2 = DtoFactory.createAdvancedThrottlePolicyDTO((String)"APIPolicyWithRequestCount2", (String)"", (String)"", (boolean)false, (ThrottleLimitDTO)defaultLimit2, this.createConditionalGroups(defaultLimit));
        ApiResponse addedApiPolicy2 = this.restAPIAdmin.addAdvancedThrottlingPolicy(requestCountAdvancedPolicyDTO2);
        Assert.assertEquals((int)addedApiPolicy2.getStatusCode(), (int)201);
        AdvancedThrottlePolicyDTO addedAdvancedPolicyDTO2 = (AdvancedThrottlePolicyDTO)addedApiPolicy2.getData();
        this.apiPolicyId2 = addedAdvancedPolicyDTO2.getPolicyId();
        Assert.assertNotNull((Object)this.apiPolicyId2, (String)"The policy ID cannot be null or empty");
        String backendEP = this.gatewayUrlsWrk.getWebAppURLNhttp() + "response/";
        String APIName = "RequestCountTestAPI";
        String APIContext = "requestcounttestapi";
        String description = "This is test API create by API manager integration test";
        String APIVersion = "1.0.0";
        APIRequest apiRequest = new APIRequest(APIName, APIContext, new URL(backendEP), new URL(backendEP));
        apiRequest.setDescription(description);
        apiRequest.setVersion(APIVersion);
        apiRequest.setSandbox(backendEP);
        apiRequest.setProvider(this.user.getUserName());
        apiRequest.setTiersCollection("Unlimited,SubPolicyWithRequestCount");
        ArrayList<APIOperationsDTO> operations = new ArrayList<APIOperationsDTO>();
        APIOperationsDTO apiOperationsDTO = new APIOperationsDTO();
        apiOperationsDTO.setVerb("POST");
        apiOperationsDTO.setTarget("/*");
        apiOperationsDTO.setAuthType("Application & Application User");
        apiOperationsDTO.setThrottlingPolicy("Unlimited");
        operations.add(apiOperationsDTO);
        apiRequest.setOperationsDTOS(operations);
        HttpResponse serviceResponse = this.restAPIPublisher.addAPI(apiRequest);
        this.apiId = serviceResponse.getData();
        this.createAPIRevisionAndDeployUsingRest(this.apiId, this.restAPIPublisher);
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, "Publish");
        this.waitForAPIDeploymentSync(this.user.getUserName(), APIName, APIVersion, "\"isApiExists\":true");
        this.gatewayUrl = this.getAPIInvocationURLHttps(APIContext + "/" + APIVersion + "/");
        HashMap requestHeaders = new HashMap();
        HttpResponse response = HttpRequestUtil.doGet((String)backendEP, requestHeaders);
        Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Backend (dummy_api.xml) is not up and running");
        ApplicationDTO applicationDTO = this.restAPIStore.addApplication("NormalAPP", "Unlimited", "", "this-is-test");
        this.appId3 = applicationDTO.getApplicationId();
        SubscriptionDTO subscriptionDTO = this.restAPIStore.subscribeToAPI(this.apiId, applicationDTO.getApplicationId(), "Unlimited");
        Assert.assertEquals((String)subscriptionDTO.getThrottlingPolicy(), (String)"Unlimited");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        this.applicationKeyDTOOfAPILevelTest = this.restAPIStore.generateKeys(applicationDTO.getApplicationId(), "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
    }

    @Test(groups={"wso2.am"}, description="")
    public void testApplicationLevelThrottling() throws Exception {
        ApplicationDTO applicationDTO = this.restAPIStore.addApplication("ApplicationRequestCountTestApp", "AppPolicyWithRequestCount", "", "this-is-test");
        this.appId1 = applicationDTO.getApplicationId();
        Assert.assertEquals((String)applicationDTO.getThrottlingPolicy(), (String)"AppPolicyWithRequestCount");
        SubscriptionDTO subscriptionDTO = this.restAPIStore.subscribeToAPI(this.apiId, applicationDTO.getApplicationId(), "Unlimited");
        Assert.assertEquals((String)subscriptionDTO.getThrottlingPolicy(), (String)"Unlimited");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(applicationDTO.getApplicationId(), "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        String accessToken = applicationKeyDTO.getToken().getAccessToken();
        String jwtString = APIMTestCaseUtils.getDecodedJWT((String)accessToken);
        log.info((Object)("Decoded JWT token: " + jwtString));
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        requestHeaders.put("accept", "text/xml");
        requestHeaders.put("content-type", "application/json");
        Assert.assertTrue((boolean)this.isThrottled(requestHeaders, null, 12), (String)"Request not throttled by request count condition in application tier");
    }

    @Test(groups={"wso2.am"}, description="")
    public void testSubscriptionLevelThrottling() throws Exception {
        ApplicationDTO applicationDTO = this.restAPIStore.addApplication("SubscriptionRequestCountTestApp", "Unlimited", "", "this-is-test");
        this.appId2 = applicationDTO.getApplicationId();
        SubscriptionDTO subscriptionDTO = this.restAPIStore.subscribeToAPI(this.apiId, applicationDTO.getApplicationId(), "SubPolicyWithRequestCount");
        Assert.assertEquals((String)subscriptionDTO.getThrottlingPolicy(), (String)"SubPolicyWithRequestCount");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(applicationDTO.getApplicationId(), "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        String accessToken = applicationKeyDTO.getToken().getAccessToken();
        String jwtString = APIMTestCaseUtils.getDecodedJWT((String)accessToken);
        log.info((Object)("Decoded JWT token: " + jwtString));
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        requestHeaders.put("accept", "text/xml");
        requestHeaders.put("content-type", "application/json");
        Assert.assertTrue((boolean)this.isThrottled(requestHeaders, null, 6), (String)"Request not throttled by request count condition in subscription tier");
    }

    @Test(groups={"wso2.am"}, description="", dependsOnMethods={"testSubscriptionLevelThrottling", "testApplicationLevelThrottling"})
    public void testAPILevelThrottling() throws Exception {
        HttpResponse api = this.restAPIPublisher.getAPI(this.apiId);
        Gson gson = new Gson();
        APIDTO apidto = (APIDTO)gson.fromJson(api.getData(), APIDTO.class);
        apidto.setApiThrottlingPolicy("APIPolicyWithRequestCount1");
        APIDTO updatedAPI = this.restAPIPublisher.updateAPI(apidto, this.apiId);
        Assert.assertEquals((String)updatedAPI.getApiThrottlingPolicy(), (String)"APIPolicyWithRequestCount1", (String)"API tier not updated.");
        this.createAPIRevisionAndDeployUsingRest(this.apiId, this.restAPIPublisher);
        this.waitForAPIDeployment();
        this.waitForAPIDeploymentSync(this.user.getUserName(), apidto.getName(), apidto.getVersion(), "\"isApiExists\":true");
        Assert.assertNotNull((Object)this.applicationKeyDTOOfAPILevelTest.getToken());
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + this.applicationKeyDTOOfAPILevelTest.getToken().getAccessToken());
        requestHeaders.put("accept", "text/xml");
        requestHeaders.put("content-type", "application/json");
        Assert.assertTrue((boolean)this.isThrottled(requestHeaders, null, 7), (String)"Request not throttled by request count condition in api tier");
    }

    @Test(groups={"wso2.am"}, description="", dependsOnMethods={"testAPILevelThrottling"})
    public void testAPILevelThrottlingWithIpCondition() throws Exception {
        HttpResponse api = this.restAPIPublisher.getAPI(this.apiId);
        Gson gson = new Gson();
        APIDTO apidto = (APIDTO)gson.fromJson(api.getData(), APIDTO.class);
        apidto.setApiThrottlingPolicy("Unlimited");
        APIDTO updatedAPI = this.restAPIPublisher.updateAPI(apidto, this.apiId);
        Assert.assertEquals((String)updatedAPI.getApiThrottlingPolicy(), (String)"Unlimited", (String)"API tier not updated.");
        this.createAPIRevisionAndDeployUsingRest(this.apiId, this.restAPIPublisher);
        this.waitForAPIDeploymentSync(this.user.getUserName(), apidto.getName(), apidto.getVersion(), "\"isApiExists\":false");
        this.waitForAPIDeploymentSync(this.user.getUserName(), apidto.getName(), apidto.getVersion(), "\"isApiExists\":true");
        Assert.assertNotNull((Object)this.applicationKeyDTOOfAPILevelTest.getToken());
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + this.applicationKeyDTOOfAPILevelTest.getToken().getAccessToken());
        requestHeaders.put("accept", "text/xml");
        requestHeaders.put("content-type", "application/json");
        requestHeaders.put("X-Forwarded-For", "10.100.1.22");
        Assert.assertFalse((boolean)this.isThrottled(requestHeaders, null, -1), (String)"Request was throttled unexpectedly in Unlimited API tier");
        apidto.setApiThrottlingPolicy("APIPolicyWithRequestCount2");
        updatedAPI = this.restAPIPublisher.updateAPI(apidto, this.apiId);
        Assert.assertEquals((String)updatedAPI.getApiThrottlingPolicy(), (String)"APIPolicyWithRequestCount2", (String)"API tier not updated.");
        Assert.assertFalse((boolean)this.isThrottled(requestHeaders, null, -1), (String)"Request not need to throttle since policy was Unlimited");
        this.createAPIRevisionAndDeployUsingRest(this.apiId, this.restAPIPublisher);
        this.waitForAPIDeploymentSync(this.user.getUserName(), apidto.getName(), apidto.getVersion(), "\"isApiExists\":false");
        this.waitForAPIDeploymentSync(this.user.getUserName(), apidto.getName(), apidto.getVersion(), "\"isApiExists\":true");
        Assert.assertTrue((boolean)this.isThrottled(requestHeaders, null, 7), (String)"Request not need to throttle since policy was updated");
    }

    @Test(groups={"wso2.am"}, description="", dependsOnMethods={"testAPILevelThrottlingWithIpCondition"})
    public void testAPILevelThrottlingWithHeaderCondition() throws Exception {
        HttpResponse api = this.restAPIPublisher.getAPI(this.apiId);
        Gson gson = new Gson();
        APIDTO apidto = (APIDTO)gson.fromJson(api.getData(), APIDTO.class);
        Assert.assertEquals((String)apidto.getApiThrottlingPolicy(), (String)"APIPolicyWithRequestCount2", (String)"API tier not updated.");
        Assert.assertNotNull((Object)this.applicationKeyDTOOfAPILevelTest.getToken());
        String accessToken = this.applicationKeyDTOOfAPILevelTest.getToken().getAccessToken();
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        requestHeaders.put("accept", "text/xml");
        requestHeaders.put("content-type", "application/json");
        requestHeaders.put("Host", "10.100.7.77");
        Assert.assertTrue((boolean)this.isThrottled(requestHeaders, null, 7), (String)"Request not throttled by request count header condition in API tier");
    }

    @Test(groups={"wso2.am"}, description="", dependsOnMethods={"testAPILevelThrottlingWithHeaderCondition"})
    public void testAPILevelThrottlingWithQueryCondition() throws Exception {
        HttpResponse api = this.restAPIPublisher.getAPI(this.apiId);
        Gson gson = new Gson();
        APIDTO apidto = (APIDTO)gson.fromJson(api.getData(), APIDTO.class);
        Assert.assertEquals((String)apidto.getApiThrottlingPolicy(), (String)"APIPolicyWithRequestCount2", (String)"API tier not updated.");
        Assert.assertNotNull((Object)this.applicationKeyDTOOfAPILevelTest.getToken());
        String accessToken = this.applicationKeyDTOOfAPILevelTest.getToken().getAccessToken();
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        requestHeaders.put("accept", "text/xml");
        requestHeaders.put("content-type", "application/json");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("name", "admin");
        Assert.assertTrue((boolean)this.isThrottled(requestHeaders, queryParams, 7), (String)"Request not throttled by request count query parameter condition in API tier");
    }

    @Test(groups={"wso2.am"}, description="", dependsOnMethods={"testAPILevelThrottlingWithQueryCondition"})
    public void testAPILevelThrottlingWithJWTClaimCondition() throws Exception {
        HttpResponse api = this.restAPIPublisher.getAPI(this.apiId);
        Gson gson = new Gson();
        APIDTO apidto = (APIDTO)gson.fromJson(api.getData(), APIDTO.class);
        Assert.assertEquals((String)apidto.getApiThrottlingPolicy(), (String)"APIPolicyWithRequestCount2", (String)"API tier not updated.");
        ApplicationDTO applicationDTO = this.restAPIStore.addApplication("NormalAPP5", "Unlimited", "", "this-is-test");
        this.appId4 = applicationDTO.getApplicationId();
        SubscriptionDTO subscriptionDTO = this.restAPIStore.subscribeToAPI(this.apiId, applicationDTO.getApplicationId(), "Unlimited");
        Assert.assertEquals((String)subscriptionDTO.getThrottlingPolicy(), (String)"Unlimited");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(applicationDTO.getApplicationId(), "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        String accessToken = applicationKeyDTO.getToken().getAccessToken();
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        requestHeaders.put("accept", "text/xml");
        requestHeaders.put("content-type", "application/json");
        Assert.assertTrue((boolean)this.isThrottled(requestHeaders, null, 10), (String)"Request not throttled by request count jwt claim condition in API tier");
    }

    private boolean isThrottled(Map<String, String> requestHeaders, Map<String, String> queryParams, int expectedCount) throws InterruptedException, IOException {
        Thread.sleep(1000L);
        StringBuilder url = new StringBuilder(this.gatewayUrl);
        if (queryParams != null) {
            int i = 0;
            if (expectedCount == -1) {
                expectedCount = 21;
            }
            for (Map.Entry<String, String> entry : queryParams.entrySet()) {
                System.out.println(entry.getKey() + "/" + entry.getValue());
                if (i == 0) {
                    url.append((CharSequence)url).append("?").append(entry.getKey()).append("=").append(entry.getValue());
                } else {
                    url.append((CharSequence)url).append("&").append(entry.getKey()).append("=").append(entry.getValue());
                }
                ++i;
            }
        }
        boolean isThrottled = false;
        for (int j = 0; j < expectedCount; ++j) {
            String body = "{\"payload\" : \"00000000000000000\"}";
            HttpResponse response = HTTPSClientUtils.doPost((String)url.toString(), requestHeaders, (String)body);
            log.info((Object)("==============Response " + response.getResponseCode()));
            if (response.getResponseCode() == 429) {
                isThrottled = true;
                break;
            }
            Thread.sleep(500L);
        }
        return isThrottled;
    }

    public List<ConditionalGroupDTO> createConditionalGroups(ThrottleLimitDTO limit) {
        ArrayList<ConditionalGroupDTO> conditionalGroups = new ArrayList<ConditionalGroupDTO>();
        ArrayList<ThrottleConditionDTO> throttleConditions1 = new ArrayList<ThrottleConditionDTO>();
        String specificIP = "10.100.1.22";
        IPConditionDTO ipConditionDTO = DtoFactory.createIPConditionDTO((IPConditionDTO.IpConditionTypeEnum)IPConditionDTO.IpConditionTypeEnum.IPSPECIFIC, (String)specificIP, null, null);
        ThrottleConditionDTO ipCondition = DtoFactory.createThrottleConditionDTO((ThrottleConditionDTO.TypeEnum)ThrottleConditionDTO.TypeEnum.IPCONDITION, (boolean)false, null, (IPConditionDTO)ipConditionDTO, null, null);
        throttleConditions1.add(ipCondition);
        conditionalGroups.add(DtoFactory.createConditionalGroupDTO((String)"Test conditional group 1", throttleConditions1, (ThrottleLimitDTO)limit));
        ArrayList<ThrottleConditionDTO> throttleConditions2 = new ArrayList<ThrottleConditionDTO>();
        String headerName = "Host";
        String headerValue = "10.100.7.77";
        HeaderConditionDTO headerConditionDTO = DtoFactory.createHeaderConditionDTO((String)headerName, (String)headerValue);
        ThrottleConditionDTO headerCondition = DtoFactory.createThrottleConditionDTO((ThrottleConditionDTO.TypeEnum)ThrottleConditionDTO.TypeEnum.HEADERCONDITION, (boolean)false, (HeaderConditionDTO)headerConditionDTO, null, null, null);
        throttleConditions2.add(headerCondition);
        conditionalGroups.add(DtoFactory.createConditionalGroupDTO((String)"Test conditional group 2", throttleConditions2, (ThrottleLimitDTO)limit));
        ArrayList<ThrottleConditionDTO> throttleConditions3 = new ArrayList<ThrottleConditionDTO>();
        String parameterName = "name";
        String parameterValue = "admin";
        QueryParameterConditionDTO queryParameterConditionDTO = DtoFactory.createQueryParameterConditionDTO((String)parameterName, (String)parameterValue);
        ThrottleConditionDTO queryParameterCondition = DtoFactory.createThrottleConditionDTO((ThrottleConditionDTO.TypeEnum)ThrottleConditionDTO.TypeEnum.QUERYPARAMETERCONDITION, (boolean)false, null, null, null, (QueryParameterConditionDTO)queryParameterConditionDTO);
        throttleConditions3.add(queryParameterCondition);
        conditionalGroups.add(DtoFactory.createConditionalGroupDTO((String)"Test conditional group 3", throttleConditions3, (ThrottleLimitDTO)limit));
        ArrayList<ThrottleConditionDTO> throttleConditions4 = new ArrayList<ThrottleConditionDTO>();
        String claimUrl = "http://wso2.org/claims/applicationname";
        String attribute = "NormalAPP5";
        JWTClaimsConditionDTO jwtClaimsConditionDTO = DtoFactory.createJWTClaimsConditionDTO((String)claimUrl, (String)attribute);
        ThrottleConditionDTO jwtClaimsCondition = DtoFactory.createThrottleConditionDTO((ThrottleConditionDTO.TypeEnum)ThrottleConditionDTO.TypeEnum.JWTCLAIMSCONDITION, (boolean)false, null, null, (JWTClaimsConditionDTO)jwtClaimsConditionDTO, null);
        throttleConditions4.add(jwtClaimsCondition);
        conditionalGroups.add(DtoFactory.createConditionalGroupDTO((String)"Test conditional group 4", throttleConditions4, (ThrottleLimitDTO)limit));
        return conditionalGroups;
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIStore.deleteApplication(this.appId1);
        this.restAPIStore.deleteApplication(this.appId2);
        this.restAPIStore.deleteApplication(this.appId3);
        this.restAPIStore.deleteApplication(this.appId4);
        this.restAPIPublisher.deleteAPI(this.apiId);
        this.restAPIAdmin.deleteAdvancedThrottlingPolicy(this.apiPolicyId1);
        this.restAPIAdmin.deleteAdvancedThrottlingPolicy(this.apiPolicyId2);
        this.restAPIAdmin.deleteApplicationThrottlingPolicy(this.appPolicyId);
        this.restAPIAdmin.deleteSubscriptionThrottlingPolicy(this.subPolicyId);
    }
}

