/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.token;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.Response;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SubscriptionDTO;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.token.TokenUtils;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class RefreshTokenTestCase
extends APIMIntegrationBaseTest {
    private static String backEndEndpointUrl;
    private String apiId;
    private String tokenTestApiAppId;
    private static final String APPLICATION_NAME = "RefreshTokenTestAPI-Application";

    @Factory(dataProvider="userModeDataProvider")
    public RefreshTokenTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}, {TestUserMode.SUPER_TENANT_USER_STORE_USER}, {TestUserMode.SUPER_TENANT_EMAIL_USER}, {TestUserMode.TENANT_EMAIL_USER}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        backEndEndpointUrl = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice";
    }

    @Test(groups={"wso2.am"}, description="Test Refresh token functionality")
    public void testRefreshTokenAPITestCase() throws Exception {
        String apiName = "RefreshTokenTestAPI";
        String apiContext = "refreshTokenTestAPI";
        String tags = "sample, token, media";
        String description = "This is test API create by API manager integration test";
        String apiVersion = "1.0.0";
        APIRequest apiRequest = new APIRequest(apiName, apiContext, new URL(backEndEndpointUrl));
        apiRequest.setTags(tags);
        apiRequest.setDescription(description);
        apiRequest.setVersion(apiVersion);
        apiRequest.setSandbox(backEndEndpointUrl);
        apiRequest.setProvider(this.user.getUserName());
        HttpResponse serviceResponse = this.restAPIPublisher.addAPI(apiRequest);
        this.apiId = serviceResponse.getData();
        this.createAPIRevisionAndDeployUsingRest(this.apiId, this.restAPIPublisher);
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, "Publish");
        this.waitForAPIDeploymentSync(apiRequest.getProvider(), apiName, apiVersion, "\"isApiExists\":true");
        String gatewayUrl = this.getAPIInvocationURLHttp("tokenTestAPI/1.0.0/customers/123");
        ApplicationDTO applicationDTO = this.restAPIStore.addApplicationWithTokenType(APPLICATION_NAME, "Unlimited", "", "this-is-test", "OAUTH");
        this.tokenTestApiAppId = applicationDTO.getApplicationId();
        SubscriptionDTO subscriptionDTO = this.restAPIStore.subscribeToAPI(this.apiId, applicationDTO.getApplicationId(), "Gold");
        Assert.assertEquals((boolean)true, (boolean)subscriptionDTO.getThrottlingPolicy().equals("Gold"));
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("password");
        grantTypes.add("refresh_token");
        grantTypes.add("client_credentials");
        ApplicationKeyDTO productionApplicationKeyDTO = this.restAPIStore.generateKeys(this.tokenTestApiAppId, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        String consumerKey = productionApplicationKeyDTO.getConsumerKey();
        String consumerSecret = productionApplicationKeyDTO.getConsumerSecret();
        String requestBody = "grant_type=password&username=" + this.user.getUserName() + "&password=" + this.user.getPassword() + "&scope=PRODUCTION";
        URL tokenEndpointURL = new URL(this.keyManagerHTTPSURL + "oauth2/token");
        JSONObject accessTokenGenerationResponse = new JSONObject(this.restAPIStore.generateUserAccessKey(consumerKey, consumerSecret, requestBody, tokenEndpointURL).getData());
        String userAccessToken = accessTokenGenerationResponse.getString("access_token");
        String refreshToken = accessTokenGenerationResponse.getString("refresh_token");
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        String tokenJti = TokenUtils.getJtiOfJwtToken((String)userAccessToken);
        requestHeaders.put("Authorization", "Bearer " + tokenJti);
        requestHeaders.put("accept", "text/xml");
        String apiUrl = this.getAPIInvocationURLHttp("refreshTokenTestAPI/1.0.0/customers/123");
        HttpResponse httpResponse = HttpRequestUtil.doGet((String)apiUrl, requestHeaders);
        Thread.sleep(5000L);
        httpResponse = HttpRequestUtil.doGet((String)apiUrl, requestHeaders);
        Assert.assertEquals((int)httpResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched");
        Assert.assertTrue((boolean)httpResponse.getData().contains("John"), (String)"Response data mismatched");
        Assert.assertTrue((boolean)httpResponse.getData().contains("<name>"), (String)"Response data mismatched");
        Assert.assertTrue((boolean)httpResponse.getData().contains("<Customer>"), (String)"Response data mismatched");
        String getAccessTokenFromRefreshTokenRequestBody = "grant_type=refresh_token&refresh_token=" + refreshToken;
        accessTokenGenerationResponse = new JSONObject(this.restAPIStore.generateUserAccessKey(consumerKey, consumerSecret, getAccessTokenFromRefreshTokenRequestBody, tokenEndpointURL).getData());
        userAccessToken = accessTokenGenerationResponse.getString("access_token");
        requestHeaders = new HashMap();
        tokenJti = TokenUtils.getJtiOfJwtToken((String)userAccessToken);
        requestHeaders.put("Authorization", "Bearer " + tokenJti);
        requestHeaders.put("accept", "text/xml");
        httpResponse = HttpRequestUtil.doGet((String)apiUrl, requestHeaders);
        Assert.assertEquals((int)httpResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched");
        Assert.assertTrue((boolean)httpResponse.getData().contains("John"), (String)"Response data mismatched");
        Assert.assertTrue((boolean)httpResponse.getData().contains("<name"), (String)"Response data mismatched");
        Assert.assertTrue((boolean)httpResponse.getData().contains("<Customer>"), (String)"Response data mismatched");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIStore.deleteApplication(this.tokenTestApiAppId);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.apiId, this.restAPIPublisher);
        this.restAPIPublisher.deleteAPI(this.apiId);
    }
}

