/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APICreationTestCase
extends APIManagerLifecycleBaseTest {
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private String apiEndpointUrl;
    private String apiId;

    @Factory(dataProvider="userModeDataProvider")
    public APICreationTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void initialize() throws Exception {
        super.init(this.userMode);
        this.apiEndpointUrl = this.backEndServerUrl.getWebAppURLHttp() + "jaxrs_basic/services/customers/customerservice/";
    }

    @Test(groups={"wso2.am"}, description="Test deployment of API with Mutual SSL enabled")
    public void testCreateAndDeployApiWithMutualSSLEnabled() throws Exception {
        APIRequest apiRequest = new APIRequest("MutuallSSLEnabledAPI", "mutualsslapi", new URL(this.apiEndpointUrl));
        apiRequest.setVersion("1.0.0");
        apiRequest.setTier("Unlimited");
        apiRequest.setProvider(this.user.getUserName());
        List<String> securityScheme = Arrays.asList("mutualssl", "mutualssl_mandatory");
        apiRequest.setSecurityScheme(securityScheme);
        HttpResponse apiResponse = this.restAPIPublisher.addAPI(apiRequest);
        this.apiId = apiResponse.getData();
        String certificate = this.getAMResourceLocation() + File.separator + "lifecycletest" + File.separator + "mutualssl" + File.separator + "example.crt";
        this.restAPIPublisher.uploadCertificate(new File(certificate), "example", this.apiId, "Unlimited");
        String revisionUUID = this.createAPIRevisionAndDeployUsingRest(this.apiId, this.restAPIPublisher);
        Assert.assertNotNull((Object)revisionUUID);
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        this.restAPIPublisher.deleteAPI(this.apiId);
    }
}

