/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.store.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SubscriptionDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SubscriptionListDTO;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APILifeCycleAction;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIAccessibilityOfPublishedOldAPIAndPublishedCopyAPITestCase
extends APIManagerLifecycleBaseTest {
    private final String API_NAME = "APIAccessibilityOfOldAndCopyAPITest";
    private final String API_CONTEXT = "APIAccessibilityOfOldAndCopyAPI";
    private final String API_TAGS = "testTag1, testTag2, testTag3";
    private final String API_DESCRIPTION = "This is test API create by API manager integration test";
    private final String API_END_POINT_METHOD = "customers/123";
    private final String API_RESPONSE_DATA = "<id>123</id><name>John</name></Customer>";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String API_VERSION_2_0_0 = "2.0.0";
    private final String APPLICATION_NAME = "APIAccessibilityOfPublishedOldAPIAndPublishedCopyAPITestCase";
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private String apiEndPointUrl;
    private String providerName;
    private String applicationId;
    private String apiId;
    private String newApiId;
    private APIRequest apiRequest;
    private ArrayList<String> grantTypes;
    private Map<String, String> requestHeaders;

    @BeforeClass(alwaysRun=true)
    public void initialize() throws Exception {
        super.init();
        this.apiEndPointUrl = this.backEndServerUrl.getWebAppURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        this.providerName = this.user.getUserName();
        this.grantTypes = new ArrayList();
        this.apiEndPointUrl = this.backEndServerUrl.getWebAppURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        this.providerName = this.user.getUserName();
        this.apiRequest = new APIRequest("APIAccessibilityOfOldAndCopyAPITest", "APIAccessibilityOfOldAndCopyAPI", new URL(this.apiEndPointUrl));
        this.apiRequest.setVersion("1.0.0");
        this.apiRequest.setTiersCollection("Unlimited");
        this.apiRequest.setTier("Unlimited");
        this.apiRequest.setProvider(this.providerName);
        this.apiRequest.setTags("testTag1, testTag2, testTag3");
        this.apiRequest.setDescription("This is test API create by API manager integration test");
        this.apiId = this.createAndPublishAPIUsingRest(this.apiRequest, this.restAPIPublisher, false);
        HttpResponse applicationResponse = this.restAPIStore.createApplication("APIAccessibilityOfPublishedOldAPIAndPublishedCopyAPITestCase", "Test Application", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
        this.applicationId = applicationResponse.getData();
    }

    @Test(groups={"wso2.am"}, description=" Test Copy API.Copy API version 1.0.0  to 2.0.0 ")
    public void testCopyAPI() throws Exception {
        this.waitForAPIDeploymentSync(this.apiRequest.getProvider(), this.apiRequest.getName(), this.apiRequest.getVersion(), "\"isApiExists\":true");
        this.apiRequest.setVersion("2.0.0");
        HttpResponse newVersionResponse = this.restAPIPublisher.copyAPI("2.0.0", this.apiId, null);
        Assert.assertEquals((int)newVersionResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Copy API request code is invalid." + this.getAPIIdentifierStringFromAPIRequest(this.apiRequest)));
        Assert.assertTrue((boolean)StringUtils.isNotEmpty((String)newVersionResponse.getData()), (String)("Copy  API response data is invalid" + this.getAPIIdentifierStringFromAPIRequest(this.apiRequest)));
        this.newApiId = newVersionResponse.getData();
        this.createAPIRevisionAndDeployUsingRest(this.newApiId, this.restAPIPublisher);
    }

    @Test(groups={"wso2.am"}, description="Test publish activity of a copied API.", dependsOnMethods={"testCopyAPI"})
    public void testPublishCopiedAPI() throws Exception {
        HttpResponse publishAPIResponse = this.restAPIPublisher.changeAPILifeCycleStatus(this.newApiId, APILifeCycleAction.PUBLISH.getAction(), null);
        Assert.assertEquals((int)publishAPIResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("API publish Response code is invalid " + this.getAPIIdentifierStringFromAPIRequest(this.apiRequest)));
        Assert.assertTrue((boolean)APILifeCycleState.PUBLISHED.getState().equals(publishAPIResponse.getData()), (String)("API status Change is invalid when retire an API :APIAccessibilityOfOldAndCopyAPITest with API ID (" + this.apiId + ") Response Code:" + publishAPIResponse.getResponseCode()));
    }

    @Test(groups={"wso2.am"}, description=" Test availability of old and new API versions in the store.", dependsOnMethods={"testPublishCopiedAPI"})
    public void testAvailabilityOfOldAndNewAPIVersionsInStore() throws Exception {
        this.waitForAPIDeploymentSync(this.apiRequest.getProvider(), this.apiRequest.getName(), "1.0.0", "\"isApiExists\":true");
        APIDTO oldApiDto = this.restAPIStore.getAPI(this.apiId);
        this.apiRequest.setVersion("1.0.0");
        Assert.assertTrue((boolean)StringUtils.isNotEmpty((String)oldApiDto.getId()), (String)("Old version of the API is not available in API Store" + this.getAPIIdentifierStringFromAPIRequest(this.apiRequest)));
        this.waitForAPIDeploymentSync(this.apiRequest.getProvider(), this.apiRequest.getName(), "2.0.0", "\"isApiExists\":true");
        APIDTO newApiDto = this.restAPIStore.getAPI(this.newApiId);
        this.apiRequest.setVersion("2.0.0");
        Assert.assertTrue((boolean)StringUtils.isNotEmpty((String)newApiDto.getId()), (String)("Old version of the API is not available in API Store" + this.getAPIIdentifierStringFromAPIRequest(this.apiRequest)));
    }

    @Test(groups={"wso2.am"}, description="Test subscribe of old API version.", dependsOnMethods={"testAvailabilityOfOldAndNewAPIVersionsInStore"})
    public void testSubscribeOldVersion() throws APIManagerIntegrationTestException {
        HttpResponse oldVersionSubscribeResponse = this.subscribeToAPIUsingRest(this.apiId, this.applicationId, "Unlimited", this.restAPIStore);
        this.apiRequest.setVersion("1.0.0");
        Assert.assertEquals((int)oldVersionSubscribeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Subscribe of old API version request not successful " + this.getAPIIdentifierStringFromAPIRequest(this.apiRequest)));
        Assert.assertTrue((boolean)StringUtils.isNotEmpty((String)oldVersionSubscribeResponse.getData()), (String)("Error in subscribe of old API version" + this.getAPIIdentifierStringFromAPIRequest(this.apiRequest)));
    }

    @Test(groups={"wso2.am"}, description=" Test availability of old and new API versions i the store.", dependsOnMethods={"testSubscribeOldVersion"})
    public void testSubscribeNewVersion() throws APIManagerIntegrationTestException {
        HttpResponse newVersionSubscribeResponse = this.subscribeToAPIUsingRest(this.newApiId, this.applicationId, "Unlimited", this.restAPIStore);
        this.apiRequest.setVersion("2.0.0");
        Assert.assertEquals((int)newVersionSubscribeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Subscribe of old API version request not successful " + this.getAPIIdentifierStringFromAPIRequest(this.apiRequest)));
        Assert.assertTrue((boolean)StringUtils.isNotEmpty((String)newVersionSubscribeResponse.getData()), (String)("Error in subscribe of old API version" + this.getAPIIdentifierStringFromAPIRequest(this.apiRequest)));
    }

    @Test(groups={"wso2.am"}, description="Publish a API and check its visibility in the API Store. Copy and create a new version, publish  the new version, test invocation of both old and new API versions.", dependsOnMethods={"testSubscribeNewVersion"})
    public void testAccessibilityOfPublishedOldAPIAndPublishedCopyAPI() throws Exception {
        this.grantTypes.add("password");
        this.grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.applicationId, "36000", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, this.grantTypes);
        this.requestHeaders = new HashMap<String, String>();
        this.requestHeaders.put("accept", "text/xml");
        this.requestHeaders.put("Authorization", "Bearer " + applicationKeyDTO.getToken().getAccessToken());
        HttpResponse oldVersionInvokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttps("APIAccessibilityOfOldAndCopyAPI", "1.0.0") + "/" + "customers/123"), this.requestHeaders);
        Assert.assertEquals((int)oldVersionInvokeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched");
        Assert.assertTrue((boolean)oldVersionInvokeResponse.getData().contains("<id>123</id><name>John</name></Customer>"), (String)"Response data mismatched");
        HttpResponse newVersionInvokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttps("APIAccessibilityOfOldAndCopyAPI", "2.0.0") + "/" + "customers/123"), this.requestHeaders);
        Assert.assertEquals((int)newVersionInvokeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched");
        Assert.assertTrue((boolean)newVersionInvokeResponse.getData().contains("<id>123</id><name>John</name></Customer>"), (String)"Response data mismatched");
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        SubscriptionListDTO subsDTO = this.restAPIStore.getAllSubscriptionsOfApplication(this.applicationId);
        for (SubscriptionDTO subscriptionDTO : subsDTO.getList()) {
            this.restAPIStore.removeSubscription(subscriptionDTO);
        }
        this.restAPIStore.deleteApplication(this.applicationId);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.apiId, this.restAPIPublisher);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.newApiId, this.restAPIPublisher);
        this.restAPIPublisher.deleteAPI(this.apiId);
        this.restAPIPublisher.deleteAPI(this.newApiId);
        super.cleanUp();
    }
}

