/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.ApiException;
import org.wso2.am.integration.clients.publisher.api.ApiResponse;
import org.wso2.am.integration.clients.publisher.api.v1.dto.CertMetadataDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.CertificateInfoDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.CertificateValidityDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.CertificatesDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.http.HttpRequestUtil;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIEndpointCertificateTestCase
extends APIManagerLifecycleBaseTest {
    private static final Log log = LogFactory.getLog(APIEndpointCertificateTestCase.class);
    private final String API_NAME = "APIEndpointCertificateTestCase";
    private final String API_CONTEXT = "APIEndpointCertificateTestCase";
    private final String API_VERSION_1_0_0 = "1.0.0";
    int securedEndpointPort;
    String securedEndpointHost;
    String applicationId;
    String apiId;
    WireMockServer wireMockServer;
    private String accessToken;

    @Factory(dataProvider="userModeDataProvider")
    public APIEndpointCertificateTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void initialize() throws Exception {
        super.init(this.userMode);
        this.securedEndpointHost = InetAddress.getLocalHost().getHostName();
        int lowerPortLimit = 9950;
        int upperPortLimit = 9999;
        this.securedEndpointPort = this.getAvailablePort(lowerPortLimit, upperPortLimit);
        if (this.securedEndpointPort == -1) {
            throw new APIManagerIntegrationTestException("No available port in the range " + lowerPortLimit + "-" + upperPortLimit + " was found");
        }
        log.info((Object)("Selected port " + this.securedEndpointPort + " to start backend server"));
        this.startSecureEndpoint(this.securedEndpointPort);
        String providerName = this.user.getUserName();
        String endpointURL = "https://localhost:" + this.securedEndpointPort + "/abc";
        HttpResponse applicationDTO = this.restAPIStore.createApplication("APIEndpointCertificateTestCase", "Test Application", "Unlimited", ApplicationDTO.TokenTypeEnum.OAUTH);
        this.applicationId = applicationDTO.getData();
        APIRequest apiRequest = new APIRequest("APIEndpointCertificateTestCase", "APIEndpointCertificateTestCase", new URL(endpointURL));
        apiRequest.setVersion("1.0.0");
        apiRequest.setVisibility("public");
        apiRequest.setProvider(providerName);
        ArrayList<String> securitySchemes = new ArrayList<String>();
        securitySchemes.add("oauth2");
        securitySchemes.add("api_key");
        apiRequest.setSecurityScheme(securitySchemes);
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setTier("Unlimited");
        this.apiId = this.createAndPublishAPIUsingRest(apiRequest, this.restAPIPublisher, false);
        this.restAPIStore.subscribeToAPI(this.apiId, this.applicationId, "Unlimited");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        grantTypes.add("password");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.applicationId, "36000", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        this.accessToken = applicationKeyDTO.getToken().getAccessToken();
        this.waitForAPIDeploymentSync(this.user.getUserName(), apiRequest.getName(), apiRequest.getVersion(), "\"isApiExists\":true");
    }

    @Test(groups={"wso2.am"}, description="Invoke API without inserting Endpoint Certificate")
    public void testInvokeAPIWithoutUploadingEndpointCertificate() throws XPathExpressionException, IOException {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("accept", "application/json");
        requestHeaders.put("Authorization", "Bearer " + this.accessToken);
        HttpResponse apiResponse = HttpRequestUtil.doGet((String)this.getAPIInvocationURLHttps("APIEndpointCertificateTestCase", "1.0.0"), requestHeaders);
        Assert.assertEquals((int)apiResponse.getResponseCode(), (int)500);
    }

    @Test(groups={"wso2.am"}, description="test Upload Endpoint Certificate", dependsOnMethods={"testInvokeAPIWithoutUploadingEndpointCertificate"})
    public void testUploadEndpointCertificate() throws ApiException {
        String cert = this.getAMResourceLocation() + File.separator + "endpointCertificate" + File.separator + "endpoint.cer";
        String cert2 = this.getAMResourceLocation() + File.separator + "endpointCertificate" + File.separator + "endpoint2.cer";
        File file = new File(cert);
        ApiResponse httpResponse = this.restAPIPublisher.uploadEndpointCertificate(file, "endpoint-1", "https://localhost:" + this.securedEndpointPort);
        Assert.assertEquals((int)httpResponse.getStatusCode(), (int)201);
        CertMetadataDTO data = (CertMetadataDTO)httpResponse.getData();
        Assert.assertEquals((String)data.getAlias(), (String)"endpoint-1");
        Assert.assertEquals((String)data.getEndpoint(), (String)("https://localhost:" + this.securedEndpointPort));
        httpResponse = this.restAPIPublisher.uploadEndpointCertificate(new File(cert2), "endpoint-2", "https://localhost:" + this.securedEndpointPort);
        Assert.assertEquals((int)httpResponse.getStatusCode(), (int)201);
        data = (CertMetadataDTO)httpResponse.getData();
        Assert.assertEquals((String)data.getAlias(), (String)"endpoint-2");
        Assert.assertEquals((String)data.getEndpoint(), (String)("https://localhost:" + this.securedEndpointPort));
    }

    @Test(groups={"wso2.am"}, description="test Upload Endpoint Certificate", dependsOnMethods={"testUploadEndpointCertificate"})
    public void testUploadSameEndpointCertificateInSameAlias() {
        String cert = this.getAMResourceLocation() + File.separator + "endpointCertificate" + File.separator + "endpoint.cer";
        File file = new File(cert);
        try {
            ApiResponse httpResponse = this.restAPIPublisher.uploadEndpointCertificate(file, "endpoint-1", "https://localhost:" + this.securedEndpointPort);
            Assert.fail((String)"Certificate insert twice  with same detail");
        }
        catch (ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)409);
        }
    }

    @Test(groups={"wso2.am"}, description="test Upload Endpoint Certificate", dependsOnMethods={"testUploadEndpointCertificate"})
    public void testUploadExpiredCert() {
        String cert = this.getAMResourceLocation() + File.separator + "endpointCertificate" + File.separator + "expired.cer";
        File file = new File(cert);
        try {
            ApiResponse httpResponse = this.restAPIPublisher.uploadEndpointCertificate(file, "expired-1", "https://localhost:" + this.securedEndpointPort);
            Assert.fail((String)"Expired Certificate insert ");
        }
        catch (ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)400);
            Assert.assertTrue((boolean)e.getResponseBody().contains("Error while adding the certificate. Certificate Expired."), (String)e.getResponseBody());
        }
    }

    @Test(groups={"wso2.am"}, description="test Upload Endpoint Certificate", dependsOnMethods={"testUploadEndpointCertificate"})
    public void testSearchEndpointCertificates() throws ApiException, ParseException {
        SimpleDateFormat convertedSimpleDateFormat;
        Date from;
        Date to;
        CertificateInfoDTO certificateInfoDTO;
        String endpoint = "https://localhost:" + this.securedEndpointPort;
        CertificatesDTO endpointCertificates = this.restAPIPublisher.getEndpointCertificiates(endpoint, null);
        Assert.assertNotNull((Object)endpointCertificates.getCertificates());
        Assert.assertEquals((int)endpointCertificates.getCertificates().size(), (int)2);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("IST"));
        for (CertMetadataDTO certificate : endpointCertificates.getCertificates()) {
            Assert.assertEquals((String)certificate.getEndpoint(), (String)endpoint);
            if (!"endpoint-1".equals(certificate.getAlias())) continue;
            certificateInfoDTO = this.restAPIPublisher.getendpointCertificateContent("endpoint-1");
            Assert.assertEquals((String)certificateInfoDTO.getStatus(), (String)"Active");
            Assert.assertEquals((String)certificateInfoDTO.getSubject(), (String)"CN=localhost, OU=localhost, C=LK");
            Assert.assertEquals((String)certificateInfoDTO.getVersion(), (String)"3");
            to = simpleDateFormat.parse("Thu May 06 23:41:14 IST 2032");
            from = simpleDateFormat.parse("Fri May 06 23:41:14 IST 2022");
            convertedSimpleDateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
            Assert.assertEquals((Object)certificateInfoDTO.getValidity(), (Object)new CertificateValidityDTO().to(convertedSimpleDateFormat.format(to)).from(convertedSimpleDateFormat.format(from)));
        }
        endpointCertificates = this.restAPIPublisher.getEndpointCertificiates(null, "endpoint-2");
        Assert.assertNotNull((Object)endpointCertificates.getCertificates());
        Assert.assertEquals((int)endpointCertificates.getCertificates().size(), (int)1);
        for (CertMetadataDTO certificate : endpointCertificates.getCertificates()) {
            Assert.assertEquals((String)certificate.getEndpoint(), (String)endpoint);
            if (!"endpoint-2".equals(certificate.getAlias())) continue;
            certificateInfoDTO = this.restAPIPublisher.getendpointCertificateContent("endpoint-2");
            Assert.assertEquals((String)certificateInfoDTO.getStatus(), (String)"Active");
            Assert.assertEquals((String)certificateInfoDTO.getSubject(), (String)"CN=wso2apim, OU=integration, O=WSO2, ST=Colombo, C=LK");
            Assert.assertEquals((String)certificateInfoDTO.getVersion(), (String)"3");
            to = simpleDateFormat.parse("Fri May 07 00:31:00 IST 2032");
            from = simpleDateFormat.parse("Sat May 07 00:31:00 IST 2022");
            convertedSimpleDateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
            Assert.assertEquals((Object)certificateInfoDTO.getValidity(), (Object)new CertificateValidityDTO().to(convertedSimpleDateFormat.format(to)).from(convertedSimpleDateFormat.format(from)));
        }
        endpointCertificates = this.restAPIPublisher.getEndpointCertificiates(null, "endpoint-3");
        Assert.assertNotNull((Object)endpointCertificates.getCertificates());
        Assert.assertEquals((int)endpointCertificates.getCertificates().size(), (int)0);
        endpointCertificates = this.restAPIPublisher.getEndpointCertificiates("https://abc.com", null);
        Assert.assertNotNull((Object)endpointCertificates.getCertificates());
        Assert.assertEquals((int)endpointCertificates.getCertificates().size(), (int)0);
    }

    @Test(groups={"wso2.am"}, description="test Upload Endpoint Certificate", dependsOnMethods={"testSearchEndpointCertificates"})
    public void testInvokeAPI() throws ApiException, InterruptedException, XPathExpressionException, IOException {
        Thread.sleep(60000L);
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("accept", "application/json");
        requestHeaders.put("Authorization", "Bearer " + this.accessToken);
        HttpResponse apiResponse = HttpRequestUtil.doGet((String)this.getAPIInvocationURLHttps("APIEndpointCertificateTestCase", "1.0.0"), requestHeaders);
        Assert.assertEquals((int)apiResponse.getResponseCode(), (int)200);
    }

    @Test(groups={"wso2.am"}, description="test Upload Endpoint Certificate", dependsOnMethods={"testInvokeAPI"})
    public void testInvokeAPIAfterRemovingCertificate() throws InterruptedException, XPathExpressionException, IOException, ApiException {
        ApiResponse response = this.restAPIPublisher.deleteEndpointCertificate("endpoint-1");
        Assert.assertEquals((int)response.getStatusCode(), (int)200);
        response = this.restAPIPublisher.deleteEndpointCertificate("endpoint-2");
        Assert.assertEquals((int)response.getStatusCode(), (int)200);
        Thread.sleep(60500L);
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("accept", "application/json");
        requestHeaders.put("Authorization", "Bearer " + this.accessToken);
        HttpResponse apiResponse = HttpRequestUtil.doGet((String)this.getAPIInvocationURLHttps("APIEndpointCertificateTestCase", "1.0.0"), requestHeaders);
        Assert.assertEquals((int)apiResponse.getResponseCode(), (int)500);
    }

    @Test(groups={"wso2.am"}, description="test Upload Endpoint Certificate", dependsOnMethods={"testInvokeAPI"})
    public void testDeleteNotAvailableCert() {
        try {
            this.restAPIPublisher.deleteEndpointCertificate("endpoint-negative");
            Assert.fail((String)"Failing due to certificate available");
        }
        catch (ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)404);
        }
    }

    private void startSecureEndpoint(int securedEndpointPort) {
        String jksPath = this.getAMResourceLocation() + File.separator + "endpointCertificate" + File.separator + "endpoint.jks";
        WireMockConfiguration wireMockConfiguration = new WireMockConfiguration();
        wireMockConfiguration.httpsPort(Integer.valueOf(securedEndpointPort));
        wireMockConfiguration.keystorePath(jksPath);
        wireMockConfiguration.keystorePassword("wso2carbon");
        wireMockConfiguration.keyManagerPassword("wso2carbon");
        wireMockConfiguration.keystoreType("JKS");
        this.wireMockServer = new WireMockServer((Options)wireMockConfiguration);
        this.wireMockServer.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/abc")).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"text/plain"}).withBody("Hello world!")));
        this.wireMockServer.start();
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws ApiException {
        this.restAPIStore.deleteApplication(this.applicationId);
        this.restAPIPublisher.deleteAPI(this.apiId);
        this.wireMockServer.stop();
    }
}

