/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.ApiException;
import org.wso2.am.integration.clients.publisher.api.ApiResponse;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIMetadataListDTO;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIEndpointCertificateUsageTestCase
extends APIManagerLifecycleBaseTest {
    private static final Log log = LogFactory.getLog(APIEndpointCertificateUsageTestCase.class);
    private final String API_NAME_BASE = "APIEndpointCertificateUsageTestCase";
    private final String API_CONTEXT_BASE = "APIEndpointCertificateUsageTestCase";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String API_ENDPOINT_URL_BASE_1 = "https://abc.test1.com/resource";
    private final String API_ENDPOINT_URL_BASE_2 = "https://abc.test2.com/resource";
    private final String CERT_ALIAS = "cert00001";
    private int apiCount;
    private ArrayList<String> allAPIs;
    private ArrayList<String> evenAPIs;
    private String selectedEndpointUrl;

    @Factory(dataProvider="userModeDataProvider")
    public APIEndpointCertificateUsageTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}, {TestUserMode.TENANT_USER}};
    }

    @BeforeClass(alwaysRun=true)
    public void initialize() throws Exception {
        super.init(this.userMode);
        this.evenAPIs = new ArrayList();
        this.allAPIs = new ArrayList();
        String providerName = this.user.getUserName();
        Random random = new Random();
        int limit = random.ints(20, 30).findFirst().getAsInt();
        for (int i = 0; i < limit; ++i) {
            String apiName = "APIEndpointCertificateUsageTestCase_" + i;
            String apiContext = "APIEndpointCertificateUsageTestCase_" + i;
            String apiEndPointUrl = "https://abc.test1.com/resource" + i;
            if (i % 2 == 0) {
                this.selectedEndpointUrl = apiEndPointUrl = "https://abc.test2.com/resource" + i;
            }
            APIRequest apiRequest = new APIRequest(apiName, apiContext, new URL(apiEndPointUrl));
            apiRequest.setVersion("1.0.0");
            apiRequest.setProvider(providerName);
            apiRequest.setTiersCollection("Unlimited");
            apiRequest.setTier("Unlimited");
            HttpResponse apiResponse = this.restAPIPublisher.addAPI(apiRequest);
            String apiId = apiResponse.getData();
            this.allAPIs.add(apiId);
            if (i % 2 == 0) {
                this.evenAPIs.add(apiId);
            }
            Thread.sleep(1000L);
        }
        this.apiCount = this.evenAPIs.size();
        String cert = this.getAMResourceLocation() + File.separator + "endpointCertificate" + File.separator + "endpoint.cer";
        File file = new File(cert);
        this.restAPIPublisher.uploadEndpointCertificate(file, "cert00001", this.selectedEndpointUrl);
        Thread.sleep(5000L);
    }

    @Test(groups={"wso2.am"}, description="Invoke API with invalid alias to get Endpoint Certificate usage")
    public void testGetCertificateUsageWithIncorrectAlias() throws ApiException {
        ApiResponse httpResponse = this.restAPIPublisher.getCertificateUsage("invalidcert", Integer.valueOf(this.apiCount), Integer.valueOf(0));
        Assert.assertEquals((int)httpResponse.getStatusCode(), (int)200);
        APIMetadataListDTO apiMetadataListDTO = (APIMetadataListDTO)httpResponse.getData();
        List apiMetadataDTOS = apiMetadataListDTO.getList();
        Assert.assertEquals((int)apiMetadataDTOS.size(), (int)0);
    }

    @Test(groups={"wso2.am"}, description="Invoke API to get Certificate usage", dependsOnMethods={"testGetCertificateUsageWithIncorrectAlias"})
    public void testGetCertificateUsageByAlias() throws ApiException {
        ApiResponse httpResponse = this.restAPIPublisher.getCertificateUsage("cert00001", Integer.valueOf(this.apiCount), Integer.valueOf(0));
        Assert.assertEquals((int)httpResponse.getStatusCode(), (int)200);
        APIMetadataListDTO apiMetadataListDTO = (APIMetadataListDTO)httpResponse.getData();
        List apiMetadataDTOS = apiMetadataListDTO.getList();
        Assert.assertEquals((int)apiMetadataDTOS.size(), (int)this.apiCount);
        List apiIds = apiMetadataDTOS.stream().map(apiMetadataDTO -> apiMetadataDTO.getId()).collect(Collectors.toList());
        Assert.assertTrue((boolean)this.evenAPIs.containsAll(apiIds));
    }

    @Test(groups={"wso2.am"}, description="Invoke API with different offsets & limits to test correct behavior", dependsOnMethods={"testGetCertificateUsageByAlias"})
    public void testPaginationOfGetCertificateUsageEndpoint() throws ApiException {
        int limit = this.apiCount - 1;
        int offset = 0;
        int expected = limit;
        ApiResponse httpResponse = this.restAPIPublisher.getCertificateUsage("cert00001", Integer.valueOf(limit), Integer.valueOf(offset));
        List apiMetadataDTOS = ((APIMetadataListDTO)httpResponse.getData()).getList();
        Assert.assertEquals((int)apiMetadataDTOS.size(), (int)expected);
        limit = this.apiCount;
        offset = 0;
        expected = limit;
        httpResponse = this.restAPIPublisher.getCertificateUsage("cert00001", Integer.valueOf(limit), Integer.valueOf(offset));
        apiMetadataDTOS = ((APIMetadataListDTO)httpResponse.getData()).getList();
        Assert.assertEquals((int)apiMetadataDTOS.size(), (int)expected);
        limit = this.apiCount + 5;
        offset = 0;
        expected = this.apiCount;
        httpResponse = this.restAPIPublisher.getCertificateUsage("cert00001", Integer.valueOf(limit), Integer.valueOf(offset));
        apiMetadataDTOS = ((APIMetadataListDTO)httpResponse.getData()).getList();
        Assert.assertEquals((int)apiMetadataDTOS.size(), (int)expected);
        limit = this.apiCount - 4;
        offset = 2;
        expected = this.apiCount - 4;
        httpResponse = this.restAPIPublisher.getCertificateUsage("cert00001", Integer.valueOf(limit), Integer.valueOf(offset));
        apiMetadataDTOS = ((APIMetadataListDTO)httpResponse.getData()).getList();
        Assert.assertEquals((int)apiMetadataDTOS.size(), (int)expected);
        limit = this.apiCount - 3;
        offset = 3;
        expected = this.apiCount - 3;
        httpResponse = this.restAPIPublisher.getCertificateUsage("cert00001", Integer.valueOf(limit), Integer.valueOf(offset));
        apiMetadataDTOS = ((APIMetadataListDTO)httpResponse.getData()).getList();
        Assert.assertEquals((int)apiMetadataDTOS.size(), (int)expected);
        limit = this.apiCount - 3;
        offset = 5;
        expected = this.apiCount - offset;
        httpResponse = this.restAPIPublisher.getCertificateUsage("cert00001", Integer.valueOf(limit), Integer.valueOf(offset));
        apiMetadataDTOS = ((APIMetadataListDTO)httpResponse.getData()).getList();
        Assert.assertEquals((int)apiMetadataDTOS.size(), (int)expected);
        limit = this.apiCount - 3;
        offset = this.apiCount + 2;
        expected = 0;
        httpResponse = this.restAPIPublisher.getCertificateUsage("cert00001", Integer.valueOf(limit), Integer.valueOf(offset));
        apiMetadataDTOS = ((APIMetadataListDTO)httpResponse.getData()).getList();
        Assert.assertEquals((int)apiMetadataDTOS.size(), (int)expected);
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws ApiException {
        this.restAPIPublisher.deleteEndpointCertificate("cert00001");
        for (String apiId : this.allAPIs) {
            this.restAPIPublisher.deleteAPI(apiId);
        }
    }
}

