/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIInvocationWithSimilarResourcesAndDifferentVerbsTestCase
extends APIManagerLifecycleBaseTest {
    private static final String API_NAME = "MultiVerbSimilarResourceAPI";
    private static final String API_CONTEXT = "multiVerbSimilarResourceAPI";
    private static final String API_END_POINT_POSTFIX_URL = "multiVSR/";
    private static final String API_DESCRIPTION = "This is test API create by API manager integration test";
    private static final String API_VERSION_1_0_0 = "1.0.0";
    private static final String RESPONSE_GET = "<response><value>Received GET /comp/cartes*</value></response>";
    private static final String RESPONSE_POST = "<response><value>Received POST /comp/cartes/op*</value></response>";
    private static final String API_ENDPOINT_RESOURCE = "/comp/cartes/op/123";
    private String APPLICATION_NAME = "MultiVerbSimilarResourceApp";
    private String apiEndPointUrl;
    private String providerName;
    private APIIdentifier apiIdentifier;
    private String apiId;
    private String applicarionId;
    private Map<String, String> requestHeaders;

    @BeforeClass(alwaysRun=true)
    public void initialize() throws Exception {
        super.init();
        this.apiEndPointUrl = this.getGatewayURLNhttp() + API_END_POINT_POSTFIX_URL;
        this.providerName = this.publisherContext.getContextTenant().getContextUser().getUserName();
    }

    @Test(groups={"wso2.am"}, description="Invoke all resources and verbs that are valid")
    public void testInvokeAllResources() throws Exception {
        HttpResponse applicationResponse = this.restAPIStore.createApplication(this.APPLICATION_NAME, " Description", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
        this.applicarionId = applicationResponse.getData();
        this.apiIdentifier = new APIIdentifier(this.providerName, API_NAME, API_VERSION_1_0_0);
        APIRequest apiRequest = new APIRequest(API_NAME, API_CONTEXT, new URL(this.apiEndPointUrl));
        apiRequest.setVersion(API_VERSION_1_0_0);
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setTier("Unlimited");
        APIOperationsDTO apiOperationsDTO1 = new APIOperationsDTO();
        apiOperationsDTO1.setVerb("GET");
        apiOperationsDTO1.setTarget("/comp/cartes*");
        apiOperationsDTO1.setAuthType("Application & Application User");
        apiOperationsDTO1.setThrottlingPolicy("Unlimited");
        APIOperationsDTO apiOperationsDTO2 = new APIOperationsDTO();
        apiOperationsDTO2.setVerb("POST");
        apiOperationsDTO2.setTarget("/comp/cartes/op*");
        apiOperationsDTO2.setAuthType("Application & Application User");
        apiOperationsDTO2.setThrottlingPolicy("Unlimited");
        ArrayList<APIOperationsDTO> operationsDTOS = new ArrayList<APIOperationsDTO>();
        operationsDTOS.add(apiOperationsDTO1);
        operationsDTOS.add(apiOperationsDTO2);
        apiRequest.setOperationsDTOS(operationsDTOS);
        apiRequest.setVisibility("public");
        apiRequest.setDescription(API_DESCRIPTION);
        this.apiId = this.createPublishAndSubscribeToAPIUsingRest(apiRequest, this.restAPIPublisher, this.restAPIStore, this.applicarionId, "Unlimited");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("password");
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.applicarionId, "3600", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        this.requestHeaders = new HashMap<String, String>();
        this.requestHeaders.put("Authorization", "Bearer " + applicationKeyDTO.getToken().getAccessToken());
        HttpResponse httpResponseGet = HttpRequestUtil.doGet((String)(this.getGatewayURLNhttp() + API_CONTEXT + "/" + API_VERSION_1_0_0 + API_ENDPOINT_RESOURCE), this.requestHeaders);
        Assert.assertEquals((int)httpResponseGet.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Invocation fails for GET request for /comp/cartes/op/123");
        Assert.assertTrue((boolean)httpResponseGet.getData().contains(RESPONSE_GET), (String)("Response Data not match for GET request for/comp/cartes/op/123 Expected value :\"<response><value>Received GET /comp/cartes*</value></response>\" not contains in response data:\"" + httpResponseGet.getData() + "\""));
        HttpResponse httpResponsePost = HttpRequestUtil.doPost((URL)new URL(this.getGatewayURLNhttp() + API_CONTEXT + "/" + API_VERSION_1_0_0 + API_ENDPOINT_RESOURCE), (String)"", this.requestHeaders);
        Assert.assertEquals((int)httpResponsePost.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Invocation fails for POST request for /comp/cartes/op/123");
        Assert.assertTrue((boolean)httpResponsePost.getData().contains(RESPONSE_POST), (String)("Response Data not match for POST request for auth type Application & Application User. Expected value :\"<response><value>Received GET /comp/cartes*</value></response>\" not contains in response data:\"" + httpResponsePost.getData() + "\""));
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        this.restAPIStore.deleteApplication(this.applicarionId);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.apiId, this.restAPIPublisher);
        this.restAPIPublisher.deleteAPI(this.apiId);
    }
}

