/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.store.api.ApiException;
import org.wso2.am.integration.clients.store.api.v1.dto.APIListDTO;
import org.wso2.am.integration.test.impl.RestAPIPublisherImpl;
import org.wso2.am.integration.test.impl.RestAPIStoreImpl;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.engine.context.beans.User;
import org.wso2.carbon.integration.common.admin.client.UserManagementClient;

public class APIVisibilityByRoleTestCase
extends APIManagerLifecycleBaseTest {
    private final String API_NAME_ADMIN_VISIBILITY = "APIVisibilityByRoleTest";
    private final String API_NAME_SUBSCRIBER_VISIBILITY = "APIVisibilityByRole";
    private final String API_CONTEXT1 = "testAPI1";
    private final String API_CONTEXT2 = "testAPI2";
    private final String API_TAGS = "testTag1, testTag2, testTag3";
    private final String API_DESCRIPTION = "This is test API create by API manager integration test";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String CARBON_SUPER_TENANT2_KEY = "userKey2";
    private final String EMAIL_USER_KEY = "emailUser";
    private final String EMAIL_USER2_KEY = "emailUser2";
    private final String EMAIL_USER3_KEY = "emailUser3";
    private final String TENANT_DOMAIN_KEY = "wso2.com";
    private final String TENANT_DOMAIN_ADMIN_KEY = "admin";
    private final String USER_KEY_USER2 = "userKey1";
    private final String OTHER_DOMAIN_TENANT_USER_KEY = "user1";
    private final String CARBON_SUPER_SUBSCRIBER_USERNAME = "subscriberUser1";
    private final String CARBON_SUPER_SUBSCRIBER_PASSWORD = "password@123";
    private final String TENANT_SUBSCRIBER_USERNAME = "subscriberUser2";
    private final String TENANT_SUBSCRIBER_PASSWORD = "password@123";
    private final String INTERNAL_ROLE_SUBSCRIBER = "Internal/subscriber";
    private final String ROLE_SUBSCRIBER = "subscriber";
    private final String AT = "@";
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private String apiEndPointUrl;
    private String providerName;
    private String apiVisibilityByRoleTestId;
    private String apiVisibilityByRoleId;
    private RestAPIPublisherImpl apiPublisherClientCarbonSuperUser1;
    private RestAPIStoreImpl apiStoreClientCarbonSuperUser1;
    private RestAPIPublisherImpl apiPublisherClientCarbonSuperAdmin;
    private RestAPIStoreImpl apiStoreClientCarbonSuperAdmin;
    private APIIdentifier apiIdentifierAdminVisibility;
    private APIIdentifier apiIdentifierSubscriberVisibility;
    private RestAPIStoreImpl apiStoreClientCarbonSuperUser2;
    private RestAPIPublisherImpl apiPublisherClientCarbonSuperUser2;
    private RestAPIStoreImpl apiStoreClientAnotherUserOtherDomain;
    private RestAPIPublisherImpl apiPublisherClientAnotherUserOtherDomain;
    private RestAPIStoreImpl apiStoreClientAdminOtherDomain;
    private RestAPIPublisherImpl apiPublisherClientAdminOtherDomain;
    private UserManagementClient userManagementClient1;
    private UserManagementClient userManagementClient2;
    private RestAPIStoreImpl apiStoreClientSubscriberUserSameDomain;
    private RestAPIStoreImpl apiStoreClientSubscriberUserOtherDomain;
    private String apiCreatorStoreDomain;
    private String otherDomain;

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.SUPER_TENANT_EMAIL_USER}};
    }

    @Factory(dataProvider="userModeDataProvider")
    public APIVisibilityByRoleTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true)
    public void initialize() throws Exception {
        User otherTenantUser;
        String username3;
        String username2;
        User user3;
        User user2;
        super.init(this.userMode);
        this.apiEndPointUrl = this.backEndServerUrl.getWebAppURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        this.storeURLHttp = this.getStoreURLHttp();
        this.apiPublisherClientCarbonSuperAdmin = new RestAPIPublisherImpl(this.user.getUserNameWithoutDomain(), this.user.getPassword(), this.user.getUserDomain(), this.publisherURLHttps);
        this.apiStoreClientCarbonSuperAdmin = new RestAPIStoreImpl(this.user.getUserNameWithoutDomain(), this.user.getPassword(), this.user.getUserDomain(), this.storeURLHttps);
        this.apiCreatorStoreDomain = this.storeContext.getContextTenant().getDomain();
        if (TestUserMode.SUPER_TENANT_ADMIN.equals((Object)this.userMode)) {
            this.providerName = this.publisherContext.getContextTenant().getTenantUser("userKey1").getUserName();
            user2 = this.publisherContext.getContextTenant().getTenantUser("userKey1");
            user3 = this.publisherContext.getContextTenant().getTenantUser("userKey2");
            username2 = user2.getUserNameWithoutDomain();
            username3 = user3.getUserNameWithoutDomain();
        } else {
            this.providerName = this.publisherContext.getContextTenant().getTenantUser("emailUser2").getUserName() + "@" + this.apiCreatorStoreDomain;
            user2 = this.publisherContext.getContextTenant().getTenantUser("emailUser2");
            user3 = this.publisherContext.getContextTenant().getTenantUser("emailUser3");
            username2 = user2.getUserName();
            username3 = user3.getUserName();
        }
        this.apiPublisherClientCarbonSuperUser1 = new RestAPIPublisherImpl(username2, user2.getPassword(), this.apiCreatorStoreDomain, this.publisherURLHttps);
        this.apiStoreClientCarbonSuperUser1 = new RestAPIStoreImpl(username2, user2.getPassword(), this.apiCreatorStoreDomain, this.storeURLHttps);
        this.apiStoreClientCarbonSuperUser2 = new RestAPIStoreImpl(username3, user3.getPassword(), this.apiCreatorStoreDomain, this.storeURLHttps);
        this.apiPublisherClientCarbonSuperUser2 = new RestAPIPublisherImpl(username3, user3.getPassword(), this.apiCreatorStoreDomain, this.publisherURLHttps);
        this.userManagementClient1 = new UserManagementClient(this.keyManagerContext.getContextUrls().getBackEndUrl(), this.keyManagerContext.getContextTenant().getTenantAdmin().getUserName(), this.keyManagerContext.getContextTenant().getTenantAdmin().getPassword());
        if (this.userManagementClient1.userNameExists("Internal/subscriber", "subscriberUser1")) {
            this.userManagementClient1.deleteUser("subscriberUser1");
        }
        this.userManagementClient1.addUser("subscriberUser1", "password@123", new String[]{"Internal/subscriber"}, null);
        this.apiStoreClientSubscriberUserSameDomain = new RestAPIStoreImpl("subscriberUser1", "password@123", "carbon.super", this.storeURLHttps);
        if (TestUserMode.SUPER_TENANT_ADMIN.equals((Object)this.userMode)) {
            this.init("wso2.com", "admin");
            otherTenantUser = this.publisherContext.getContextTenant().getTenantUser("user1");
        } else {
            this.init("wso2.com", "emailUser");
            otherTenantUser = this.publisherContext.getContextTenant().getTenantUser("emailUser2");
        }
        this.otherDomain = this.storeContext.getContextTenant().getDomain();
        this.apiStoreClientAnotherUserOtherDomain = new RestAPIStoreImpl(otherTenantUser.getUserNameWithoutDomain(), otherTenantUser.getPassword(), this.otherDomain, this.storeURLHttps);
        this.apiPublisherClientAnotherUserOtherDomain = new RestAPIPublisherImpl(otherTenantUser.getUserNameWithoutDomain(), otherTenantUser.getPassword(), this.otherDomain, this.publisherURLHttps);
        this.apiStoreClientAdminOtherDomain = new RestAPIStoreImpl(this.storeContext.getContextTenant().getContextUser().getUserNameWithoutDomain(), this.storeContext.getContextTenant().getContextUser().getPassword(), this.storeContext.getContextTenant().getContextUser().getUserDomain(), this.storeURLHttps);
        this.apiPublisherClientAdminOtherDomain = new RestAPIPublisherImpl(this.publisherContext.getContextTenant().getContextUser().getUserNameWithoutDomain(), this.publisherContext.getContextTenant().getContextUser().getPassword(), this.publisherContext.getContextTenant().getContextUser().getUserDomain(), this.storeURLHttps);
        this.userManagementClient2 = new UserManagementClient(this.keyManagerContext.getContextUrls().getBackEndUrl(), this.keyManagerContext.getContextTenant().getTenantAdmin().getUserName(), this.keyManagerContext.getContextTenant().getTenantAdmin().getPassword());
        if (this.userManagementClient2.userNameExists("Internal/subscriber", "subscriberUser2")) {
            this.userManagementClient2.deleteUser("subscriberUser2");
        }
        this.userManagementClient2.addUser("subscriberUser2", "password@123", new String[]{"Internal/subscriber"}, null);
        this.apiStoreClientSubscriberUserOtherDomain = new RestAPIStoreImpl("subscriberUser2", "password@123", "wso2.com", this.storeURLHttps);
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Publisher for API creator ")
    public void testVisibilityForCreatorInPublisher() throws APIManagerIntegrationTestException, MalformedURLException, XPathExpressionException, org.wso2.am.integration.clients.publisher.api.ApiException {
        this.apiIdentifierAdminVisibility = new APIIdentifier(this.providerName, "APIVisibilityByRoleTest", "1.0.0");
        this.apiIdentifierSubscriberVisibility = new APIIdentifier(this.providerName, "APIVisibilityByRole", "1.0.0");
        APICreationRequestBean apiCreationReqBeanVisibilityAdmin = new APICreationRequestBean("APIVisibilityByRoleTest", "testAPI1", "1.0.0", this.providerName, new URL(this.apiEndPointUrl));
        apiCreationReqBeanVisibilityAdmin.setTags("testTag1, testTag2, testTag3");
        apiCreationReqBeanVisibilityAdmin.setDescription("This is test API create by API manager integration test");
        apiCreationReqBeanVisibilityAdmin.setVisibility(APIDTO.VisibilityEnum.RESTRICTED.getValue());
        apiCreationReqBeanVisibilityAdmin.setRoles("admin");
        APIDTO apiDto = this.apiPublisherClientCarbonSuperUser1.addAPI(apiCreationReqBeanVisibilityAdmin);
        this.apiVisibilityByRoleTestId = apiDto.getId();
        this.publishAPI(this.apiVisibilityByRoleTestId, this.apiPublisherClientCarbonSuperUser1, false);
        this.waitForAPIDeployment();
        APICreationRequestBean apiCreationReqBeanVisibilityInternalSubscriber = new APICreationRequestBean("APIVisibilityByRole", "testAPI2", "1.0.0", this.providerName, new URL(this.apiEndPointUrl));
        apiCreationReqBeanVisibilityInternalSubscriber.setTags("testTag1, testTag2, testTag3");
        apiCreationReqBeanVisibilityInternalSubscriber.setDescription("This is test API create by API manager integration test");
        apiCreationReqBeanVisibilityInternalSubscriber.setVisibility(APIDTO.VisibilityEnum.RESTRICTED.getValue());
        apiCreationReqBeanVisibilityInternalSubscriber.setRoles("Internal/subscriber");
        apiDto = this.apiPublisherClientCarbonSuperUser1.addAPI(apiCreationReqBeanVisibilityInternalSubscriber);
        this.apiVisibilityByRoleId = apiDto.getId();
        this.publishAPI(this.apiVisibilityByRoleId, this.apiPublisherClientCarbonSuperUser1, false);
        this.waitForAPIDeployment();
        List apiPublisherAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO)this.apiPublisherClientCarbonSuperUser1.getAllAPIs());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierAdminVisibility, (List)apiPublisherAPIIdentifierList), (String)("API with  Role admin  visibility is not visible to creator in API Publisher." + this.getAPIIdentifierString(this.apiIdentifierAdminVisibility)));
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierSubscriberVisibility, (List)apiPublisherAPIIdentifierList), (String)("API with  Role Internal/subscriber  visibility is not visible to creator in API Publisher." + this.getAPIIdentifierString(this.apiIdentifierSubscriberVisibility)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Store for API creator", dependsOnMethods={"testVisibilityForCreatorInPublisher"})
    public void testVisibilityForCreatorInStore() throws APIManagerIntegrationTestException, ApiException {
        List apiStoreAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((APIListDTO)this.apiStoreClientCarbonSuperUser1.getAllAPIs(this.apiCreatorStoreDomain));
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierAdminVisibility, (List)apiStoreAPIIdentifierList), (String)("API with  Role admin  visibility is not visible to creator in API Store." + this.getAPIIdentifierString(this.apiIdentifierAdminVisibility)));
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierSubscriberVisibility, (List)apiStoreAPIIdentifierList), (String)("API  with  Role Internal/subscriber  is not visible to creator in API Store. " + this.getAPIIdentifierString(this.apiIdentifierSubscriberVisibility)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Store for admin in same domain ", dependsOnMethods={"testVisibilityForCreatorInPublisher"})
    public void testVisibilityForAdminUserWithAdminAndSubscriberRoleInSameDomainInStore() throws APIManagerIntegrationTestException, ApiException {
        List apiStoreAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((APIListDTO)this.apiStoreClientCarbonSuperAdmin.getAllAPIs(this.apiCreatorStoreDomain));
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierAdminVisibility, (List)apiStoreAPIIdentifierList), (String)("API with  Role admin  visibility is not visible to Admin user with Admin and subscriber role in same domain  in API Store." + this.getAPIIdentifierString(this.apiIdentifierAdminVisibility)));
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierSubscriberVisibility, (List)apiStoreAPIIdentifierList), (String)("API  with  Role Internal/subscriber  is not visible to Admin user with Admin and subscriber role in same domain  in API Store. " + this.getAPIIdentifierString(this.apiIdentifierSubscriberVisibility)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Publisher for another user in same domain", dependsOnMethods={"testVisibilityForAdminUserWithAdminAndSubscriberRoleInSameDomainInStore"})
    public void testVisibilityForAnotherUserWithAdminAndSubscriberRoleInSameDomainInPublisher() throws APIManagerIntegrationTestException, org.wso2.am.integration.clients.publisher.api.ApiException {
        List apiPublisherAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO)this.apiPublisherClientCarbonSuperUser2.getAllAPIs());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierAdminVisibility, (List)apiPublisherAPIIdentifierList), (String)("API with  Role admin  visibility is not visible to another user with Admin and subscriber role in same domain  in API Publisher." + this.getAPIIdentifierString(this.apiIdentifierAdminVisibility)));
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierSubscriberVisibility, (List)apiPublisherAPIIdentifierList), (String)("API with  Role Internal/subscriber  visibility is not visible to another user with Admin and subscriber role in same domain in API Publisher." + this.getAPIIdentifierString(this.apiIdentifierSubscriberVisibility)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Store for another user in same domain", dependsOnMethods={"testVisibilityForAnotherUserWithAdminAndSubscriberRoleInSameDomainInPublisher"})
    public void testVisibilityForAnotherUserWithAdminAndSubscriberRoleInSameDomainInStore() throws APIManagerIntegrationTestException, ApiException {
        List apiStoreAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((APIListDTO)this.apiStoreClientCarbonSuperUser2.getAllAPIs(this.apiCreatorStoreDomain));
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierAdminVisibility, (List)apiStoreAPIIdentifierList), (String)("API with  Role admin  visibility is not visible to another user with Admin and subscriber role in same domain in API Store." + this.getAPIIdentifierString(this.apiIdentifierAdminVisibility)));
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierSubscriberVisibility, (List)apiStoreAPIIdentifierList), (String)("API  with  Role Internal/subscriber  is not visible to another user with Admin and subscriber role in same domain in API Store. " + this.getAPIIdentifierString(this.apiIdentifierSubscriberVisibility)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Publisher for another user in other domain", dependsOnMethods={"testVisibilityForAnotherUserWithAdminAndSubscriberRoleInSameDomainInStore"})
    public void testVisibilityForAnotherUserWithAdminAndSubscriberRoleInOtherDomainInPublisher() throws APIManagerIntegrationTestException, org.wso2.am.integration.clients.publisher.api.ApiException {
        List apiPublisherAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO)this.apiPublisherClientAnotherUserOtherDomain.getAllAPIs());
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierAdminVisibility, (List)apiPublisherAPIIdentifierList), (String)("API with  Role admin  visibility is  visible to another user with Admin and subscriber role in other domain in API Publisher." + this.getAPIIdentifierString(this.apiIdentifierAdminVisibility)));
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierSubscriberVisibility, (List)apiPublisherAPIIdentifierList), (String)("API with  Role Internal/subscriber  visibility is  visible to another user with Admin and subscriber role in other domain in API Publisher." + this.getAPIIdentifierString(this.apiIdentifierSubscriberVisibility)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Store for another user in other domain", dependsOnMethods={"testVisibilityForAnotherUserWithAdminAndSubscriberRoleInOtherDomainInPublisher"})
    public void testVisibilityForAnotherUserWithAdminAndSubscriberRoleInOtherDomainInStore() throws APIManagerIntegrationTestException, ApiException {
        List apiStoreAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((APIListDTO)this.apiStoreClientAnotherUserOtherDomain.getAllAPIs());
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierAdminVisibility, (List)apiStoreAPIIdentifierList), (String)("API with  Role admin  visibility is  visible to another user with Admin and subscriber role in other domain in API Store." + this.getAPIIdentifierString(this.apiIdentifierAdminVisibility)));
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierSubscriberVisibility, (List)apiStoreAPIIdentifierList), (String)("API  with  Role Internal/subscriber  is  visible to another user with Admin and subscriber role in other domain in API Store. " + this.getAPIIdentifierString(this.apiIdentifierSubscriberVisibility)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Publisher for admin in other domain", dependsOnMethods={"testVisibilityForAnotherUserWithAdminAndSubscriberRoleInOtherDomainInStore"})
    public void testVisibilityForAdminWithAdminAndSubscriberRoleInOtherDomainInPublisher() throws APIManagerIntegrationTestException, org.wso2.am.integration.clients.publisher.api.ApiException {
        List apiPublisherAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO)this.apiPublisherClientAdminOtherDomain.getAllAPIs());
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierAdminVisibility, (List)apiPublisherAPIIdentifierList), (String)("API with  Role admin  visibility is  visible to Admin user with Admin and subscriber role in other domain in API Publisher." + this.getAPIIdentifierString(this.apiIdentifierAdminVisibility)));
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierSubscriberVisibility, (List)apiPublisherAPIIdentifierList), (String)("API with  Role Internal/subscriber  visibility is  visible to Admin user with Admin and subscriber role in other domain in API Publisher." + this.getAPIIdentifierString(this.apiIdentifierSubscriberVisibility)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Store for admin in other domain", dependsOnMethods={"testVisibilityForAdminWithAdminAndSubscriberRoleInOtherDomainInPublisher"})
    public void testVisibilityForAdminWithAdminAndSubscriberRoleInOtherDomainInStore() throws APIManagerIntegrationTestException, ApiException {
        List apiStoreAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((APIListDTO)this.apiStoreClientAdminOtherDomain.getAllAPIs());
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierAdminVisibility, (List)apiStoreAPIIdentifierList), (String)("API with  Role admin  visibility is  visible to Admin user with Admin and subscriber role in other domain in API Store." + this.getAPIIdentifierString(this.apiIdentifierAdminVisibility)));
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierSubscriberVisibility, (List)apiStoreAPIIdentifierList), (String)("API  with  Role Internal/subscriber  is  visible to Admin user with Admin and subscriber role in other domain in API Store. " + this.getAPIIdentifierString(this.apiIdentifierSubscriberVisibility)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Store for another user in same domain", dependsOnMethods={"testVisibilityForAdminWithAdminAndSubscriberRoleInOtherDomainInStore"})
    public void testVisibilityForAnotherUserWithSubscriberRoleInSameDomainInStore() throws APIManagerIntegrationTestException, ApiException {
        List apiStoreAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((APIListDTO)this.apiStoreClientSubscriberUserSameDomain.getAllAPIs());
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierAdminVisibility, (List)apiStoreAPIIdentifierList), (String)("API with  Role admin  visibility is  visible to another user with subscriber role in same domain in API Store." + this.getAPIIdentifierString(this.apiIdentifierAdminVisibility)));
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierSubscriberVisibility, (List)apiStoreAPIIdentifierList), (String)("API  with  Role Internal/subscriber  is not visible to another user with subscriber role in same domain in API Store. " + this.getAPIIdentifierString(this.apiIdentifierSubscriberVisibility)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Store for another user in same domain", dependsOnMethods={"testVisibilityForAnotherUserWithSubscriberRoleInSameDomainInStore"})
    public void testVisibilityForAnotherUserWithSubscriberRoleInOtherDomainInStore() throws APIManagerIntegrationTestException, ApiException {
        List apiStoreAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((APIListDTO)this.apiStoreClientSubscriberUserOtherDomain.getAllAPIs());
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierAdminVisibility, (List)apiStoreAPIIdentifierList), (String)("API with  Role admin  visibility is  visible to another user with subscriber role in same domain in API Store." + this.getAPIIdentifierString(this.apiIdentifierAdminVisibility)));
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierSubscriberVisibility, (List)apiStoreAPIIdentifierList), (String)("API  with  Role Internal/subscriber  is  visible to another user with subscriber role in same domain in API Store. " + this.getAPIIdentifierString(this.apiIdentifierSubscriberVisibility)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility for API in other domainStore for anonymous user", dependsOnMethods={"testVisibilityForAnotherUserWithSubscriberRoleInOtherDomainInStore"})
    public void testVisibilityForAnonymousUserInOtherDomainInStore() throws APIManagerIntegrationTestException, ApiException {
        List apiStoreAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((APIListDTO)this.apiStoreClientAdminOtherDomain.getAPIListFromStoreAsAnonymousUser(this.apiCreatorStoreDomain));
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierAdminVisibility, (List)apiStoreAPIIdentifierList), (String)("API is  visible to admin in other domain in API Store. When Visibility is public. " + this.getAPIIdentifierString(this.apiIdentifierAdminVisibility)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility for API in Same domainStore for anonymous user", dependsOnMethods={"testVisibilityForAnonymousUserInOtherDomainInStore"})
    public void testVisibilityForAnonymousUserInSameDomainInStore() throws APIManagerIntegrationTestException, ApiException {
        List apiStoreAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((APIListDTO)this.apiStoreClientAdminOtherDomain.getAPIListFromStoreAsAnonymousUser(this.otherDomain));
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierAdminVisibility, (List)apiStoreAPIIdentifierList), (String)("API is  visible to admin in other domain in API Store. When Visibility is public. " + this.getAPIIdentifierString(this.apiIdentifierAdminVisibility)));
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        this.deleteAPI(this.apiVisibilityByRoleTestId, this.apiPublisherClientCarbonSuperAdmin);
        this.deleteAPI(this.apiVisibilityByRoleId, this.apiPublisherClientCarbonSuperAdmin);
        this.userManagementClient1.deleteUser("subscriberUser1");
        this.userManagementClient2.deleteUser("subscriberUser2");
        super.cleanUp();
    }
}

