/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.store.api.ApiException;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.utils.bean.APILifeCycleAction;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class AccessibilityOfRetireAPITestCase
extends APIManagerLifecycleBaseTest {
    private final String API_NAME = "RetireAPITest";
    private final String API_CONTEXT = "RetireAPI";
    private final String API_END_POINT_METHOD = "/customers/123";
    private final String API_RESPONSE_DATA = "<id>123</id><name>John</name></Customer>";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String APPLICATION_NAME = "AccessibilityOfRetireAPITestCase";
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private String apiEndPointUrl;
    private String apiId;
    private String applicationId;
    private ArrayList<String> grantTypes;
    private Map<String, String> requestHeaders;

    @BeforeClass(alwaysRun=true)
    public void initialize() throws Exception {
        super.init();
        this.apiEndPointUrl = this.backEndServerUrl.getWebAppURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        this.grantTypes = new ArrayList();
        HttpResponse applicationResponse = this.restAPIStore.createApplication("AccessibilityOfRetireAPITestCase", "Test Application", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
        Assert.assertEquals((int)applicationResponse.getResponseCode(), (int)200, (String)"Response code is not as expected");
        this.applicationId = applicationResponse.getData();
        APIRequest apiRequest = new APIRequest("RetireAPITest", "RetireAPI", new URL(this.apiEndPointUrl));
        apiRequest.setVersion("1.0.0");
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setTier("Unlimited");
        this.apiId = this.createPublishAndSubscribeToAPIUsingRest(apiRequest, this.restAPIPublisher, this.restAPIStore, this.applicationId, "Unlimited");
        this.grantTypes.add("password");
        this.grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.applicationId, "36000", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, this.grantTypes);
        this.requestHeaders = new HashMap<String, String>();
        this.requestHeaders.put("accept", "text/xml");
        this.requestHeaders.put("Authorization", "Bearer " + applicationKeyDTO.getToken().getAccessToken());
        this.waitForAPIDeploymentSync(this.user.getUserName(), "RetireAPITest", "1.0.0", "\"isApiExists\":true");
    }

    @Test(groups={"wso2.am"}, description="Test invocation of the APi before retire")
    public void testInvokeAPIBeforeChangeAPILifecycleToRetired() throws Exception {
        HttpResponse oldVersionInvokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttps("RetireAPI", "1.0.0") + "/customers/123"), this.requestHeaders);
        Assert.assertEquals((int)oldVersionInvokeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched when invoke api before Retire");
        Assert.assertTrue((boolean)oldVersionInvokeResponse.getData().contains("<id>123</id><name>John</name></Customer>"), (String)("Response data mismatched when invoke  API  before Retire Response Data:" + oldVersionInvokeResponse.getData()));
    }

    @Test(groups={"wso2.am"}, description="Change API lifecycle to Retired", dependsOnMethods={"testInvokeAPIBeforeChangeAPILifecycleToRetired"})
    public void testChangeAPILifecycleToDepricated() throws Exception {
        HttpResponse blockAPIActionResponse = this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, APILifeCycleAction.DEPRECATE.getAction(), null);
        Assert.assertEquals((int)blockAPIActionResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched");
        Assert.assertTrue((boolean)APILifeCycleState.DEPRECATED.getState().equals(blockAPIActionResponse.getData()), (String)("API status Change is invalid when retire an API :RetireAPITest with API ID (" + this.apiId + ") Response Code:" + blockAPIActionResponse.getResponseCode()));
    }

    @Test(groups={"wso2.am"}, description="Change API lifecycle to Retired", dependsOnMethods={"testChangeAPILifecycleToDepricated"})
    public void testChangeAPILifecycleToRetired() throws Exception {
        HttpResponse blockAPIActionResponse = this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, APILifeCycleAction.RETIRE.getAction(), null);
        Assert.assertEquals((int)blockAPIActionResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched");
        Assert.assertTrue((boolean)APILifeCycleState.RETIRED.getState().equals(blockAPIActionResponse.getData()), (String)("API status Change is invalid when retire an API :RetireAPITest with API ID (" + this.apiId + ") Response Code:" + blockAPIActionResponse.getResponseCode()));
    }

    @Test(groups={"wso2.am"}, description="Test the availability of retired API in the store", dependsOnMethods={"testChangeAPILifecycleToRetired"})
    public void testAvailabilityOfRetiredAPIInStore() {
        try {
            this.restAPIStore.getAPI(this.apiId);
        }
        catch (ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)HTTP_RESPONSE_CODE_FORBIDDEN, (String)"Response code mismatch");
        }
    }

    @Test(groups={"wso2.am"}, description="Test the invocation of the API after retire", dependsOnMethods={"testAvailabilityOfRetiredAPIInStore"})
    public void testInvokeAPIAfterChangeAPILifecycleToRetired() throws Exception {
        this.waitForAPIDeploymentSync(this.user.getUserName(), "RetireAPITest", "1.0.0", "\"isApiExists\":false");
        HttpResponse oldVersionInvokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttps("RetireAPI", "1.0.0") + "/customers/123"), this.requestHeaders);
        Assert.assertEquals((int)oldVersionInvokeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_NOT_FOUND, (String)"Response code mismatched when invoke api after retire");
        Assert.assertTrue((boolean)oldVersionInvokeResponse.getData().contains("{\"code\":\"404\",\"type\":\"Status report\",\"message\":\"Not Found\",\"description\":\"The requested resource is not available.\"}"), (String)("Response data mismatched when invoke  API  after retire Response Data:" + oldVersionInvokeResponse.getData()));
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        this.restAPIStore.deleteApplication(this.applicationId);
        this.restAPIPublisher.deleteAPI(this.apiId);
        super.cleanUp();
    }
}

