/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.ClientAuthenticator;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.ApplicationKeyBean;
import org.wso2.am.integration.test.utils.bean.DCRParamRequest;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.am.integration.test.utils.token.TokenUtils;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.engine.context.beans.User;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import waffle.util.Base64;

public class AddEndPointSecurityPerTypeTestCase
extends APIManagerLifecycleBaseTest {
    private static final Log log = LogFactory.getLog(AddEndPointSecurityPerTypeTestCase.class);
    private final String API_NAME = "AddEndPointSecurityPerTypeTestCase";
    private final String API_CONTEXT = "AddEndPointSecurityPerTypeTestCase";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String APPLICATION_NAME = "AddEndPointSecurityPerTypeTestCase";
    ApplicationKeyBean applicationKeyBeanProduction;
    ApplicationKeyBean applicationKeyBeanSandbox;
    private HashMap<String, String> requestHeadersGet;
    private String providerName;
    private String apiEndPointUrl;
    private String applicationID;
    private ApplicationKeyDTO productionApplication;
    private ApplicationKeyDTO sandboxApplication;
    private APIIdentifier apiIdentifier;
    private String dcrURL;
    private String clientCredGrantTypeEndpointSecurityForProductionAndSandbox;
    ArrayList<String> apiIds = new ArrayList();

    @Factory(dataProvider="userModeDataProvider")
    public AddEndPointSecurityPerTypeTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}, {TestUserMode.SUPER_TENANT_USER}, {TestUserMode.TENANT_USER}};
    }

    @BeforeClass(alwaysRun=true)
    public void initialize() throws Exception {
        super.init(this.userMode);
        this.dcrURL = this.backEndServerUrl.getWebAppURLHttp() + "client-registration/v0.17/register";
        this.apiEndPointUrl = this.getGatewayURLNhttp() + "backendSecurity/1.0.0";
        this.providerName = this.user.getUserName();
        this.requestHeadersGet = new HashMap();
        this.requestHeadersGet.put("accept", "text/plain");
        this.requestHeadersGet.put("Content-Type", "text/plain");
        ApplicationDTO dto = this.restAPIStore.addApplicationWithTokenType("AddEndPointSecurityPerTypeTestCase", "Unlimited", "", "", ApplicationDTO.TokenTypeEnum.OAUTH.getValue());
        this.applicationID = dto.getApplicationId();
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        this.productionApplication = this.restAPIStore.generateKeys(this.applicationID, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        this.sandboxApplication = this.restAPIStore.generateKeys(this.applicationID, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.SANDBOX, null, grantTypes);
        DCRParamRequest oauthAppProduction = new DCRParamRequest("dummyapp--production", null, null, this.user.getUserName(), "password client_credentials", this.dcrURL, this.user.getUserName(), this.user.getPassword(), null);
        DCRParamRequest oauthAppSandbox = new DCRParamRequest("dummyapp--sandbox", null, null, this.user.getUserName(), "password client_credentials", this.dcrURL, this.user.getUserName(), this.user.getPassword(), null);
        this.applicationKeyBeanProduction = ClientAuthenticator.makeDCRRequest((DCRParamRequest)oauthAppProduction);
        this.applicationKeyBeanSandbox = ClientAuthenticator.makeDCRRequest((DCRParamRequest)oauthAppSandbox);
        this.clientCredGrantTypeEndpointSecurityForProductionAndSandbox = "{\n  \"production\":{\n    \"enabled\":true,\n    \"type\":\"OAUTH\",\n    \"tokenUrl\":\"https://localhost:9943/oauth2/token\",\n    \"clientId\":\"" + this.applicationKeyBeanProduction.getConsumerKey() + "\",\n    \"clientSecret\":\"" + this.applicationKeyBeanProduction.getConsumerSecret() + "\",\n    \"customParameters\":{},\n    \"grantType\":\"CLIENT_CREDENTIALS\"\n  },\n  \"sandbox\":{\n    \"enabled\":true,\n    \"type\":\"OAUTH\",\n    \"tokenUrl\":\"https://localhost:9943/oauth2/token\",\n    \"clientId\":\"" + this.applicationKeyBeanSandbox.getConsumerKey() + "\",\n    \"clientSecret\":\"" + this.applicationKeyBeanSandbox.getConsumerSecret() + "\",\n    \"customParameters\":{},\n    \"grantType\":\"CLIENT_CREDENTIALS\"\n  }\n  }";
    }

    @Test(groups={"wso2.am"}, description="Add Endpoint Security for production")
    public void testAddEndpointSecurityForProduction() throws Exception {
        String apiName = "AddEndPointSecurityPerTypeTestCase1";
        String apiContext = "AddEndPointSecurityPerTypeTestCase1";
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean(apiName, apiContext, "1.0.0", this.providerName, new URL(this.apiEndPointUrl), new URL(this.apiEndPointUrl));
        apiCreationRequestBean.setTier("Unlimited");
        apiCreationRequestBean.setTiersCollection("Unlimited");
        apiCreationRequestBean.setProvider(this.user.getUserName());
        apiCreationRequestBean.setSetEndpointSecurityDirectlyToEndpoint(Boolean.TRUE);
        this.apiIdentifier = new APIIdentifier(this.providerName, apiName, "1.0.0");
        this.apiIdentifier.setTier("Unlimited");
        String productionEndpointSecurity = "{\n  \"production\":{\n    \"enabled\":true,\n    \"type\":\"BASIC\",\n    \"username\":\"admin1234\",\n    \"password\":\"admin123#QA\"\n  }\n  }";
        org.json.JSONObject endpointConfig = apiCreationRequestBean.getEndpoint();
        endpointConfig.put("endpoint_security", new JSONParser().parse(productionEndpointSecurity));
        apiCreationRequestBean.setEndpoint(endpointConfig);
        APIDTO apidto = this.createPublishAndSubscribeToAPI(this.apiIdentifier, apiCreationRequestBean, this.restAPIPublisher, this.restAPIStore, this.applicationID, "Unlimited");
        this.apiIds.add(apidto.getId());
        this.createAPIRevisionAndDeployUsingRest(apidto.getId(), this.restAPIPublisher);
        this.waitForAPIDeploymentSync(this.user.getUserName(), apiName, "1.0.0", "\"isApiExists\":true");
        this.waitForAPIDeploymentSync(this.user.getUserName(), apiName, "1.0.0", "\"isApiExists\":true");
        Map addedEndpointConfig = (Map)apidto.getEndpointConfig();
        Assert.assertNotNull(addedEndpointConfig.get("endpoint_security"));
        Map endpointSecurity = (Map)addedEndpointConfig.get("endpoint_security");
        Assert.assertNotNull(endpointSecurity.get("production"));
        Map endpointSecurityModel = (Map)endpointSecurity.get("production");
        Assert.assertTrue((boolean)((Boolean)endpointSecurityModel.get("enabled")));
        Assert.assertTrue((boolean)"admin1234".equals(endpointSecurityModel.get("username")));
        Assert.assertTrue((boolean)"".equals(endpointSecurityModel.get("password")));
        Assert.assertTrue((boolean)"basic".equalsIgnoreCase((String)endpointSecurityModel.get("type")));
        String prodAppTokenJti = TokenUtils.getJtiOfJwtToken((String)this.productionApplication.getToken().getAccessToken());
        this.requestHeadersGet.put("Authorization", "Bearer " + prodAppTokenJti);
        HttpResponse productionResponse = HTTPSClientUtils.doGet((String)this.getAPIInvocationURLHttp(apiContext, "1.0.0"), this.requestHeadersGet);
        Assert.assertEquals((int)productionResponse.getResponseCode(), (int)200);
        Map headers = productionResponse.getHeaders();
        Assert.assertEquals((String)((String)headers.get("BACKEND_AUTHORIZATION_HEADER")), (String)"Basic".concat(" ").concat(Base64.encode((byte[])"admin1234".concat(":").concat("admin123#QA").getBytes())));
        String sandAppTokenJti = TokenUtils.getJtiOfJwtToken((String)this.sandboxApplication.getToken().getAccessToken());
        this.requestHeadersGet.put("Authorization", "Bearer " + sandAppTokenJti);
        HttpResponse sandboxResponse = HTTPSClientUtils.doGet((String)this.getAPIInvocationURLHttp(apiContext, "1.0.0"), this.requestHeadersGet);
        Assert.assertEquals((int)sandboxResponse.getResponseCode(), (int)200);
        headers = sandboxResponse.getHeaders();
        Assert.assertEquals((String)((String)headers.get("BACKEND_AUTHORIZATION_HEADER")), (String)"");
    }

    @Test(groups={"wso2.am"}, description="Add Endpoint Security for Sandbox", dependsOnMethods={"testAddEndpointSecurityForProduction"})
    public void testAddEndpointSecurityForSandbox() throws Exception {
        String apiName = "AddEndPointSecurityPerTypeTestCase2";
        String apiContext = "AddEndPointSecurityPerTypeTestCase2";
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean(apiName, apiContext, "1.0.0", this.providerName, new URL(this.apiEndPointUrl), new URL(this.apiEndPointUrl));
        apiCreationRequestBean.setTier("Unlimited");
        apiCreationRequestBean.setTiersCollection("Unlimited");
        apiCreationRequestBean.setProvider(this.user.getUserName());
        apiCreationRequestBean.setSetEndpointSecurityDirectlyToEndpoint(Boolean.TRUE);
        this.apiIdentifier = new APIIdentifier(this.providerName, apiName, "1.0.0");
        this.apiIdentifier.setTier("Unlimited");
        String sandboxEndpointSecurity = "{\n  \"sandbox\":{\n    \"enabled\":true,\n    \"type\":\"BASIC\",\n    \"username\":\"sandboxusername\",\n    \"password\":\"admin123#QA\"\n  }\n  }";
        org.json.JSONObject endpointConfig = apiCreationRequestBean.getEndpoint();
        endpointConfig.put("endpoint_security", new JSONParser().parse(sandboxEndpointSecurity));
        apiCreationRequestBean.setEndpoint(endpointConfig);
        APIDTO apidto = this.createPublishAndSubscribeToAPI(this.apiIdentifier, apiCreationRequestBean, this.restAPIPublisher, this.restAPIStore, this.applicationID, "Unlimited");
        this.apiIds.add(apidto.getId());
        this.createAPIRevisionAndDeployUsingRest(apidto.getId(), this.restAPIPublisher);
        this.waitForAPIDeploymentSync(this.user.getUserName(), apiName, "1.0.0", "\"isApiExists\":true");
        this.waitForAPIDeploymentSync(this.user.getUserName(), apiName, "1.0.0", "\"isApiExists\":true");
        Map addedEndpointConfig = (Map)apidto.getEndpointConfig();
        Assert.assertNotNull(addedEndpointConfig.get("endpoint_security"));
        Map endpointSecurity = (Map)addedEndpointConfig.get("endpoint_security");
        Assert.assertNotNull(endpointSecurity.get("sandbox"));
        Map endpointSecurityModel = (Map)endpointSecurity.get("sandbox");
        Assert.assertTrue((boolean)((Boolean)endpointSecurityModel.get("enabled")));
        Assert.assertTrue((boolean)"sandboxusername".equals(endpointSecurityModel.get("username")));
        Assert.assertTrue((boolean)"".equals(endpointSecurityModel.get("password")));
        Assert.assertTrue((boolean)"basic".equalsIgnoreCase((String)endpointSecurityModel.get("type")));
        String prodAppTokenJti = TokenUtils.getJtiOfJwtToken((String)this.productionApplication.getToken().getAccessToken());
        this.requestHeadersGet.put("Authorization", "Bearer " + prodAppTokenJti);
        HttpResponse productionResponse = HTTPSClientUtils.doGet((String)this.getAPIInvocationURLHttp(apiContext, "1.0.0"), this.requestHeadersGet);
        Assert.assertEquals((int)productionResponse.getResponseCode(), (int)200);
        Map headers = productionResponse.getHeaders();
        Assert.assertEquals((String)((String)headers.get("BACKEND_AUTHORIZATION_HEADER")), (String)"");
        String sandAppTokenJti = TokenUtils.getJtiOfJwtToken((String)this.sandboxApplication.getToken().getAccessToken());
        this.requestHeadersGet.put("Authorization", "Bearer " + sandAppTokenJti);
        HttpResponse sandboxResponse = HTTPSClientUtils.doGet((String)this.getAPIInvocationURLHttp(apiContext, "1.0.0"), this.requestHeadersGet);
        Assert.assertEquals((int)sandboxResponse.getResponseCode(), (int)200);
        headers = sandboxResponse.getHeaders();
        Assert.assertEquals((String)((String)headers.get("BACKEND_AUTHORIZATION_HEADER")), (String)"Basic".concat(" ").concat(Base64.encode((byte[])"sandboxusername".concat(":").concat("admin123#QA").getBytes())));
    }

    @Test(groups={"wso2.am"}, description="Add Endpoint Security for Production and Sandbox", dependsOnMethods={"testAddEndpointSecurityForSandbox"})
    public void testAddEndpointSecurityForSandboxAndProduction() throws Exception {
        String apiName = "AddEndPointSecurityPerTypeTestCase3";
        String apiContext = "AddEndPointSecurityPerTypeTestCase3";
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean(apiName, apiContext, "1.0.0", this.providerName, new URL(this.apiEndPointUrl), new URL(this.apiEndPointUrl));
        apiCreationRequestBean.setTier("Unlimited");
        apiCreationRequestBean.setTiersCollection("Unlimited");
        apiCreationRequestBean.setProvider(this.user.getUserName());
        apiCreationRequestBean.setSetEndpointSecurityDirectlyToEndpoint(Boolean.TRUE);
        this.apiIdentifier = new APIIdentifier(this.providerName, apiName, "1.0.0");
        this.apiIdentifier.setTier("Unlimited");
        String productionAndSandboxEndpointSecurity = "{\n  \"production\":{\n    \"enabled\":true,\n    \"type\":\"BASIC\",\n    \"username\":\"production1234\",\n    \"password\":\"admin123#dev\"\n  },\n  \"sandbox\":{\n    \"enabled\":true,\n    \"type\":\"BASIC\",\n    \"username\":\"sandbox1234\",\n    \"password\":\"admin123#prod\"\n  }\n  }";
        org.json.JSONObject endpointConfig = apiCreationRequestBean.getEndpoint();
        endpointConfig.put("endpoint_security", new JSONParser().parse(productionAndSandboxEndpointSecurity));
        apiCreationRequestBean.setEndpoint(endpointConfig);
        APIDTO apidto = this.createPublishAndSubscribeToAPI(this.apiIdentifier, apiCreationRequestBean, this.restAPIPublisher, this.restAPIStore, this.applicationID, "Unlimited");
        this.apiIds.add(apidto.getId());
        this.createAPIRevisionAndDeployUsingRest(apidto.getId(), this.restAPIPublisher);
        this.waitForAPIDeploymentSync(this.user.getUserName(), apiName, "1.0.0", "\"isApiExists\":true");
        this.waitForAPIDeploymentSync(this.user.getUserName(), apiName, "1.0.0", "\"isApiExists\":true");
        Map addedEndpointConfig = (Map)apidto.getEndpointConfig();
        Assert.assertNotNull(addedEndpointConfig.get("endpoint_security"));
        Map endpointSecurity = (Map)addedEndpointConfig.get("endpoint_security");
        Assert.assertNotNull(endpointSecurity.get("sandbox"));
        Map endpointSecurityModel = (Map)endpointSecurity.get("sandbox");
        Assert.assertTrue((boolean)((Boolean)endpointSecurityModel.get("enabled")));
        Assert.assertTrue((boolean)"sandbox1234".equals(endpointSecurityModel.get("username")));
        Assert.assertTrue((boolean)"".equals(endpointSecurityModel.get("password")));
        Assert.assertTrue((boolean)"basic".equalsIgnoreCase((String)endpointSecurityModel.get("type")));
        Assert.assertNotNull(endpointSecurity.get("production"));
        Map productionMap = (Map)endpointSecurity.get("production");
        Assert.assertTrue((boolean)((Boolean)productionMap.get("enabled")));
        Assert.assertTrue((boolean)"production1234".equals(productionMap.get("username")));
        Assert.assertTrue((boolean)"".equals(productionMap.get("password")));
        Assert.assertTrue((boolean)"basic".equalsIgnoreCase((String)productionMap.get("type")));
        String prodAppTokenJti = TokenUtils.getJtiOfJwtToken((String)this.productionApplication.getToken().getAccessToken());
        this.requestHeadersGet.put("Authorization", "Bearer " + prodAppTokenJti);
        HttpResponse productionResponse = HTTPSClientUtils.doGet((String)this.getAPIInvocationURLHttp(apiContext, "1.0.0"), this.requestHeadersGet);
        Assert.assertEquals((int)productionResponse.getResponseCode(), (int)200);
        Map headers = productionResponse.getHeaders();
        Assert.assertEquals((String)((String)headers.get("BACKEND_AUTHORIZATION_HEADER")), (String)"Basic".concat(" ").concat(Base64.encode((byte[])"production1234".concat(":").concat("admin123#dev").getBytes())));
        String sandAppTokenJti = TokenUtils.getJtiOfJwtToken((String)this.sandboxApplication.getToken().getAccessToken());
        this.requestHeadersGet.put("Authorization", "Bearer " + sandAppTokenJti);
        HttpResponse sandboxResponse = HTTPSClientUtils.doGet((String)this.getAPIInvocationURLHttp(apiContext, "1.0.0"), this.requestHeadersGet);
        Assert.assertEquals((int)sandboxResponse.getResponseCode(), (int)200);
        headers = sandboxResponse.getHeaders();
        Assert.assertEquals((String)((String)headers.get("BACKEND_AUTHORIZATION_HEADER")), (String)"Basic".concat(" ").concat(Base64.encode((byte[])"sandbox1234".concat(":").concat("admin123#prod").getBytes())));
    }

    @Test(groups={"wso2.am"}, description="Test add OAuth endpoint security for CLIENT_CREDENTIALS grant type", dependsOnMethods={"testAddEndpointSecurityForSandboxAndProduction"})
    public void testAddEndpointSecurityForOauthForClientCredentialsGrantType() throws Exception {
        String apiName = "AddEndPointSecurityPerTypeTestCase4";
        String apiContext = "AddEndPointSecurityPerTypeTestCase4";
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean(apiName, apiContext, "1.0.0", this.providerName, new URL(this.apiEndPointUrl), new URL(this.apiEndPointUrl));
        apiCreationRequestBean.setTier("Unlimited");
        apiCreationRequestBean.setTiersCollection("Unlimited");
        apiCreationRequestBean.setProvider(this.user.getUserName());
        apiCreationRequestBean.setSetEndpointSecurityDirectlyToEndpoint(Boolean.TRUE);
        this.apiIdentifier = new APIIdentifier(this.providerName, apiName, "1.0.0");
        this.apiIdentifier.setTier("Unlimited");
        org.json.JSONObject endpointConfig = apiCreationRequestBean.getEndpoint();
        endpointConfig.put("endpoint_security", new JSONParser().parse(this.clientCredGrantTypeEndpointSecurityForProductionAndSandbox));
        apiCreationRequestBean.setEndpoint(endpointConfig);
        APIDTO apidto = this.createPublishAndSubscribeToAPI(this.apiIdentifier, apiCreationRequestBean, this.restAPIPublisher, this.restAPIStore, this.applicationID, "Unlimited");
        this.apiIds.add(apidto.getId());
        this.createAPIRevisionAndDeployUsingRest(apidto.getId(), this.restAPIPublisher);
        this.waitForAPIDeploymentSync(this.user.getUserName(), apiName, "1.0.0", "\"isApiExists\":true");
        this.waitForAPIDeploymentSync(this.user.getUserName(), apiName, "1.0.0", "\"isApiExists\":true");
        Map addedEndpointConfig = (Map)apidto.getEndpointConfig();
        Assert.assertNotNull(addedEndpointConfig.get("endpoint_security"));
        Map endpointSecurityModel = (Map)addedEndpointConfig.get("endpoint_security");
        Assert.assertNotNull(endpointSecurityModel.get("sandbox"));
        Map sandboxEndpointSecurityModel = (Map)endpointSecurityModel.get("sandbox");
        Assert.assertTrue((boolean)((Boolean)sandboxEndpointSecurityModel.get("enabled")));
        Assert.assertEquals(sandboxEndpointSecurityModel.get("type"), (Object)"OAUTH");
        Assert.assertEquals(sandboxEndpointSecurityModel.get("tokenUrl"), (Object)"https://localhost:9943/oauth2/token");
        Assert.assertEquals(sandboxEndpointSecurityModel.get("clientId"), (Object)this.applicationKeyBeanSandbox.getConsumerKey());
        Assert.assertEquals(sandboxEndpointSecurityModel.get("clientSecret"), (Object)this.applicationKeyBeanSandbox.getConsumerSecret());
        Assert.assertNotNull(endpointSecurityModel.get("production"));
        Map productionEndpointSecurityModel = (Map)endpointSecurityModel.get("production");
        Assert.assertTrue((boolean)((Boolean)productionEndpointSecurityModel.get("enabled")));
        Assert.assertEquals(productionEndpointSecurityModel.get("type"), (Object)"OAUTH");
        Assert.assertEquals(productionEndpointSecurityModel.get("tokenUrl"), (Object)"https://localhost:9943/oauth2/token");
        Assert.assertEquals(productionEndpointSecurityModel.get("clientId"), (Object)this.applicationKeyBeanProduction.getConsumerKey());
        Assert.assertEquals(productionEndpointSecurityModel.get("clientSecret"), (Object)this.applicationKeyBeanProduction.getConsumerSecret());
        String prodAppTokenJti = TokenUtils.getJtiOfJwtToken((String)this.productionApplication.getToken().getAccessToken());
        this.requestHeadersGet.put("Authorization", "Bearer " + prodAppTokenJti);
        HttpResponse productionResponse = HTTPSClientUtils.doGet((String)this.getAPIInvocationURLHttp(apiContext, "1.0.0"), this.requestHeadersGet);
        Assert.assertEquals((int)productionResponse.getResponseCode(), (int)200);
        Map headers = productionResponse.getHeaders();
        String authorization = (String)headers.get("BACKEND_AUTHORIZATION_HEADER");
        Assert.assertNotNull((Object)authorization);
        Assert.assertTrue((boolean)authorization.contains("Bearer"));
        String backendToken = authorization.replaceFirst("Bearer ", "");
        this.validateIntrospectionResponse(this.user, backendToken, this.applicationKeyBeanProduction.getConsumerKey());
        HttpResponse productionResponse2 = HTTPSClientUtils.doGet((String)this.getAPIInvocationURLHttp(apiContext, "1.0.0"), this.requestHeadersGet);
        Assert.assertEquals((int)productionResponse2.getResponseCode(), (int)200);
        String sandAppTokenJti = TokenUtils.getJtiOfJwtToken((String)this.sandboxApplication.getToken().getAccessToken());
        this.requestHeadersGet.put("Authorization", "Bearer " + sandAppTokenJti);
        HttpResponse sandboxResponse = HTTPSClientUtils.doGet((String)this.getAPIInvocationURLHttp(apiContext, "1.0.0"), this.requestHeadersGet);
        Assert.assertEquals((int)sandboxResponse.getResponseCode(), (int)200);
        headers = sandboxResponse.getHeaders();
        authorization = (String)headers.get("BACKEND_AUTHORIZATION_HEADER");
        Assert.assertNotNull((Object)authorization);
        Assert.assertTrue((boolean)authorization.contains("Bearer"));
        backendToken = authorization.replaceFirst("Bearer ", "");
        this.validateIntrospectionResponse(this.user, backendToken, this.applicationKeyBeanSandbox.getConsumerKey());
    }

    @Test(groups={"wso2.am"}, description="API definition import with endpoint security", dependsOnMethods={"testAddEndpointSecurityForOauthForClientCredentialsGrantType"})
    public void testAPIDefinitionImportWithEndpointSecurity() throws Exception {
        String resourcePath = "oas" + File.separator + "v3" + File.separator;
        String originalDefinition = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(resourcePath + "oas_import.json"), (String)"UTF-8");
        String additionalProperties = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(resourcePath + "additionalProperties.json"), (String)"UTF-8");
        org.json.JSONObject additionalPropertiesObj = new org.json.JSONObject(additionalProperties);
        additionalPropertiesObj.put("provider", (Object)this.user.getUserName());
        org.json.JSONObject endpointConfig = (org.json.JSONObject)additionalPropertiesObj.get("endpointConfig");
        endpointConfig.put("endpoint_security", new JSONParser().parse(this.clientCredGrantTypeEndpointSecurityForProductionAndSandbox));
        additionalPropertiesObj.put("endpointConfig", (Object)endpointConfig);
        File file = this.geTempFileWithContent(originalDefinition);
        APIDTO apidto = this.restAPIPublisher.importOASDefinition(file, additionalPropertiesObj.toString());
        this.apiIds.add(apidto.getId());
        this.restAPIPublisher.changeAPILifeCycleStatus(apidto.getId(), "Publish");
        Map addedEndpointConfig = (Map)apidto.getEndpointConfig();
        Assert.assertNotNull(addedEndpointConfig.get("endpoint_security"));
        Map endpointSecurityModel = (Map)addedEndpointConfig.get("endpoint_security");
        Assert.assertNotNull(endpointSecurityModel.get("sandbox"));
        Map sandboxEndpointSecurityModel = (Map)endpointSecurityModel.get("sandbox");
        Assert.assertTrue((boolean)((Boolean)sandboxEndpointSecurityModel.get("enabled")));
        Assert.assertEquals(sandboxEndpointSecurityModel.get("type"), (Object)"OAUTH");
        Assert.assertEquals(sandboxEndpointSecurityModel.get("tokenUrl"), (Object)"https://localhost:9943/oauth2/token");
        Assert.assertEquals(sandboxEndpointSecurityModel.get("clientId"), (Object)this.applicationKeyBeanSandbox.getConsumerKey());
        Assert.assertEquals(sandboxEndpointSecurityModel.get("clientSecret"), (Object)this.applicationKeyBeanSandbox.getConsumerSecret());
        Assert.assertNotNull(endpointSecurityModel.get("production"));
        Map productionEndpointSecurityModel = (Map)endpointSecurityModel.get("production");
        Assert.assertTrue((boolean)((Boolean)productionEndpointSecurityModel.get("enabled")));
        Assert.assertEquals(productionEndpointSecurityModel.get("type"), (Object)"OAUTH");
        Assert.assertEquals(productionEndpointSecurityModel.get("tokenUrl"), (Object)"https://localhost:9943/oauth2/token");
        Assert.assertEquals(productionEndpointSecurityModel.get("clientId"), (Object)this.applicationKeyBeanProduction.getConsumerKey());
        Assert.assertEquals(productionEndpointSecurityModel.get("clientSecret"), (Object)this.applicationKeyBeanProduction.getConsumerSecret());
    }

    @Test(groups={"wso2.am"}, description="Test add OAuth endpoint security for PASSWORD grant type", dependsOnMethods={"testAddEndpointSecurityForOauthForClientCredentialsGrantType"})
    public void testAddEndpointSecurityForOauthForPasswordGrantType() throws Exception {
        String clientCredGrantTypeEndpointSecurityForProductionAndSandboxForPasswordGrantType = "{\n  \"production\":{\n    \"enabled\":true,\n    \"type\":\"OAUTH\",\n    \"username\":\"" + this.user.getUserName() + "\",\n    \"password\":\"" + this.user.getPassword() + "\",\n    \"tokenUrl\":\"https://localhost:9943/oauth2/token\",\n    \"clientId\":\"" + this.applicationKeyBeanProduction.getConsumerKey() + "\",\n    \"clientSecret\":\"" + this.applicationKeyBeanProduction.getConsumerSecret() + "\",\n    \"customParameters\":{},\n    \"grantType\":\"PASSWORD\"\n  },\n  \"sandbox\":{\n    \"enabled\":true,\n    \"type\":\"OAUTH\",\n    \"username\":\"" + this.user.getUserName() + "\",\n    \"password\":\"" + this.user.getPassword() + "\",\n    \"tokenUrl\":\"https://localhost:9943/oauth2/token\",\n    \"clientId\":\"" + this.applicationKeyBeanSandbox.getConsumerKey() + "\",\n    \"clientSecret\":\"" + this.applicationKeyBeanSandbox.getConsumerSecret() + "\",\n    \"customParameters\":{},\n    \"grantType\":\"PASSWORD\"\n  }\n  }";
        String apiName = "AddEndPointSecurityPerTypeTestCase5";
        String apiContext = "AddEndPointSecurityPerTypeTestCase5";
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean(apiName, apiContext, "1.0.0", this.providerName, new URL(this.apiEndPointUrl), new URL(this.apiEndPointUrl));
        apiCreationRequestBean.setTier("Unlimited");
        apiCreationRequestBean.setTiersCollection("Unlimited");
        apiCreationRequestBean.setProvider(this.user.getUserName());
        apiCreationRequestBean.setSetEndpointSecurityDirectlyToEndpoint(Boolean.TRUE);
        this.apiIdentifier = new APIIdentifier(this.providerName, apiName, "1.0.0");
        this.apiIdentifier.setTier("Unlimited");
        org.json.JSONObject endpointConfig = apiCreationRequestBean.getEndpoint();
        endpointConfig.put("endpoint_security", new JSONParser().parse(clientCredGrantTypeEndpointSecurityForProductionAndSandboxForPasswordGrantType));
        apiCreationRequestBean.setEndpoint(endpointConfig);
        APIDTO apidto = this.createPublishAndSubscribeToAPI(this.apiIdentifier, apiCreationRequestBean, this.restAPIPublisher, this.restAPIStore, this.applicationID, "Unlimited");
        this.apiIds.add(apidto.getId());
        this.createAPIRevisionAndDeployUsingRest(apidto.getId(), this.restAPIPublisher);
        this.waitForAPIDeploymentSync(this.user.getUserName(), apiName, "1.0.0", "\"isApiExists\":true");
        this.waitForAPIDeploymentSync(this.user.getUserName(), apiName, "1.0.0", "\"isApiExists\":true");
        Map addedEndpointConfig = (Map)apidto.getEndpointConfig();
        Assert.assertNotNull(addedEndpointConfig.get("endpoint_security"));
        Map endpointSecurityModel = (Map)addedEndpointConfig.get("endpoint_security");
        Assert.assertNotNull(endpointSecurityModel.get("sandbox"));
        Map sandboxEndpointSecurityModel = (Map)endpointSecurityModel.get("sandbox");
        Assert.assertTrue((boolean)((Boolean)sandboxEndpointSecurityModel.get("enabled")));
        Assert.assertEquals(sandboxEndpointSecurityModel.get("type"), (Object)"OAUTH");
        Assert.assertEquals(sandboxEndpointSecurityModel.get("tokenUrl"), (Object)"https://localhost:9943/oauth2/token");
        Assert.assertEquals(sandboxEndpointSecurityModel.get("clientId"), (Object)this.applicationKeyBeanSandbox.getConsumerKey());
        Assert.assertEquals(sandboxEndpointSecurityModel.get("clientSecret"), (Object)this.applicationKeyBeanSandbox.getConsumerSecret());
        Assert.assertNotNull(endpointSecurityModel.get("production"));
        Map productionEndpointSecurityModel = (Map)endpointSecurityModel.get("production");
        Assert.assertTrue((boolean)((Boolean)productionEndpointSecurityModel.get("enabled")));
        Assert.assertEquals(productionEndpointSecurityModel.get("type"), (Object)"OAUTH");
        Assert.assertEquals(productionEndpointSecurityModel.get("tokenUrl"), (Object)"https://localhost:9943/oauth2/token");
        Assert.assertEquals(productionEndpointSecurityModel.get("clientId"), (Object)this.applicationKeyBeanProduction.getConsumerKey());
        Assert.assertEquals(productionEndpointSecurityModel.get("clientSecret"), (Object)this.applicationKeyBeanProduction.getConsumerSecret());
        String prodAppTokenJti = TokenUtils.getJtiOfJwtToken((String)this.productionApplication.getToken().getAccessToken());
        this.requestHeadersGet.put("Authorization", "Bearer " + prodAppTokenJti);
        HttpResponse productionResponse = HTTPSClientUtils.doGet((String)this.getAPIInvocationURLHttp(apiContext, "1.0.0"), this.requestHeadersGet);
        Assert.assertEquals((int)productionResponse.getResponseCode(), (int)200);
        Map headers = productionResponse.getHeaders();
        String authorization = (String)headers.get("BACKEND_AUTHORIZATION_HEADER");
        Assert.assertNotNull((Object)authorization);
        Assert.assertTrue((boolean)authorization.contains("Bearer"));
        String backendToken = authorization.replaceFirst("Bearer ", "");
        this.validateIntrospectionResponse(this.user, backendToken, this.applicationKeyBeanProduction.getConsumerKey());
        HttpResponse productionResponse2 = HTTPSClientUtils.doGet((String)this.getAPIInvocationURLHttp(apiContext, "1.0.0"), this.requestHeadersGet);
        Assert.assertEquals((int)productionResponse2.getResponseCode(), (int)200);
        String sandAppTokenJti = TokenUtils.getJtiOfJwtToken((String)this.sandboxApplication.getToken().getAccessToken());
        this.requestHeadersGet.put("Authorization", "Bearer " + sandAppTokenJti);
        HttpResponse sandboxResponse = HTTPSClientUtils.doGet((String)this.getAPIInvocationURLHttp(apiContext, "1.0.0"), this.requestHeadersGet);
        Assert.assertEquals((int)sandboxResponse.getResponseCode(), (int)200);
        headers = sandboxResponse.getHeaders();
        authorization = (String)headers.get("BACKEND_AUTHORIZATION_HEADER");
        Assert.assertNotNull((Object)authorization);
        Assert.assertTrue((boolean)authorization.contains("Bearer"));
        backendToken = authorization.replaceFirst("Bearer ", "");
        this.validateIntrospectionResponse(this.user, backendToken, this.applicationKeyBeanSandbox.getConsumerKey());
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        this.restAPIStore.removeApplicationById(this.applicationID);
        for (String apiId : this.apiIds) {
            this.undeployAndDeleteAPIRevisionsUsingRest(apiId, this.restAPIPublisher);
            this.restAPIPublisher.deleteAPI(apiId);
        }
        super.cleanUp();
    }

    private void validateIntrospectionResponse(User user, String accessToken, String clientId) throws Exception {
        String introspectionUrl = "https://localhost:9943/oauth2/introspect";
        if (!"carbon.super".equals(user.getUserDomain())) {
            introspectionUrl = "https://localhost:9943/t/" + user.getUserDomain() + "/oauth2/introspect";
        }
        CloseableHttpClient closeableHttpClient = HttpClientBuilder.create().build();
        HttpPost httpPost = new HttpPost();
        httpPost.addHeader("Authorization", "Basic " + Base64.encode((byte[])user.getUserName().concat(":").concat(user.getPassword()).getBytes()));
        httpPost.setURI(URI.create(introspectionUrl));
        UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity(Arrays.asList(new BasicNameValuePair("token", accessToken)));
        httpPost.setEntity((HttpEntity)urlEncodedFormEntity);
        try (CloseableHttpResponse response = closeableHttpClient.execute((HttpUriRequest)httpPost);){
            Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)200);
            HttpEntity entity = response.getEntity();
            JSONObject jsonPayload = (JSONObject)new JSONParser().parse((Reader)new InputStreamReader(entity.getContent()));
            Assert.assertTrue((boolean)((Boolean)jsonPayload.get((Object)"active")));
            Assert.assertNotNull((Object)jsonPayload.get((Object)"client_id"));
            Assert.assertEquals((Object)jsonPayload.get((Object)"client_id"), (Object)clientId);
        }
        catch (IOException | ParseException e) {
            log.error((Object)e.getMessage());
            throw new Exception(e);
        }
    }

    private File geTempFileWithContent(String swagger) throws Exception {
        File temp = File.createTempFile("swagger", ".json");
        temp.deleteOnExit();
        BufferedWriter out = new BufferedWriter(new FileWriter(temp));
        out.write(swagger);
        out.close();
        return temp;
    }
}

