/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class ChangeAPITierAndTestInvokingTestCase
extends APIManagerLifecycleBaseTest {
    private final String API_NAME = "ChangeAPITierAndTestInvokingTest";
    private final String API_CONTEXT = "ChangeAPITierAndTestInvoking";
    private final String API_TAGS = "testTag1, testTag2, testTag3";
    private final String API_DESCRIPTION = "This is test API create by API manager integration test";
    private final String API_END_POINT_METHOD = "customers/123";
    private final String API_RESPONSE_DATA = "<id>123</id><name>John</name></Customer>";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String APPLICATION_NAME = "ChangeAPITierAndTestInvokingTestCase";
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private String apiEndPointUrl;
    private String applicationNameGold;
    private String applicationNameSilver;
    private Map<String, String> requestHeadersGoldTier;
    private APIIdentifier apiIdentifier;
    private String providerName;
    private APICreationRequestBean apiCreationRequestBean;
    private APIPublisherRestClient apiPublisherClientUser1;
    private APIStoreRestClient apiStoreClientUser1;
    private boolean isInitialised = false;

    public void initialize() throws Exception {
        if (!this.isInitialised) {
            super.init();
            this.apiEndPointUrl = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice/";
            this.providerName = this.user.getUserName();
            String publisherURLHttp = this.getPublisherURLHttp();
            String storeURLHttp = this.getStoreURLHttp();
            this.apiPublisherClientUser1 = new APIPublisherRestClient(publisherURLHttp);
            this.apiStoreClientUser1 = new APIStoreRestClient(storeURLHttp);
            this.apiPublisherClientUser1.login(this.user.getUserName(), this.user.getPassword());
            this.apiStoreClientUser1.login(this.user.getUserName(), this.user.getPassword());
            this.apiIdentifier = new APIIdentifier(this.providerName, "ChangeAPITierAndTestInvokingTest", "1.0.0");
            this.isInitialised = true;
        }
    }

    @Test(groups={"wso2.am"}, description="test  invocation of  api under tier Gold.")
    public void testInvokingWithGoldTier() throws Exception {
        long currentTime;
        this.initialize();
        this.applicationNameGold = "ChangeAPITierAndTestInvokingTestCaseGold";
        this.apiStoreClientUser1.addApplication(this.applicationNameGold, "Unlimited", "", "");
        this.apiCreationRequestBean = new APICreationRequestBean("ChangeAPITierAndTestInvokingTest", "ChangeAPITierAndTestInvoking", "1.0.0", this.providerName, new URL(this.apiEndPointUrl));
        this.apiCreationRequestBean.setTags("testTag1, testTag2, testTag3");
        this.apiCreationRequestBean.setDescription("This is test API create by API manager integration test");
        this.apiCreationRequestBean.setTier("Gold");
        this.createPublishAndSubscribeToAPI(this.apiIdentifier, this.apiCreationRequestBean, this.apiPublisherClientUser1, this.apiStoreClientUser1, this.applicationNameGold);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "ChangeAPITierAndTestInvokingTest", "1.0.0", "\"isApiExists\":true");
        String accessToken = this.generateApplicationKeys(this.apiStoreClientUser1, this.applicationNameGold).getAccessToken();
        this.requestHeadersGoldTier = new HashMap<String, String>();
        this.requestHeadersGoldTier.put("Authorization", "Bearer " + accessToken);
        this.requestHeadersGoldTier.put("accept", "text/xml");
        long startTime = System.currentTimeMillis();
        for (int invocationCount = 1; invocationCount <= 20; ++invocationCount) {
            currentTime = System.currentTimeMillis();
            HttpResponse invokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("ChangeAPITierAndTestInvoking", "1.0.0") + "/" + "customers/123"), this.requestHeadersGoldTier);
            Assert.assertEquals((int)invokeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Response code mismatched. Invocation attempt:" + invocationCount + " failed  during :" + (currentTime - startTime) + " milliseconds under Gold API level tier"));
            Assert.assertTrue((boolean)invokeResponse.getData().contains("<id>123</id><name>John</name></Customer>"), (String)("Response data mismatched. Invocation attempt:" + invocationCount + " failed  during :" + (currentTime - startTime) + " milliseconds under Gold API level tier"));
        }
        currentTime = System.currentTimeMillis();
        HttpResponse invokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("ChangeAPITierAndTestInvoking", "1.0.0") + "/" + "customers/123"), this.requestHeadersGoldTier);
        if (this.executionMode.equalsIgnoreCase(String.valueOf(ExecutionEnvironment.PLATFORM))) {
            invokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("ChangeAPITierAndTestInvoking", "1.0.0") + "/" + "customers/123"), this.requestHeadersGoldTier);
        }
        Assert.assertEquals((int)invokeResponse.getResponseCode(), (int)429, (String)("Response code mismatched. Invocation attempt:21 passed  during :" + (currentTime - startTime) + " milliseconds under Gold API level tier"));
        Assert.assertTrue((boolean)invokeResponse.getData().contains("<amt:code>900800</amt:code><amt:message>Message throttled out</amt:message><amt:description>You have exceeded your quota</amt:description>"), (String)("Response data mismatched. Invocation attempt:21 passed  during :" + (currentTime - startTime) + " milliseconds under Gold API level tier"));
    }

    @Test(groups={"wso2.am"}, description="test  invocation of APi after expire the throttling block time.", dependsOnMethods={"testInvokingWithGoldTier"})
    public void testInvokingAfterExpireThrottleExpireTime() throws Exception {
        this.initialize();
        Thread.sleep(65000L);
        HttpResponse invokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("ChangeAPITierAndTestInvoking", "1.0.0") + "/" + "customers/123"), this.requestHeadersGoldTier);
        Assert.assertEquals((int)invokeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched, Invocation fails after wait 65000millisecond to expire the throttling block");
        Assert.assertTrue((boolean)invokeResponse.getData().contains("<id>123</id><name>John</name></Customer>"), (String)"Response data mismatched. Invocation fails after wait 65000millisecond to expire the throttling block");
    }

    @Test(groups={"wso2.am"}, description="Test changing of the API Tier from Gold to Silver", dependsOnMethods={"testInvokingAfterExpireThrottleExpireTime"})
    public void testEditAPITierToSilver() throws Exception {
        this.initialize();
        this.apiCreationRequestBean = new APICreationRequestBean("ChangeAPITierAndTestInvokingTest", "ChangeAPITierAndTestInvoking", "1.0.0", this.providerName, new URL(this.apiEndPointUrl));
        this.apiCreationRequestBean.setTags("testTag1, testTag2, testTag3");
        this.apiCreationRequestBean.setDescription("This is test API create by API manager integration test");
        this.apiCreationRequestBean.setTier("Silver");
        this.apiCreationRequestBean.setTiersCollection("Silver");
        HttpResponse updateAPIHTTPResponse = this.apiPublisherClientUser1.updateAPI(this.apiCreationRequestBean);
        this.waitForAPIDeployment();
        Assert.assertEquals((int)updateAPIHTTPResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Update API Response Code is invalid. Updating of API information fail" + this.getAPIIdentifierString(this.apiIdentifier)));
        Assert.assertEquals((String)this.getValueFromJSON(updateAPIHTTPResponse, "error"), (String)"false", (String)("Error in API Update in " + this.getAPIIdentifierString(this.apiIdentifier) + "Response Data:" + updateAPIHTTPResponse.getData()));
    }

    @Test(groups={"wso2.am"}, description="test  invocation of  api under tier Silver.", dependsOnMethods={"testEditAPITierToSilver"})
    public void testInvokingWithSilverTier() throws Exception {
        long currentTime;
        this.initialize();
        this.applicationNameSilver = "ChangeAPITierAndTestInvokingTestCaseSilver";
        this.apiStoreClientUser1.addApplication(this.applicationNameSilver, "Large", "", "");
        this.apiIdentifier.setTier("Silver");
        this.subscribeToAPI(this.apiIdentifier, this.applicationNameSilver, this.apiStoreClientUser1);
        String accessToken = this.generateApplicationKeys(this.apiStoreClientUser1, this.applicationNameSilver).getAccessToken();
        HashMap<String, String> requestHeadersSilverTier = new HashMap<String, String>();
        requestHeadersSilverTier.put("accept", "text/xml");
        requestHeadersSilverTier.put("Authorization", "Bearer " + accessToken);
        Thread.sleep(65000L);
        long startTime = System.currentTimeMillis();
        for (int invocationCount = 1; invocationCount <= 5; ++invocationCount) {
            currentTime = System.currentTimeMillis();
            HttpResponse invokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("ChangeAPITierAndTestInvoking", "1.0.0") + "/" + "customers/123"), requestHeadersSilverTier);
            Assert.assertEquals((int)invokeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Response code mismatched. Invocation attempt:" + invocationCount + " failed  during :" + (currentTime - startTime) + " milliseconds under Silver API level tier"));
            Assert.assertTrue((boolean)invokeResponse.getData().contains("<id>123</id><name>John</name></Customer>"), (String)("Response data mismatched. Invocation attempt:" + invocationCount + " failed  during :" + (currentTime - startTime) + " milliseconds under Silver API level tier"));
        }
        currentTime = System.currentTimeMillis();
        HttpResponse invokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("ChangeAPITierAndTestInvoking", "1.0.0") + "/" + "customers/123"), requestHeadersSilverTier);
        if (this.executionMode.equalsIgnoreCase(String.valueOf(ExecutionEnvironment.PLATFORM))) {
            invokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("ChangeAPITierAndTestInvoking", "1.0.0") + "/" + "customers/123"), requestHeadersSilverTier);
        }
        Assert.assertEquals((int)invokeResponse.getResponseCode(), (int)429, (String)("Response code mismatched. Invocation attempt:6 passed  during :" + (currentTime - startTime) + " milliseconds under Silver API level tier"));
        Assert.assertTrue((boolean)invokeResponse.getData().contains("<amt:code>900800</amt:code><amt:message>Message throttled out</amt:message><amt:description>You have exceeded your quota</amt:description>"), (String)("Response data mismatched. Invocation attempt:6 passed  during :" + (currentTime - startTime) + " milliseconds under Silver API level tier"));
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        this.apiStoreClientUser1.removeApplication(this.applicationNameGold);
        this.apiStoreClientUser1.removeApplication(this.applicationNameSilver);
        this.deleteAPI(this.apiIdentifier, this.apiPublisherClientUser1);
    }
}

