/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.admin.clients.lifecycle.LifeCycleAdminClient;
import org.wso2.am.integration.test.utils.bean.APILifeCycleAction;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.admin.client.AuthenticatorClient;

public class CustomLifeCycleTestCase
extends APIManagerLifecycleBaseTest {
    private static final String API_NAME = "APICustomLifecycleTestApi";
    private LifeCycleAdminClient lifeCycleAdminClient;
    private String apiEndPointUrl;
    private AuthenticatorClient loginClient;
    private String backendUrl;
    private static final String API_LIFECYCLE_PATH = "artifacts/AM/configFiles/lifecycle/APILifeCycle.json";
    private static final String TENANT_CONFIG_PATH = "artifacts/AM/configFiles/tenantConf/tenant-conf.json";
    private static final String UTF_8 = "UTF-8";
    private String apiId;

    @Factory(dataProvider="userModeDataProvider")
    public CustomLifeCycleTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass
    public void initialize() throws Exception {
        super.init(this.userMode);
        this.backendUrl = this.gatewayContextMgt.getContextUrls().getBackEndUrl();
        this.loginClient = new AuthenticatorClient(this.backendUrl);
        String session = this.loginClient.login(this.user.getUserName(), this.user.getPassword(), "localhost");
        this.lifeCycleAdminClient = new LifeCycleAdminClient(this.backendUrl, session);
        InputStream tenantConfigStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(TENANT_CONFIG_PATH);
        JSONParser jsonParser = new JSONParser();
        JSONObject tenantJsonObject = (JSONObject)jsonParser.parse((Reader)new InputStreamReader(tenantConfigStream, UTF_8));
        InputStream lcStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(API_LIFECYCLE_PATH);
        jsonParser = new JSONParser();
        JSONObject lcJsonObj = (JSONObject)jsonParser.parse((Reader)new InputStreamReader(lcStream, UTF_8));
        tenantJsonObject.put((Object)"LifeCycle", (Object)lcJsonObj);
        this.restAPIAdmin.updateTenantConfig((Object)tenantJsonObject);
        String gatewayUrl = "carbon.super".equals(this.gatewayContextWrk.getContextTenant().getDomain()) ? this.gatewayUrlsWrk.getWebAppURLNhttp() : this.gatewayUrlsWrk.getWebAppURLNhttp() + "t/" + this.gatewayContextWrk.getContextTenant().getDomain() + "/";
        this.apiEndPointUrl = gatewayUrl + "jaxrs_basic/services/customers/customerservice";
        APIRequest apiRequest = new APIRequest(API_NAME, "{version}/api", new URL(this.apiEndPointUrl));
        apiRequest.setVersion("1.0.0");
        apiRequest.setSandbox(this.apiEndPointUrl);
        apiRequest.setProvider(this.user.getUserName());
        HttpResponse serviceResponse = this.restAPIPublisher.addAPI(apiRequest);
        this.apiId = serviceResponse.getData();
    }

    @Test(groups={"wso2.am"}, description="Check custom life cycle state.")
    public void testCustomLifeCycle() throws Exception {
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, APILifeCycleAction.PUBLISH.getAction());
        Assert.assertEquals((String)APILifeCycleState.PUBLISHED.getState(), (String)this.restAPIPublisher.getLifecycleStatus(this.apiId).getData(), (String)"lifecycle not changed to published");
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, APILifeCycleAction.PROMOTE.getAction());
        Assert.assertEquals((String)APILifeCycleState.PROMOTED.getState(), (String)this.restAPIPublisher.getLifecycleStatus(this.apiId).getData(), (String)"lifecycle not changed to custom");
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, APILifeCycleAction.RE_PUBLISH.getAction());
        Assert.assertEquals((String)APILifeCycleState.PUBLISHED.getState(), (String)this.restAPIPublisher.getLifecycleStatus(this.apiId).getData(), (String)"lifecycle not changed to published");
    }

    @AfterClass
    public void cleanupArtifacts() throws Exception {
        this.restAPIPublisher.deleteAPI(this.apiId);
        super.cleanUp();
    }
}

