/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import com.google.gson.internal.LinkedTreeMap;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.SearchResultListDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.admin.client.UserManagementClient;

public class DynamicAPIContextTestCase
extends APIManagerLifecycleBaseTest {
    private final Log log = LogFactory.getLog(DynamicAPIContextTestCase.class);
    private final String API_NAME = "ContextSearchAPI";
    private final String API_CONTEXT_TEMPLATE = "api/developer/{version}";
    private final String API_CONTEXT = "api/developer";
    private final String API_DESCRIPTION = "This is an API with a dynamic context";
    private final String API_VERSION = "1.0.0";
    private final String API_ENDPOINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private final String API_ENDPOINT_RESOURCE = "/customers/123";
    private final String APPLICATION_NAME = "DynamicContextTestApp";
    private String endpointUrl;
    private String apiId;
    private String applicationId;
    private String providerName;

    @Factory(dataProvider="userModeDataProvider")
    public DynamicAPIContextTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void initialize() throws Exception {
        super.init(this.userMode);
        this.userManagementClient = new UserManagementClient(this.keyManagerContext.getContextUrls().getBackEndUrl(), this.keyManagerContext.getContextTenant().getTenantAdmin().getUserName(), this.keyManagerContext.getContextTenant().getTenantAdmin().getPassword());
        this.endpointUrl = this.backEndServerUrl.getWebAppURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        this.providerName = this.user.getUserName();
        HttpResponse applicationResponse = this.restAPIStore.createApplication("DynamicContextTestApp", "Test Application", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
        this.applicationId = applicationResponse.getData();
    }

    @Test(groups={"wso2.am"}, description="Test API behavior when the API context is a templated context")
    public void testAPIWithTemplatedContext() throws Exception {
        APIRequest apiRequest = new APIRequest("ContextSearchAPI", "api/developer/{version}", new URL(this.endpointUrl));
        apiRequest.setVersion("1.0.0");
        apiRequest.setDescription("This is an API with a dynamic context");
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setTier("Unlimited");
        apiRequest.setProvider(this.providerName);
        apiRequest.setVisibility(APIDTO.VisibilityEnum.PUBLIC.getValue());
        this.apiId = this.createPublishAndSubscribeToAPIUsingRest(apiRequest, this.restAPIPublisher, this.restAPIStore, this.applicationId, "Unlimited");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("password");
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.applicationId, "3600", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        String accessToken = applicationKeyDTO.getToken().getAccessToken();
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        requestHeaders.put("accept", "text/xml");
        String apiInvocationUrl = this.getAPIInvocationURLHttps("api/developer", "1.0.0") + "/customers/123";
        HttpResponse response = HttpRequestUtil.doGet((String)apiInvocationUrl, requestHeaders);
        Assert.assertEquals((int)response.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Invocation fails for GET Method");
    }

    @Test(groups={"wso2.am"}, description="Test API search using the templated context", dependsOnMethods={"testAPIWithTemplatedContext"})
    public void testAPISearchUsingTemplatedContext() throws Exception {
        String query = "context:/api/developer/{version}";
        int retries = 20;
        for (int i = 0; i <= retries; ++i) {
            SearchResultListDTO searchResultListDTO = this.restAPIPublisher.searchAPIs(query);
            if (searchResultListDTO.getCount() == 1) {
                Object apiObj = searchResultListDTO.getList() != null ? searchResultListDTO.getList().get(0) : null;
                String searchResultAPIName = ((LinkedTreeMap)apiObj).get((Object)"name").toString();
                Assert.assertEquals((String)searchResultAPIName, (String)"ContextSearchAPI", (String)"Returned API list after executing the search query is not as expected");
                break;
            }
            if (i == retries) {
                Assert.fail((String)("API search using context template in publisher failed. Received API count: " + searchResultListDTO.getCount()));
                continue;
            }
            this.log.warn((Object)("API search using context template in publisher failed. Received API count: " + searchResultListDTO.getCount() + ". Retrying..."));
            Thread.sleep(3000L);
        }
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        this.restAPIStore.deleteApplication(this.applicationId);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.apiId, this.restAPIPublisher);
        this.restAPIPublisher.deleteAPI(this.apiId);
        super.cleanUp();
    }
}

