/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.xpath.XPathExpressionException;
import org.json.JSONException;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.ApiException;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APILifeCycleAction;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class EditAPIAndCheckUpdatedInformationTestCase
extends APIManagerLifecycleBaseTest {
    private final String API_NAME = "EditAPIAndCheckUpdatedInformationTest";
    private final String API_CONTEXT = "EditAPIAndCheckUpdatedInformation";
    private final String API_TAGS = "testTag1, testTag2, testTag3";
    private final String API_DESCRIPTION = "This is test API create by API manager integration test";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String NEW_API_TAG = "newTag";
    private final String NEW_API_DESCRIPTION = "This is test API create by API manager integration test New Description";
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private String apiEndPointUrl;
    private String providerName;
    private APIRequest apiRequest;
    private APIIdentifier apiIdentifier;
    private String apiId;

    @Factory(dataProvider="userModeDataProvider")
    public EditAPIAndCheckUpdatedInformationTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void initialize() throws APIManagerIntegrationTestException, XPathExpressionException, MalformedURLException {
        super.init(this.userMode);
        this.apiEndPointUrl = this.backEndServerUrl.getWebAppURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        this.providerName = this.user.getUserName();
        this.apiRequest = new APIRequest("EditAPIAndCheckUpdatedInformationTest", "EditAPIAndCheckUpdatedInformation", new URL(this.apiEndPointUrl));
        this.apiRequest.setVersion("1.0.0");
        this.apiRequest.setTags("testTag1, testTag2, testTag3");
        this.apiRequest.setDescription("This is test API create by API manager integration test");
        this.apiRequest.setProvider(this.providerName);
        this.apiIdentifier = new APIIdentifier(this.providerName, "EditAPIAndCheckUpdatedInformationTest", "1.0.0");
    }

    @Test(groups={"wso2.am"}, description="Edit the API Information")
    public void testEditAPIInformation() throws APIManagerIntegrationTestException, ApiException, XPathExpressionException, JSONException {
        HttpResponse serviceResponse = this.restAPIPublisher.addAPI(this.apiRequest);
        this.apiId = serviceResponse.getData();
        this.createAPIRevisionAndDeployUsingRest(this.apiId, this.restAPIPublisher);
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, APILifeCycleAction.PUBLISH.getAction(), null);
        this.waitForAPIDeploymentSync(this.providerName, "EditAPIAndCheckUpdatedInformationTest", "1.0.0", "\"isApiExists\":true");
        String apiNewTags = "testTag1, testTag2, testTag3, newTag";
        this.apiRequest.setTags(apiNewTags);
        this.apiRequest.setDescription("This is test API create by API manager integration test New Description");
        HttpResponse updateAPIHTTPResponse = this.restAPIPublisher.updateAPI(this.apiRequest, this.apiId);
        this.createAPIRevisionAndDeployUsingRest(this.apiId, this.restAPIPublisher);
        this.waitForAPIDeploymentSync(this.providerName, "EditAPIAndCheckUpdatedInformationTest", "1.0.0", "\"isApiExists\":true");
        Assert.assertEquals((int)updateAPIHTTPResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Update API Response Code is invalid. " + this.getAPIIdentifierString(this.apiIdentifier)));
        Assert.assertNotNull((Object)updateAPIHTTPResponse.getData(), (String)("Error in API Update in " + this.getAPIIdentifierString(this.apiIdentifier)));
    }

    @Test(groups={"wso2.am"}, description="Test whether the updated information available in the publisher ", dependsOnMethods={"testEditAPIInformation"})
    public void testUpdatedAPIInformationFromAPIPublisher() throws APIManagerIntegrationTestException, ApiException {
        HttpResponse httpResponse = this.restAPIPublisher.getAPI(this.apiId);
        Assert.assertEquals((String)this.getValueFromJSON(httpResponse, "description"), (String)"This is test API create by API manager integration test New Description", (String)"Updated Description is not available");
        Assert.assertTrue((boolean)httpResponse.getData().contains("newTag"), (String)"Newly added Tag is not available");
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        this.undeployAndDeleteAPIRevisionsUsingRest(this.apiId, this.restAPIPublisher);
        this.restAPIPublisher.deleteAPI(this.apiId);
        super.cleanUp();
    }
}

