/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import com.google.gson.Gson;
import java.net.URL;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APIInfoDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APIListDTO;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleAction;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class NewVersionUpdateTestCase
extends APIMIntegrationBaseTest {
    private String apiName = "NewVersionUpdateTestCaseAPIName";
    private String APIContext = "NewVersionUpdateTestCaseContext";
    private String tags = "test";
    private String endpointUrl;
    private String endpointUrlNew;
    private String description = "This is test API create by API manager integration test";
    private String APIVersion = "1.0.0";
    private String APIVersionNew = "2.0.0";
    private String apiId;
    private String apiId2;

    @Factory(dataProvider="userModeDataProvider")
    public NewVersionUpdateTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.endpointUrl = this.backEndServerUrl.getWebAppURLHttp() + "am/sample/calculator/v1/api/add";
        this.endpointUrlNew = this.backEndServerUrl.getWebAppURLHttp() + "am/sample/calculator/v1/api/multiply";
    }

    @Test(groups={"wso2.am"}, description="Create new version and publish")
    public void testAPINewVersionCreation() throws Exception {
        String providerName = this.user.getUserName();
        APIRequest apiRequest = new APIRequest(this.apiName, this.APIContext, new URL(this.endpointUrl));
        apiRequest.setTags(this.tags);
        apiRequest.setDescription(this.description);
        apiRequest.setVersion(this.APIVersion);
        apiRequest.setProvider(providerName);
        HttpResponse serviceResponse = this.restAPIPublisher.addAPI(apiRequest);
        this.apiId = serviceResponse.getData();
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, APILifeCycleAction.PUBLISH.getAction(), null);
        serviceResponse = this.restAPIPublisher.copyAPI(this.APIVersionNew, this.apiId, Boolean.valueOf(false));
        this.apiId2 = serviceResponse.getData();
        serviceResponse = this.restAPIPublisher.getAPI(this.apiId2);
        Gson g = new Gson();
        APIDTO apidto = (APIDTO)g.fromJson(serviceResponse.getData(), APIDTO.class);
        String version = apidto.getVersion();
        Assert.assertEquals((String)version, (String)this.APIVersionNew);
    }

    @Test(groups={"wso2.am"}, description="Update new version api with endpoint", dependsOnMethods={"testAPINewVersionCreation"})
    public void testNewVersionAPIUpdate() throws Exception {
        APIRequest apiUpdateRequest = new APIRequest(this.apiName, this.APIContext, new URL(this.endpointUrlNew));
        String providerName = this.user.getUserName();
        apiUpdateRequest.setProvider(providerName);
        apiUpdateRequest.setVersion(this.APIVersionNew);
        HttpResponse updateResponse = this.restAPIPublisher.updateAPI(apiUpdateRequest, this.apiId);
        this.waitForAPIDeployment();
        HttpResponse apiResponse = this.restAPIPublisher.getAPI(updateResponse.getData());
        Gson g = new Gson();
        APIDTO apidto = (APIDTO)g.fromJson(apiResponse.getData(), APIDTO.class);
        String endPointConfig = apidto.getEndpointConfig().toString();
        Assert.assertTrue((boolean)endPointConfig.contains(this.endpointUrlNew));
    }

    @Test(groups={"wso2.am"}, description="Check the count of the APIs when display multiple versioned APIs option is disabled in devportal", dependsOnMethods={"testNewVersionAPIUpdate"})
    public void testCheckMultipleVersionedAPIsCount() throws Exception {
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId2, APILifeCycleAction.PUBLISH.getAction());
        this.waitForAPIDeployment();
        APIListDTO restAPIStoreAllAPIs = this.restAPIStore.getAllAPIs(this.user.getUserDomain());
        Assert.assertEquals((String)restAPIStoreAllAPIs.getCount().toString(), (String)String.valueOf(1), (String)"Wrong API count returned");
        Assert.assertEquals((String)((APIInfoDTO)restAPIStoreAllAPIs.getList().get(0)).getVersion(), (String)this.APIVersionNew, (String)"Wrong API list returned");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIPublisher.deleteAPI(this.apiId);
        this.restAPIPublisher.deleteAPI(this.apiId2);
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}, {TestUserMode.SUPER_TENANT_USER_STORE_USER}, {TestUserMode.SUPER_TENANT_EMAIL_USER}, {TestUserMode.TENANT_EMAIL_USER}};
    }
}

