/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class PluggableVersioningStrategyTestCase
extends APIManagerLifecycleBaseTest {
    private static final Log log = LogFactory.getLog(PluggableVersioningStrategyTestCase.class);
    private final String INVOKABLE_API_CONTEXT = "1.0.0/api";
    private static final String API_GET_ENDPOINT_METHOD = "/customers/123";
    private static final String RESPONSE_GET = "<id>123</id><name>John</name></Customer>";

    @BeforeClass(alwaysRun=true)
    public void initialize(ITestContext ctx) throws Exception {
        super.init();
    }

    @Test(groups={"webapp"}, description="This test method tests the pluggable versioning stratergy")
    public void testPluggableVersioningStratergy(ITestContext ctx) throws Exception, IOException {
        HashMap<String, String> requestHeadersGet = new HashMap<String, String>();
        requestHeadersGet.put("accept", "text/xml");
        String accessToken = (String)ctx.getAttribute("accessToken");
        requestHeadersGet.put("Authorization", "Bearer " + accessToken);
        HttpResponse httpResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("1.0.0/api") + API_GET_ENDPOINT_METHOD), requestHeadersGet);
        Assert.assertEquals((int)httpResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Invocation fails for GET request");
        Assert.assertTrue((boolean)httpResponse.getData().contains(RESPONSE_GET), (String)("Response Data not match for GET request. Expected value : <id>123</id><name>John</name></Customer> not contains in response data " + httpResponse.getData()));
    }
}

