/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.revision;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.plexus.util.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.ApiResponse;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleAction;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.bean.APIRevisionDeployUndeployRequest;
import org.wso2.am.integration.test.utils.bean.APIRevisionRequest;
import org.wso2.am.integration.test.utils.http.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIRevisionTestCase
extends APIMIntegrationBaseTest {
    private final Log log = LogFactory.getLog(APIRevisionTestCase.class);
    protected static final int HTTP_RESPONSE_CODE_OK = Response.Status.OK.getStatusCode();
    protected static final int HTTP_RESPONSE_CODE_CREATED = Response.Status.CREATED.getStatusCode();
    protected static final int HTTP_RESPONSE_CODE_NOT_FOUND = Response.Status.NOT_FOUND.getStatusCode();
    protected static final int HTTP_RESPONSE_CODE_BAD_REQUEST = Response.Status.BAD_REQUEST.getStatusCode();
    protected static final int HTTP_RESPONSE_CODE_SERVICE_UNAVAILABLE = Response.Status.SERVICE_UNAVAILABLE.getStatusCode();
    protected static final int HTTP_RESPONSE_CODE_INTERNAL_SERVER_ERROR = Response.Status.INTERNAL_SERVER_ERROR.getStatusCode();
    private final String API_CONTEXT = "revisiontestapi";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String API_END_POINT_METHOD = "/customers/123";
    private final String INVALID_API_UUID = "2C0q51h4-621g-3163-7eip-as246v8x681m";
    private final String INVALID_REVISION_UUID = "4bm28320-l75v-3895-70ks-025294jd85a5";
    private String apiEndPointUrl;
    private String apiId;
    private String revisionUUID;
    private String accessToken;

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init();
        this.apiEndPointUrl = this.backEndServerUrl.getWebAppURLHttp() + "jaxrs_basic/services/customers/customerservice/";
    }

    @Test(groups={"wso2.am"}, description="API Revision create test case")
    public void testCreateAPIRevision() throws Exception {
        APIRequest apiRequest = new APIRequest("RevisionTestAPI", "revisiontestapi", new URL(this.apiEndPointUrl));
        apiRequest.setVersion("1.0.0");
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setTier("Unlimited");
        HttpResponse apiResponse = this.restAPIPublisher.addAPI(apiRequest);
        this.apiId = apiResponse.getData();
        Assert.assertEquals((int)apiResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_CREATED, (String)("Create API Response Code is invalid." + this.apiId));
        HttpResponse apiDto = this.restAPIPublisher.getAPI(apiResponse.getData());
        Assert.assertTrue((boolean)StringUtils.isNotEmpty((String)apiDto.getData()), (String)("Added Api is not available in APi Publisher. API ID " + this.apiId));
        APIRevisionRequest apiRevisionRequest = new APIRevisionRequest();
        apiRevisionRequest.setApiUUID(this.apiId);
        apiRevisionRequest.setDescription("Test Revision 1");
        HttpResponse apiRevisionResponse = this.restAPIPublisher.addAPIRevision(apiRevisionRequest);
        Assert.assertEquals((int)apiRevisionResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_CREATED, (String)("Create API Response Code is invalid." + apiRevisionResponse.getData()));
        JSONObject revisionResponseData = new JSONObject(apiRevisionResponse.getData());
        this.revisionUUID = revisionResponseData.getString("id");
    }

    @Test(groups={"wso2.am"}, description="API Revision create with invalid API UUID", dependsOnMethods={"testCreateAPIRevision"})
    public void testCreateAPIRevisionWithInvalidAPI() throws Exception {
        APIRevisionRequest apiRevisionRequest = new APIRevisionRequest();
        apiRevisionRequest.setApiUUID("2C0q51h4-621g-3163-7eip-as246v8x681m");
        apiRevisionRequest.setDescription("Test Revision 2");
        HttpResponse apiRevisionResponse = this.restAPIPublisher.addAPIRevision(apiRevisionRequest);
        Assert.assertEquals((int)apiRevisionResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_INTERNAL_SERVER_ERROR, (String)"Invalid response code for API Revision with invalid API.");
    }

    @Test(groups={"wso2.am"}, description="API Revision create without description", dependsOnMethods={"testCreateAPIRevisionWithInvalidAPI"})
    public void testCreateAPIRevisionWithoutDescription() throws Exception {
        APIRevisionRequest apiRevisionRequest = new APIRevisionRequest();
        apiRevisionRequest.setApiUUID(this.apiId);
        HttpResponse apiRevisionResponse = this.restAPIPublisher.addAPIRevision(apiRevisionRequest);
        Assert.assertEquals((int)apiRevisionResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_CREATED, (String)("Create API Response Code is invalid." + apiRevisionResponse.getData()));
    }

    @Test(groups={"wso2.am"}, description="Check the availability of API Revision in publisher before deploying.", dependsOnMethods={"testCreateAPIRevisionWithoutDescription"})
    public void testGetAPIRevisions() throws Exception {
        HttpResponse apiRevisionsGetResponse = this.restAPIPublisher.getAPIRevisions(this.apiId, null);
        Assert.assertEquals((int)apiRevisionsGetResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Unable to retrieve revisions" + apiRevisionsGetResponse.getData()));
        ArrayList<JSONObject> revisionList = new ArrayList<JSONObject>();
        JSONObject jsonObject = new JSONObject(apiRevisionsGetResponse.getData());
        JSONArray arrayList = jsonObject.getJSONArray("list");
        int l = arrayList.length();
        for (int i = 0; i < l; ++i) {
            revisionList.add(arrayList.getJSONObject(i));
        }
        for (JSONObject revision : revisionList) {
            Assert.assertNotNull((Object)revision.getString("id"), (String)"Unable to retrieve revision UUID");
        }
    }

    @Test(groups={"wso2.am"}, description="Check the availability of API Revision in publisher after deploying.", dependsOnMethods={"testGetAPIRevisions"})
    public void testGetDeployedAPIRevisions() throws Exception {
        HttpResponse apiRevisionsGetResponse = this.restAPIPublisher.getAPIRevisions(this.apiId, "deployed:true");
        Assert.assertEquals((int)apiRevisionsGetResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Unable to retrieve deployed revisions" + apiRevisionsGetResponse.getData()));
        ArrayList<JSONObject> revisionList = new ArrayList<JSONObject>();
        JSONObject jsonObject = new JSONObject(apiRevisionsGetResponse.getData());
        JSONArray arrayList = jsonObject.getJSONArray("list");
        int l = arrayList.length();
        for (int i = 0; i < l; ++i) {
            revisionList.add(arrayList.getJSONObject(i));
        }
        for (JSONObject revision : revisionList) {
            Assert.assertNotNull((Object)revision.getString("id"), (String)"Unable to retrieve revision UUID");
        }
    }

    @Test(groups={"wso2.am"}, description="Test deploying API Revision to gateway environments", dependsOnMethods={"testGetDeployedAPIRevisions"})
    public void testDeployAPIRevision() throws Exception {
        ArrayList<APIRevisionDeployUndeployRequest> apiRevisionDeployRequestList = new ArrayList<APIRevisionDeployUndeployRequest>();
        APIRevisionDeployUndeployRequest apiRevisionDeployRequest = new APIRevisionDeployUndeployRequest();
        apiRevisionDeployRequest.setName("Default");
        apiRevisionDeployRequest.setVhost("localhost");
        apiRevisionDeployRequest.setDisplayOnDevportal(true);
        apiRevisionDeployRequestList.add(apiRevisionDeployRequest);
        HttpResponse apiRevisionsDeployResponse = this.restAPIPublisher.deployAPIRevision(this.apiId, this.revisionUUID, apiRevisionDeployRequestList, "API");
        Assert.assertEquals((int)apiRevisionsDeployResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_CREATED, (String)("Unable to deploy API Revisions:" + apiRevisionsDeployResponse.getData()));
    }

    @Test(groups={"wso2.am"}, description="Test deploying API Revision to gateway environments with invalid API UUID", dependsOnMethods={"testDeployAPIRevision"})
    public void testDeployAPIRevisionWithInvalidAPI() throws Exception {
        ArrayList<APIRevisionDeployUndeployRequest> apiRevisionDeployRequestList = new ArrayList<APIRevisionDeployUndeployRequest>();
        APIRevisionDeployUndeployRequest apiRevisionDeployRequest = new APIRevisionDeployUndeployRequest();
        apiRevisionDeployRequest.setName("Default");
        apiRevisionDeployRequest.setVhost("localhost");
        apiRevisionDeployRequest.setDisplayOnDevportal(true);
        apiRevisionDeployRequestList.add(apiRevisionDeployRequest);
        HttpResponse apiRevisionsDeployResponse = this.restAPIPublisher.deployAPIRevision("2C0q51h4-621g-3163-7eip-as246v8x681m", this.revisionUUID, apiRevisionDeployRequestList, "API");
        Assert.assertEquals((int)apiRevisionsDeployResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_NOT_FOUND, (String)("Invalid response code for deploying API Revision with invalid API UUID:" + apiRevisionsDeployResponse.getData()));
    }

    @Test(groups={"wso2.am"}, description="Test deploying API Revision to gateway environments with invalid Revision UUID", dependsOnMethods={"testDeployAPIRevisionWithInvalidAPI"})
    public void testDeployAPIRevisionWithInvalidRevisionUUID() throws Exception {
        ArrayList<APIRevisionDeployUndeployRequest> apiRevisionDeployRequestList = new ArrayList<APIRevisionDeployUndeployRequest>();
        APIRevisionDeployUndeployRequest apiRevisionDeployRequest = new APIRevisionDeployUndeployRequest();
        apiRevisionDeployRequest.setName("Default");
        apiRevisionDeployRequest.setVhost("localhost");
        apiRevisionDeployRequest.setDisplayOnDevportal(true);
        apiRevisionDeployRequestList.add(apiRevisionDeployRequest);
        HttpResponse apiRevisionsDeployResponse = this.restAPIPublisher.deployAPIRevision(this.apiId, "4bm28320-l75v-3895-70ks-025294jd85a5", apiRevisionDeployRequestList, "API");
        Assert.assertEquals((int)apiRevisionsDeployResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_NOT_FOUND, (String)("Invalid response code for deploying API Revision with invalid Revision UUID:" + apiRevisionsDeployResponse.getData()));
    }

    @Test(groups={"wso2.am"}, description="Test deploying API Revision to gateway environments with invalid deployment information", dependsOnMethods={"testDeployAPIRevisionWithInvalidRevisionUUID"})
    public void testDeployAPIRevisionWithInvalidDeploymentInfo() throws Exception {
        ArrayList<APIRevisionDeployUndeployRequest> apiRevisionDeployRequestList = new ArrayList<APIRevisionDeployUndeployRequest>();
        APIRevisionDeployUndeployRequest apiRevisionDeployRequest = new APIRevisionDeployUndeployRequest();
        apiRevisionDeployRequest.setName("us-region");
        apiRevisionDeployRequest.setVhost("gw.apim.com");
        apiRevisionDeployRequest.setDisplayOnDevportal(true);
        apiRevisionDeployRequestList.add(apiRevisionDeployRequest);
        HttpResponse apiRevisionsDeployResponse = this.restAPIPublisher.deployAPIRevision(this.apiId, this.revisionUUID, apiRevisionDeployRequestList, "API");
        Assert.assertEquals((int)apiRevisionsDeployResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_BAD_REQUEST, (String)("Unable to deploy API Revisions:" + apiRevisionsDeployResponse.getData()));
    }

    @Test(groups={"wso2.am"}, description="Test UnDeploying API Revision to gateway environments", dependsOnMethods={"testDeployAPIRevisionWithInvalidDeploymentInfo"})
    public void testUnDeployAPIRevision() throws Exception {
        ArrayList<APIRevisionDeployUndeployRequest> apiRevisionUndeployRequestList = new ArrayList<APIRevisionDeployUndeployRequest>();
        APIRevisionDeployUndeployRequest apiRevisionUnDeployRequest = new APIRevisionDeployUndeployRequest();
        apiRevisionUnDeployRequest.setName("Default");
        apiRevisionUnDeployRequest.setVhost(null);
        apiRevisionUnDeployRequest.setDisplayOnDevportal(true);
        apiRevisionUndeployRequestList.add(apiRevisionUnDeployRequest);
        HttpResponse apiRevisionsUnDeployResponse = this.restAPIPublisher.undeployAPIRevision(this.apiId, this.revisionUUID, apiRevisionUndeployRequestList);
        Assert.assertEquals((int)apiRevisionsUnDeployResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_CREATED, (String)("Unable to Undeploy API Revisions:" + apiRevisionsUnDeployResponse.getData()));
    }

    @Test(groups={"wso2.am"}, description="Test UnDeploying API Revision with invalid API UUID to gateway environments", dependsOnMethods={"testUnDeployAPIRevision"})
    public void testUnDeployAPIRevisionWithInvalidAPI() throws Exception {
        ArrayList<APIRevisionDeployUndeployRequest> apiRevisionUndeployRequestList = new ArrayList<APIRevisionDeployUndeployRequest>();
        APIRevisionDeployUndeployRequest apiRevisionUnDeployRequest = new APIRevisionDeployUndeployRequest();
        apiRevisionUnDeployRequest.setName("us-region");
        apiRevisionUnDeployRequest.setVhost("gw.apim.com");
        apiRevisionUnDeployRequest.setDisplayOnDevportal(true);
        apiRevisionUndeployRequestList.add(apiRevisionUnDeployRequest);
        HttpResponse apiRevisionsUnDeployResponse = this.restAPIPublisher.undeployAPIRevision("2C0q51h4-621g-3163-7eip-as246v8x681m", this.revisionUUID, apiRevisionUndeployRequestList);
        Assert.assertEquals((int)apiRevisionsUnDeployResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_NOT_FOUND, (String)("Invalid Response Code for Undeploy API Revisions with Invalid Deployment Information:" + apiRevisionsUnDeployResponse.getData()));
    }

    @Test(groups={"wso2.am"}, description="Test UnDeploying API Revision with invalid Revision UUID to gateway environments", dependsOnMethods={"testUnDeployAPIRevisionWithInvalidAPI"})
    public void testUnDeployAPIRevisionWithInvalidRevisionUUID() throws Exception {
        ArrayList<APIRevisionDeployUndeployRequest> apiRevisionUndeployRequestList = new ArrayList<APIRevisionDeployUndeployRequest>();
        APIRevisionDeployUndeployRequest apiRevisionUnDeployRequest = new APIRevisionDeployUndeployRequest();
        apiRevisionUnDeployRequest.setName("Default");
        apiRevisionUnDeployRequest.setVhost(null);
        apiRevisionUnDeployRequest.setDisplayOnDevportal(true);
        apiRevisionUndeployRequestList.add(apiRevisionUnDeployRequest);
        HttpResponse apiRevisionsUnDeployResponse = this.restAPIPublisher.undeployAPIRevision(this.apiId, "4bm28320-l75v-3895-70ks-025294jd85a5", apiRevisionUndeployRequestList);
        Assert.assertEquals((int)apiRevisionsUnDeployResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_NOT_FOUND, (String)("Invalid Response Code for Undeploy API Revisions with Invalid Revision UUID:" + apiRevisionsUnDeployResponse.getData()));
    }

    @Test(groups={"wso2.am"}, description="Test UnDeploying API Revision with invalid Deployment Information to gateway environments", dependsOnMethods={"testUnDeployAPIRevisionWithInvalidRevisionUUID"})
    public void testUnDeployAPIRevisionWithInvalidDeploymentInfo() throws Exception {
        ArrayList<APIRevisionDeployUndeployRequest> apiRevisionUndeployRequestList = new ArrayList<APIRevisionDeployUndeployRequest>();
        APIRevisionDeployUndeployRequest apiRevisionUnDeployRequest = new APIRevisionDeployUndeployRequest();
        apiRevisionUnDeployRequest.setName("Default");
        apiRevisionUnDeployRequest.setVhost(null);
        apiRevisionUnDeployRequest.setDisplayOnDevportal(true);
        apiRevisionUndeployRequestList.add(apiRevisionUnDeployRequest);
        HttpResponse apiRevisionsUnDeployResponse = this.restAPIPublisher.undeployAPIRevision(this.apiId, "4bm28320-l75v-3895-70ks-025294jd85a5", apiRevisionUndeployRequestList);
        Assert.assertEquals((int)apiRevisionsUnDeployResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_NOT_FOUND, (String)("Invalid Response Code for Undeploy API Revisions with Invalid Revision UUID:" + apiRevisionsUnDeployResponse.getData()));
    }

    @Test(groups={"wso2.am"}, description="Test restoring API using created API Revision", dependsOnMethods={"testUnDeployAPIRevisionWithInvalidDeploymentInfo"})
    public void testRestoreAPIRevision() throws Exception {
        HttpResponse apiRevisionsRestoreResponse = this.restAPIPublisher.restoreAPIRevision(this.apiId, this.revisionUUID);
        Assert.assertEquals((int)apiRevisionsRestoreResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_CREATED, (String)("Unable to restore API Revisions:" + apiRevisionsRestoreResponse.getData()));
    }

    @Test(groups={"wso2.am"}, description="Test restoring API Revision with invalid API UUID", dependsOnMethods={"testRestoreAPIRevision"})
    public void testRestoreAPIRevisionWithInvalidAPIUUID() throws Exception {
        HttpResponse apiRevisionsWithInvalidAPIUUIDRestoreResponse = this.restAPIPublisher.restoreAPIRevision("2C0q51h4-621g-3163-7eip-as246v8x681m", this.revisionUUID);
        Assert.assertEquals((int)apiRevisionsWithInvalidAPIUUIDRestoreResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_NOT_FOUND, (String)("Unable to get API not found error: " + apiRevisionsWithInvalidAPIUUIDRestoreResponse.getData()));
    }

    @Test(groups={"wso2.am"}, description="Test restoring API Revision with invalid Revision UUID", dependsOnMethods={"testRestoreAPIRevisionWithInvalidAPIUUID"})
    public void testRestoreAPIRevisionWithInvalidRevisionUUID() throws Exception {
        HttpResponse apiRevisionsWithInvalidRevisionUUIDRestoreResponse = this.restAPIPublisher.restoreAPIRevision(this.apiId, "4bm28320-l75v-3895-70ks-025294jd85a5");
        Assert.assertEquals((int)apiRevisionsWithInvalidRevisionUUIDRestoreResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_NOT_FOUND, (String)("Unable to get Revision not found error: " + apiRevisionsWithInvalidRevisionUUIDRestoreResponse.getData()));
    }

    @Test(groups={"wso2.am"}, description="Test deleting API Revision having deployments", dependsOnMethods={"testRestoreAPIRevisionWithInvalidRevisionUUID"})
    public void testDeleteAPIRevisionHavingDeployments() throws Exception {
        ArrayList<APIRevisionDeployUndeployRequest> apiRevisionDeployRequestList = new ArrayList<APIRevisionDeployUndeployRequest>();
        APIRevisionDeployUndeployRequest apiRevisionDeployRequest = new APIRevisionDeployUndeployRequest();
        apiRevisionDeployRequest.setName("Default");
        apiRevisionDeployRequest.setVhost("localhost");
        apiRevisionDeployRequest.setDisplayOnDevportal(true);
        apiRevisionDeployRequestList.add(apiRevisionDeployRequest);
        HttpResponse apiRevisionDeployResponse = this.restAPIPublisher.deployAPIRevision(this.apiId, this.revisionUUID, apiRevisionDeployRequestList, "API");
        Assert.assertEquals((int)apiRevisionDeployResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_CREATED, (String)("Unable to deploy API Revisions: " + apiRevisionDeployResponse.getData()));
        this.waitForAPIDeployment();
        HttpResponse apiRevisionsHavingDeploymentsDeleteResponse = this.restAPIPublisher.deleteAPIRevision(this.apiId, this.revisionUUID);
        Assert.assertEquals((int)apiRevisionsHavingDeploymentsDeleteResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_BAD_REQUEST, (String)("Unable to get error for deleting revisions having deployments: " + apiRevisionsHavingDeploymentsDeleteResponse.getData()));
    }

    @Test(groups={"wso2.am"}, description="Test deleting API Revision", dependsOnMethods={"testDeleteAPIRevisionHavingDeployments"})
    public void testDeleteAPIRevision() throws Exception {
        ArrayList<APIRevisionDeployUndeployRequest> apiRevisionUndeployRequestList = new ArrayList<APIRevisionDeployUndeployRequest>();
        APIRevisionDeployUndeployRequest apiRevisionUnDeployRequest = new APIRevisionDeployUndeployRequest();
        apiRevisionUnDeployRequest.setName("Default");
        apiRevisionUnDeployRequest.setVhost(null);
        apiRevisionUnDeployRequest.setDisplayOnDevportal(true);
        apiRevisionUndeployRequestList.add(apiRevisionUnDeployRequest);
        HttpResponse apiRevisionUnDeployResponse = this.restAPIPublisher.undeployAPIRevision(this.apiId, this.revisionUUID, apiRevisionUndeployRequestList);
        Assert.assertEquals((int)apiRevisionUnDeployResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_CREATED, (String)("Unable to undeploy API Revisions: " + apiRevisionUnDeployResponse.getData()));
        HttpResponse apiRevisionDeleteResponse = this.restAPIPublisher.deleteAPIRevision(this.apiId, this.revisionUUID);
        Assert.assertEquals((int)apiRevisionDeleteResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Unable to delete API Revisions: " + apiRevisionDeleteResponse.getData()));
    }

    @Test(groups={"wso2.am"}, description="Test deleting API Revision with invalid API UUID", dependsOnMethods={"testDeleteAPIRevision"})
    public void testDeleteAPIRevisionWithInvalidAPIUUID() throws Exception {
        HttpResponse apiRevisionsWithInvalidAPIUUIDDeleteResponse = this.restAPIPublisher.deleteAPIRevision("2C0q51h4-621g-3163-7eip-as246v8x681m", this.revisionUUID);
        Assert.assertEquals((int)apiRevisionsWithInvalidAPIUUIDDeleteResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_NOT_FOUND, (String)("Unable to get API not found error: " + apiRevisionsWithInvalidAPIUUIDDeleteResponse.getData()));
    }

    @Test(groups={"wso2.am"}, description="Test deleting API Revision with invalid Revision UUID", dependsOnMethods={"testDeleteAPIRevisionWithInvalidAPIUUID"})
    public void testDeleteAPIRevisionWithInvalidRevisionUUID() throws Exception {
        HttpResponse apiRevisionsWithInvalidRevisionUUIDDeleteResponse = this.restAPIPublisher.deleteAPIRevision(this.apiId, "4bm28320-l75v-3895-70ks-025294jd85a5");
        Assert.assertEquals((int)apiRevisionsWithInvalidRevisionUUIDDeleteResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_NOT_FOUND, (String)("Unable to get Revision not found error: " + apiRevisionsWithInvalidRevisionUUIDDeleteResponse.getData()));
    }

    @Test(groups={"wso2.am"}, description="Test invoking API for a new Revision in CREATED lifecycle stage", dependsOnMethods={"testDeleteAPIRevisionWithInvalidRevisionUUID"})
    public void testInvokeAPIInCreatedLifecycleStage() throws Exception {
        APIRevisionRequest apiRevisionRequest = new APIRevisionRequest();
        apiRevisionRequest.setApiUUID(this.apiId);
        apiRevisionRequest.setDescription("Test Revision for Lifecycle Changes Testing API");
        HttpResponse apiRevisionResponse = this.restAPIPublisher.addAPIRevision(apiRevisionRequest);
        Assert.assertEquals((int)apiRevisionResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_CREATED, (String)("Unable to create API Revision: " + apiRevisionResponse.getData()));
        JSONObject revisionResponseData = new JSONObject(apiRevisionResponse.getData());
        this.revisionUUID = revisionResponseData.getString("id");
        ArrayList<APIRevisionDeployUndeployRequest> apiRevisionDeployRequestList = new ArrayList<APIRevisionDeployUndeployRequest>();
        APIRevisionDeployUndeployRequest apiRevisionDeployRequest = new APIRevisionDeployUndeployRequest();
        apiRevisionDeployRequest.setName("Default");
        apiRevisionDeployRequest.setVhost("localhost");
        apiRevisionDeployRequest.setDisplayOnDevportal(true);
        apiRevisionDeployRequestList.add(apiRevisionDeployRequest);
        HttpResponse apiRevisionDeployResponse = this.restAPIPublisher.deployAPIRevision(this.apiId, this.revisionUUID, apiRevisionDeployRequestList, "API");
        Assert.assertEquals((int)apiRevisionDeployResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_CREATED, (String)("Unable to deploy API Revision in CREATED stage: " + apiRevisionDeployResponse.getData()));
        this.waitForAPIDeployment();
        ApiResponse apiKeyDTO = this.restAPIPublisher.generateInternalApiKey(this.apiId);
        String apiKey = ((APIKeyDTO)apiKeyDTO.getData()).getApikey();
        HashMap<String, String> invokeAPIRequestHeaders = new HashMap<String, String>();
        invokeAPIRequestHeaders.put("accept", "*/*");
        invokeAPIRequestHeaders.put("Internal-Key", apiKey);
        HttpResponse invokeAPIResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("revisiontestapi", "1.0.0") + "/customers/123"), invokeAPIRequestHeaders);
        Assert.assertEquals((int)invokeAPIResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Unable to invoke API in CREATED stage using a test token");
    }

    @Test(groups={"wso2.am"}, description="Test invoking API for a new Revision in PUBLISHED lifecycle stage", dependsOnMethods={"testInvokeAPIInCreatedLifecycleStage"})
    public void testInvokeAPIInPublishedLifecycleStage() throws Exception {
        HttpResponse apiLifecycleChangeResponse = this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, APILifeCycleAction.PUBLISH.getAction(), null);
        Assert.assertEquals((int)apiLifecycleChangeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Unable to change lifecycle stage to PUBLISHED: " + apiLifecycleChangeResponse.getData()));
        this.waitForAPIDeployment();
        ApplicationDTO applicationDTO = this.restAPIStore.addApplication("RevisionTestApplication", "Unlimited", "", "");
        String applicationId = applicationDTO.getApplicationId();
        this.restAPIStore.subscribeToAPI(this.apiId, applicationId, "Unlimited");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(applicationId, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        this.accessToken = Objects.requireNonNull(applicationKeyDTO.getToken()).getAccessToken();
        Assert.assertNotNull((Object)this.accessToken, (String)"Unable to get application subscription access token");
        HashMap<String, String> invokeAPIRequestHeaders = new HashMap<String, String>();
        invokeAPIRequestHeaders.put("accept", "*/*");
        invokeAPIRequestHeaders.put("Authorization", "Bearer " + this.accessToken);
        HttpResponse invokeAPIResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("revisiontestapi", "1.0.0") + "/customers/123"), invokeAPIRequestHeaders);
        Assert.assertEquals((int)invokeAPIResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Unable to invoke API in PUBLISHED stage using application subscription token");
    }

    @Test(groups={"wso2.am"}, description="Test invoking API for a new Revision in BLOCKED lifecycle stage", dependsOnMethods={"testInvokeAPIInPublishedLifecycleStage"})
    public void testInvokeAPIInBlockedLifecycleStage() throws Exception {
        HttpResponse apiLifecycleChangeResponse = this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, APILifeCycleAction.BLOCK.getAction(), null);
        Assert.assertEquals((int)apiLifecycleChangeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Unable to change lifecycle stage to BLOCKED: " + apiLifecycleChangeResponse.getData()));
        this.waitForAPIDeployment();
        HashMap<String, String> invokeAPIRequestHeaders = new HashMap<String, String>();
        invokeAPIRequestHeaders.put("accept", "*/*");
        invokeAPIRequestHeaders.put("Authorization", "Bearer " + this.accessToken);
        HttpResponse invokeAPIResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("revisiontestapi", "1.0.0") + "/customers/123"), invokeAPIRequestHeaders);
        Assert.assertEquals((int)invokeAPIResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_SERVICE_UNAVAILABLE, (String)"Unable to get error for invoking API in BLOCKED stage using application subscription token");
    }

    @Test(groups={"wso2.am"}, description="Test invoking API for a new Revision in DEPRECATED lifecycle stage", dependsOnMethods={"testInvokeAPIInBlockedLifecycleStage"})
    public void testInvokeAPIInDeprecatedLifecycleStage() throws Exception {
        HttpResponse apiLifecycleChangeResponse = this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, APILifeCycleAction.DEPRECATE.getAction(), null);
        Assert.assertEquals((int)apiLifecycleChangeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Unable to change lifecycle stage to DEPRECATED: " + apiLifecycleChangeResponse.getData()));
        this.waitForAPIDeployment();
        HashMap<String, String> invokeAPIRequestHeaders = new HashMap<String, String>();
        invokeAPIRequestHeaders.put("accept", "*/*");
        invokeAPIRequestHeaders.put("Authorization", "Bearer " + this.accessToken);
        HttpResponse invokeAPIResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("revisiontestapi", "1.0.0") + "/customers/123"), invokeAPIRequestHeaders);
        Assert.assertEquals((int)invokeAPIResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Unable to invoke API in DEPRECATED stage using application subscription token");
    }

    @Test(groups={"wso2.am"}, description="Test invoking API for a new Revision in RETIRED lifecycle stage", dependsOnMethods={"testInvokeAPIInDeprecatedLifecycleStage"})
    public void testInvokeAPIInRetiredLifecycleStage() throws Exception {
        HttpResponse apiLifecycleChangeResponse = this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, APILifeCycleAction.RETIRE.getAction(), null);
        Assert.assertEquals((int)apiLifecycleChangeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Unable to change lifecycle stage to RETIRED: " + apiLifecycleChangeResponse.getData()));
        this.waitForAPIDeployment();
        HashMap<String, String> invokeAPIRequestHeaders = new HashMap<String, String>();
        invokeAPIRequestHeaders.put("accept", "*/*");
        invokeAPIRequestHeaders.put("Authorization", "Bearer " + this.accessToken);
        HttpResponse invokeAPIResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("revisiontestapi", "1.0.0") + "/customers/123"), invokeAPIRequestHeaders);
        Assert.assertEquals((int)invokeAPIResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_NOT_FOUND, (String)"Unable to get error for invoking API in RETIRED stage using application subscription token");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIPublisher.deleteAPI(this.apiId);
    }
}

