/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.sdk;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.plexus.util.StringUtils;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.store.api.ApiException;
import org.wso2.am.integration.clients.store.api.ApiResponse;
import org.wso2.am.integration.test.impl.RestAPIStoreImpl;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class SDKGenerationTestCase
extends APIMIntegrationBaseTest {
    private final Log log = LogFactory.getLog(SDKGenerationTestCase.class);
    private final String SWAGGER_FOLDER = "swagger";
    private final String secondTenantDomain = "tenant2.com";
    private final String secondTenantAdminUserName = "secondAdmin";
    private final String secondTenantAdminPassword = "password2";
    private final String apiName = "TestAPI";
    private final String apiVersion = "1.0.0";
    private String testApiId;
    private String privateApiId;
    private String invalidSwaggerAPIId;

    @Factory(dataProvider="userModeDataProvider")
    public SDKGenerationTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.tenantManagementServiceClient.addTenant("tenant2.com", "password2", "secondAdmin", "demo");
    }

    @Test(groups={"wso2.am"}, description="SDK Generation test case")
    public void testSDKGeneration() throws Exception {
        String apiContext = "testContext";
        String url = "https://localhost:9443/test";
        APIRequest apiRequest = new APIRequest("TestAPI", apiContext, new URL(url));
        String tags = "sdkGen";
        apiRequest.setTags(tags);
        String description = "This is test API create by API manager integration test.";
        apiRequest.setDescription(description);
        apiRequest.setVersion("1.0.0");
        apiRequest.setSandbox(url);
        apiRequest.setResourceMethod("GET");
        apiRequest.setProvider(this.user.getUserName());
        apiRequest.setVisibility("public");
        HttpResponse response = this.restAPIPublisher.addAPI(apiRequest);
        this.testApiId = response.getData();
        int responseCode = response.getResponseCode();
        Assert.assertEquals((int)responseCode, (int)201);
        HttpResponse lifecycleResponse = this.restAPIPublisher.changeAPILifeCycleStatusToPublish(this.testApiId, false);
        Assert.assertEquals((int)lifecycleResponse.getResponseCode(), (int)200);
        String sdkLanguage = "java";
        boolean isSDKGenerationSuccessfulInSameTenant = this.generateSDK(this.restAPIStore, this.user.getUserNameWithoutDomain(), this.user.getPassword(), this.testApiId, sdkLanguage, this.user.getUserDomain(), null);
        boolean isSDKGenerationSuccessfulAcrossTenants = this.generateSDK(null, "secondAdmin", "password2", this.testApiId, sdkLanguage, "tenant2.com", this.user.getUserDomain());
        Assert.assertTrue((isSDKGenerationSuccessfulInSameTenant && !isSDKGenerationSuccessfulAcrossTenants ? 1 : 0) != 0);
    }

    @Test(groups={"wso2.am"}, description="SDK Generation for invalid swagger test case")
    public void testSDKGenerationForInvalidSwagger() throws Exception {
        String swaggerPath = this.getAMResourceLocation() + File.separator + "swagger" + File.separator + "invalid-petstore.json";
        File definition = new File(swaggerPath);
        JSONObject endpoints = new JSONObject();
        endpoints.put("url", (Object)"test.com");
        JSONObject endpointConfig = new JSONObject();
        endpointConfig.put("endpoint_type", (Object)"http");
        endpointConfig.put("production_endpoints", (Object)endpoints);
        endpointConfig.put("sandbox_endpoints", (Object)endpoints);
        ArrayList<String> tierList = new ArrayList<String>();
        tierList.add("Silver");
        tierList.add("Gold");
        String uniqueName = "InvalidSwaggerAPI";
        JSONObject apiProperties = new JSONObject();
        apiProperties.put("name", (Object)uniqueName);
        apiProperties.put("context", (Object)("/" + uniqueName));
        apiProperties.put("version", (Object)"1.0.0");
        apiProperties.put("provider", (Object)this.user.getUserName());
        apiProperties.put("policies", tierList);
        apiProperties.put("endpointConfig", (Object)endpointConfig);
        APIDTO apiDto = this.restAPIPublisher.importOASDefinition(definition, apiProperties.toString());
        this.invalidSwaggerAPIId = apiDto.getId();
        HttpResponse lifecycleResponse = this.restAPIPublisher.changeAPILifeCycleStatusToPublish(this.invalidSwaggerAPIId, false);
        Assert.assertEquals((int)lifecycleResponse.getResponseCode(), (int)200);
        String sdkLanguage = "java";
        boolean isSDKGenerationSuccessfulInSameTenant = this.generateSDK(this.restAPIStore, this.user.getUserNameWithoutDomain(), this.user.getPassword(), this.invalidSwaggerAPIId, sdkLanguage, this.user.getUserDomain(), null);
        boolean isSDKGenerationSuccessfulAcrossTenants = this.generateSDK(null, "secondAdmin", "password2", this.invalidSwaggerAPIId, sdkLanguage, "tenant2.com", this.user.getUserDomain());
        Assert.assertTrue((isSDKGenerationSuccessfulInSameTenant && !isSDKGenerationSuccessfulAcrossTenants ? 1 : 0) != 0);
    }

    @Test(groups={"wso2.am"}, description="SDK Generation test case for private apis")
    public void testSDKGenerationForPrivateAPIs() throws Exception {
        String apiName = "PrivateAPI";
        String apiContext = "privateContext";
        String url = "https://localhost:9443/test";
        APIRequest apiRequest = new APIRequest(apiName, apiContext, new URL(url));
        String tags = "sdkGen";
        apiRequest.setTags(tags);
        String description = "This is test API create by API manager integration test.";
        apiRequest.setDescription(description);
        apiRequest.setVersion("1.0.0");
        apiRequest.setSandbox(url);
        apiRequest.setResourceMethod("GET");
        apiRequest.setProvider(this.user.getUserName());
        apiRequest.setVisibility("private");
        HttpResponse response = this.restAPIPublisher.addAPI(apiRequest);
        this.privateApiId = response.getData();
        int responseCode = response.getResponseCode();
        Assert.assertEquals((int)responseCode, (int)201);
        HttpResponse lifecycleResponse = this.restAPIPublisher.changeAPILifeCycleStatusToPublish(this.privateApiId, false);
        Assert.assertEquals((int)lifecycleResponse.getResponseCode(), (int)200);
        String sdkLanguage = "java";
        boolean isSDKGenerationSuccessfulInSameTenant = this.generateSDK(this.restAPIStore, this.user.getUserNameWithoutDomain(), this.user.getPassword(), this.privateApiId, sdkLanguage, this.user.getUserDomain(), null);
        boolean isSDKGenerationSuccessfulForPrivateAPIs = this.generateSDK(null, "secondAdmin", "password2", this.privateApiId, sdkLanguage, "tenant2.com", this.user.getUserDomain());
        Assert.assertTrue((isSDKGenerationSuccessfulInSameTenant && !isSDKGenerationSuccessfulForPrivateAPIs ? 1 : 0) != 0);
    }

    private boolean generateSDK(RestAPIStoreImpl restAPIStore, String tenantAwareUserName, String password, String apiId, String language, String tenant, String crossTenant) throws Exception {
        if (restAPIStore == null) {
            restAPIStore = new RestAPIStoreImpl(tenantAwareUserName, password, tenant, this.storeURLHttps);
        }
        try {
            restAPIStore.getAPI(apiId);
        }
        catch (ApiException e) {
            return false;
        }
        String crossTenantLocal = StringUtils.isEmpty((String)crossTenant) ? tenant : crossTenant;
        ApiResponse sdkGenerationResponse = restAPIStore.generateSDKUpdated(apiId, language, crossTenantLocal);
        if (!sdkGenerationResponse.getHeaders().containsKey("Content-Disposition")) {
            this.log.error((Object)("SDK generation failed for API : TestAPI 1.0.0 User : " + tenantAwareUserName));
            return false;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write((byte[])sdkGenerationResponse.getData());
        String tempDirectoryLocation = "tmp";
        String zipFileName = RandomStringUtils.randomAlphabetic((int)5) + ".zip";
        File sdkArchive = new File(tempDirectoryLocation + File.separator + zipFileName);
        FileUtils.writeByteArrayToFile((File)sdkArchive, (byte[])byteArrayOutputStream.toByteArray());
        if ((double)FileUtils.sizeOf((File)sdkArchive) > 0.0) {
            this.log.info((Object)("SDK generated successfully for API : TestAPI 1.0.0 User : " + tenantAwareUserName));
            return true;
        }
        this.log.error((Object)("SDK generation failed for API : TestAPI 1.0.0 User : " + tenantAwareUserName));
        return false;
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        if (this.privateApiId != null) {
            this.restAPIPublisher.deleteAPI(this.privateApiId);
        }
        if (this.testApiId != null) {
            this.restAPIPublisher.deleteAPI(this.testApiId);
        }
        if (this.invalidSwaggerAPIId != null) {
            this.restAPIPublisher.deleteAPI(this.invalidSwaggerAPIId);
        }
        this.tenantManagementServiceClient.deleteTenant("tenant2.com");
    }
}

