/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.apiproduct.lifecycle;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.core.Response;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.junit.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.ApiException;
import org.wso2.am.integration.clients.publisher.api.ApiResponse;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIKeyDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIProductDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.LifecycleStateDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.SubscriptionListDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.WorkflowResponseDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.impl.ApiProductTestHelper;
import org.wso2.am.integration.test.impl.ApiTestHelper;
import org.wso2.am.integration.test.impl.InvocationStatusCodes;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.http.HttpRequestUtil;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;

public class APIProductLifecycleTest
extends APIManagerLifecycleBaseTest {
    private ApiProductTestHelper apiProductTestHelper;
    private ApiTestHelper apiTestHelper;
    private List<org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO> apisToBeUsed;
    private String apiProductId;
    private String applicationId;
    private ApplicationKeyDTO productionAppKey;
    private final InvocationStatusCodes invocationStatusCodes = new InvocationStatusCodes();
    private String accessToken;
    private String gatewayUrl;
    private String context;

    @Factory(dataProvider="userModeDataProvider")
    public APIProductLifecycleTest(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}, {TestUserMode.SUPER_TENANT_EMAIL_USER}, {TestUserMode.TENANT_EMAIL_USER}, {TestUserMode.SUPER_TENANT_USER_STORE_USER}};
    }

    @BeforeClass(alwaysRun=true)
    public void initialize() throws Exception {
        super.init(this.userMode);
        this.apiProductTestHelper = new ApiProductTestHelper(this.restAPIPublisher, this.restAPIStore);
        this.apiTestHelper = new ApiTestHelper(this.restAPIPublisher, this.restAPIStore, this.getAMResourceLocation(), this.keyManagerContext.getContextTenant().getDomain(), this.keyManagerHTTPSURL, this.user);
        this.apisToBeUsed = new ArrayList<org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO>();
        org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO apiOne = this.apiTestHelper.createApiOne(this.getBackendEndServiceEndPointHttp("wildcard/resources"));
        org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO apiTwo = this.apiTestHelper.createApiTwo(this.getBackendEndServiceEndPointHttp("wildcard/resources"));
        this.createAPIRevisionAndDeployUsingRest(apiOne.getId(), this.restAPIPublisher);
        this.createAPIRevisionAndDeployUsingRest(apiTwo.getId(), this.restAPIPublisher);
        this.apisToBeUsed.add(apiOne);
        this.apisToBeUsed.add(apiTwo);
        this.gatewayUrl = this.keyManagerContext.getContextTenant().getDomain().equals("carbon.super") ? this.gatewayUrlsWrk.getWebAppURLNhttp() : this.gatewayUrlsWrk.getWebAppURLNhttp() + "t/" + this.keyManagerContext.getContextTenant().getDomain() + "/";
    }

    @Test(groups={"wso2.am"}, description="Test creation of the API Product")
    public void testCreateAPIProduct() throws Exception {
        String provider = this.userMode == TestUserMode.SUPER_TENANT_USER_STORE_USER ? this.user.getUserNameWithoutDomain() : this.user.getUserName();
        String name = UUID.randomUUID().toString();
        this.context = "/" + UUID.randomUUID();
        List<String> policies = Arrays.asList("Unlimited", "Gold");
        APIProductDTO apiProductDTO = this.apiProductTestHelper.createAPIProductInPublisher(provider, name, this.context, this.apisToBeUsed, policies);
        this.apiProductId = apiProductDTO.getId();
        assert (apiProductDTO.getState() != null);
        Assert.assertTrue((boolean)APILifeCycleState.CREATED.getState().equalsIgnoreCase(apiProductDTO.getState()));
        this.waitForAPIDeployment();
        this.createAPIProductRevisionAndDeployUsingRest(this.apiProductId, this.restAPIPublisher);
        this.waitForAPIDeployment();
        this.apiProductTestHelper.verfiyApiProductInPublisher(apiProductDTO);
        ApiResponse apiKeyDTOResponse = this.restAPIPublisher.generateInternalApiKey(this.apiProductId);
        Assert.assertEquals((long)apiKeyDTOResponse.getStatusCode(), (long)200L);
        HttpResponse response = this.invokeApiWithInternalKey(((APIKeyDTO)apiKeyDTOResponse.getData()).getApikey(), this.context.substring(1));
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
    }

    @Test(groups={"wso2.am"}, description="Test Publishing API Product", dependsOnMethods={"testCreateAPIProduct"})
    public void testPublishAPIProduct() throws Exception {
        WorkflowResponseDTO workflowResponseDTO = this.apiProductTestHelper.changeLifecycleStateOfApiProduct(this.apiProductId, "Publish", null);
        Assert.assertNotNull((Object)workflowResponseDTO);
        LifecycleStateDTO lifecycleStateDTO = workflowResponseDTO.getLifecycleState();
        Assert.assertNotNull((Object)lifecycleStateDTO);
        Assert.assertEquals((Object)"APPROVED", (Object)workflowResponseDTO.getWorkflowStatus().getValue());
        assert (APILifeCycleState.PUBLISHED.getState().equals(lifecycleStateDTO.getState()));
        assert (lifecycleStateDTO.getAvailableTransitions() != null);
        Assert.assertEquals((long)4L, (long)lifecycleStateDTO.getAvailableTransitions().size());
        APIProductDTO returnedProduct = this.restAPIPublisher.getApiProduct(this.apiProductId);
        APIDTO apiDTO = this.apiProductTestHelper.verifyApiProductInPortal(returnedProduct);
        ApplicationDTO applicationDTO = this.apiTestHelper.verifySubscription(apiDTO, UUID.randomUUID().toString(), "Unlimited");
        this.applicationId = applicationDTO.getApplicationId();
        List<String> grantTypes = Arrays.asList("client_credentials", "password");
        this.productionAppKey = this.apiTestHelper.verifyKeyGeneration(applicationDTO, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, new ArrayList(), grantTypes);
        assert (this.productionAppKey.getToken() != null);
        this.apiTestHelper.verifyInvocation(apiDTO, this.productionAppKey.getToken().getAccessToken(), this.productionAppKey.getToken().getAccessToken(), this.invocationStatusCodes);
        this.accessToken = this.productionAppKey.getToken().getAccessToken();
    }

    @Test(groups={"wso2.am"}, description="Test invocation of the API Product in blocked state", dependsOnMethods={"testPublishAPIProduct"})
    public void testChangeAPIProductLifecycleStateToBlockedState() throws Exception {
        WorkflowResponseDTO workflowResponseDTO = this.apiProductTestHelper.changeLifecycleStateOfApiProduct(this.apiProductId, "Block", null);
        this.waitForAPIDeployment();
        Assert.assertNotNull((Object)workflowResponseDTO);
        LifecycleStateDTO lifecycleStateDTO = workflowResponseDTO.getLifecycleState();
        Assert.assertNotNull((Object)lifecycleStateDTO);
        Assert.assertEquals((Object)"APPROVED", (Object)workflowResponseDTO.getWorkflowStatus().getValue());
        assert (APILifeCycleState.BLOCKED.getState().equals(lifecycleStateDTO.getState()));
        assert (lifecycleStateDTO.getAvailableTransitions() != null);
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse response = this.invokeApiWithBearerToken(this.accessToken, this.context.substring(1));
        Assert.assertEquals((long)503L, (long)response.getResponseCode());
        workflowResponseDTO = this.apiProductTestHelper.changeLifecycleStateOfApiProduct(this.apiProductId, "Re-Publish", null);
        this.waitForAPIDeployment();
        Assert.assertEquals((Object)"APPROVED", (Object)workflowResponseDTO.getWorkflowStatus().getValue());
        assert (workflowResponseDTO.getLifecycleState() != null);
        Assert.assertEquals((Object)workflowResponseDTO.getLifecycleState().getState(), (Object)APILifeCycleState.PUBLISHED.getState());
        APIProductDTO returnedProduct = this.restAPIPublisher.getApiProduct(this.apiProductId);
        APIDTO apiDTO = this.apiProductTestHelper.verifyApiProductInPortal(returnedProduct);
        assert (this.productionAppKey.getToken() != null);
        this.apiTestHelper.verifyInvocation(apiDTO, this.productionAppKey.getToken().getAccessToken(), this.productionAppKey.getToken().getAccessToken(), this.invocationStatusCodes);
    }

    @Test(groups={"wso2.am"}, description="Test invocation of the APi before retire", dependsOnMethods={"testChangeAPIProductLifecycleStateToBlockedState"})
    public void testDeleteDeprecatedAPIProductsWithSubscription() throws Exception {
        try {
            this.restAPIPublisher.deleteApiProduct(this.apiProductId);
        }
        catch (ApiException e) {
            Assert.assertEquals((long)Response.Status.CONFLICT.getStatusCode(), (long)e.getCode());
            org.testng.Assert.assertTrue((boolean)e.getResponseBody().contains("active subscriptions exist"));
        }
        WorkflowResponseDTO workflowResponseDTO = this.apiProductTestHelper.changeLifecycleStateOfApiProduct(this.apiProductId, "Deprecate", null);
        Assert.assertEquals((Object)"APPROVED", (Object)workflowResponseDTO.getWorkflowStatus().getValue());
        APIDTO responseData = this.restAPIStore.getAPI(this.apiProductId);
        assert (this.productionAppKey.getToken() != null);
        this.apiTestHelper.verifyInvocation(responseData, this.productionAppKey.getToken().getAccessToken(), this.productionAppKey.getToken().getAccessToken(), this.invocationStatusCodes);
    }

    @Test(groups={"wso2.am"}, description="Test invocation of the APi before retire", dependsOnMethods={"testDeleteDeprecatedAPIProductsWithSubscription"})
    public void testDeleteRetiredAPIProducts() throws Exception {
        WorkflowResponseDTO workflowResponseDTO = this.apiProductTestHelper.changeLifecycleStateOfApiProduct(this.apiProductId, "Retire", null);
        Assert.assertEquals((Object)"APPROVED", (Object)workflowResponseDTO.getWorkflowStatus().getValue());
        Assert.assertNotNull((Object)workflowResponseDTO.getLifecycleState());
        Assert.assertEquals((Object)workflowResponseDTO.getLifecycleState().getState(), (Object)APILifeCycleState.RETIRED.getState());
        SubscriptionListDTO subscriptionListDTO = this.restAPIPublisher.getSubscriptionByAPIID(this.apiProductId);
        assert (subscriptionListDTO.getList() != null);
        Assert.assertEquals((long)subscriptionListDTO.getList().size(), (long)0L);
        this.restAPIPublisher.deleteApiProduct(this.apiProductId);
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        for (org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO apiDto : this.apisToBeUsed) {
            this.restAPIPublisher.deleteAPI(apiDto.getId());
        }
        this.restAPIStore.deleteApplication(this.applicationId);
    }

    private HttpResponse invokeApiWithInternalKey(String internalKey, String context) throws IOException {
        CloseableHttpClient client = HttpClientBuilder.create().setHostnameVerifier((X509HostnameVerifier)new AllowAllHostnameVerifier()).build();
        HttpGet request = new HttpGet(this.gatewayUrl + context + "/customers");
        request.setHeader("Internal-Key", internalKey);
        request.setHeader("accept", "application/json");
        return client.execute((HttpUriRequest)request);
    }

    private org.wso2.carbon.automation.test.utils.http.client.HttpResponse invokeApiWithBearerToken(String accessToken, String context) throws IOException {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("accept", "application/json");
        requestHeaders.put("Bearer", "Authorization : " + accessToken);
        return HttpRequestUtil.doGet((String)(this.gatewayUrl + context + "/customers"), requestHeaders);
    }
}

