/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.application;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.Response;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.json.JSONObject;
import org.junit.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.integration.common.utils.mgt.ServerConfigurationManager;

public class ApplicationAttributesTestCase
extends APIManagerLifecycleBaseTest {
    private ServerConfigurationManager serverConfigurationManager;
    private String endpointURL;
    private String apiId;
    private String API_NAME = "ApplicationAttributeAPI";
    URL tokenEndpointURL;
    private final String JWT_ASSERTION_HEADER = "X-JWT-Assertion";
    String applicationId1;
    String applicationId2;

    @Factory(dataProvider="userModeDataProvider")
    public ApplicationAttributesTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.serverConfigurationManager = new ServerConfigurationManager(this.gatewayContextWrk);
        this.serverConfigurationManager.applyConfiguration(new File(this.getAMResourceLocation() + File.separator + "configFiles" + File.separator + "applicationAttributes" + File.separator + "deployment.toml"));
        this.endpointURL = this.getSuperTenantAPIInvocationURLHttp("jwt_backend", "1.0");
        this.tokenEndpointURL = new URL(this.gatewayUrlsWrk.getWebAppURLNhttp() + "token");
        APIRequest apiRequest = new APIRequest(this.API_NAME, this.API_NAME, new URL(this.endpointURL));
        apiRequest.setVersion("1.0.0");
        apiRequest.setVisibility("public");
        apiRequest.setProvider(this.user.getUserName());
        ArrayList<String> securitySchemes = new ArrayList<String>();
        securitySchemes.add("oauth2");
        securitySchemes.add("api_key");
        apiRequest.setSecurityScheme(securitySchemes);
        this.apiId = this.createAndPublishAPIUsingRest(apiRequest, this.restAPIPublisher, false);
    }

    @Test(description="Add and verify application attributes in JWT application")
    public void testVerifyApplicationAttributesInJWTApplication() throws Exception {
        HashMap<String, String> attribute = new HashMap<String, String>();
        attribute.put("External Reference Id", "c1237890");
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse applicationResponse = this.restAPIStore.createApplicationWithCustomAttribute("JWTAppWithAppAttributes", "JWT Application with application attributes", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT, attribute);
        this.applicationId1 = applicationResponse.getData();
        Assert.assertEquals((long)applicationResponse.getResponseCode(), (long)HTTP_RESPONSE_CODE_OK);
        ApplicationDTO jwtApp = this.restAPIStore.getApplicationById(this.applicationId1);
        Assert.assertEquals(jwtApp.getAttributes().get("External Reference Id"), (Object)"c1237890");
        this.restAPIStore.subscribeToAPI(this.apiId, this.applicationId1, "Gold");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("password");
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.applicationId1, "36000", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        String accessToken = applicationKeyDTO.getToken().getAccessToken();
        Assert.assertNotNull((Object)accessToken);
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(this.getAPIInvocationURLHttp(this.API_NAME, "1.0.0"));
        get.addHeader("Authorization", "Bearer " + accessToken);
        HttpResponse response = httpclient.execute((HttpUriRequest)get);
        Assert.assertEquals((long)response.getStatusLine().getStatusCode(), (long)Response.Status.OK.getStatusCode());
        Header[] responseHeaders = response.getAllHeaders();
        Header jwtheader = this.pickHeader(responseHeaders, "X-JWT-Assertion");
        Assert.assertNotNull((Object)jwtheader);
        String decodedJWTString = APIMTestCaseUtils.getDecodedJWT((String)jwtheader.getValue());
        JSONObject jsonJWTObject = new JSONObject(decodedJWTString);
        Assert.assertTrue((boolean)jsonJWTObject.getString("http://wso2.org/claims/applicationAttributes").equals("{\"External Reference Id\":\"c1237890\"}"));
    }

    @Test(description="Add and verify application attributes in Oauth application")
    public void testVerifyApplicationAttributesInOauthApplication() throws Exception {
        HashMap<String, String> attribute = new HashMap<String, String>();
        attribute.put("External Reference Id", "c1237890");
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse applicationResponse = this.restAPIStore.createApplicationWithCustomAttribute("OauthAppWithAppAttributes", "Oauth Application with application attributes", "Unlimited", ApplicationDTO.TokenTypeEnum.OAUTH, attribute);
        this.applicationId2 = applicationResponse.getData();
        Assert.assertEquals((long)applicationResponse.getResponseCode(), (long)HTTP_RESPONSE_CODE_OK);
        ApplicationDTO jwtApp = this.restAPIStore.getApplicationById(this.applicationId2);
        Assert.assertEquals(jwtApp.getAttributes().get("External Reference Id"), (Object)"c1237890");
        this.restAPIStore.subscribeToAPI(this.apiId, this.applicationId2, "Gold");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("password");
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.applicationId2, "36000", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        String accessToken = applicationKeyDTO.getToken().getAccessToken();
        Assert.assertNotNull((Object)accessToken);
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(this.getAPIInvocationURLHttp(this.API_NAME, "1.0.0"));
        get.addHeader("Authorization", "Bearer " + accessToken);
        HttpResponse response = httpclient.execute((HttpUriRequest)get);
        Assert.assertEquals((long)response.getStatusLine().getStatusCode(), (long)Response.Status.OK.getStatusCode());
        Header[] responseHeaders = response.getAllHeaders();
        Header jwtheader = this.pickHeader(responseHeaders, "X-JWT-Assertion");
        Assert.assertNotNull((Object)jwtheader);
        String decodedJWTString = APIMTestCaseUtils.getDecodedJWT((String)jwtheader.getValue());
        JSONObject jsonJWTObject = new JSONObject(decodedJWTString);
        Assert.assertTrue((boolean)jsonJWTObject.getString("http://wso2.org/claims/applicationAttributes").equals("{\"External Reference Id\":\"c1237890\"}"));
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIStore.deleteApplication(this.applicationId1);
        this.restAPIStore.deleteApplication(this.applicationId2);
        this.restAPIPublisher.deleteAPI(this.apiId);
        this.serverConfigurationManager.restoreToLastConfiguration();
    }
}

