/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.application;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.junit.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.SubscriptionsApi;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.impl.RestAPIStoreImpl;
import org.wso2.am.integration.test.utils.UserManagementUtils;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class ApplicationBlockSubscriptionTestCase
extends APIManagerLifecycleBaseTest {
    private static final String APPLICATION_NAME = "test-app";
    private static final String USER_NAME = "test-user";
    private static final String PASSWORD = "password";
    private static final String ORGANIZATION = "test";
    private static final String FIRST_NAME = "John";
    private RestAPIStoreImpl restAPIStoreClientUser;
    private String applicationId;
    private String apiId;
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private SubscriptionsApi subscriptionsApi;
    private String subscriptionId;
    private final String API_END_POINT_METHOD = "/customers/123";
    private final String API_NAME = "BlockAPITest";
    private final String API_CONTEXT = "BlockAPI";
    private static final String PROD_ONLY_BLOCK_STATE = "BLOCKED";
    private String accessToken;

    @Factory(dataProvider="userModeDataProvider")
    public ApplicationBlockSubscriptionTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.subscriptionsApi = new SubscriptionsApi(this.restAPIPublisher.apiPublisherClient);
        this.createUsersAndApplications();
    }

    @Test(description="To test block functionality works for the application name and owner name which contains hyphen")
    public void testBlockUnblockSubscription() throws Exception {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("accept", "text/xml");
        requestHeaders.put("Authorization", "Bearer " + this.accessToken);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "BlockAPITest", "1.0.0", "\"isApiExists\":true");
        HttpResponse invokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("BlockAPI", "1.0.0") + "/customers/123"), requestHeaders);
        org.testng.Assert.assertEquals((int)invokeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched when invoke api before block");
        int statusCodeBlock = this.subscriptionsApi.blockSubscriptionWithHttpInfo(this.subscriptionId, PROD_ONLY_BLOCK_STATE, null).getStatusCode();
        Assert.assertEquals((long)statusCodeBlock, (long)HTTP_RESPONSE_CODE_OK);
        Thread.sleep(1000L);
        invokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("BlockAPI", "1.0.0") + "/customers/123"), requestHeaders);
        if (invokeResponse.getResponseCode() != HTTP_RESPONSE_CODE_UNAUTHORIZED) {
            Thread.sleep(5000L);
            invokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("BlockAPI", "1.0.0") + "/customers/123"), requestHeaders);
        }
        org.testng.Assert.assertEquals((int)invokeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_UNAUTHORIZED, (String)"Response code mismatched when invoke api after block");
        int statusCodeUnblock = this.subscriptionsApi.unBlockSubscriptionWithHttpInfo(this.subscriptionId, null).getStatusCode();
        Assert.assertEquals((long)statusCodeUnblock, (long)HTTP_RESPONSE_CODE_OK);
        Thread.sleep(1000L);
        invokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("BlockAPI", "1.0.0") + "/customers/123"), requestHeaders);
        if (invokeResponse.getResponseCode() != HTTP_RESPONSE_CODE_OK) {
            Thread.sleep(5000L);
            invokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("BlockAPI", "1.0.0") + "/customers/123"), requestHeaders);
        }
        org.testng.Assert.assertEquals((int)invokeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched when invoke api after unblock");
    }

    private void createUsersAndApplications() throws Exception {
        UserManagementUtils.signupUser((String)USER_NAME, (String)PASSWORD, (String)FIRST_NAME, (String)ORGANIZATION);
        this.restAPIStoreClientUser = new RestAPIStoreImpl(USER_NAME, PASSWORD, "carbon.super", this.storeURLHttps);
        HttpResponse appCreationResponse1 = this.restAPIStoreClientUser.createApplication(APPLICATION_NAME, "App created by user", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
        this.applicationId = appCreationResponse1.getData();
        String apiEndPointUrl = this.backEndServerUrl.getWebAppURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        APIRequest apiRequest = new APIRequest("BlockAPITest", "BlockAPI", new URL(apiEndPointUrl));
        apiRequest.setVersion("1.0.0");
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setTier("Unlimited");
        apiRequest.setProvider(this.user.getUserName());
        this.apiId = this.createAndPublishAPIUsingRest(apiRequest, this.restAPIPublisher, false);
        this.subscriptionId = this.restAPIStoreClientUser.subscribeToAPI(this.apiId, this.applicationId, "Unlimited").getSubscriptionId();
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStoreClientUser.generateKeys(this.applicationId, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        this.accessToken = applicationKeyDTO.getToken().getAccessToken();
    }
}

