/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.application;

import com.google.gson.Gson;
import java.net.URL;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.admin.clients.application.ApplicationManagementClient;
import org.wso2.am.admin.clients.oauth.OAuthAdminServiceClient;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO;
import org.wso2.am.integration.clients.store.api.ApiException;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyReGenerateResponseDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SubscriptionDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SubscriptionListDTO;
import org.wso2.am.integration.test.utils.base.APIMIntegrationConstants;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.identity.application.common.model.xsd.InboundAuthenticationConfig;
import org.wso2.carbon.identity.application.common.model.xsd.InboundAuthenticationRequestConfig;
import org.wso2.carbon.identity.application.common.model.xsd.Property;
import org.wso2.carbon.identity.application.common.model.xsd.ServiceProvider;
import org.wso2.carbon.identity.oauth.stub.dto.OAuthConsumerAppDTO;

public class ApplicationTestCase
extends APIManagerLifecycleBaseTest {
    private static final Log log = LogFactory.getLog(ApplicationTestCase.class);
    private static final String webApp = "jaxrs_basic";
    private final String version = "1.0.0";
    private final String visibility = "public";
    private final String description = "API subscription";
    private final String tier = "Unlimited";
    private final String keyType = "PRODUCTION";
    private final String tags = "subscription";
    private final String applicationName = "NewApplicationTest";
    private final String newApplicationName = "UpdatedApplicationTest";
    private final String endPointType = "http";
    private String apiName = "SubscriptionAPITest";
    private String apiContext = "subscriptionapicontext";
    private String applicationId;
    private String apiId;
    private String applicationId1;
    private String applicationId2;
    private String applicationId3;
    private String app3KeyMappingId;
    private ArrayList<String> grantTypes;
    private ApplicationDTO applicationDTO;
    protected ApplicationManagementClient applicationManagementClient;
    private String oidcApp1ClientId;
    private String oidcApp1ClientSecret;
    private String oidcApp2ClientId;
    private String oidcApp2ClientSecret;

    @Factory(dataProvider="userModeDataProvider")
    public ApplicationTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        log.info((Object)("Test Starting user mode:" + this.userMode));
        this.grantTypes = new ArrayList();
        String uri = "customers/{id}/";
        String endpoint = "/services/customers/customerservice";
        String endpointUrl = this.gatewayUrlsWrk.getWebAppURLHttp() + webApp + endpoint;
        String providerName = this.publisherContext.getContextTenant().getContextUser().getUserName();
        ArrayList<APIOperationsDTO> apiOperationsDTOS = new ArrayList<APIOperationsDTO>();
        APIOperationsDTO apiOperationsDTO = new APIOperationsDTO();
        apiOperationsDTO.setVerb("GET");
        apiOperationsDTO.setAuthType(APIMIntegrationConstants.ResourceAuthTypes.APPLICATION_AND_APPLICATION_USER.getAuthType());
        apiOperationsDTO.setThrottlingPolicy("Unlimited");
        apiOperationsDTO.setTarget(uri);
        apiOperationsDTOS.add(apiOperationsDTO);
        APIRequest apiRequest = new APIRequest(this.apiName, this.apiContext, new URL(endpointUrl));
        apiRequest.setVersion("1.0.0");
        apiRequest.setProvider(providerName);
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setTier("Unlimited");
        apiRequest.setOperationsDTOS(apiOperationsDTOS);
        apiRequest.setEndpointType("http");
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setTags("subscription");
        apiRequest.setDescription("API subscription");
        apiRequest.setVisibility("public");
        this.apiId = this.createAndPublishAPIUsingRest(apiRequest, this.restAPIPublisher, false);
        HttpResponse applicationResponse = this.restAPIStore.createApplication("NewApplicationTest", "Test Application", "Unlimited", ApplicationDTO.TokenTypeEnum.OAUTH);
        Assert.assertEquals((int)applicationResponse.getResponseCode(), (int)200, (String)"Response code is not as expected");
        this.applicationId = applicationResponse.getData();
        this.grantTypes.add("client_credentials");
        this.applicationManagementClient = new ApplicationManagementClient(this.keyManagerContext.getContextUrls().getBackEndUrl(), this.keymanagerSessionCookie);
        this.oAuthAdminServiceClient = new OAuthAdminServiceClient(this.keyManagerContext.getContextUrls().getBackEndUrl(), this.keymanagerSessionCookie);
    }

    @Test(groups={"webapp"}, description="Get Application By Application Id")
    public void testGetApplicationById() throws Exception {
        this.applicationDTO = this.restAPIStore.getApplicationById(this.applicationId);
        Assert.assertTrue((boolean)StringUtils.isNotEmpty((String)this.applicationDTO.getApplicationId()), (String)"Adding application failed");
    }

    @Test(groups={"webapp"}, description="Application Key Generation By Application Id", dependsOnMethods={"testGetApplicationById"})
    public void testApplicationKeyGenerationById() throws Exception {
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.applicationId, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, this.grantTypes);
        Assert.assertNotNull((Object)applicationKeyDTO.getToken().getAccessToken());
    }

    @Test(groups={"webapp"}, description="Update Client Application By Application Id", dependsOnMethods={"testApplicationKeyGenerationById"})
    public void testUpdateApplicationById() throws Exception {
        String callbackUrl = "test-callback";
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("password");
        this.applicationDTO.setName("UpdatedApplicationTest");
        ApplicationKeyDTO applicationKeyDTO = new ApplicationKeyDTO();
        applicationKeyDTO.setKeyType(ApplicationKeyDTO.KeyTypeEnum.PRODUCTION);
        applicationKeyDTO.setCallbackUrl(callbackUrl);
        applicationKeyDTO.setSupportedGrantTypes(grantTypes);
        ArrayList<ApplicationKeyDTO> applicationKeyDTOS = new ArrayList<ApplicationKeyDTO>();
        applicationKeyDTOS.add(applicationKeyDTO);
        this.applicationDTO.setKeys(applicationKeyDTOS);
        HttpResponse updateResponse = this.restAPIStore.updateClientApplicationById(this.applicationId, this.applicationDTO);
        Assert.assertEquals((int)updateResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched when adding an application");
        Gson gsonObject = new Gson();
        ApplicationDTO applicationDTOResponse = (ApplicationDTO)gsonObject.fromJson(updateResponse.getData(), ApplicationDTO.class);
        Assert.assertEquals((String)applicationDTOResponse.getName(), (String)"UpdatedApplicationTest", (String)"Application has not been updated");
    }

    @Test(groups={"webapp"}, description="Add subscription By Application Id", dependsOnMethods={"testUpdateApplicationById"})
    public void testAddSubscriptionApplicationById() throws Exception {
        HttpResponse subscriptionResponse = this.subscribeToAPIUsingRest(this.apiId, this.applicationId, "Unlimited", this.restAPIStore);
        Assert.assertEquals((int)subscriptionResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched when adding an application");
    }

    @Test(groups={"webapp"}, description="Add subscription By Application Id", dependsOnMethods={"testUpdateApplicationById"})
    public void testGetSubscriptionForApplicationById() throws Exception {
        SubscriptionListDTO subsDTO = this.restAPIStore.getAllSubscriptionsOfApplication(this.applicationId);
        boolean isApiAvailable = false;
        for (SubscriptionDTO subscriptionDTO : subsDTO.getList()) {
            if (!this.apiId.equals(subscriptionDTO.getApiId())) continue;
            isApiAvailable = true;
            break;
        }
        Assert.assertTrue((boolean)isApiAvailable, (String)"Response Error in Api");
    }

    @Test(groups={"webapp"}, description="Add subscription By Application Id", dependsOnMethods={"testGetSubscriptionForApplicationById"})
    public void testCleanupApplicationRegistrationById() throws Exception {
        HttpResponse cleanupAppResponse = this.restAPIStore.cleanUpApplicationRegistrationByApplicationId(this.applicationId, "PRODUCTION");
        Assert.assertEquals((int)cleanupAppResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched when cleaning up an application");
    }

    @Test(groups={"webapp"}, description="Remove application By Application Id", dependsOnMethods={"testCleanupApplicationRegistrationById"})
    public void testRemoveApplicationById() {
        HttpResponse removeAppResponse = this.restAPIStore.deleteApplication(this.applicationId);
        Assert.assertEquals((int)removeAppResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched when deleting an application");
    }

    @Test(groups={"webapp"}, description="Map application keys negative test case")
    public void mapApplicationKeysNegative() throws Exception {
        OAuthConsumerAppDTO oAuthApplicationData = this.createOIDCApplication("OauthApp1");
        this.oidcApp1ClientId = oAuthApplicationData.getOauthConsumerKey();
        this.oidcApp1ClientSecret = oAuthApplicationData.getOauthConsumerSecret();
        this.createServiceProvider("OauthApp1", this.oidcApp1ClientId, this.oidcApp1ClientSecret);
        HttpResponse applicationDTO = this.restAPIStore.createApplication("DevPortalApp1", "JWT Application", "10PerMin", ApplicationDTO.TokenTypeEnum.JWT);
        this.applicationId1 = applicationDTO.getData();
        try {
            this.restAPIStore.generateKeys(this.applicationId1, "36000", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, this.grantTypes);
            this.restAPIStore.mapConsumerKeyWithApplication(this.oidcApp1ClientId, this.oidcApp1ClientSecret, this.applicationId1, "Resident Key Manager");
        }
        catch (ApiException e) {
            Assert.assertEquals((int)409, (int)e.getCode());
            Assert.assertTrue((boolean)e.getResponseBody().contains("Key Mappings already exists"));
        }
    }

    @Test(groups={"webapp"}, description="Map application keys test case", dependsOnMethods={"mapApplicationKeysNegative"})
    public void mapApplicationKeys() throws Exception {
        OAuthConsumerAppDTO oAuthApplicationData = this.createOIDCApplication("OauthApp2");
        this.oidcApp2ClientId = oAuthApplicationData.getOauthConsumerKey();
        this.oidcApp2ClientSecret = oAuthApplicationData.getOauthConsumerSecret();
        this.createServiceProvider("OauthApp2", this.oidcApp2ClientId, this.oidcApp2ClientSecret);
        HttpResponse applicationDTO = this.restAPIStore.createApplication("DevPortalApp2", "JWT Application", "10PerMin", ApplicationDTO.TokenTypeEnum.JWT);
        this.applicationId2 = applicationDTO.getData();
        try {
            ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.mapConsumerKeyWithApplication(this.oidcApp2ClientId, this.oidcApp2ClientSecret, this.applicationId2, "Resident Key Manager");
            Assert.assertNotNull((Object)applicationKeyDTO);
            this.restAPIStore.generateKeys(this.applicationId2, "3600", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, this.grantTypes);
        }
        catch (ApiException e) {
            Assert.assertEquals((int)409, (int)e.getCode());
            Assert.assertTrue((boolean)e.getResponseBody().contains("Key Mappings already exists"));
        }
    }

    @Test(groups={"webapp"}, description="Fetch Oauth key details by key mapping ID")
    public void testFetchKeyDetailsByKeyMappingID() throws Exception {
        HttpResponse applicationResponse = this.restAPIStore.createApplication("KeyMappingTestApp", "Test Application", "Unlimited", ApplicationDTO.TokenTypeEnum.OAUTH);
        Assert.assertEquals((int)applicationResponse.getResponseCode(), (int)200, (String)"Error while adding test application");
        this.applicationId3 = applicationResponse.getData();
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.applicationId3, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, this.grantTypes);
        Assert.assertNotNull((Object)applicationKeyDTO);
        this.app3KeyMappingId = applicationKeyDTO.getKeyMappingId();
        ApplicationKeyDTO responseKeyDTO = this.restAPIStore.getApplicationKeyByKeyMappingId(this.applicationId3, this.app3KeyMappingId);
        Assert.assertNotNull((Object)responseKeyDTO);
        Assert.assertNotNull((Object)responseKeyDTO.getConsumerKey(), (String)"Consumer secret is not populated in REST API response");
        Assert.assertEquals((String)responseKeyDTO.getConsumerKey(), (String)applicationKeyDTO.getConsumerKey(), (String)"Incorrect consumer key returned");
    }

    @Test(groups={"webapp"}, description="Regenerate secret by key mapping ID", dependsOnMethods={"testFetchKeyDetailsByKeyMappingID"})
    public void testRegenerateSecretForKeyMappingId() throws Exception {
        ApplicationKeyReGenerateResponseDTO reGenerateResponseDTO = this.restAPIStore.regenerateSecretByKeyMappingId(this.applicationId3, this.app3KeyMappingId);
        Assert.assertNotNull((Object)reGenerateResponseDTO);
        Assert.assertNotNull((Object)reGenerateResponseDTO.getConsumerSecret(), (String)"Secret is not populated");
    }

    private OAuthConsumerAppDTO createOIDCApplication(String applicationName) throws Exception {
        OAuthConsumerAppDTO appDTO = new OAuthConsumerAppDTO();
        appDTO.setApplicationName(applicationName);
        appDTO.setCallbackUrl("http://localhost:8490/playground2/oauth2clien");
        appDTO.setOAuthVersion("OAuth-2.0");
        appDTO.setGrantTypes("authorization_code");
        appDTO.setBackChannelLogoutUrl("http://localhost:8490/playground2/bclogout");
        this.oAuthAdminServiceClient.registerOAuthApplicationData(appDTO);
        OAuthConsumerAppDTO createdApp = this.oAuthAdminServiceClient.getOAuthAppByName(applicationName);
        Assert.assertNotNull((Object)createdApp);
        return createdApp;
    }

    private ServiceProvider createServiceProvider(String applicationName, String clientId, String clientSecret) throws Exception {
        ServiceProvider serviceProvider = new ServiceProvider();
        serviceProvider.setApplicationName(applicationName);
        this.applicationManagementClient.createApplication(serviceProvider);
        serviceProvider = this.applicationManagementClient.getApplication(applicationName);
        InboundAuthenticationRequestConfig requestConfig = new InboundAuthenticationRequestConfig();
        requestConfig.setInboundAuthKey(clientId);
        requestConfig.setInboundAuthType("oauth2");
        if (StringUtils.isNotBlank((String)clientSecret)) {
            Property property = new Property();
            property.setName("oauthConsumerSecret");
            property.setValue(clientSecret);
            Property[] properties = new Property[]{property};
            requestConfig.setProperties(properties);
        }
        InboundAuthenticationConfig inboundAuthenticationConfig = new InboundAuthenticationConfig();
        inboundAuthenticationConfig.setInboundAuthenticationRequestConfigs(new InboundAuthenticationRequestConfig[]{requestConfig});
        serviceProvider.setInboundAuthenticationConfig(inboundAuthenticationConfig);
        this.applicationManagementClient.updateApplication(serviceProvider);
        return serviceProvider;
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.undeployAndDeleteAPIRevisionsUsingRest(this.apiId, this.restAPIPublisher);
        this.restAPIPublisher.deleteAPI(this.apiId);
        this.restAPIStore.deleteApplication(this.applicationId1);
        this.restAPIStore.deleteApplication(this.applicationId2);
        this.applicationManagementClient.deleteApplication("OauthApp1");
        this.applicationManagementClient.deleteApplication("OauthApp2");
    }
}

