/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.application;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.utils.base.APIMIntegrationConstants;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.bean.APIThrottlingTier;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.ALL})
public class PkceEnabledApplicationTestCase
extends APIManagerLifecycleBaseTest {
    private static final Log log = LogFactory.getLog(PkceEnabledApplicationTestCase.class);
    private final String API_NAME = "GrantTypeTokenGenerateAPIName";
    private final String API_CONTEXT = "GrantTypeTokenGenerateContext";
    private final String DESCRIPTION = "This is test API create by API manager integration test";
    private final String API_VERSION = "1.0.0";
    private final String APP_NAME_ONE = "TokenGenerateAppWithPkce";
    private final String APP_NAME_TWO = "TokenGenerateAppWithPkcePlainText";
    private final String APP_NAME_THREE = "TokenGenerateAppWithPkcePlainTextByPassSecret";
    private final String CALLBACK_URL = "https://localhost:9443/store/";
    private final String TAGS = "grantType,implicitly,code";
    private final String TIER_COLLECTION = "Unlimited";
    private String endpointUrl;
    private String consumerKey;
    private String consumerSecret;
    private String apiId;
    private String applicationIdOne;
    private String applicationIdTwo;
    private String applicationIdThree;
    private ArrayList<String> grantTypes = new ArrayList();
    private APIRequest apiRequest;

    @Factory(dataProvider="userModeDataProvider")
    public PkceEnabledApplicationTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.storeURLHttp = this.getStoreURLHttp();
        this.endpointUrl = this.backEndServerUrl.getWebAppURLHttp() + "am/sample/calculator/v1/api";
        HttpResponse applicationResponseOne = this.restAPIStore.createApplication("TokenGenerateAppWithPkce", "Test Application", APIThrottlingTier.UNLIMITED.getState(), ApplicationDTO.TokenTypeEnum.JWT);
        Assert.assertEquals((int)applicationResponseOne.getResponseCode(), (int)200, (String)"Response code is not as expected");
        this.applicationIdOne = applicationResponseOne.getData();
        HttpResponse applicationResponseTwo = this.restAPIStore.createApplication("TokenGenerateAppWithPkcePlainText", "Test Application", APIThrottlingTier.UNLIMITED.getState(), ApplicationDTO.TokenTypeEnum.JWT);
        Assert.assertEquals((int)applicationResponseTwo.getResponseCode(), (int)200, (String)"Response code is not as expected");
        this.applicationIdTwo = applicationResponseTwo.getData();
        HttpResponse applicationResponseThree = this.restAPIStore.createApplication("TokenGenerateAppWithPkcePlainTextByPassSecret", "Test Application", APIThrottlingTier.UNLIMITED.getState(), ApplicationDTO.TokenTypeEnum.JWT);
        Assert.assertEquals((int)applicationResponseThree.getResponseCode(), (int)200, (String)"Response code is not as expected");
        this.applicationIdThree = applicationResponseThree.getData();
        String providerName = this.user.getUserName();
        ArrayList<APIOperationsDTO> apiOperationsDTOS = new ArrayList<APIOperationsDTO>();
        APIOperationsDTO apiOperationsDTO = new APIOperationsDTO();
        apiOperationsDTO.setVerb("GET");
        apiOperationsDTO.setAuthType(APIMIntegrationConstants.ResourceAuthTypes.APPLICATION_AND_APPLICATION_USER.getAuthType());
        apiOperationsDTO.setThrottlingPolicy("20KPerMin");
        apiOperationsDTO.setTarget("/add");
        apiOperationsDTOS.add(apiOperationsDTO);
        this.apiRequest = new APIRequest("GrantTypeTokenGenerateAPIName", "GrantTypeTokenGenerateContext", new URL(this.endpointUrl));
        this.apiRequest.setVersion("1.0.0");
        this.apiRequest.setProvider(providerName);
        this.apiRequest.setTiersCollection("Unlimited");
        this.apiRequest.setTier("Unlimited");
        this.apiRequest.setOperationsDTOS(apiOperationsDTOS);
        this.apiRequest.setTiersCollection("Unlimited");
        this.apiRequest.setTags("grantType,implicitly,code");
        this.apiRequest.setDescription("This is test API create by API manager integration test");
        this.apiId = this.createPublishAndSubscribeToAPIUsingRest(this.apiRequest, this.restAPIPublisher, this.restAPIStore, this.applicationIdOne, "Unlimited");
        this.grantTypes.add("authorization_code");
    }

    @Test(groups={"wso2.am"}, description="Test Application Creation and key generations")
    public void testApplicationCreationKeyGenerationWithPkce() throws Exception {
        HashMap<String, String> additionalProperties = new HashMap<String, String>();
        additionalProperties.put("pkceMandatory", "true");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeysWithAdditionalProperties(this.applicationIdOne, "3600", "https://localhost:9443/store/", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, this.grantTypes, additionalProperties);
        Assert.assertNotNull((Object)applicationKeyDTO.getToken().getAccessToken());
        this.consumerKey = applicationKeyDTO.getConsumerKey();
        this.consumerSecret = applicationKeyDTO.getConsumerSecret();
        Map additionalPropertyResponse = (Map)applicationKeyDTO.getAdditionalProperties();
        Assert.assertEquals((Object)Boolean.TRUE, additionalPropertyResponse.get("pkceMandatory"));
        Assert.assertEquals((Object)Boolean.FALSE, additionalPropertyResponse.get("pkceSupportPlain"));
        Assert.assertEquals((Object)Boolean.FALSE, additionalPropertyResponse.get("bypassClientCredentials"));
        Assert.assertNotNull((Object)this.consumerKey, (String)"Consumer Key not found");
        Assert.assertNotNull((Object)this.consumerSecret, (String)"Consumer Secret not found ");
    }

    @Test(groups={"wso2.am"}, description="Test Application Creation and key generations")
    public void testApplicationCreationKeyGenerationWithPkcePlainText() throws Exception {
        HashMap<String, String> additionalProperties = new HashMap<String, String>();
        additionalProperties.put("pkceMandatory", "true");
        additionalProperties.put("pkceSupportPlain", "true");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeysWithAdditionalProperties(this.applicationIdTwo, "3600", "https://localhost:9443/store/", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, this.grantTypes, additionalProperties);
        Assert.assertNotNull((Object)applicationKeyDTO.getToken().getAccessToken());
        this.consumerKey = applicationKeyDTO.getConsumerKey();
        this.consumerSecret = applicationKeyDTO.getConsumerSecret();
        Map additionalPropertyResponse = (Map)applicationKeyDTO.getAdditionalProperties();
        Assert.assertEquals((Object)Boolean.TRUE, additionalPropertyResponse.get("pkceMandatory"));
        Assert.assertEquals((Object)Boolean.TRUE, additionalPropertyResponse.get("pkceSupportPlain"));
        Assert.assertEquals((Object)Boolean.FALSE, additionalPropertyResponse.get("bypassClientCredentials"));
        Assert.assertNotNull((Object)this.consumerKey, (String)"Consumer Key not found");
        Assert.assertNotNull((Object)this.consumerSecret, (String)"Consumer Secret not found ");
    }

    @Test(groups={"wso2.am"}, description="Test Application Creation and key generations")
    public void testApplicationCreationKeyGenerationWithPkcePlainTextByPassSecret() throws Exception {
        HashMap<String, String> additionalProperties = new HashMap<String, String>();
        additionalProperties.put("pkceMandatory", "true");
        additionalProperties.put("pkceSupportPlain", "true");
        additionalProperties.put("bypassClientCredentials", "true");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeysWithAdditionalProperties(this.applicationIdThree, "3600", "https://localhost:9443/store/", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, this.grantTypes, additionalProperties);
        Assert.assertNotNull((Object)applicationKeyDTO.getToken().getAccessToken());
        this.consumerKey = applicationKeyDTO.getConsumerKey();
        this.consumerSecret = applicationKeyDTO.getConsumerSecret();
        Map additionalPropertyResponse = (Map)applicationKeyDTO.getAdditionalProperties();
        Assert.assertEquals((Object)Boolean.TRUE, additionalPropertyResponse.get("pkceMandatory"));
        Assert.assertEquals((Object)Boolean.TRUE, additionalPropertyResponse.get("pkceSupportPlain"));
        Assert.assertEquals((Object)Boolean.TRUE, additionalPropertyResponse.get("bypassClientCredentials"));
        Assert.assertNotNull((Object)this.consumerKey, (String)"Consumer Key not found");
        Assert.assertNotNull((Object)this.consumerSecret, (String)"Consumer Secret not found ");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIStore.deleteApplication(this.applicationIdOne);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.apiId, this.restAPIPublisher);
        this.restAPIPublisher.deleteAPI(this.apiId);
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }
}

