/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.application.groupSharing;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.store.api.ApiException;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.test.impl.RestAPIStoreImpl;
import org.wso2.am.integration.test.utils.UserManagementUtils;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class ApplicationSharingTestCase
extends APIMIntegrationBaseTest {
    private static final String APPLICATION_NAME = "TestApplication";
    private static final String SHARED_APPLICATION_NAME = "SharedApplication";
    private static final String USER_ONE = "userOne";
    private static final String USER_TWO = "userTwo";
    private static final String PASSWORD = "test@123";
    private static final String FIRST_NAME = "John";
    private static final String LAST_NAME = "Doe";
    private static final String EMAIL = "john.doe@test.com";
    private static final String ORGANIZATION = "Test";
    private String userOneApplicationId;
    private String userTwoApplicationId;
    private String userOneSharedApplicationId;
    private RestAPIStoreImpl restAPIStoreClientUser1;
    private RestAPIStoreImpl restAPIStoreClientUser2;
    private static final Log log = LogFactory.getLog(ApplicationSharingTestCase.class);
    List<String> groups = new ArrayList<String>();

    @Factory(dataProvider="userModeDataProvider")
    public ApplicationSharingTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.createUsersAndApplications();
        this.groups.add(ORGANIZATION);
    }

    @Test(groups={"wso2.am"}, description="Remove user one's application and check if user two's application also is getting deleted")
    public void testUserTwoApplicationRemoval() throws Exception {
        this.restAPIStoreClientUser1.removeApplicationById(this.userOneApplicationId);
        List user2AllAppsList = this.restAPIStoreClientUser2.getAllApps().getList();
        boolean isUserTwoAppDeleted = user2AllAppsList.stream().noneMatch(applicationInfoDTO -> this.userTwoApplicationId.equals(applicationInfoDTO.getApplicationId()));
        Assert.assertFalse((boolean)isUserTwoAppDeleted, (String)"Deletion of User One's application has deleted User Two's application too");
    }

    @Test(groups={"wso2.am"}, description="Edit application by application owner", dependsOnMethods={"testUserTwoApplicationRemoval"})
    public void testEditApplicationByApplicationOwner() throws Exception {
        HttpResponse serviceResponse = this.restAPIStoreClientUser1.updateApplicationByID(this.userOneSharedApplicationId, SHARED_APPLICATION_NAME, "This app has been edited", "10PerMin", ApplicationDTO.TokenTypeEnum.JWT, this.groups);
        Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)200, (String)"Response code is not as expected");
        ApplicationDTO applicationDTO = this.restAPIStoreClientUser1.getApplicationById(this.userOneSharedApplicationId);
        Assert.assertEquals((String)applicationDTO.getDescription(), (String)"This app has been edited");
        Assert.assertEquals((String)applicationDTO.getThrottlingPolicy(), (String)"10PerMin");
    }

    @Test(groups={"wso2.am"}, description="Edit application by application by user in application group", dependsOnMethods={"testEditApplicationByApplicationOwner"})
    public void testEditApplicationByUserInApplicationGroup() throws ApiException {
        List user2AllAppsList = this.restAPIStoreClientUser2.getAllApps().getList();
        ApplicationDTO applicationDTO = this.restAPIStoreClientUser2.getApplicationById(this.userOneSharedApplicationId);
        Assert.assertNotNull((Object)applicationDTO);
        Assert.assertEquals((String)applicationDTO.getName(), (String)SHARED_APPLICATION_NAME);
        HttpResponse serviceResponse = this.restAPIStoreClientUser2.updateApplicationByID(this.userOneSharedApplicationId, APPLICATION_NAME, "This app has been edited by user1", "10PerMin", ApplicationDTO.TokenTypeEnum.JWT, this.groups);
        Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)403);
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIStoreClientUser2.removeApplicationById(this.userTwoApplicationId);
        super.cleanUp();
    }

    private void createUsersAndApplications() throws Exception {
        UserManagementUtils.signupUser((String)USER_ONE, (String)PASSWORD, (String)FIRST_NAME, (String)ORGANIZATION);
        UserManagementUtils.signupUser((String)USER_TWO, (String)PASSWORD, (String)FIRST_NAME, (String)ORGANIZATION);
        this.restAPIStoreClientUser1 = new RestAPIStoreImpl(USER_ONE, PASSWORD, "carbon.super", this.storeURLHttps);
        this.restAPIStoreClientUser2 = new RestAPIStoreImpl(USER_TWO, PASSWORD, "carbon.super", this.storeURLHttps);
        HttpResponse appCreationResponse1 = this.restAPIStoreClientUser1.createApplication(APPLICATION_NAME, "App created by user1", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
        this.userOneApplicationId = appCreationResponse1.getData();
        HttpResponse appCreationResponse2 = this.restAPIStoreClientUser2.createApplication(APPLICATION_NAME, "App created by user2", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
        this.userTwoApplicationId = appCreationResponse2.getData();
        HttpResponse appCreationResponse3 = this.restAPIStoreClientUser1.createApplicationWithOrganization(SHARED_APPLICATION_NAME, "App created by user1", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT, this.groups);
        this.userOneSharedApplicationId = appCreationResponse3.getData();
    }
}

