/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.comments;

import com.google.gson.Gson;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.ws.rs.core.Response;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.store.api.v1.dto.CommentDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.CommentListDTO;
import org.wso2.am.integration.test.impl.RestAPIPublisherImpl;
import org.wso2.am.integration.test.impl.RestAPIStoreImpl;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleAction;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.engine.context.beans.User;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class DevPortalCommentTest
extends APIMIntegrationBaseTest {
    private String apiId;
    private String rootCommentIdToAddReplies;
    private String rootCommentIdForPublisherTest;
    private HttpResponse getCommentWithRepliesResponse;
    private List<String> rootComments;
    private List<String> replies;
    private String replyToRootComment;
    private String updatedTime;
    private String replyToTestPublisherVisibility;
    private String commentFromNonAdminUser;
    private RestAPIStoreImpl apiStoreClientCarbonSuperNewAdmin;
    private RestAPIStoreImpl apiStoreClientCarbonSuperNonAdminUser;
    private RestAPIPublisherImpl apiPublisherClientCarbonSuperNonAdminUser;

    @Factory(dataProvider="userModeDataProvider")
    public DevPortalCommentTest(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}, {TestUserMode.SUPER_TENANT_USER_STORE_USER}, {TestUserMode.SUPER_TENANT_EMAIL_USER}, {TestUserMode.TENANT_EMAIL_USER}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        if (TestUserMode.SUPER_TENANT_ADMIN.equals((Object)this.userMode)) {
            this.apiStoreClientCarbonSuperNewAdmin = new RestAPIStoreImpl(this.user.getUserNameWithoutDomain(), this.user.getPassword(), this.user.getUserDomain(), this.publisherURLHttps);
            String apiCreatorPublisherDomain = this.publisherContext.getContextTenant().getDomain();
            String apiCreatorStoreDomain = this.storeContext.getContextTenant().getDomain();
            String USER_KEY_NON_ADMIN_USER = "userKey1";
            User nonAdminUser = this.publisherContext.getContextTenant().getTenantUser(USER_KEY_NON_ADMIN_USER);
            String nonAdminUsername = nonAdminUser.getUserNameWithoutDomain();
            this.apiPublisherClientCarbonSuperNonAdminUser = new RestAPIPublisherImpl(nonAdminUsername, nonAdminUser.getPassword(), apiCreatorPublisherDomain, this.publisherURLHttps);
            this.apiStoreClientCarbonSuperNonAdminUser = new RestAPIStoreImpl(nonAdminUsername, nonAdminUser.getPassword(), apiCreatorStoreDomain, this.storeURLHttps);
        }
    }

    @Test(groups={"wso2.am"}, description="Deploy and Verify API for Comments Test Cases")
    public void testDevPortalDeployAPITest() throws Exception {
        String APIName = "CommentRatingAPI";
        String APIContext = "commentRating";
        String tags = "youtube, video, media";
        String url = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice";
        String description = "This is test API create by API manager integration test";
        String providerName = this.user.getUserName();
        String APIVersion = "1.0.0";
        APIRequest apiRequest = new APIRequest(APIName, APIContext, new URL(url));
        apiRequest.setTags(tags);
        apiRequest.setDescription(description);
        apiRequest.setVersion(APIVersion);
        apiRequest.setProvider(providerName);
        HttpResponse serviceResponse = this.restAPIPublisher.addAPI(apiRequest);
        this.apiId = serviceResponse.getData();
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, APILifeCycleAction.PUBLISH.getAction(), null);
    }

    @Test(dependsOnMethods={"testDevPortalDeployAPITest"}, groups={"wso2.am"}, description="Test add root comments for API Test Cases")
    public void testDevPortalAddRootCommentsToAPIByAdminTest() throws Exception {
        this.rootComments = new ArrayList<String>();
        for (int i = 1; i < 3; ++i) {
            HttpResponse addRootCommentResponse = this.restAPIStore.addComment(this.apiId, "This is root comment " + i, "general", null);
            Assert.assertNotNull((Object)addRootCommentResponse, (String)"Error adding comment");
            Assert.assertEquals((int)addRootCommentResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched");
            Gson getCommentsGson = new Gson();
            CommentDTO addedRootCommentDTO = (CommentDTO)getCommentsGson.fromJson(addRootCommentResponse.getData().replace("devPortal", "DEVPORTAL"), CommentDTO.class);
            String rootCommentId = addedRootCommentDTO.getId();
            Assert.assertNotNull((Object)rootCommentId, (String)"Comment Id is null");
            this.rootComments.add(rootCommentId);
            Thread.sleep(1000L);
        }
        this.rootCommentIdToAddReplies = this.rootComments.get(0);
        this.rootCommentIdForPublisherTest = this.rootComments.get(1);
    }

    @Test(dependsOnMethods={"testDevPortalAddRootCommentsToAPIByAdminTest"}, groups={"wso2.am"}, description="Test add replies to root comment Test Cases")
    public void testAddRepliesToRootCommentByAdminTest() throws Exception {
        this.replies = new ArrayList<String>();
        for (int i = 1; i < 4; ++i) {
            HttpResponse addReplyCommentResponse = this.restAPIStore.addComment(this.apiId, "This is a reply " + i, "general", this.rootCommentIdToAddReplies);
            Assert.assertNotNull((Object)addReplyCommentResponse, (String)"Error adding comment");
            Assert.assertEquals((int)addReplyCommentResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched");
            Gson getCommentsGson = new Gson();
            CommentDTO addedCommentDTO = (CommentDTO)getCommentsGson.fromJson(addReplyCommentResponse.getData().replace("devPortal", "DEVPORTAL"), CommentDTO.class);
            String replyCommentId = addedCommentDTO.getId();
            Assert.assertNotNull((Object)replyCommentId, (String)"Comment Id is null");
            this.replies.add(replyCommentId);
            Thread.sleep(1000L);
        }
        HttpResponse addReplyCommentResponse = this.restAPIStore.addComment(this.apiId, "This is reply", "general", this.rootCommentIdForPublisherTest);
        Assert.assertNotNull((Object)addReplyCommentResponse, (String)"Error adding comment");
        Assert.assertEquals((int)addReplyCommentResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched");
        Gson getCommentsGson = new Gson();
        CommentDTO addedCommentDTO = (CommentDTO)getCommentsGson.fromJson(addReplyCommentResponse.getData().replace("devPortal", "DEVPORTAL"), CommentDTO.class);
        this.replyToTestPublisherVisibility = addedCommentDTO.getId();
        Assert.assertNotNull((Object)this.replyToTestPublisherVisibility, (String)"Comment Id is null");
        this.getCommentWithRepliesResponse = this.restAPIStore.getComment(this.rootCommentIdToAddReplies, this.apiId, this.gatewayContextWrk.getContextTenant().getDomain(), false, Integer.valueOf(3), Integer.valueOf(0));
        Assert.assertEquals((int)this.getCommentWithRepliesResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Error retrieving comment");
        Gson getCommentWithRepliesGson = new Gson();
        CommentDTO commentWithRepliesCommentDTO = (CommentDTO)getCommentWithRepliesGson.fromJson(this.getCommentWithRepliesResponse.getData().replace("devPortal", "DEVPORTAL"), CommentDTO.class);
        Assert.assertEquals((String)commentWithRepliesCommentDTO.getContent(), (String)"This is root comment 1", (String)"Comments do not match");
        Assert.assertEquals((String)commentWithRepliesCommentDTO.getCategory(), (String)"general", (String)"Comments do not match");
        Assert.assertEquals((Object)commentWithRepliesCommentDTO.getEntryPoint(), (Object)CommentDTO.EntryPointEnum.DEVPORTAL, (String)"Comments do not match");
        Assert.assertNotNull((Object)commentWithRepliesCommentDTO.getReplies());
        Assert.assertNotNull((Object)commentWithRepliesCommentDTO.getReplies().getList());
        for (CommentDTO reply : commentWithRepliesCommentDTO.getReplies().getList()) {
            Assert.assertEquals((String)reply.getCategory(), (String)"general", (String)"Comments do not match");
            Assert.assertEquals((Object)reply.getEntryPoint(), (Object)CommentDTO.EntryPointEnum.DEVPORTAL, (String)"Comments do not match");
            Assert.assertEquals((String)reply.getParentCommentId(), (String)this.rootCommentIdToAddReplies, (String)"Comments do not match");
            Assert.assertTrue((boolean)this.replies.contains(reply.getId()), (String)"Comments do not match");
        }
        Assert.assertEquals((int)commentWithRepliesCommentDTO.getReplies().getList().size(), (int)3, (String)"Replies limit does not match");
    }

    @Test(dependsOnMethods={"testAddRepliesToRootCommentByAdminTest"}, groups={"wso2.am"}, description="Verify Pagination of Replies List of a Comment Test Case")
    public void testDevPortalPaginatedCommentListTest() throws Exception {
        HttpResponse getCommentToVerifyPagination = this.restAPIStore.getComment(this.rootCommentIdToAddReplies, this.apiId, this.gatewayContextWrk.getContextTenant().getDomain(), false, Integer.valueOf(3), Integer.valueOf(1));
        Assert.assertEquals((int)getCommentToVerifyPagination.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Error retrieving comment");
        Gson getCommentToVerifyPaginationGson = new Gson();
        CommentDTO getCommentToVerifyPaginationCommentDTO = (CommentDTO)getCommentToVerifyPaginationGson.fromJson(getCommentToVerifyPagination.getData().replace("devPortal", "DEVPORTAL"), CommentDTO.class);
        Assert.assertNotNull((Object)getCommentToVerifyPaginationCommentDTO.getReplies());
        Assert.assertNotNull((Object)getCommentToVerifyPaginationCommentDTO.getReplies().getList());
        Assert.assertEquals((int)getCommentToVerifyPaginationCommentDTO.getReplies().getList().size(), (int)2, (String)"Replies limit does not match");
        Assert.assertEquals((String)((CommentDTO)getCommentToVerifyPaginationCommentDTO.getReplies().getList().get(0)).getContent(), (String)"This is a reply 2", (String)"Offset value does not captured");
        Assert.assertEquals((String)((CommentDTO)getCommentToVerifyPaginationCommentDTO.getReplies().getList().get(1)).getContent(), (String)"This is a reply 3", (String)"Offset value does not captured");
    }

    @Test(dependsOnMethods={"testDevPortalPaginatedCommentListTest"}, groups={"wso2.am"}, description="Get  all comments Test Case")
    public void testDevPortalGetAllCommentsTest() throws Exception {
        HttpResponse getCommentsResponse = this.restAPIStore.getComments(this.apiId, this.gatewayContextWrk.getContextTenant().getDomain(), false, Integer.valueOf(5), Integer.valueOf(0));
        Assert.assertEquals((int)getCommentsResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Error retrieving comment");
        Gson getCommentsGson = new Gson();
        CommentListDTO commentListDTO = (CommentListDTO)getCommentsGson.fromJson(getCommentsResponse.getData().replace("devPortal", "DEVPORTAL"), CommentListDTO.class);
        Assert.assertNotNull((Object)commentListDTO.getCount());
        Assert.assertEquals((int)commentListDTO.getCount(), (int)2, (String)"Root comments count do not match");
        Assert.assertNotNull((Object)commentListDTO.getList());
        for (CommentDTO rootCommentDTO : commentListDTO.getList()) {
            Assert.assertEquals((String)rootCommentDTO.getCategory(), (String)"general", (String)"Comments do not match");
            Assert.assertEquals((Object)rootCommentDTO.getEntryPoint(), (Object)CommentDTO.EntryPointEnum.DEVPORTAL, (String)"Comments do not match");
            Assert.assertNull((Object)rootCommentDTO.getParentCommentId(), (String)"Comments do not match");
            Assert.assertTrue((boolean)this.rootComments.contains(rootCommentDTO.getId()), (String)"Comments do not match");
        }
    }

    @Test(dependsOnMethods={"testDevPortalGetAllCommentsTest"}, groups={"wso2.am"}, description="Verify Pagination of Root Comment List Test Case")
    public void testDevPortalPaginatedRootCommentsTest() throws Exception {
        HttpResponse getRootCommentsToVerifyPagination = this.restAPIStore.getComments(this.apiId, this.gatewayContextWrk.getContextTenant().getDomain(), false, Integer.valueOf(3), Integer.valueOf(1));
        Assert.assertEquals((int)getRootCommentsToVerifyPagination.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Error retrieving comment");
        Gson getRootCommentsToVerifyPaginationGson = new Gson();
        CommentListDTO getRootCommentsToVerifyPaginationCommentDTO = (CommentListDTO)getRootCommentsToVerifyPaginationGson.fromJson(getRootCommentsToVerifyPagination.getData().replace("devPortal", "DEVPORTAL"), CommentListDTO.class);
        Assert.assertNotNull((Object)getRootCommentsToVerifyPaginationCommentDTO.getList());
        Assert.assertEquals((int)getRootCommentsToVerifyPaginationCommentDTO.getList().size(), (int)1, (String)"Comments limit does not match");
        Assert.assertEquals((String)((CommentDTO)getRootCommentsToVerifyPaginationCommentDTO.getList().get(0)).getContent(), (String)"This is root comment 1", (String)"Offset value does not captured");
    }

    @Test(dependsOnMethods={"testDevPortalPaginatedRootCommentsTest"}, groups={"wso2.am"}, description="Verify Total Number of Comments from Pagination of Root Comment List Test Case")
    public void testDevPortalTotalCommentsOfPaginatedRootCommentsTest() throws Exception {
        HttpResponse getRootCommentsToVerifyPagination = this.restAPIStore.getComments(this.apiId, this.gatewayContextWrk.getContextTenant().getDomain(), false, Integer.valueOf(1), Integer.valueOf(0));
        Assert.assertEquals((int)getRootCommentsToVerifyPagination.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Error retrieving comment");
        Gson getRootCommentsToVerifyPaginationGson = new Gson();
        CommentListDTO getRootCommentsToVerifyPaginationCommentDTO = (CommentListDTO)getRootCommentsToVerifyPaginationGson.fromJson(getRootCommentsToVerifyPagination.getData().replace("devPortal", "DEVPORTAL"), CommentListDTO.class);
        Assert.assertNotNull((Object)getRootCommentsToVerifyPaginationCommentDTO.getList());
        Assert.assertEquals((int)getRootCommentsToVerifyPaginationCommentDTO.getList().size(), (int)1, (String)"Comments limit does not match");
        Assert.assertNotNull((Object)getRootCommentsToVerifyPaginationCommentDTO.getPagination());
        if (!Objects.isNull(getRootCommentsToVerifyPaginationCommentDTO.getPagination().getTotal())) {
            int totalComments = getRootCommentsToVerifyPaginationCommentDTO.getPagination().getTotal();
            Assert.assertEquals((int)totalComments, (int)2, (String)"Total comments count does not match");
        }
    }

    @Test(dependsOnMethods={"testDevPortalTotalCommentsOfPaginatedRootCommentsTest"}, groups={"wso2.am"}, description="Get All Replies of Comment Test Case")
    public void testDevPortalGetRepliesOfCommentTest() throws Exception {
        HttpResponse getRepliesResponse = this.restAPIStore.getReplies(this.rootCommentIdToAddReplies, this.apiId, this.gatewayContextWrk.getContextTenant().getDomain(), false, Integer.valueOf(5), Integer.valueOf(0));
        Assert.assertEquals((int)getRepliesResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Error retrieving comment");
        Gson getRepliesGson = new Gson();
        CommentListDTO replyListDTO = (CommentListDTO)getRepliesGson.fromJson(getRepliesResponse.getData().replace("devPortal", "DEVPORTAL"), CommentListDTO.class);
        Assert.assertNotNull((Object)replyListDTO.getCount());
        Assert.assertEquals((int)replyListDTO.getCount(), (int)3, (String)"Replies count do not match");
        Assert.assertNotNull((Object)replyListDTO.getList());
        for (CommentDTO replyDTO : replyListDTO.getList()) {
            Assert.assertEquals((String)replyDTO.getCategory(), (String)"general", (String)"Comments do not match");
            Assert.assertEquals((Object)replyDTO.getEntryPoint(), (Object)CommentDTO.EntryPointEnum.DEVPORTAL, (String)"Comments do not match");
            Assert.assertEquals((String)replyDTO.getParentCommentId(), (String)this.rootCommentIdToAddReplies, (String)"Comments do not match");
            Assert.assertTrue((boolean)this.replies.contains(replyDTO.getId()), (String)"Comments do not match");
        }
    }

    @Test(dependsOnMethods={"testDevPortalGetRepliesOfCommentTest"}, groups={"wso2.am"}, description="Verify Pagination of Replies List of Comment Test Case")
    public void testDevPortalPaginationOfRepliesOfCommentTest() throws Exception {
        HttpResponse getRepliesToVerifyPagination = this.restAPIStore.getReplies(this.rootCommentIdToAddReplies, this.apiId, this.gatewayContextWrk.getContextTenant().getDomain(), false, Integer.valueOf(3), Integer.valueOf(1));
        Assert.assertEquals((int)getRepliesToVerifyPagination.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Error retrieving comment");
        Gson getRepliesToVerifyPaginationGson = new Gson();
        CommentListDTO getRepliesToVerifyPaginationCommentListDTO = (CommentListDTO)getRepliesToVerifyPaginationGson.fromJson(getRepliesToVerifyPagination.getData().replace("devPortal", "DEVPORTAL"), CommentListDTO.class);
        Assert.assertNotNull((Object)getRepliesToVerifyPaginationCommentListDTO.getList());
        Assert.assertEquals((int)getRepliesToVerifyPaginationCommentListDTO.getList().size(), (int)2, (String)"Comments limit does not match");
        Assert.assertEquals((String)((CommentDTO)getRepliesToVerifyPaginationCommentListDTO.getList().get(0)).getContent(), (String)"This is a reply 2", (String)"Offset value does not captured");
        Assert.assertEquals((String)((CommentDTO)getRepliesToVerifyPaginationCommentListDTO.getList().get(1)).getContent(), (String)"This is a reply 3", (String)"Offset value does not captured");
    }

    @Test(dependsOnMethods={"testDevPortalPaginationOfRepliesOfCommentTest"}, groups={"wso2.am"}, description="Verify Total Number of Replies of Pagination of Replies List of Comment Test Case")
    public void testDevPortalTotalRepliesOfPaginationOfRepliesOfCommentTest() throws Exception {
        HttpResponse getRepliesToVerifyPagination = this.restAPIStore.getReplies(this.rootCommentIdToAddReplies, this.apiId, this.gatewayContextWrk.getContextTenant().getDomain(), false, Integer.valueOf(1), Integer.valueOf(0));
        Assert.assertEquals((int)getRepliesToVerifyPagination.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Error retrieving comment");
        Gson getRepliesToVerifyPaginationGson = new Gson();
        CommentListDTO getRepliesToVerifyPaginationCommentListDTO = (CommentListDTO)getRepliesToVerifyPaginationGson.fromJson(getRepliesToVerifyPagination.getData().replace("devPortal", "DEVPORTAL"), CommentListDTO.class);
        Assert.assertNotNull((Object)getRepliesToVerifyPaginationCommentListDTO.getList());
        Assert.assertEquals((int)getRepliesToVerifyPaginationCommentListDTO.getList().size(), (int)1, (String)"Replies limit does not match");
        Assert.assertNotNull((Object)getRepliesToVerifyPaginationCommentListDTO.getPagination());
        if (!Objects.isNull(getRepliesToVerifyPaginationCommentListDTO.getPagination().getTotal())) {
            int totalReplies = getRepliesToVerifyPaginationCommentListDTO.getPagination().getTotal();
            Assert.assertEquals((int)totalReplies, (int)3, (String)"Total replies count does not match");
        }
    }

    @Test(dependsOnMethods={"testDevPortalTotalRepliesOfPaginationOfRepliesOfCommentTest"}, groups={"wso2.am"}, description="Get and verify all comments from Publisher Test Case")
    public void testVerifyPublisherGetAllCommentsTest() throws Exception {
        HttpResponse getCommentsResponse = this.restAPIPublisher.getComments(this.apiId, this.gatewayContextWrk.getContextTenant().getDomain(), false, Integer.valueOf(5), Integer.valueOf(0));
        Assert.assertEquals((int)getCommentsResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Error retrieving comment");
        Gson getCommentsGson = new Gson();
        CommentListDTO commentListDTO = (CommentListDTO)getCommentsGson.fromJson(getCommentsResponse.getData().replace("devPortal", "DEVPORTAL"), CommentListDTO.class);
        Assert.assertNotNull((Object)commentListDTO.getCount());
        Assert.assertEquals((int)commentListDTO.getCount(), (int)2, (String)"Root comments count do not match");
        Assert.assertNotNull((Object)commentListDTO.getList());
        for (CommentDTO rootCommentDTO : commentListDTO.getList()) {
            Assert.assertEquals((String)rootCommentDTO.getCategory(), (String)"general", (String)"Comments do not match");
            Assert.assertEquals((Object)rootCommentDTO.getEntryPoint(), (Object)CommentDTO.EntryPointEnum.DEVPORTAL, (String)"Comments do not match");
            Assert.assertNull((Object)rootCommentDTO.getParentCommentId(), (String)"Comments do not match");
            Assert.assertTrue((boolean)this.rootComments.contains(rootCommentDTO.getId()), (String)"Comments do not match");
        }
    }

    @Test(dependsOnMethods={"testVerifyPublisherGetAllCommentsTest"}, groups={"wso2.am"}, description="Verify Pagination of Replies List of a Comment from Publisher Test Case")
    public void testVerifyPublisherPaginatedCommentListTest() throws Exception {
        HttpResponse getCommentToVerifyPagination = this.restAPIPublisher.getComment(this.rootCommentIdToAddReplies, this.apiId, this.gatewayContextWrk.getContextTenant().getDomain(), false, Integer.valueOf(3), Integer.valueOf(1));
        Assert.assertEquals((int)getCommentToVerifyPagination.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Error retrieving comment");
        Gson getCommentToVerifyPaginationGson = new Gson();
        CommentDTO getCommentToVerifyPaginationCommentDTO = (CommentDTO)getCommentToVerifyPaginationGson.fromJson(getCommentToVerifyPagination.getData().replace("devPortal", "DEVPORTAL"), CommentDTO.class);
        Assert.assertNotNull((Object)getCommentToVerifyPaginationCommentDTO.getReplies());
        Assert.assertNotNull((Object)getCommentToVerifyPaginationCommentDTO.getReplies().getList());
        Assert.assertEquals((int)getCommentToVerifyPaginationCommentDTO.getReplies().getList().size(), (int)2, (String)"Replies limit does not match");
        Assert.assertEquals((String)((CommentDTO)getCommentToVerifyPaginationCommentDTO.getReplies().getList().get(0)).getContent(), (String)"This is a reply 2", (String)"Offset value does not captured");
        Assert.assertEquals((String)((CommentDTO)getCommentToVerifyPaginationCommentDTO.getReplies().getList().get(1)).getContent(), (String)"This is a reply 3", (String)"Offset value does not captured");
    }

    @Test(dependsOnMethods={"testVerifyPublisherPaginatedCommentListTest"}, groups={"wso2.am"}, description="Get All Replies of Comment from Publisher Test Case")
    public void testVerifyPublisherGetRepliesOfCommentTest() throws Exception {
        HttpResponse getRepliesResponse = this.restAPIPublisher.getReplies(this.rootCommentIdToAddReplies, this.apiId, this.gatewayContextWrk.getContextTenant().getDomain(), false, Integer.valueOf(5), Integer.valueOf(0));
        Assert.assertEquals((int)getRepliesResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Error retrieving comment");
        Gson getRepliesGson = new Gson();
        CommentListDTO replyListDTO = (CommentListDTO)getRepliesGson.fromJson(getRepliesResponse.getData().replace("devPortal", "DEVPORTAL"), CommentListDTO.class);
        Assert.assertNotNull((Object)replyListDTO.getCount());
        Assert.assertEquals((int)replyListDTO.getCount(), (int)3, (String)"Replies count do not match");
        Assert.assertNotNull((Object)replyListDTO.getList());
        for (CommentDTO replyDTO : replyListDTO.getList()) {
            Assert.assertEquals((String)replyDTO.getCategory(), (String)"general", (String)"Comments do not match");
            Assert.assertEquals((Object)replyDTO.getEntryPoint(), (Object)CommentDTO.EntryPointEnum.DEVPORTAL, (String)"Comments do not match");
            Assert.assertEquals((String)replyDTO.getParentCommentId(), (String)this.rootCommentIdToAddReplies, (String)"Comments do not match");
            Assert.assertTrue((boolean)this.replies.contains(replyDTO.getId()), (String)"Comments do not match");
        }
    }

    @Test(dependsOnMethods={"testVerifyPublisherGetRepliesOfCommentTest"}, groups={"wso2.am"}, description="Verify Pagination of Replies List of Comment from Publisher Test Case")
    public void testVerifyPublisherPaginationOfRepliesOfCommentTest() throws Exception {
        HttpResponse getRepliesToVerifyPagination = this.restAPIPublisher.getReplies(this.rootCommentIdToAddReplies, this.apiId, this.gatewayContextWrk.getContextTenant().getDomain(), false, Integer.valueOf(3), Integer.valueOf(1));
        Assert.assertEquals((int)getRepliesToVerifyPagination.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Error retrieving comment");
        Gson getRepliesToVerifyPaginationGson = new Gson();
        CommentListDTO getRepliesToVerifyPaginationCommentListDTO = (CommentListDTO)getRepliesToVerifyPaginationGson.fromJson(getRepliesToVerifyPagination.getData().replace("devPortal", "DEVPORTAL"), CommentListDTO.class);
        Assert.assertNotNull((Object)getRepliesToVerifyPaginationCommentListDTO.getList());
        Assert.assertEquals((int)getRepliesToVerifyPaginationCommentListDTO.getList().size(), (int)2, (String)"Comments limit does not match");
        Assert.assertEquals((String)((CommentDTO)getRepliesToVerifyPaginationCommentListDTO.getList().get(0)).getContent(), (String)"This is a reply 2", (String)"Offset value does not captured");
        Assert.assertEquals((String)((CommentDTO)getRepliesToVerifyPaginationCommentListDTO.getList().get(1)).getContent(), (String)"This is a reply 3", (String)"Offset value does not captured");
    }

    @DataProvider(name="input-data-provider")
    public Object[][] inputDataProviderMethod() {
        return new Object[][]{{"Edited root comment", "general"}, {"Edited root comment", "bug fix"}, {"Edited root comment 1", "general bug fix"}};
    }

    @Test(dependsOnMethods={"testVerifyPublisherPaginationOfRepliesOfCommentTest"}, groups={"wso2.am"}, description="Edit Comment Test Case", dataProvider="input-data-provider")
    public void testDevPortalEditCommentTest(String content, String category) throws Exception {
        HttpResponse editCommentResponse = this.restAPIStore.editComment(this.rootCommentIdToAddReplies, this.apiId, content, category);
        Assert.assertNotNull((Object)editCommentResponse, (String)"Error adding comment");
        Assert.assertEquals((int)editCommentResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched");
        Gson editCommentGson = new Gson();
        CommentDTO editCommentDTO = (CommentDTO)editCommentGson.fromJson(editCommentResponse.getData().replace("devPortal", "DEVPORTAL"), CommentDTO.class);
        Assert.assertEquals((String)editCommentDTO.getContent(), (String)content);
        Assert.assertEquals((String)editCommentDTO.getCategory(), (String)category);
        Assert.assertNotEquals((Object)editCommentDTO.getUpdatedTime(), null);
        if (!content.equals("Edited root comment") || !category.equals("general")) {
            Assert.assertNotEquals((Object)editCommentDTO.getUpdatedTime(), (Object)this.updatedTime);
        }
        this.updatedTime = editCommentDTO.getUpdatedTime();
        Thread.sleep(1000L);
        if (content.equals("Edited root comment 1") && category.equals("general bug fix")) {
            editCommentResponse = this.restAPIStore.editComment(this.rootCommentIdToAddReplies, this.apiId, content, category);
            Assert.assertNull((Object)editCommentResponse.getData());
            Assert.assertEquals((int)editCommentResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched");
            editCommentResponse = this.restAPIStore.getComment(this.rootCommentIdToAddReplies, this.apiId, this.gatewayContextWrk.getContextTenant().getDomain(), false, Integer.valueOf(3), Integer.valueOf(0));
            Assert.assertEquals((int)this.getCommentWithRepliesResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Error retrieving comment");
            editCommentGson = new Gson();
            editCommentDTO = (CommentDTO)editCommentGson.fromJson(editCommentResponse.getData().replace("devPortal", "DEVPORTAL"), CommentDTO.class);
            Assert.assertEquals((String)editCommentDTO.getContent(), (String)content);
            Assert.assertEquals((String)editCommentDTO.getCategory(), (String)category);
            Assert.assertNotEquals((Object)editCommentDTO.getUpdatedTime(), null);
            Assert.assertEquals((String)editCommentDTO.getUpdatedTime(), (String)this.updatedTime);
        }
    }

    @Test(dependsOnMethods={"testDevPortalEditCommentTest"}, groups={"wso2.am"}, description="Delete Comment Test Case")
    public void testDevPortalDeleteCommentTest() throws Exception {
        HttpResponse deleteResponse = this.restAPIStore.removeComment(this.rootCommentIdToAddReplies, this.apiId);
        Assert.assertEquals((int)deleteResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched");
        for (String reply : this.replies) {
            HttpResponse replyResponse = this.restAPIStore.getComment(reply, this.apiId, this.gatewayContextWrk.getContextTenant().getDomain(), false, Integer.valueOf(3), Integer.valueOf(0));
            Assert.assertEquals((int)replyResponse.getResponseCode(), (int)Response.Status.NOT_FOUND.getStatusCode(), (String)"Error retrieving comment");
        }
    }

    @Test(dependsOnMethods={"testDevPortalDeleteCommentTest"}, groups={"wso2.am"}, description="Delete Not Existing Comment Test Case")
    public void testDevPortalDeleteNotExistingCommentTest() throws Exception {
        HttpResponse deleteResponse = this.restAPIStore.removeComment(this.rootCommentIdToAddReplies, this.apiId);
        Assert.assertEquals((int)deleteResponse.getResponseCode(), (int)Response.Status.NOT_FOUND.getStatusCode(), (String)"Response code mismatched");
    }

    @Test(dependsOnMethods={"testDevPortalDeleteNotExistingCommentTest"}, groups={"wso2.am"}, description="Test Add a Root Comment and Reply to Root Comment Test Cases")
    public void testDevPortalAddNewRootCommentWithReplyTest() throws Exception {
        HttpResponse addRootCommentResponse = this.restAPIStore.addComment(this.apiId, "This is root comment", "general", null);
        Assert.assertNotNull((Object)addRootCommentResponse, (String)"Error adding comment");
        Assert.assertEquals((int)addRootCommentResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched");
        Gson getCommentsGson = new Gson();
        CommentDTO addedRootCommentDTO = (CommentDTO)getCommentsGson.fromJson(addRootCommentResponse.getData().replace("devPortal", "DEVPORTAL"), CommentDTO.class);
        this.rootCommentIdToAddReplies = addedRootCommentDTO.getId();
        Assert.assertNotNull((Object)this.rootCommentIdToAddReplies, (String)"Comment Id is null");
        Thread.sleep(1000L);
        HttpResponse addReplyCommentResponse = this.restAPIStore.addComment(this.apiId, "This is reply", "general", this.rootCommentIdToAddReplies);
        Assert.assertNotNull((Object)addReplyCommentResponse, (String)"Error adding comment");
        Assert.assertEquals((int)addReplyCommentResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched");
        Gson getRepliesGson = new Gson();
        CommentDTO addedCommentDTO = (CommentDTO)getRepliesGson.fromJson(addReplyCommentResponse.getData().replace("devPortal", "DEVPORTAL"), CommentDTO.class);
        this.replyToRootComment = addedCommentDTO.getId();
        Assert.assertNotNull((Object)this.replyToRootComment, (String)"Comment Id is null");
    }

    @Test(dependsOnMethods={"testDevPortalAddNewRootCommentWithReplyTest"}, groups={"wso2.am"}, description="Edit Comment by Non Owner Non Admin User Test Case")
    public void testDevPortalEditCommentByNonOwnerNonAdminUserTest() throws Exception {
        if (TestUserMode.SUPER_TENANT_ADMIN.equals((Object)this.userMode)) {
            HttpResponse editCommentResponse = this.apiStoreClientCarbonSuperNonAdminUser.editComment(this.rootCommentIdToAddReplies, this.apiId, "Edited root comment by non owner non admin user", "general");
            Assert.assertNotNull((Object)editCommentResponse, (String)"Error adding comment");
            Assert.assertEquals((int)editCommentResponse.getResponseCode(), (int)Response.Status.FORBIDDEN.getStatusCode(), (String)"Response code mismatched");
        }
    }

    @Test(dependsOnMethods={"testDevPortalEditCommentByNonOwnerNonAdminUserTest"}, groups={"wso2.am"}, description="Edit Comment by Non Owner Admin User Test Case")
    public void testDevPortalEditCommentByNonOwnerAdminUserTest() throws Exception {
        if (TestUserMode.SUPER_TENANT_ADMIN.equals((Object)this.userMode)) {
            HttpResponse editCommentResponse = this.apiStoreClientCarbonSuperNewAdmin.editComment(this.rootCommentIdToAddReplies, this.apiId, "Edited root comment by non owner admin user", "new_general");
            Assert.assertNotNull((Object)editCommentResponse, (String)"Error adding comment");
            Assert.assertEquals((int)editCommentResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched");
            Gson editCommentGson = new Gson();
            CommentDTO editCommentDTO = (CommentDTO)editCommentGson.fromJson(editCommentResponse.getData().replace("devPortal", "DEVPORTAL"), CommentDTO.class);
            Assert.assertEquals((String)editCommentDTO.getContent(), (String)"Edited root comment by non owner admin user");
            Assert.assertEquals((String)editCommentDTO.getCategory(), (String)"new_general");
        }
    }

    @Test(dependsOnMethods={"testDevPortalEditCommentByNonOwnerAdminUserTest"}, groups={"wso2.am"}, description="Add New Comment by Non Admin User Test Case")
    public void testDevPortalAddCommentByNonAdminUserTest() throws Exception {
        if (TestUserMode.SUPER_TENANT_ADMIN.equals((Object)this.userMode)) {
            Thread.sleep(1000L);
            HttpResponse addRootCommentResponse = this.apiStoreClientCarbonSuperNonAdminUser.addComment(this.apiId, "This is root comment by non admin user", "general", null);
            Assert.assertNotNull((Object)addRootCommentResponse, (String)"Error adding comment");
            Assert.assertEquals((int)addRootCommentResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched");
            Gson getCommentsGson = new Gson();
            CommentDTO addedRootCommentDTO = (CommentDTO)getCommentsGson.fromJson(addRootCommentResponse.getData().replace("devPortal", "DEVPORTAL"), CommentDTO.class);
            this.commentFromNonAdminUser = addedRootCommentDTO.getId();
            Assert.assertNotNull((Object)this.commentFromNonAdminUser, (String)"Comment Id of non admin user is null");
        }
    }

    @Test(dependsOnMethods={"testDevPortalAddCommentByNonAdminUserTest"}, groups={"wso2.am"}, description="Add Reply to Non Admin User Comment by Admin User Test Case")
    public void testDevPortalAddReplyToNonAdminUserCommentByAdminUserTest() throws Exception {
        if (TestUserMode.SUPER_TENANT_ADMIN.equals((Object)this.userMode)) {
            Thread.sleep(1000L);
            HttpResponse addReplyCommentResponse = this.restAPIStore.addComment(this.apiId, "This is a reply from admin user", "general", this.commentFromNonAdminUser);
            Assert.assertNotNull((Object)addReplyCommentResponse, (String)"Error adding comment");
            Assert.assertEquals((int)addReplyCommentResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched");
            Gson getCommentsGson = new Gson();
            CommentDTO addedCommentDTO = (CommentDTO)getCommentsGson.fromJson(addReplyCommentResponse.getData().replace("devPortal", "DEVPORTAL"), CommentDTO.class);
            String replyCommentId = addedCommentDTO.getId();
            Assert.assertNotNull((Object)replyCommentId, (String)"Comment Id is null");
        }
    }

    @Test(dependsOnMethods={"testDevPortalAddReplyToNonAdminUserCommentByAdminUserTest"}, groups={"wso2.am"}, description="Add Reply to Non Admin User Comment by Non Admin User Test Case")
    public void testDevPortalAddReplyToAdminUserCommentByNonAdminUserTest() throws Exception {
        if (TestUserMode.SUPER_TENANT_ADMIN.equals((Object)this.userMode)) {
            Thread.sleep(1000L);
            HttpResponse addReplyCommentResponse = this.apiStoreClientCarbonSuperNonAdminUser.addComment(this.apiId, "This is a reply from non admin user", "general", this.rootCommentIdForPublisherTest);
            Assert.assertNotNull((Object)addReplyCommentResponse, (String)"Error adding comment");
            Assert.assertEquals((int)addReplyCommentResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched");
            Gson getCommentsGson = new Gson();
            CommentDTO addedCommentDTO = (CommentDTO)getCommentsGson.fromJson(addReplyCommentResponse.getData().replace("devPortal", "DEVPORTAL"), CommentDTO.class);
            String replyCommentId = addedCommentDTO.getId();
            Assert.assertNotNull((Object)replyCommentId, (String)"Comment Id is null");
        }
    }

    @Test(dependsOnMethods={"testDevPortalAddReplyToAdminUserCommentByNonAdminUserTest"}, groups={"wso2.am"}, description="Add Reply to Publisher Non Admin User Comment by Admin User Test Case")
    public void testPublisherNonAdminUserAddReplyToCommentFromDevPortalTest() throws Exception {
        if (TestUserMode.SUPER_TENANT_ADMIN.equals((Object)this.userMode)) {
            Thread.sleep(1000L);
            HttpResponse addReplyCommentResponse = this.apiPublisherClientCarbonSuperNonAdminUser.addComment(this.apiId, "This is a reply from non admin user from Publisher", "general", this.rootCommentIdForPublisherTest);
            Assert.assertNotNull((Object)addReplyCommentResponse, (String)"Error adding comment");
            Assert.assertEquals((int)addReplyCommentResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched");
            Gson getCommentsGson = new Gson();
            CommentDTO addedCommentDTO = (CommentDTO)getCommentsGson.fromJson(addReplyCommentResponse.getData().replace("publisher", "PUBLISHER"), CommentDTO.class);
            String replyCommentId = addedCommentDTO.getId();
            Assert.assertNotNull((Object)replyCommentId, (String)"Comment Id is null");
        }
    }

    @Test(dependsOnMethods={"testPublisherNonAdminUserAddReplyToCommentFromDevPortalTest"}, groups={"wso2.am"}, description="Add Reply to Publisher Admin User Comment by Admin User Test Case")
    public void testPublisherAdminUserAddReplyToCommentFromDevPortalTest() throws Exception {
        if (TestUserMode.SUPER_TENANT_ADMIN.equals((Object)this.userMode)) {
            Thread.sleep(1000L);
            HttpResponse addReplyCommentResponse = this.restAPIPublisher.addComment(this.apiId, "This is a reply from admin user from Publisher", "general", this.rootCommentIdForPublisherTest);
            Assert.assertNotNull((Object)addReplyCommentResponse, (String)"Error adding comment");
            Assert.assertEquals((int)addReplyCommentResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched");
            Gson getCommentsGson = new Gson();
            CommentDTO addedCommentDTO = (CommentDTO)getCommentsGson.fromJson(addReplyCommentResponse.getData().replace("publisher", "PUBLISHER"), CommentDTO.class);
            String replyCommentId = addedCommentDTO.getId();
            Assert.assertNotNull((Object)replyCommentId, (String)"Comment Id is null");
        }
    }

    @Test(dependsOnMethods={"testPublisherAdminUserAddReplyToCommentFromDevPortalTest"}, groups={"wso2.am"}, description="Delete Comment by Non Owner Non Admin User Test Case")
    public void testDevPortalDeleteCommentByNonOwnerNonAdminUserTest() throws Exception {
        if (TestUserMode.SUPER_TENANT_ADMIN.equals((Object)this.userMode)) {
            HttpResponse deleteResponse = this.apiStoreClientCarbonSuperNonAdminUser.removeComment(this.rootCommentIdToAddReplies, this.apiId);
            Assert.assertEquals((int)deleteResponse.getResponseCode(), (int)Response.Status.FORBIDDEN.getStatusCode(), (String)"Response code mismatched");
        }
    }

    @Test(dependsOnMethods={"testDevPortalDeleteCommentByNonOwnerNonAdminUserTest"}, groups={"wso2.am"}, description="Delete Comment by Non Owner Admin User Test Case")
    public void testDevPortalDeleteCommentByNonOwnerAdminUserTest() throws Exception {
        if (TestUserMode.SUPER_TENANT_ADMIN.equals((Object)this.userMode)) {
            HttpResponse deleteResponse = this.apiStoreClientCarbonSuperNewAdmin.removeComment(this.rootCommentIdToAddReplies, this.apiId);
            Assert.assertEquals((int)deleteResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched");
            HttpResponse replyResponse = this.restAPIStore.getComment(this.replyToRootComment, this.apiId, this.gatewayContextWrk.getContextTenant().getDomain(), false, Integer.valueOf(5), Integer.valueOf(0));
            Assert.assertEquals((int)replyResponse.getResponseCode(), (int)Response.Status.NOT_FOUND.getStatusCode(), (String)"Error retrieving comment");
        }
    }

    @Test(dependsOnMethods={"testDevPortalDeleteCommentByNonOwnerAdminUserTest"}, groups={"wso2.am"}, description="Delete Comment from Publisher Test Case")
    public void testVerifyPublisherAdminDeleteCommentTest() throws Exception {
        HttpResponse deleteResponse = this.restAPIPublisher.removeComment(this.rootCommentIdForPublisherTest, this.apiId);
        Assert.assertEquals((int)deleteResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched");
        HttpResponse replyResponse = this.restAPIStore.getComment(this.replyToTestPublisherVisibility, this.apiId, this.gatewayContextWrk.getContextTenant().getDomain(), false, Integer.valueOf(3), Integer.valueOf(0));
        Assert.assertEquals((int)replyResponse.getResponseCode(), (int)Response.Status.NOT_FOUND.getStatusCode(), (String)"Error retrieving comment");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIPublisher.deleteAPI(this.apiId);
        super.cleanUp();
    }
}

