/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.crossSubscription;

import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.xml.xpath.XPathExpressionException;
import org.json.JSONException;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.admin.clients.user.RemoteUserStoreManagerServiceClient;
import org.wso2.am.integration.clients.admin.ApiResponse;
import org.wso2.am.integration.clients.admin.api.dto.ApplicationThrottlePolicyDTO;
import org.wso2.am.integration.clients.admin.api.dto.KeyManagerCertificatesDTO;
import org.wso2.am.integration.clients.admin.api.dto.KeyManagerDTO;
import org.wso2.am.integration.clients.admin.api.dto.KeyManagerInfoDTO;
import org.wso2.am.integration.clients.admin.api.dto.RequestCountLimitDTO;
import org.wso2.am.integration.clients.admin.api.dto.SubscriptionThrottlePolicyDTO;
import org.wso2.am.integration.clients.admin.api.dto.SubscriptionThrottlePolicyPermissionDTO;
import org.wso2.am.integration.clients.admin.api.dto.ThrottleLimitDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.store.api.ApiException;
import org.wso2.am.integration.clients.store.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APIInfoDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APIListDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APITiersDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyListDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.KeyManagerListDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SubscriptionDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SubscriptionListDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ThrottlingPolicyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ThrottlingPolicyListDTO;
import org.wso2.am.integration.test.impl.DtoFactory;
import org.wso2.am.integration.test.impl.RestAPIAdminImpl;
import org.wso2.am.integration.test.impl.RestAPIPublisherImpl;
import org.wso2.am.integration.test.impl.RestAPIStoreImpl;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.token.TokenUtils;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.um.ws.api.stub.PermissionDTO;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class CrossTenantSubscriptionTestCase
extends APIManagerLifecycleBaseTest {
    private static final String tenant1Name = "crosstenant1.com";
    private static final String tenant2Name = "crosstenant2.com";
    private static RestAPIPublisherImpl apiPublisherRestClientTenant1;
    private static RestAPIPublisherImpl apiPublisherRestClientTenant2;
    private static RestAPIStoreImpl apiStoreRestClientTenant1;
    private static RestAPIStoreImpl apiStoreRestClientTenant2;
    private static RestAPIAdminImpl restAPIAdminTenant1;
    private static RestAPIAdminImpl restAPIAdminTenant2;
    private final String apiName = "CrossTenantSubscriptionAPI";
    private final String apiContext = "crossTenantSubscriptionAPI";
    private final String apiVersion = "1.0.0";
    String apiPrototypeEndpointPostfixUrl = "am/sample/pizzashack/v1/api";
    private String apiEndPointUrl;
    String apiId2;
    String apiId1;
    private final String timeUnit = "min";
    private final Integer unitTime = 1;
    private final Integer rateLimitCount = -1;
    private final String rateLimitTimeUnit = "NA";
    ApplicationDTO tenant1Application;
    ApplicationDTO tenant2Application;
    String policyIdTenant1;
    String policyIdTenant2;
    private KeyManagerDTO keymanagerTenant1;
    private KeyManagerDTO keymanagerTenant2;
    private String residentKMTenant1;
    private String residentKMTenant2;
    private ApplicationKeyDTO tenant1AppTenant2Store;
    private ApplicationKeyDTO tenant1AppTenant1Store;
    private RemoteUserStoreManagerServiceClient tenant1UserStoreManager;
    private RemoteUserStoreManagerServiceClient tenant2UserStoreManager;
    private ApplicationDTO tenant3Application;
    private ApplicationDTO tenant4Application;
    private SubscriptionThrottlePolicyDTO testPolicyTenant1Public;
    private SubscriptionThrottlePolicyDTO testPolicyTenant2Public;
    private SubscriptionThrottlePolicyDTO testPolicyTenant1Restricted;
    private SubscriptionThrottlePolicyDTO testPolicyTenant2Restricted;

    @Factory(dataProvider="userModeDataProvider")
    public CrossTenantSubscriptionTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init();
        this.apiEndPointUrl = this.gatewayUrlsWrk.getWebAppURLHttp() + this.apiPrototypeEndpointPostfixUrl;
        this.tenantManagementServiceClient.addTenant(tenant1Name, "wso2carbon", "firstTenantAdmin", "demo");
        this.tenantManagementServiceClient.addTenant(tenant2Name, "wso2carbon", "secondTenantAdmin", "demo");
        apiPublisherRestClientTenant1 = new RestAPIPublisherImpl("firstTenantAdmin", "wso2carbon", tenant1Name, this.publisherURLHttps);
        apiPublisherRestClientTenant2 = new RestAPIPublisherImpl("secondTenantAdmin", "wso2carbon", tenant2Name, this.publisherURLHttps);
        apiStoreRestClientTenant1 = new RestAPIStoreImpl("firstTenantAdmin", "wso2carbon", tenant1Name, this.publisherURLHttps);
        apiStoreRestClientTenant2 = new RestAPIStoreImpl("secondTenantAdmin", "wso2carbon", tenant2Name, this.publisherURLHttps);
        restAPIAdminTenant1 = new RestAPIAdminImpl("firstTenantAdmin", "wso2carbon", tenant1Name, this.publisherURLHttps);
        restAPIAdminTenant2 = new RestAPIAdminImpl("secondTenantAdmin", "wso2carbon", tenant2Name, this.publisherURLHttps);
        this.tenant1UserStoreManager = new RemoteUserStoreManagerServiceClient(this.keyManagerContext.getContextUrls().getBackEndUrl(), "firstTenantAdmin@".concat(tenant1Name), "wso2carbon");
        this.tenant2UserStoreManager = new RemoteUserStoreManagerServiceClient(this.keyManagerContext.getContextUrls().getBackEndUrl(), "secondTenantAdmin@".concat(tenant2Name), "wso2carbon");
        this.tenant1UserStoreManager.addRole("role1", new String[]{"firstTenantAdmin"}, new PermissionDTO[0]);
        this.tenant2UserStoreManager.addRole("role1", new String[]{"secondTenantAdmin"}, new PermissionDTO[0]);
        this.createSubscriptionPolicyForTenant1();
        this.createSubscriptionPolicyForTenant2();
        this.createSubscriptionPolicyForTenant1RoleRestricted();
        this.createSubscriptionPolicyForTenant2Restricted();
        APIRequest apiRequest = new APIRequest("CrossTenantSubscriptionAPI", "crossTenantSubscriptionAPI", new URL(this.apiEndPointUrl));
        apiRequest.setVersion("1.0.0");
        apiRequest.setVisibility("public");
        apiRequest.setProvider("firstTenantAdmin@".concat(tenant1Name));
        apiRequest.setSubscriptionAvailability(APIDTO.SubscriptionAvailabilityEnum.ALL_TENANTS.toString());
        ArrayList<String> securitySchemes = new ArrayList<String>();
        securitySchemes.add("oauth2");
        securitySchemes.add("api_key");
        apiRequest.setSecurityScheme(securitySchemes);
        apiRequest.setTiersCollection(String.join((CharSequence)",", "TestPolicyTenant1Public", "TestPolicyTenant1Restricted"));
        this.apiId1 = this.createAndPublishAPIUsingRest(apiRequest, apiPublisherRestClientTenant1, false);
        apiRequest = new APIRequest("CrossTenantSubscriptionAPI", "crossTenantSubscriptionAPI", new URL(this.apiEndPointUrl));
        apiRequest.setVersion("1.0.0");
        apiRequest.setVisibility("public");
        apiRequest.setProvider("secondTenantAdmin@".concat(tenant2Name));
        apiRequest.setSecurityScheme(securitySchemes);
        apiRequest.setTiersCollection(String.join((CharSequence)",", "TestPolicyTenant2Public", "TestPolicyTenant2Restricted"));
        apiRequest.setSubscriptionAvailability(APIDTO.SubscriptionAvailabilityEnum.ALL_TENANTS.toString());
        this.apiId2 = this.createAndPublishAPIUsingRest(apiRequest, apiPublisherRestClientTenant2, false);
        Long requestCount = 5L;
        RequestCountLimitDTO requestCountLimit = DtoFactory.createRequestCountLimitDTO((String)"min", (Integer)this.unitTime, (Long)requestCount);
        ThrottleLimitDTO defaultLimit = DtoFactory.createThrottleLimitDTO((ThrottleLimitDTO.TypeEnum)ThrottleLimitDTO.TypeEnum.REQUESTCOUNTLIMIT, (RequestCountLimitDTO)requestCountLimit, null);
        ApplicationThrottlePolicyDTO requestCountPolicyDTO = DtoFactory.createApplicationThrottlePolicyDTO((String)"Tenant1AppPolicy", (String)"Tenant1AppPolicy", (String)"description", (boolean)false, (ThrottleLimitDTO)defaultLimit);
        ApiResponse addedPolicy1 = restAPIAdminTenant1.addApplicationThrottlingPolicy(requestCountPolicyDTO);
        Assert.assertEquals((int)addedPolicy1.getStatusCode(), (int)201);
        ApplicationThrottlePolicyDTO addedPolicyDTO = (ApplicationThrottlePolicyDTO)addedPolicy1.getData();
        this.policyIdTenant1 = addedPolicyDTO.getPolicyId();
        Assert.assertNotNull((Object)this.policyIdTenant1, (String)"The policy ID cannot be null or empty");
        requestCountPolicyDTO.setPolicyName("Tenant2AppPolicy");
        requestCountPolicyDTO.setDisplayName("Tenant2AppPolicy");
        ApiResponse addedPolicy2 = restAPIAdminTenant2.addApplicationThrottlingPolicy(requestCountPolicyDTO);
        Assert.assertEquals((int)addedPolicy2.getStatusCode(), (int)201);
        addedPolicyDTO = (ApplicationThrottlePolicyDTO)addedPolicy2.getData();
        this.policyIdTenant2 = addedPolicyDTO.getPolicyId();
        Assert.assertNotNull((Object)this.policyIdTenant2, (String)"The policy ID cannot be null or empty");
        KeyManagerCertificatesDTO keyManagerCertificatesDTO = new KeyManagerCertificatesDTO();
        keyManagerCertificatesDTO.setType(KeyManagerCertificatesDTO.TypeEnum.JWKS);
        keyManagerCertificatesDTO.setValue("https://localhost:8743/jwks/1.0");
        KeyManagerDTO keyManagerDTO = DtoFactory.createKeyManagerDTO((String)"Tenant1KM", (String)"Tenant1KM", (String)"custom", (String)"Tenant1KM", (String)"https://teant1.com", (String)"azp", (String)"scopes", Collections.singletonList("client_credentials"), (KeyManagerCertificatesDTO)keyManagerCertificatesDTO);
        keyManagerDTO.setEnableMapOAuthConsumerApps(Boolean.valueOf(true));
        keyManagerDTO.setEnableTokenGeneration(Boolean.valueOf(false));
        keyManagerDTO.setEnableOAuthAppCreation(Boolean.valueOf(false));
        ApiResponse keyManagerDTOApiResponse = restAPIAdminTenant1.addKeyManager(keyManagerDTO);
        Assert.assertEquals((int)keyManagerDTOApiResponse.getStatusCode(), (int)201);
        this.keymanagerTenant1 = (KeyManagerDTO)keyManagerDTOApiResponse.getData();
        KeyManagerDTO keyManagerDTO2 = DtoFactory.createKeyManagerDTO((String)"Tenant2KM", (String)"Tenant1KM", (String)"custom", (String)"Tenant1KM", (String)"https://teant2.com", (String)"azp", (String)"scopes", Collections.singletonList("client_credentials"), (KeyManagerCertificatesDTO)keyManagerCertificatesDTO);
        keyManagerDTO.setEnableMapOAuthConsumerApps(Boolean.valueOf(true));
        keyManagerDTO.setEnableTokenGeneration(Boolean.valueOf(false));
        keyManagerDTO.setEnableOAuthAppCreation(Boolean.valueOf(false));
        keyManagerDTOApiResponse = restAPIAdminTenant2.addKeyManager(keyManagerDTO2);
        Assert.assertEquals((int)keyManagerDTOApiResponse.getStatusCode(), (int)201);
        this.keymanagerTenant2 = (KeyManagerDTO)keyManagerDTOApiResponse.getData();
        for (KeyManagerInfoDTO keyManagerInfoDTO : restAPIAdminTenant1.getKeyManagers().getList()) {
            if (!"Resident Key Manager".equals(keyManagerInfoDTO.getName())) continue;
            this.residentKMTenant1 = keyManagerInfoDTO.getId();
        }
        for (KeyManagerInfoDTO keyManagerInfoDTO : restAPIAdminTenant2.getKeyManagers().getList()) {
            if (!"Resident Key Manager".equals(keyManagerInfoDTO.getName())) continue;
            this.residentKMTenant2 = keyManagerInfoDTO.getId();
        }
    }

    public void createSubscriptionPolicyForTenant1() throws org.wso2.am.integration.clients.admin.ApiException {
        String policyName = "TestPolicyTenant1Public";
        Long requestCount = 10L;
        RequestCountLimitDTO requestCountLimit = DtoFactory.createRequestCountLimitDTO((String)"min", (Integer)this.unitTime, (Long)requestCount);
        ThrottleLimitDTO defaultLimit = DtoFactory.createThrottleLimitDTO((ThrottleLimitDTO.TypeEnum)ThrottleLimitDTO.TypeEnum.REQUESTCOUNTLIMIT, (RequestCountLimitDTO)requestCountLimit, null);
        SubscriptionThrottlePolicyDTO requestCountPolicyDTO = DtoFactory.createSubscriptionThrottlePolicyDTO((String)policyName, (String)policyName, (String)"description", (boolean)true, (ThrottleLimitDTO)defaultLimit, (int)this.rateLimitCount, (String)"NA", (boolean)true, null);
        ApiResponse addedPolicy = restAPIAdminTenant1.addSubscriptionThrottlingPolicy(requestCountPolicyDTO);
        Assert.assertEquals((int)addedPolicy.getStatusCode(), (int)201);
        this.testPolicyTenant1Public = (SubscriptionThrottlePolicyDTO)addedPolicy.getData();
        String policyId = this.testPolicyTenant1Public.getPolicyId();
        Assert.assertNotNull((Object)policyId, (String)"The policy ID cannot be null or empty");
    }

    public void createSubscriptionPolicyForTenant2() throws org.wso2.am.integration.clients.admin.ApiException {
        String policyName = "TestPolicyTenant2Public";
        Long requestCount = 10L;
        RequestCountLimitDTO requestCountLimit = DtoFactory.createRequestCountLimitDTO((String)"min", (Integer)this.unitTime, (Long)requestCount);
        ThrottleLimitDTO defaultLimit = DtoFactory.createThrottleLimitDTO((ThrottleLimitDTO.TypeEnum)ThrottleLimitDTO.TypeEnum.REQUESTCOUNTLIMIT, (RequestCountLimitDTO)requestCountLimit, null);
        SubscriptionThrottlePolicyDTO requestCountPolicyDTO = DtoFactory.createSubscriptionThrottlePolicyDTO((String)policyName, (String)policyName, (String)"description", (boolean)true, (ThrottleLimitDTO)defaultLimit, (int)this.rateLimitCount, (String)"NA", (boolean)true, null);
        ApiResponse addedPolicy = restAPIAdminTenant2.addSubscriptionThrottlingPolicy(requestCountPolicyDTO);
        Assert.assertEquals((int)addedPolicy.getStatusCode(), (int)201);
        this.testPolicyTenant2Public = (SubscriptionThrottlePolicyDTO)addedPolicy.getData();
        String policyId = this.testPolicyTenant2Public.getPolicyId();
        Assert.assertNotNull((Object)policyId, (String)"The policy ID cannot be null or empty");
    }

    public void createSubscriptionPolicyForTenant1RoleRestricted() throws org.wso2.am.integration.clients.admin.ApiException {
        String policyName = "TestPolicyTenant1Restricted";
        Long requestCount = 10L;
        RequestCountLimitDTO requestCountLimit = DtoFactory.createRequestCountLimitDTO((String)"min", (Integer)this.unitTime, (Long)requestCount);
        ThrottleLimitDTO defaultLimit = DtoFactory.createThrottleLimitDTO((ThrottleLimitDTO.TypeEnum)ThrottleLimitDTO.TypeEnum.REQUESTCOUNTLIMIT, (RequestCountLimitDTO)requestCountLimit, null);
        SubscriptionThrottlePolicyPermissionDTO permissions = new SubscriptionThrottlePolicyPermissionDTO().permissionType(SubscriptionThrottlePolicyPermissionDTO.PermissionTypeEnum.ALLOW).roles(Collections.singletonList("role1"));
        SubscriptionThrottlePolicyDTO requestCountPolicyDTO = DtoFactory.createSubscriptionThrottlePolicyDTO((String)policyName, (String)policyName, (String)"description", (boolean)true, (ThrottleLimitDTO)defaultLimit, (int)this.rateLimitCount, (String)"NA", (boolean)true, (SubscriptionThrottlePolicyPermissionDTO)permissions);
        ApiResponse addedPolicy = restAPIAdminTenant1.addSubscriptionThrottlingPolicy(requestCountPolicyDTO);
        Assert.assertEquals((int)addedPolicy.getStatusCode(), (int)201);
        this.testPolicyTenant1Restricted = (SubscriptionThrottlePolicyDTO)addedPolicy.getData();
        String policyId = this.testPolicyTenant1Restricted.getPolicyId();
        Assert.assertNotNull((Object)policyId, (String)"The policy ID cannot be null or empty");
    }

    public void createSubscriptionPolicyForTenant2Restricted() throws org.wso2.am.integration.clients.admin.ApiException {
        String policyName = "TestPolicyTenant2Restricted";
        Long requestCount = 10L;
        RequestCountLimitDTO requestCountLimit = DtoFactory.createRequestCountLimitDTO((String)"min", (Integer)this.unitTime, (Long)requestCount);
        ThrottleLimitDTO defaultLimit = DtoFactory.createThrottleLimitDTO((ThrottleLimitDTO.TypeEnum)ThrottleLimitDTO.TypeEnum.REQUESTCOUNTLIMIT, (RequestCountLimitDTO)requestCountLimit, null);
        SubscriptionThrottlePolicyPermissionDTO permissions = new SubscriptionThrottlePolicyPermissionDTO().permissionType(SubscriptionThrottlePolicyPermissionDTO.PermissionTypeEnum.ALLOW).roles(Collections.singletonList("role1"));
        SubscriptionThrottlePolicyDTO requestCountPolicyDTO = DtoFactory.createSubscriptionThrottlePolicyDTO((String)policyName, (String)policyName, (String)"description", (boolean)true, (ThrottleLimitDTO)defaultLimit, (int)this.rateLimitCount, (String)"NA", (boolean)true, (SubscriptionThrottlePolicyPermissionDTO)permissions);
        ApiResponse addedPolicy = restAPIAdminTenant2.addSubscriptionThrottlingPolicy(requestCountPolicyDTO);
        Assert.assertEquals((int)addedPolicy.getStatusCode(), (int)201);
        this.testPolicyTenant2Restricted = (SubscriptionThrottlePolicyDTO)addedPolicy.getData();
        String policyId = this.testPolicyTenant2Restricted.getPolicyId();
        Assert.assertNotNull((Object)policyId, (String)"The policy ID cannot be null or empty");
    }

    @Test(groups={"wso2.am"}, description="Check Visibility of API from cross Tenant")
    public void testVisibilityOfAPIFromOtherDomain() throws ApiException {
        APIListDTO allAPIs = apiStoreRestClientTenant1.getAllAPIs(tenant2Name);
        Assert.assertNotNull((Object)allAPIs);
        assert (allAPIs.getCount() != null);
        Assert.assertEquals((int)allAPIs.getCount(), (int)1);
        boolean found = false;
        assert (allAPIs.getList() != null);
        for (APIInfoDTO apiInfoDTO : allAPIs.getList()) {
            if (!this.apiId2.equals(apiInfoDTO.getId())) continue;
            found = true;
            break;
        }
        Assert.assertTrue((boolean)found, (String)("API with ID" + this.apiId1 + "not found"));
    }

    @Test(groups={"wso2.am"}, description="Check Visibility of API from cross Tenant")
    public void testVisibilityOfAPIFromOtherDomain2() throws ApiException {
        APIListDTO allAPIs = apiStoreRestClientTenant2.getAllAPIs(tenant1Name);
        Assert.assertNotNull((Object)allAPIs);
        assert (allAPIs.getCount() != null);
        Assert.assertEquals((int)allAPIs.getCount(), (int)1);
        boolean found = false;
        assert (allAPIs.getList() != null);
        for (APIInfoDTO apiInfoDTO : allAPIs.getList()) {
            if (!this.apiId1.equals(apiInfoDTO.getId())) continue;
            found = true;
            break;
        }
        Assert.assertTrue((boolean)found, (String)("API with ID" + this.apiId1 + "not found"));
    }

    @Test(groups={"wso2.am"}, description="Check Visibility of API from cross Tenant")
    public void testDirectAPIAvailability() throws ApiException {
        APIDTO api = apiStoreRestClientTenant1.getAPI(this.apiId2, tenant2Name);
        Assert.assertNotNull((Object)api);
        Assert.assertEquals((String)api.getName(), (String)"CrossTenantSubscriptionAPI");
    }

    @Test(groups={"wso2.am"}, description="Check Visibility of API from cross Tenant")
    public void testDirectAPIAvailability2() throws ApiException {
        APIDTO api = apiStoreRestClientTenant2.getAPI(this.apiId1, tenant1Name);
        Assert.assertNotNull((Object)api);
        Assert.assertEquals((String)api.getName(), (String)"CrossTenantSubscriptionAPI");
    }

    @Test(groups={"wso2.am"}, description="Check Visibility of ApplicationPolicy from cross Tenant")
    public void testApplicationPolicyAvailabilityInTenant2() throws ApiException {
        ThrottlingPolicyListDTO applicationPolicies = apiStoreRestClientTenant2.getApplicationPolicies(tenant1Name);
        Assert.assertNotNull((Object)applicationPolicies);
        boolean tenant1AppPolicyFound = false;
        boolean tenant2AppPolicyFound = false;
        assert (applicationPolicies.getList() != null);
        for (ThrottlingPolicyDTO applicationPolicy : applicationPolicies.getList()) {
            if ("Tenant1AppPolicy".equals(applicationPolicy.getName())) {
                tenant1AppPolicyFound = true;
            }
            if (!"Tenant2AppPolicy".equals(applicationPolicy.getName())) continue;
            tenant2AppPolicyFound = true;
        }
        Assert.assertTrue((boolean)tenant2AppPolicyFound, (String)"Tenant2AppPolicy didn't found");
        Assert.assertFalse((boolean)tenant1AppPolicyFound, (String)"Tenant1AppPolicy found");
    }

    @Test(groups={"wso2.am"}, description="Check Visibility of ApplicationPolicy from cross Tenant")
    public void testApplicationPolicyAvailabilityInTenant1() throws ApiException {
        ThrottlingPolicyListDTO applicationPolicies = apiStoreRestClientTenant1.getApplicationPolicies(tenant2Name);
        Assert.assertNotNull((Object)applicationPolicies);
        boolean tenant1AppPolicyFound = false;
        boolean tenant2AppPolicyFound = false;
        assert (applicationPolicies.getList() != null);
        for (ThrottlingPolicyDTO applicationPolicy : applicationPolicies.getList()) {
            if ("Tenant1AppPolicy".equals(applicationPolicy.getName())) {
                tenant1AppPolicyFound = true;
            }
            if (!"Tenant2AppPolicy".equals(applicationPolicy.getName())) continue;
            tenant2AppPolicyFound = true;
        }
        Assert.assertFalse((boolean)tenant2AppPolicyFound, (String)"Tenant2AppPolicy found");
        Assert.assertTrue((boolean)tenant1AppPolicyFound, (String)"Tenant1AppPolicy didn't found");
    }

    @Test(groups={"wso2.am"}, description="Check Visibility of SubscriptionPolicy from cross Tenant")
    public void testSubscriptionPolicyAvailabilityInTenant1() throws ApiException {
        APIDTO api = apiStoreRestClientTenant2.getAPI(this.apiId1, tenant1Name);
        Assert.assertNotNull((Object)api);
        boolean publicPolicyFound = false;
        boolean restrictedPolicyFound = false;
        List tiers = api.getTiers();
        assert (tiers != null);
        for (APITiersDTO tier : tiers) {
            if ("TestPolicyTenant1Public".equals(tier.getTierName())) {
                publicPolicyFound = true;
            }
            if (!"TestPolicyTenant1Restricted".equals(tier.getTierName())) continue;
            restrictedPolicyFound = true;
        }
        Assert.assertTrue((boolean)publicPolicyFound, (String)"TestPolicyTenant1Public not found");
        Assert.assertFalse((boolean)restrictedPolicyFound, (String)"TestPolicyTenant1Restricted found");
    }

    @Test(groups={"wso2.am"}, description="Check Visibility of SubscriptionPolicy from cross Tenant")
    public void testSubscriptionPolicyAvailabilityInTenant2() throws ApiException {
        APIDTO api = apiStoreRestClientTenant1.getAPI(this.apiId2, tenant2Name);
        Assert.assertNotNull((Object)api);
        boolean publicPolicyFound = false;
        boolean restrictedPolicyFound = false;
        List tiers = api.getTiers();
        assert (tiers != null);
        for (APITiersDTO tier : tiers) {
            if ("TestPolicyTenant2Public".equals(tier.getTierName())) {
                publicPolicyFound = true;
            }
            if (!"TestPolicyTenant2Restricted".equals(tier.getTierName())) continue;
            restrictedPolicyFound = true;
        }
        Assert.assertTrue((boolean)publicPolicyFound, (String)"TestPolicyTenant2Public not found");
        Assert.assertFalse((boolean)restrictedPolicyFound, (String)"TestPolicyTenant2Restricted found");
    }

    @Test(groups={"wso2.am"}, description="Create Application from other tenant")
    public void testCreateApplicationInTenant1FromTenant2User() throws APIManagerIntegrationTestException, ApiException {
        this.tenant2Application = apiStoreRestClientTenant2.addApplication("Tenant2App", "Tenant2AppPolicy", "", "");
        this.tenant3Application = apiStoreRestClientTenant2.addApplication("Tenant3App", "Tenant2AppPolicy", "", "");
    }

    @Test(groups={"wso2.am"}, description="Create Application from other tenant")
    public void testCreateApplicationInTenant2FromTenant1User() throws APIManagerIntegrationTestException, ApiException {
        this.tenant1Application = apiStoreRestClientTenant1.addApplication("Tenant1App", "Tenant1AppPolicy", "", "");
        this.tenant4Application = apiStoreRestClientTenant1.addApplication("Tenant4App", "Tenant1AppPolicy", "", "");
    }

    @Test(groups={"wso2.am"}, description="Create Application from other tenant using same tenant Application Policy")
    public void testCreateApplicationInTenant1FromTenant2UserNegative() throws APIManagerIntegrationTestException {
        try {
            apiStoreRestClientTenant2.applicationsPostWithHttpInfo("Tenant2AppNegative", "Tenant1AppPolicy", "");
            Assert.fail((String)"Application created with other tenant applicationPolicy");
        }
        catch (ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)400);
        }
    }

    @Test(groups={"wso2.am"}, description="Create Application from other tenant same tenant Application Policy")
    public void testCreateApplicationInTenant2FromTenant1UserNegative() throws APIManagerIntegrationTestException {
        try {
            apiStoreRestClientTenant1.applicationsPostWithHttpInfo("Tenant1AppNegative", "Tenant2AppPolicy", "");
            Assert.fail((String)"Application created with other tenant applicationPolicy");
        }
        catch (ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)400);
        }
    }

    @Test(groups={"wso2.am"}, description="Create Subscription to tenant1 API from Tenant2 App", dependsOnMethods={"testCreateApplicationInTenant1FromTenant2User", "testCreateApplicationInTenant2FromTenant1User"})
    public void testCreateSubscriptionFromTenant2AppToTenant1API() throws APIManagerIntegrationTestException, ApiException {
        apiStoreRestClientTenant2.subscribeToAPI(this.apiId1, this.tenant2Application.getApplicationId(), "TestPolicyTenant1Public", tenant1Name);
        apiStoreRestClientTenant2.subscribeToAPI(this.apiId2, this.tenant2Application.getApplicationId(), "TestPolicyTenant2Public", tenant2Name);
    }

    @Test(groups={"wso2.am"}, description="Create Subscription to tenant2 API from Tenant1 App", dependsOnMethods={"testCreateApplicationInTenant1FromTenant2User", "testCreateApplicationInTenant2FromTenant1User"})
    public void testCreateSubscriptionFromTenant1AppToTenant2API() throws APIManagerIntegrationTestException, ApiException {
        apiStoreRestClientTenant1.subscribeToAPI(this.apiId2, this.tenant1Application.getApplicationId(), "TestPolicyTenant2Public", tenant2Name);
        apiStoreRestClientTenant1.subscribeToAPI(this.apiId1, this.tenant1Application.getApplicationId(), "TestPolicyTenant1Public", tenant1Name);
    }

    @Test(groups={"wso2.am"}, description="Create Subscription to tenant1 API from Tenant2 App", dependsOnMethods={"testCreateApplicationInTenant1FromTenant2User", "testCreateApplicationInTenant2FromTenant1User"})
    public void testCreateSubscriptionFromTenant2AppToTenant1APIRestrictedPolicy() throws APIManagerIntegrationTestException {
        try {
            apiStoreRestClientTenant2.subscribeToAPI(this.apiId1, this.tenant3Application.getApplicationId(), "TestPolicyTenant1Restricted", tenant1Name);
            Assert.fail();
        }
        catch (ApiException e) {
            Assert.assertEquals((long)e.getCode(), (long)403L);
        }
    }

    @Test(groups={"wso2.am"}, description="Create Subscription to tenant2 API from Tenant1 App", dependsOnMethods={"testCreateApplicationInTenant1FromTenant2User", "testCreateApplicationInTenant2FromTenant1User"})
    public void testCreateSubscriptionFromTenant1AppToTenant2APIRestrictedPolicy() throws APIManagerIntegrationTestException {
        try {
            apiStoreRestClientTenant1.subscribeToAPI(this.apiId2, this.tenant4Application.getApplicationId(), "TestPolicyTenant2Restricted", tenant2Name);
            Assert.fail();
        }
        catch (ApiException e) {
            Assert.assertEquals((long)e.getCode(), (long)403L);
        }
    }

    @Test(groups={"wso2.am"}, description="Create Application from other tenant")
    public void getKeyManagersFromTenant1FromTenant2User() throws ApiException {
        KeyManagerListDTO keyManagers = apiStoreRestClientTenant2.getKeyManagers(tenant1Name);
        Assert.assertNotNull((Object)keyManagers);
        boolean tenant1KMFound = false;
        boolean tenant2KMFound = false;
        assert (keyManagers.getList() != null);
        for (org.wso2.am.integration.clients.store.api.v1.dto.KeyManagerInfoDTO keyManagerInfoDTO : keyManagers.getList()) {
            if (Objects.equals(this.keymanagerTenant1.getName(), keyManagerInfoDTO.getName()) && Objects.equals(this.keymanagerTenant1.getId(), keyManagerInfoDTO.getId())) {
                tenant1KMFound = true;
            }
            if (!Objects.equals(this.keymanagerTenant2.getName(), keyManagerInfoDTO.getName()) || !this.keymanagerTenant2.getId().equals(keyManagerInfoDTO.getId())) continue;
            tenant2KMFound = true;
        }
        Assert.assertTrue((boolean)tenant1KMFound, (String)"Tenant1 KM not found");
        Assert.assertFalse((boolean)tenant2KMFound, (String)"Tenant2 KM found");
    }

    @Test(groups={"wso2.am"}, description="Create Application from other tenant")
    public void getKeyManagersFromTenant2FromTenant1User() throws ApiException {
        KeyManagerListDTO keyManagers = apiStoreRestClientTenant1.getKeyManagers(tenant2Name);
        Assert.assertNotNull((Object)keyManagers);
        boolean tenant1KMFound = false;
        boolean tenant2KMFound = false;
        assert (keyManagers.getList() != null);
        for (org.wso2.am.integration.clients.store.api.v1.dto.KeyManagerInfoDTO keyManagerInfoDTO : keyManagers.getList()) {
            if (Objects.equals(this.keymanagerTenant2.getName(), keyManagerInfoDTO.getName()) && Objects.equals(this.keymanagerTenant2.getId(), keyManagerInfoDTO.getId())) {
                tenant2KMFound = true;
            }
            if (!Objects.equals(this.keymanagerTenant1.getName(), keyManagerInfoDTO.getName()) || !Objects.equals(this.keymanagerTenant1.getId(), keyManagerInfoDTO.getId())) continue;
            tenant1KMFound = true;
        }
        Assert.assertFalse((boolean)tenant1KMFound, (String)"Tenant1 KM found");
        Assert.assertTrue((boolean)tenant2KMFound, (String)"Tenant2 KM not found");
    }

    @Test(groups={"wso2.am"}, description="Create Application from other tenant", dependsOnMethods={"testCreateApplicationInTenant1FromTenant2User", "testCreateApplicationInTenant2FromTenant1User", "testCreateSubscriptionFromTenant2AppToTenant1API", "testCreateSubscriptionFromTenant1AppToTenant2API"})
    public void testGenerateKeysFromTenant1AppInTenant2Store() throws APIManagerIntegrationTestException, ApiException {
        this.tenant1AppTenant2Store = apiStoreRestClientTenant1.generateKeys(this.tenant1Application.getApplicationId(), "3600", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, new ArrayList(), Arrays.asList("client_credentials", "password"), this.residentKMTenant2);
        Assert.assertNotNull((Object)this.tenant1AppTenant2Store);
        Assert.assertNotNull((Object)this.tenant1AppTenant2Store.getConsumerKey());
        Assert.assertNotNull((Object)this.tenant1AppTenant2Store.getConsumerSecret());
    }

    @Test(groups={"wso2.am"}, description="Create Application from other tenant", dependsOnMethods={"testCreateApplicationInTenant1FromTenant2User", "testCreateApplicationInTenant2FromTenant1User", "testCreateSubscriptionFromTenant2AppToTenant1API", "testCreateSubscriptionFromTenant1AppToTenant2API"})
    public void testGenerateKeysFromTenant1AppInTenant1Store() throws APIManagerIntegrationTestException, ApiException {
        this.tenant1AppTenant1Store = apiStoreRestClientTenant1.generateKeys(this.tenant1Application.getApplicationId(), "3600", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, new ArrayList(), Arrays.asList("client_credentials", "password"), this.residentKMTenant1);
        Assert.assertNotNull((Object)this.tenant1AppTenant1Store);
        Assert.assertNotNull((Object)this.tenant1AppTenant1Store.getConsumerKey());
        Assert.assertNotNull((Object)this.tenant1AppTenant1Store.getConsumerSecret());
    }

    @Test(groups={"wso2.am"}, description="Create Application from other tenant", dependsOnMethods={"testCreateApplicationInTenant1FromTenant2User", "testCreateApplicationInTenant2FromTenant1User", "testGenerateKeysFromTenant1AppInTenant2Store", "testGenerateKeysFromTenant1AppInTenant1Store"})
    public void testRetrieveOauthKeysFromTenant1Store() throws ApiException {
        ApplicationKeyListDTO applicationOauthKeys = apiStoreRestClientTenant1.getApplicationOauthKeys(this.tenant1Application.getApplicationId(), tenant1Name);
        Assert.assertNotNull((Object)applicationOauthKeys);
        Assert.assertNotNull((Object)applicationOauthKeys.getList());
        boolean foundtenant1AppTenant1Store = false;
        boolean foundtenant1AppTenant2Store = false;
        for (ApplicationKeyDTO applicationKeyDTO : applicationOauthKeys.getList()) {
            if (this.tenant1AppTenant1Store.getConsumerKey().equals(applicationKeyDTO.getConsumerKey()) && this.tenant1AppTenant1Store.getKeyMappingId().equals(applicationKeyDTO.getKeyMappingId())) {
                foundtenant1AppTenant1Store = true;
            }
            if (!this.tenant1AppTenant2Store.getConsumerKey().equals(applicationKeyDTO.getConsumerKey()) || !this.tenant1AppTenant2Store.getKeyMappingId().equals(applicationKeyDTO.getKeyMappingId())) continue;
            foundtenant1AppTenant2Store = true;
        }
        Assert.assertTrue((boolean)foundtenant1AppTenant1Store, (String)"Tenant1 Application Keys can't see");
        Assert.assertFalse((boolean)foundtenant1AppTenant2Store, (String)"Tenant2 Application Keys can see");
    }

    @Test(groups={"wso2.am"}, description="Create Application from other tenant", dependsOnMethods={"testCreateApplicationInTenant1FromTenant2User", "testCreateApplicationInTenant2FromTenant1User", "testGenerateKeysFromTenant1AppInTenant2Store", "testGenerateKeysFromTenant1AppInTenant1Store"})
    public void testRetrieveOauthKeysFromTenant2() throws ApiException {
        ApplicationKeyListDTO applicationOauthKeys = apiStoreRestClientTenant1.getApplicationOauthKeys(this.tenant1Application.getApplicationId(), tenant2Name);
        Assert.assertNotNull((Object)applicationOauthKeys);
        Assert.assertNotNull((Object)applicationOauthKeys.getList());
        boolean foundtenant1AppTenant1Store = false;
        boolean foundtenant1AppTenant2Store = false;
        for (ApplicationKeyDTO applicationKeyDTO : applicationOauthKeys.getList()) {
            if (this.tenant1AppTenant1Store.getConsumerKey().equals(applicationKeyDTO.getConsumerKey()) && this.tenant1AppTenant1Store.getKeyMappingId().equals(applicationKeyDTO.getKeyMappingId())) {
                foundtenant1AppTenant1Store = true;
            }
            if (!this.tenant1AppTenant2Store.getConsumerKey().equals(applicationKeyDTO.getConsumerKey()) || !this.tenant1AppTenant2Store.getKeyMappingId().equals(applicationKeyDTO.getKeyMappingId())) continue;
            foundtenant1AppTenant2Store = true;
        }
        Assert.assertFalse((boolean)foundtenant1AppTenant1Store, (String)"Tenant2 Application Keys can see");
        Assert.assertTrue((boolean)foundtenant1AppTenant2Store, (String)"Tenant2 Application Keys can't see");
    }

    @Test(groups={"wso2.am"}, description="Create Application from other tenant", dependsOnMethods={"testCreateApplicationInTenant1FromTenant2User", "testCreateApplicationInTenant2FromTenant1User", "testGenerateKeysFromTenant1AppInTenant2Store", "testGenerateKeysFromTenant1AppInTenant1Store"})
    public void invokeFromTokenInSameTenant() throws IOException, APIManagerIntegrationTestException, JSONException, XPathExpressionException, ParseException {
        URL tokenEndpointURL = new URL(this.keyManagerHTTPSURL + "oauth2/token");
        String requestBody = "grant_type=client_credentials";
        HttpResponse httpResponse = apiStoreRestClientTenant1.generateUserAccessKey(this.tenant1AppTenant1Store.getConsumerKey(), this.tenant1AppTenant1Store.getConsumerSecret(), requestBody, tokenEndpointURL);
        JSONObject subsAccessTokenGenerationResponse = new JSONObject(httpResponse.getData());
        HashMap<String, String> requestHeader = new HashMap<String, String>();
        String accessToken = subsAccessTokenGenerationResponse.getString("access_token");
        requestHeader.put("Authorization", "Bearer " + accessToken);
        requestHeader.put("accept", "application/json");
        HttpResponse response = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttps("t/".concat(tenant1Name).concat("/").concat("crossTenantSubscriptionAPI"), "1.0.0") + "/menu"), requestHeader);
        Assert.assertEquals((int)response.getResponseCode(), (int)200);
        String opaqueToken = TokenUtils.getJtiOfJwtToken((String)accessToken);
        requestHeader.put("Authorization", "Bearer " + opaqueToken);
        response = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttps("t/".concat(tenant1Name).concat("/").concat("crossTenantSubscriptionAPI"), "1.0.0") + "/menu"), requestHeader);
        Assert.assertEquals((int)response.getResponseCode(), (int)200);
    }

    @Test(groups={"wso2.am"}, description="Create Application from other tenant", dependsOnMethods={"testCreateApplicationInTenant1FromTenant2User", "testCreateApplicationInTenant2FromTenant1User", "testGenerateKeysFromTenant1AppInTenant2Store", "testGenerateKeysFromTenant1AppInTenant1Store"})
    public void invokeFromTokenInOtherTenant() throws IOException, APIManagerIntegrationTestException, JSONException, XPathExpressionException, ParseException {
        URL tokenEndpointURL = new URL(this.keyManagerHTTPSURL + "oauth2/token");
        String requestBody = "grant_type=client_credentials";
        HttpResponse httpResponse = apiStoreRestClientTenant1.generateUserAccessKey(this.tenant1AppTenant2Store.getConsumerKey(), this.tenant1AppTenant2Store.getConsumerSecret(), requestBody, tokenEndpointURL);
        JSONObject subsAccessTokenGenerationResponse = new JSONObject(httpResponse.getData());
        HashMap<String, String> requestHeader = new HashMap<String, String>();
        String accessToken = subsAccessTokenGenerationResponse.getString("access_token");
        requestHeader.put("Authorization", "Bearer " + accessToken);
        requestHeader.put("accept", "application/json");
        HttpResponse response = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttps("t/".concat(tenant2Name).concat("/").concat("crossTenantSubscriptionAPI"), "1.0.0") + "/menu"), requestHeader);
        Assert.assertEquals((int)response.getResponseCode(), (int)200);
        String opaqueToken = TokenUtils.getJtiOfJwtToken((String)accessToken);
        requestHeader.put("Authorization", "Bearer " + opaqueToken);
        requestHeader.put("accept", "application/json");
        response = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttps("t/".concat(tenant2Name).concat("/").concat("crossTenantSubscriptionAPI"), "1.0.0") + "/menu"), requestHeader);
        Assert.assertEquals((int)response.getResponseCode(), (int)200);
    }

    @Test(groups={"wso2.am"}, description="Create Application from other tenant", dependsOnMethods={"testCreateApplicationInTenant1FromTenant2User", "testCreateApplicationInTenant2FromTenant1User", "testGenerateKeysFromTenant1AppInTenant2Store", "testGenerateKeysFromTenant1AppInTenant1Store"})
    public void testRetrieveSubscriptionsFromApplicationId() throws ApiException {
        SubscriptionListDTO allSubscriptionsOfApplication = apiStoreRestClientTenant1.getAllSubscriptionsOfApplication(this.tenant1Application.getApplicationId(), tenant1Name);
        Assert.assertNotNull((Object)allSubscriptionsOfApplication);
        Assert.assertNotNull((Object)allSubscriptionsOfApplication.getList());
        Assert.assertEquals((int)allSubscriptionsOfApplication.getCount(), (int)1);
        boolean foundAPI1 = false;
        boolean foundAPI2 = false;
        for (SubscriptionDTO subscriptionDTO : allSubscriptionsOfApplication.getList()) {
            if (this.apiId1.equals(subscriptionDTO.getApiId())) {
                foundAPI1 = true;
            }
            if (!this.apiId2.equals(subscriptionDTO.getApiId())) continue;
            foundAPI2 = true;
        }
        Assert.assertTrue((boolean)foundAPI1, (String)"Subscription for API1 not found");
        Assert.assertFalse((boolean)foundAPI2, (String)"Subscription for API2 found");
        ApplicationDTO applicationById = apiStoreRestClientTenant1.getApplicationById(this.tenant1Application.getApplicationId(), tenant2Name);
        Assert.assertNotNull((Object)applicationById);
        Assert.assertEquals((int)applicationById.getSubscriptionCount(), (int)1);
        applicationById = apiStoreRestClientTenant1.getApplicationById(this.tenant1Application.getApplicationId(), tenant1Name);
        Assert.assertNotNull((Object)applicationById);
        Assert.assertEquals((int)applicationById.getSubscriptionCount(), (int)1);
    }

    @Test(groups={"wso2.am"}, description="Create Application from other tenant", dependsOnMethods={"testCreateApplicationInTenant1FromTenant2User", "testCreateApplicationInTenant2FromTenant1User", "testGenerateKeysFromTenant1AppInTenant2Store", "testGenerateKeysFromTenant1AppInTenant1Store"})
    public void testRetrieveSubscriptionsFromApplicationId2() throws ApiException {
        SubscriptionListDTO allSubscriptionsOfApplication = apiStoreRestClientTenant1.getAllSubscriptionsOfApplication(this.tenant1Application.getApplicationId(), tenant2Name);
        Assert.assertNotNull((Object)allSubscriptionsOfApplication);
        Assert.assertNotNull((Object)allSubscriptionsOfApplication.getList());
        Assert.assertEquals((int)allSubscriptionsOfApplication.getCount(), (int)1);
        boolean foundAPI1 = false;
        boolean foundAPI2 = false;
        for (SubscriptionDTO subscriptionDTO : allSubscriptionsOfApplication.getList()) {
            if (this.apiId1.equals(subscriptionDTO.getApiId())) {
                foundAPI1 = true;
            }
            if (!this.apiId2.equals(subscriptionDTO.getApiId())) continue;
            foundAPI2 = true;
        }
        Assert.assertFalse((boolean)foundAPI1, (String)"Subscription for API1 found");
        Assert.assertTrue((boolean)foundAPI2, (String)"Subscription for API2 not found");
        ApplicationDTO applicationById = apiStoreRestClientTenant2.getApplicationById(this.tenant2Application.getApplicationId(), tenant2Name);
        Assert.assertNotNull((Object)applicationById);
        Assert.assertEquals((int)applicationById.getSubscriptionCount(), (int)1);
        applicationById = apiStoreRestClientTenant2.getApplicationById(this.tenant2Application.getApplicationId(), tenant1Name);
        Assert.assertNotNull((Object)applicationById);
        Assert.assertEquals((int)applicationById.getSubscriptionCount(), (int)1);
    }

    @AfterClass(alwaysRun=true)
    public void destroyAPIs() throws Exception {
        apiStoreRestClientTenant1.deleteApplication(this.tenant1Application.getApplicationId());
        apiStoreRestClientTenant2.deleteApplication(this.tenant2Application.getApplicationId());
        apiStoreRestClientTenant2.deleteApplication(this.tenant3Application.getApplicationId());
        apiStoreRestClientTenant1.deleteApplication(this.tenant4Application.getApplicationId());
        apiPublisherRestClientTenant1.deleteAPI(this.apiId1);
        apiPublisherRestClientTenant2.deleteAPI(this.apiId2);
        restAPIAdminTenant1.deleteApplicationThrottlingPolicy(this.policyIdTenant1);
        restAPIAdminTenant2.deleteApplicationThrottlingPolicy(this.policyIdTenant2);
        restAPIAdminTenant1.deleteSubscriptionThrottlingPolicy(this.testPolicyTenant1Restricted.getPolicyId());
        restAPIAdminTenant1.deleteSubscriptionThrottlingPolicy(this.testPolicyTenant1Public.getPolicyId());
        restAPIAdminTenant2.deleteSubscriptionThrottlingPolicy(this.testPolicyTenant2Restricted.getPolicyId());
        restAPIAdminTenant2.deleteSubscriptionThrottlingPolicy(this.testPolicyTenant2Public.getPolicyId());
        restAPIAdminTenant1.deleteKeyManager(this.keymanagerTenant1.getId());
        restAPIAdminTenant2.deleteKeyManager(this.keymanagerTenant2.getId());
        this.tenant1UserStoreManager.deleteRole("role1");
        this.tenant2UserStoreManager.deleteRole("role1");
        this.tenantManagementServiceClient.deleteTenant(tenant1Name);
        this.tenantManagementServiceClient.deleteTenant(tenant2Name);
        super.cleanUp();
    }
}

