/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.graphql;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.eclipse.jetty.websocket.server.WebSocketHandler;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.json.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.admin.ApiResponse;
import org.wso2.am.integration.clients.admin.api.dto.AdvancedThrottlePolicyDTO;
import org.wso2.am.integration.clients.admin.api.dto.RequestCountLimitDTO;
import org.wso2.am.integration.clients.admin.api.dto.SubscriptionThrottlePolicyDTO;
import org.wso2.am.integration.clients.admin.api.dto.ThrottleLimitDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIScopeDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.GraphQLCustomComplexityInfoDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.GraphQLQueryComplexityInfoDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.GraphQLSchemaTypeDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.GraphQLSchemaTypeListDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.GraphQLValidationResponseDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.GraphQLValidationResponseGraphQLInfoDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.ScopeDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APIListDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SubscriptionDTO;
import org.wso2.am.integration.test.impl.DtoFactory;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.am.integration.tests.graphql.websocket.client.SubscriptionWSClientImpl;
import org.wso2.am.integration.tests.graphql.websocket.server.SubscriptionServerCreator;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.utils.xml.StringUtils;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class GraphqlSubscriptionTestCase
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(GraphqlSubscriptionTestCase.class);
    private static final String GRAPHQL_ROLE = "graphqlSubRole";
    private static final String GRAPHQL_TEST_USER = "graphqlSubUser";
    private static final String GRAPHQL_TEST_USER_PASSWORD = "graphqlSubUser";
    private static final String GRAPHQL_API_NAME = "SnowtoothGraphQLSubAPI";
    private static final String GRAPHQL_API_CONTEXT = "snowtooth";
    private static final String GRAPHQL_API_VERSION = "1.0.0";
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private int webSocketServerPort;
    private String webSocketServerHost;
    private String graphqlApiId;
    private String apiEndPoint;
    String appJWTId;
    ApplicationKeyDTO applicationKeyDTO;
    String throttleAppId;
    String complexAppId;
    String depthAppId;

    @Factory(dataProvider="userModeDataProvider")
    public GraphqlSubscriptionTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.userManagementClient.addUser("graphqlSubUser", "graphqlSubUser", new String[0], null);
        this.userManagementClient.addRole(GRAPHQL_ROLE, new String[]{"graphqlSubUser"}, new String[0]);
        this.webSocketServerHost = InetAddress.getLocalHost().getHostName();
        int lowerPortLimit = 9950;
        int upperPortLimit = 9999;
        this.webSocketServerPort = this.getAvailablePort(lowerPortLimit, upperPortLimit);
        if (this.webSocketServerPort == -1) {
            throw new APIManagerIntegrationTestException("No available port in the range " + lowerPortLimit + "-" + upperPortLimit + " was found");
        }
        log.info((Object)("Selected port " + this.webSocketServerPort + " to start graphql subscription backend server"));
        this.startGraphQLSubscriptionServer(this.webSocketServerPort);
    }

    @Test(groups={"wso2.am"}, description="Publish GraphQL API with Subscriptions")
    public void publishGraphQLAPIWithSubscriptions() throws Exception {
        String arrayToJson = null;
        String schemaDefinition = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("graphql" + File.separator + "subscriptions" + File.separator + "schema.graphql"), (Charset)StandardCharsets.UTF_8);
        File file = this.getTempFileWithContent(schemaDefinition);
        GraphQLValidationResponseDTO responseApiDto = this.restAPIPublisher.validateGraphqlSchemaDefinition(file);
        GraphQLValidationResponseGraphQLInfoDTO graphQLInfo = responseApiDto.getGraphQLInfo();
        if (graphQLInfo != null) {
            arrayToJson = new ObjectMapper().writeValueAsString((Object)graphQLInfo.getOperations());
        }
        JSONArray operations = new JSONArray(arrayToJson);
        SubscriptionThrottlePolicyDTO subscriptionThrottlePolicyDTO = new SubscriptionThrottlePolicyDTO();
        this.createNewComplexSubscriptionPolicyObject(subscriptionThrottlePolicyDTO);
        ApiResponse response = this.restAPIAdmin.addSubscriptionThrottlingPolicy(subscriptionThrottlePolicyDTO);
        Assert.assertEquals((int)response.getStatusCode(), (int)201);
        SubscriptionThrottlePolicyDTO addedSubPolicy = (SubscriptionThrottlePolicyDTO)response.getData();
        String subPolicyPolicyId = addedSubPolicy.getPolicyId();
        Assert.assertNotNull((Object)subPolicyPolicyId, (String)"The policy ID cannot be null or empty");
        subscriptionThrottlePolicyDTO = new SubscriptionThrottlePolicyDTO();
        this.createNewDepthSubscriptionPolicyObject(subscriptionThrottlePolicyDTO);
        response = this.restAPIAdmin.addSubscriptionThrottlingPolicy(subscriptionThrottlePolicyDTO);
        Assert.assertEquals((int)response.getStatusCode(), (int)201);
        addedSubPolicy = (SubscriptionThrottlePolicyDTO)response.getData();
        subPolicyPolicyId = addedSubPolicy.getPolicyId();
        Assert.assertNotNull((Object)subPolicyPolicyId, (String)"The policy ID cannot be null or empty");
        ArrayList<String> policies = new ArrayList<String>();
        policies.add("Unlimited");
        policies.add("QueryComplexPolicy");
        policies.add("QueryDepthPolicy");
        org.json.JSONObject additionalPropertiesObj = new org.json.JSONObject();
        additionalPropertiesObj.put("name", (Object)GRAPHQL_API_NAME);
        additionalPropertiesObj.put("context", (Object)GRAPHQL_API_CONTEXT);
        additionalPropertiesObj.put("version", (Object)GRAPHQL_API_VERSION);
        org.json.JSONObject url = new org.json.JSONObject();
        url.put("url", (Object)("http://" + this.webSocketServerHost + ":" + this.webSocketServerPort));
        org.json.JSONObject endpointConfig = new org.json.JSONObject();
        endpointConfig.put("endpoint_type", (Object)"http");
        endpointConfig.put("sandbox_endpoints", (Object)url);
        endpointConfig.put("production_endpoints", (Object)url);
        additionalPropertiesObj.put("endpointConfig", (Object)endpointConfig);
        additionalPropertiesObj.put("policies", policies);
        additionalPropertiesObj.put("operations", (Object)operations);
        APIDTO apidto = this.restAPIPublisher.importGraphqlSchemaDefinition(file, additionalPropertiesObj.toString());
        this.graphqlApiId = apidto.getId();
        HttpResponse createdApiResponse = this.restAPIPublisher.getAPI(this.graphqlApiId);
        System.out.println(createdApiResponse.getData());
        Assert.assertEquals((int)Response.Status.OK.getStatusCode(), (int)createdApiResponse.getResponseCode(), (String)"SnowtoothGraphQLSubAPI API creation is failed");
        this.createAPIRevisionAndDeployUsingRest(this.graphqlApiId, this.restAPIPublisher);
        this.restAPIPublisher.changeAPILifeCycleStatus(this.graphqlApiId, "Publish");
        this.waitForAPIDeploymentSync(this.user.getUserName(), GRAPHQL_API_NAME, GRAPHQL_API_VERSION, "\"isApiExists\":true");
        this.apiEndPoint = TestUserMode.SUPER_TENANT_ADMIN.equals((Object)this.userMode) || TestUserMode.SUPER_TENANT_USER.equals((Object)this.userMode) ? this.getWebSocketAPIInvocationURL(GRAPHQL_API_CONTEXT, GRAPHQL_API_VERSION) : this.getWebSocketTenantAPIInvocationURL(GRAPHQL_API_CONTEXT, GRAPHQL_API_VERSION, this.user.getUserDomain());
        log.info((Object)("API Endpoint URL" + this.apiEndPoint));
        APIIdentifier apiIdentifierWebSocket = new APIIdentifier(this.user.getUserName(), GRAPHQL_API_NAME, GRAPHQL_API_VERSION);
        org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO apiPublisherAllAPIs = this.restAPIPublisher.getAllAPIs();
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)apiIdentifierWebSocket, (org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO)apiPublisherAllAPIs), (String)"Published API is visible in API Publisher.");
        APIListDTO restAPIStoreAllAPIs = TestUserMode.SUPER_TENANT_ADMIN == this.userMode ? this.restAPIStore.getAllAPIs() : this.restAPIStore.getAllAPIs(this.user.getUserDomain());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailableInStore((APIIdentifier)apiIdentifierWebSocket, (APIListDTO)restAPIStoreAllAPIs), (String)"Published API is visible in Dev Portal.");
    }

    @Test(description="Create JWT Type Application and subscribe", dependsOnMethods={"publishGraphQLAPIWithSubscriptions"})
    public void testGraphQLAPIJWTApplicationSubscription() throws Exception {
        String applicationName = "GraphQLSubApplication";
        HttpResponse applicationResponse = this.restAPIStore.createApplication(applicationName, "", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
        this.appJWTId = applicationResponse.getData();
        SubscriptionDTO subscriptionDTO = this.restAPIStore.subscribeToAPI(this.graphqlApiId, this.appJWTId, "Unlimited");
        Assert.assertEquals((Object)subscriptionDTO.getStatus(), (Object)SubscriptionDTO.StatusEnum.UNBLOCKED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"wso2.am"}, description="Invoke Subscriptions using token", dependsOnMethods={"testGraphQLAPIJWTApplicationSubscription"})
    public void testGraphQLAPIInvocationWithJWTToken() throws Exception {
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("password");
        grantTypes.add("refresh_token");
        grantTypes.add("client_credentials");
        this.applicationKeyDTO = this.restAPIStore.generateKeys(this.appJWTId, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        WebSocketClient client = new WebSocketClient();
        try {
            Assert.assertNotNull((Object)this.applicationKeyDTO.getToken());
            this.invokeGraphQLSubscriptionSuccess(client, this.applicationKeyDTO.getToken().getAccessToken(), AUTH_IN.HEADER);
            this.invokeGraphQLSubscriptionSuccess(client, this.applicationKeyDTO.getToken().getAccessToken(), AUTH_IN.QUERY);
        }
        catch (Exception e) {
            log.error((Object)"Exception in connecting to server", (Throwable)e);
            Assert.fail((String)"Client cannot connect to server");
        }
        finally {
            client.stop();
        }
    }

    @Test(description="Invoke subscription with invalid payload", dependsOnMethods={"testGraphQLAPIInvocationWithJWTToken"})
    public void testGraphQLAPIInvocationWithInvalidPayload() throws Exception {
        WebSocketClient client = new WebSocketClient();
        try {
            this.invokeGraphQLSubscriptionForInvalidPayloadError(client, this.applicationKeyDTO.getToken().getAccessToken());
        }
        catch (Exception e) {
            log.error((Object)"Exception in connecting to server", (Throwable)e);
            Assert.fail((String)"Client cannot connect to server");
        }
        finally {
            client.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"wso2.am"}, description="Invoke Subscriptions for complexity", dependsOnMethods={"testGraphQLAPIInvocationWithJWTToken"})
    public void testGraphQLAPIInvocationForComplexity() throws Exception {
        GraphQLSchemaTypeListDTO graphQLSchemaTypeList = this.restAPIPublisher.getGraphQLSchemaTypeList(this.graphqlApiId);
        HttpResponse response = this.restAPIPublisher.getGraphQLSchemaTypeListResponse(this.graphqlApiId);
        Assert.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getResponseCode());
        List list = graphQLSchemaTypeList.getTypeList();
        ArrayList<GraphQLCustomComplexityInfoDTO> complexityList = new ArrayList<GraphQLCustomComplexityInfoDTO>();
        for (GraphQLSchemaTypeDTO graphQLSchemaTypeDTO : list) {
            List fieldList = graphQLSchemaTypeDTO.getFieldList();
            for (String field : fieldList) {
                GraphQLCustomComplexityInfoDTO graphQLCustomComplexityInfoDTO = new GraphQLCustomComplexityInfoDTO();
                graphQLCustomComplexityInfoDTO.setType(graphQLSchemaTypeDTO.getType());
                graphQLCustomComplexityInfoDTO.setField(field);
                graphQLCustomComplexityInfoDTO.setComplexityValue(Integer.valueOf(1));
                log.info((Object)graphQLCustomComplexityInfoDTO);
                complexityList.add(graphQLCustomComplexityInfoDTO);
            }
        }
        GraphQLQueryComplexityInfoDTO graphQLQueryComplexityInfoDTO = new GraphQLQueryComplexityInfoDTO();
        graphQLQueryComplexityInfoDTO.setList(complexityList);
        this.restAPIPublisher.addGraphQLComplexityDetails(graphQLQueryComplexityInfoDTO, this.graphqlApiId);
        this.createAPIRevisionAndDeployUsingRest(this.graphqlApiId, this.restAPIPublisher);
        Thread.sleep(10000L);
        this.waitForAPIDeploymentSync(this.user.getUserName(), GRAPHQL_API_NAME, GRAPHQL_API_VERSION, "\"isApiExists\":true");
        HttpResponse complexityResponse = this.restAPIPublisher.getGraphQLComplexityResponse(this.graphqlApiId);
        Assert.assertEquals((int)Response.Status.OK.getStatusCode(), (int)complexityResponse.getResponseCode());
        ApplicationDTO applicationDTO = this.restAPIStore.addApplicationWithTokenType("GraphQLSubComplexApp", "Unlimited", "", "complexity analysis test-app", ApplicationDTO.TokenTypeEnum.JWT.toString());
        this.complexAppId = applicationDTO.getApplicationId();
        SubscriptionDTO subscriptionDTO = this.restAPIStore.subscribeToAPI(this.graphqlApiId, this.complexAppId, "QueryComplexPolicy");
        Assert.assertEquals((String)subscriptionDTO.getThrottlingPolicy(), (String)"QueryComplexPolicy");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("password");
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(applicationDTO.getApplicationId(), "36000", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        String accessToken = applicationKeyDTO.getToken().getAccessToken();
        WebSocketClient client = new WebSocketClient();
        try {
            this.invokeGraphQLSubscriptionSuccess(client, accessToken, AUTH_IN.HEADER);
            this.invokeGraphQLSubscriptionForComplexityError(client, accessToken);
        }
        catch (Exception e) {
            log.error((Object)"Exception in connecting to server", (Throwable)e);
            Assert.fail((String)"Client cannot connect to server");
        }
        finally {
            client.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"wso2.am"}, description="Invoke Subscriptions for depth", dependsOnMethods={"testGraphQLAPIInvocationForComplexity"})
    public void testGraphQLAPIInvocationForDepth() throws Exception {
        ApplicationDTO applicationDTO = this.restAPIStore.addApplicationWithTokenType("GraphQLSubDepthApp", "Unlimited", "", "depth analysis test-app", ApplicationDTO.TokenTypeEnum.JWT.toString());
        SubscriptionDTO subscriptionDTO = this.restAPIStore.subscribeToAPI(this.graphqlApiId, applicationDTO.getApplicationId(), "QueryDepthPolicy");
        Assert.assertEquals((String)subscriptionDTO.getThrottlingPolicy(), (String)"QueryDepthPolicy");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("password");
        grantTypes.add("client_credentials");
        this.complexAppId = applicationDTO.getApplicationId();
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.complexAppId, "36000", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        String accessToken = applicationKeyDTO.getToken().getAccessToken();
        WebSocketClient client = new WebSocketClient();
        try {
            this.invokeGraphQLSubscriptionForDepthError(client, accessToken);
        }
        catch (Exception e) {
            log.error((Object)"Exception in connecting to server", (Throwable)e);
            Assert.fail((String)"Client cannot connect to server");
        }
        finally {
            client.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"wso2.am"}, description="Invoke Subscriptions using token", dependsOnMethods={"testGraphQLAPIInvocationForDepth"})
    public void testGraphQLAPIInvocationWithScopes() throws Exception {
        ArrayList<String> role = new ArrayList<String>();
        role.add(GRAPHQL_ROLE);
        ScopeDTO scopeObject = new ScopeDTO();
        scopeObject.setName("subscriber");
        scopeObject.setBindings(role);
        APIScopeDTO apiScopeDTO = new APIScopeDTO();
        apiScopeDTO.setScope(scopeObject);
        ArrayList<APIScopeDTO> apiScopeList = new ArrayList<APIScopeDTO>();
        apiScopeList.add(apiScopeDTO);
        HttpResponse createdApiResponse = this.restAPIPublisher.getAPI(this.graphqlApiId);
        Gson g = new Gson();
        APIDTO apidto = (APIDTO)g.fromJson(createdApiResponse.getData(), APIDTO.class);
        apidto.setScopes(apiScopeList);
        ArrayList<String> scope = new ArrayList<String>();
        scope.add("subscriber");
        List operations = apidto.getOperations();
        operations.forEach(item -> {
            if (item.getTarget().equals("liftStatusChange")) {
                item.setScopes(scope);
            }
        });
        apidto.operations(operations);
        this.restAPIPublisher.updateAPI(apidto, this.graphqlApiId);
        this.createAPIRevisionAndDeployUsingRest(this.graphqlApiId, this.restAPIPublisher);
        Thread.sleep(20000L);
        this.waitForAPIDeploymentSync(apidto.getProvider(), apidto.getName(), apidto.getVersion(), "\"isApiExists\":true");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("password");
        grantTypes.add("refresh_token");
        grantTypes.add("client_credentials");
        log.info((Object)("Access Token response without scope: " + this.applicationKeyDTO.getToken().getAccessToken()));
        WebSocketClient client = new WebSocketClient();
        try {
            this.invokeGraphQLSubscriptionScopeInvalidError(client, this.applicationKeyDTO.getToken().getAccessToken());
        }
        catch (Exception e) {
            log.error((Object)"Exception in connecting to server", (Throwable)e);
            Assert.fail((String)"Client cannot connect to server");
        }
        finally {
            client.stop();
        }
        String consumerKey = this.applicationKeyDTO.getConsumerKey();
        String consumerSecret = this.applicationKeyDTO.getConsumerSecret();
        URL tokenEndpointURL = new URL(this.keyManagerHTTPSURL + "oauth2/token");
        String username = "graphqlSubUser";
        if (this.userMode != TestUserMode.SUPER_TENANT_ADMIN) {
            username = username.concat("@").concat(this.user.getUserDomain());
        }
        String requestBody = "grant_type=password&username=" + username + "&password=" + "graphqlSubUser" + "&scope=subscriber";
        HttpResponse response = this.restAPIStore.generateUserAccessKey(consumerKey, consumerSecret, requestBody, tokenEndpointURL);
        org.json.JSONObject accessTokenGenerationResponse = new org.json.JSONObject(response.getData());
        log.info((Object)("Access Token response with scope: " + response.getData()));
        String accessToken = accessTokenGenerationResponse.getString("access_token");
        try {
            this.invokeGraphQLSubscriptionSuccess(client, accessToken, AUTH_IN.HEADER);
        }
        catch (Exception e) {
            log.error((Object)"Exception in connecting to server", (Throwable)e);
            Assert.fail((String)"Client cannot connect to server");
        }
        finally {
            client.stop();
        }
        createdApiResponse = this.restAPIPublisher.getAPI(this.graphqlApiId);
        apidto = (APIDTO)g.fromJson(createdApiResponse.getData(), APIDTO.class);
        apidto.setScopes(null);
        operations = apidto.getOperations();
        operations.forEach(item -> {
            if (item.getTarget().equals("liftStatusChange")) {
                item.setScopes(null);
            }
        });
        apidto.operations(operations);
        this.restAPIPublisher.updateAPI(apidto, this.graphqlApiId);
        this.createAPIRevisionAndDeployUsingRest(this.graphqlApiId, this.restAPIPublisher);
        Thread.sleep(20000L);
        this.waitForAPIDeploymentSync(apidto.getProvider(), apidto.getName(), apidto.getVersion(), "\"isApiExists\":true");
    }

    @Test(groups={"wso2.am"}, description="Invoke Subscriptions for throttling", dependsOnMethods={"testGraphQLAPIInvocationWithScopes"})
    public void testGraphQLAPISubscriptionThrottling() throws Exception {
        InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("graphql" + File.separator + "subscriptions" + File.separator + "policy.json");
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonMap = mapper.readTree(inputStream);
        String policyName = jsonMap.get("policyName").textValue();
        String policyDescription = jsonMap.get("policyDescription").textValue();
        JsonNode defaultLimitJson = jsonMap.get("defaultLimit");
        JsonNode requestCountJson = defaultLimitJson.get("requestCount");
        Long requestCountLimit = Long.valueOf(String.valueOf(requestCountJson.get("requestCount")));
        String timeUnit = requestCountJson.get("timeUnit").textValue();
        Integer unitTime = Integer.valueOf(String.valueOf(requestCountJson.get("unitTime")));
        RequestCountLimitDTO requestCountLimitDTO = DtoFactory.createRequestCountLimitDTO((String)timeUnit, (Integer)unitTime, (Long)requestCountLimit);
        ThrottleLimitDTO defaultLimit = DtoFactory.createThrottleLimitDTO((ThrottleLimitDTO.TypeEnum)ThrottleLimitDTO.TypeEnum.REQUESTCOUNTLIMIT, (RequestCountLimitDTO)requestCountLimitDTO, null);
        AdvancedThrottlePolicyDTO advancedThrottlePolicyDTO = DtoFactory.createAdvancedThrottlePolicyDTO((String)policyName, (String)"", (String)policyDescription, (boolean)false, (ThrottleLimitDTO)defaultLimit, new ArrayList());
        ApiResponse addedPolicy = this.restAPIAdmin.addAdvancedThrottlingPolicy(advancedThrottlePolicyDTO);
        Assert.assertEquals((int)addedPolicy.getStatusCode(), (int)201);
        AdvancedThrottlePolicyDTO addedAdvancedPolicyDTO = (AdvancedThrottlePolicyDTO)addedPolicy.getData();
        String apiPolicyId = addedAdvancedPolicyDTO.getPolicyId();
        Assert.assertNotNull((Object)apiPolicyId, (String)"The policy ID cannot be null or empty");
        HttpResponse response = this.restAPIPublisher.getAPI(this.graphqlApiId);
        Gson g = new Gson();
        APIDTO apidto = (APIDTO)g.fromJson(response.getData(), APIDTO.class);
        apidto.setApiThrottlingPolicy("GraphQLSubThrottlingPolicy");
        APIDTO updatedAPI = this.restAPIPublisher.updateAPI(apidto);
        this.createAPIRevisionAndDeployUsingRest(updatedAPI.getId(), this.restAPIPublisher);
        this.waitForAPIDeploymentSync(this.user.getUserName(), apidto.getName(), apidto.getVersion(), "\"isApiExists\":true");
        Assert.assertEquals((String)updatedAPI.getApiThrottlingPolicy(), (String)"GraphQLSubThrottlingPolicy");
        ApplicationDTO applicationDTO = this.restAPIStore.addApplicationWithTokenType("GraphQLThrottleApp", "Unlimited", "", "advanced throttle test-app", ApplicationDTO.TokenTypeEnum.JWT.toString());
        this.throttleAppId = applicationDTO.getApplicationId();
        SubscriptionDTO subscriptionDTO = this.restAPIStore.subscribeToAPI(this.graphqlApiId, this.throttleAppId, "Unlimited");
        Assert.assertEquals((String)subscriptionDTO.getThrottlingPolicy(), (String)"Unlimited");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("password");
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(applicationDTO.getApplicationId(), "36000", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        String accessToken = applicationKeyDTO.getToken().getAccessToken();
        this.testThrottling(accessToken);
    }

    private void invokeGraphQLSubscriptionSuccess(WebSocketClient client, String accessToken, AUTH_IN in) throws Exception {
        SubscriptionWSClientImpl socket = new SubscriptionWSClientImpl();
        client.start();
        ClientUpgradeRequest request = new ClientUpgradeRequest();
        URI echoUri = null;
        request.setSubProtocols(new String[]{"graphql-ws"});
        if (AUTH_IN.HEADER == in) {
            request.setHeader("Authorization", "Bearer " + accessToken);
            echoUri = new URI(this.apiEndPoint);
        } else if (AUTH_IN.QUERY == in) {
            echoUri = new URI(this.apiEndPoint + "?access_token=" + accessToken);
        }
        client.connect((Object)socket, echoUri, request);
        if (!socket.getLatch().await(30L, TimeUnit.SECONDS)) {
            throw new APIManagerIntegrationTestException("Unable to create client connection");
        }
        String textMessage = "{\"type\":\"connection_init\",\"payload\":{}}";
        Thread.sleep(20000L);
        socket.sendMessage(textMessage);
        this.waitForReply(socket);
        Thread.sleep(40000L);
        Assert.assertFalse((boolean)StringUtils.isEmpty((String)socket.getResponseMessage()), (String)"Client did not receive response from server");
        Assert.assertEquals((String)socket.getResponseMessage(), (String)"{\"type\":\"connection_ack\"}", (String)"Received response in not a Connection Ack response");
        socket.setResponseMessage(null);
        textMessage = "{\"id\":\"1\",\"type\":\"start\",\"payload\":{\"variables\":{},\"extensions\":{},\"operationName\":null,\"query\":\"subscription {\\n  liftStatusChange {\\n    name\\n  }\\n}\\n\"}}";
        socket.sendMessage(textMessage);
        this.waitForReply(socket);
        Assert.assertFalse((boolean)StringUtils.isEmpty((String)socket.getResponseMessage()), (String)"Client did not receive response from server");
        Assert.assertEquals((String)socket.getResponseMessage(), (String)"{\"type\":\"data\",\"id\":\"1\",\"payload\":{\"data\":{\"liftStatusChange\":{\"name\":\"Astra Express\"}}}}", (String)"Received response in not a lift status change sub topic event response");
        socket.setResponseMessage(null);
    }

    private void startGraphQLSubscriptionServer(int serverPort) {
        this.executorService.execute(() -> {
            WebSocketHandler wsHandler = new WebSocketHandler(){

                public void configure(WebSocketServletFactory factory) {
                    factory.setCreator((WebSocketCreator)new SubscriptionServerCreator());
                }
            };
            Server server = new Server(serverPort);
            server.setHandler((Handler)wsHandler);
            try {
                server.start();
                log.info((Object)("GraphQL WebSocket backend server started at port: " + serverPort));
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception e) {
                log.error((Object)("Error while starting graphql backend server at port: " + serverPort), (Throwable)e);
                Assert.fail((String)"Cannot start GraphQL WebSocket server");
            }
        });
    }

    protected int getAvailablePort(int lowerPortLimit, int upperPortLimit) {
        while (lowerPortLimit < upperPortLimit) {
            if (this.isPortFree(lowerPortLimit)) {
                return lowerPortLimit;
            }
            ++lowerPortLimit;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPortFree(int port) {
        Socket s = null;
        try {
            s = new Socket("localhost", port);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            boolean bl = true;
            return bl;
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to close connection ", e);
                }
            }
        }
    }

    private File getTempFileWithContent(String schema) throws Exception {
        File temp = File.createTempFile("schema", ".graphql");
        temp.deleteOnExit();
        BufferedWriter out = new BufferedWriter(new FileWriter(temp));
        out.write(schema);
        out.close();
        return temp;
    }

    private void waitForReply(SubscriptionWSClientImpl clientSocket) {
        long currentTime = System.currentTimeMillis();
        long WAIT_TIME = 30000L;
        long waitTime = currentTime + WAIT_TIME;
        while (StringUtils.isEmpty((String)clientSocket.getResponseMessage()) && waitTime > System.currentTimeMillis()) {
            try {
                log.info((Object)"Waiting for reply from server:");
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        log.info((Object)("Client received :" + clientSocket.getResponseMessage()));
    }

    private void createNewComplexSubscriptionPolicyObject(SubscriptionThrottlePolicyDTO subscriptionThrottlePolicyDTO) {
        subscriptionThrottlePolicyDTO.setPolicyName("QueryComplexPolicy");
        subscriptionThrottlePolicyDTO.setDisplayName("QueryComplexPolicy");
        subscriptionThrottlePolicyDTO.setDescription("Policy to test query complexity");
        subscriptionThrottlePolicyDTO.setRateLimitCount(Integer.valueOf(100));
        subscriptionThrottlePolicyDTO.setRateLimitTimeUnit("min");
        subscriptionThrottlePolicyDTO.setBillingPlan("COMMERCIAL");
        subscriptionThrottlePolicyDTO.setStopOnQuotaReach(Boolean.valueOf(true));
        subscriptionThrottlePolicyDTO.setIsDeployed(Boolean.valueOf(true));
        subscriptionThrottlePolicyDTO.setGraphQLMaxComplexity(Integer.valueOf(3));
        subscriptionThrottlePolicyDTO.setGraphQLMaxDepth(Integer.valueOf(2));
        subscriptionThrottlePolicyDTO.setSubscriberCount(Integer.valueOf(0));
        ThrottleLimitDTO throttleLimitDTO = new ThrottleLimitDTO();
        throttleLimitDTO.setType(ThrottleLimitDTO.TypeEnum.valueOf((String)"REQUESTCOUNTLIMIT"));
        RequestCountLimitDTO requestCountLimitDTO = new RequestCountLimitDTO();
        requestCountLimitDTO.setRequestCount(Long.valueOf(1000L));
        requestCountLimitDTO.setTimeUnit("min");
        requestCountLimitDTO.setUnitTime(Integer.valueOf(10));
        throttleLimitDTO.setRequestCount(requestCountLimitDTO);
        subscriptionThrottlePolicyDTO.setDefaultLimit(throttleLimitDTO);
    }

    private void createNewDepthSubscriptionPolicyObject(SubscriptionThrottlePolicyDTO subscriptionThrottlePolicyDTO) {
        subscriptionThrottlePolicyDTO.setPolicyName("QueryDepthPolicy");
        subscriptionThrottlePolicyDTO.setDisplayName("QueryDepthPolicy");
        subscriptionThrottlePolicyDTO.setDescription("Policy to test query depth");
        subscriptionThrottlePolicyDTO.setRateLimitCount(Integer.valueOf(100));
        subscriptionThrottlePolicyDTO.setRateLimitTimeUnit("min");
        subscriptionThrottlePolicyDTO.setBillingPlan("COMMERCIAL");
        subscriptionThrottlePolicyDTO.setStopOnQuotaReach(Boolean.valueOf(true));
        subscriptionThrottlePolicyDTO.setIsDeployed(Boolean.valueOf(true));
        subscriptionThrottlePolicyDTO.setGraphQLMaxComplexity(Integer.valueOf(3));
        subscriptionThrottlePolicyDTO.setGraphQLMaxDepth(Integer.valueOf(1));
        subscriptionThrottlePolicyDTO.setSubscriberCount(Integer.valueOf(0));
        ThrottleLimitDTO throttleLimitDTO = new ThrottleLimitDTO();
        throttleLimitDTO.setType(ThrottleLimitDTO.TypeEnum.valueOf((String)"REQUESTCOUNTLIMIT"));
        RequestCountLimitDTO requestCountLimitDTO = new RequestCountLimitDTO();
        requestCountLimitDTO.setRequestCount(Long.valueOf(1000L));
        requestCountLimitDTO.setTimeUnit("min");
        requestCountLimitDTO.setUnitTime(Integer.valueOf(10));
        throttleLimitDTO.setRequestCount(requestCountLimitDTO);
        subscriptionThrottlePolicyDTO.setDefaultLimit(throttleLimitDTO);
    }

    private void invokeGraphQLSubscriptionScopeInvalidError(WebSocketClient client, String accessToken) throws Exception {
        SubscriptionWSClientImpl socket = new SubscriptionWSClientImpl();
        client.start();
        ClientUpgradeRequest request = new ClientUpgradeRequest();
        URI echoUri = new URI(this.apiEndPoint);
        request.setHeader("Authorization", "Bearer " + accessToken);
        request.setSubProtocols(new String[]{"graphql-ws"});
        client.connect((Object)socket, echoUri, request);
        if (!socket.getLatch().await(30L, TimeUnit.SECONDS)) {
            throw new APIManagerIntegrationTestException("Unable to create client connection");
        }
        String textMessage = "{\"type\":\"connection_init\",\"payload\":{}}";
        Thread.sleep(20000L);
        socket.sendMessage(textMessage);
        Thread.sleep(20000L);
        this.waitForReply(socket);
        Thread.sleep(20000L);
        Assert.assertFalse((boolean)StringUtils.isEmpty((String)socket.getResponseMessage()), (String)"Client did not receive response from server");
        Assert.assertEquals((String)socket.getResponseMessage(), (String)"{\"type\":\"connection_ack\"}", (String)"Received response in not a Connection Ack response");
        socket.setResponseMessage(null);
        textMessage = "{\"id\":\"1\",\"type\":\"start\",\"payload\":{\"variables\":{},\"extensions\":{},\"operationName\":null,\"query\":\"subscription {\\n  liftStatusChange {\\n    name\\n  }\\n}\\n\"}}";
        socket.sendMessage(textMessage);
        this.waitForReply(socket);
        Assert.assertFalse((boolean)StringUtils.isEmpty((String)socket.getResponseMessage()), (String)"Client did not receive response from server");
        String errorMessage = socket.getResponseMessage();
        Assert.assertNotNull((Object)errorMessage);
        JSONParser jsonParser = new JSONParser();
        JSONObject errorJson = (JSONObject)jsonParser.parse(errorMessage);
        Assert.assertTrue((boolean)errorJson.containsKey((Object)"type"));
        Assert.assertEquals((Object)errorJson.get((Object)"type"), (Object)"error");
        Assert.assertTrue((boolean)errorJson.containsKey((Object)"id"));
        Assert.assertEquals((Object)errorJson.get((Object)"id"), (Object)"1");
        Assert.assertTrue((boolean)errorJson.containsKey((Object)"payload"));
        JSONObject payload = (JSONObject)((org.json.simple.JSONArray)errorJson.get((Object)"payload")).get(0);
        Assert.assertTrue((boolean)payload.containsKey((Object)"message"));
        Assert.assertTrue((boolean)payload.containsKey((Object)"code"));
        Assert.assertEquals((Object)payload.get((Object)"message"), (Object)"User is NOT authorized to access the Resource: liftStatusChange. Scope validation failed.", (String)"Received response in a invalid error message");
        Assert.assertEquals((Object)payload.get((Object)"code"), (Object)4002L, (String)"Received response code is a invalid response code");
    }

    private void invokeGraphQLSubscriptionForComplexityError(WebSocketClient client, String accessToken) throws Exception {
        SubscriptionWSClientImpl socket = new SubscriptionWSClientImpl();
        client.start();
        ClientUpgradeRequest request = new ClientUpgradeRequest();
        URI echoUri = new URI(this.apiEndPoint);
        request.setHeader("Authorization", "Bearer " + accessToken);
        request.setSubProtocols(new String[]{"graphql-ws"});
        client.connect((Object)socket, echoUri, request);
        if (!socket.getLatch().await(30L, TimeUnit.SECONDS)) {
            throw new APIManagerIntegrationTestException("Unable to create client connection");
        }
        String textMessage = "{\"type\":\"connection_init\",\"payload\":{}}";
        Thread.sleep(20000L);
        socket.sendMessage(textMessage);
        Thread.sleep(20000L);
        this.waitForReply(socket);
        Thread.sleep(20000L);
        Assert.assertFalse((boolean)StringUtils.isEmpty((String)socket.getResponseMessage()), (String)"Client did not receive response from server");
        Assert.assertEquals((String)socket.getResponseMessage(), (String)"{\"type\":\"connection_ack\"}", (String)"Received response in not a Connection Ack response");
        socket.setResponseMessage(null);
        textMessage = "{\"id\":\"1\",\"type\":\"start\",\"payload\":{\"variables\":{},\"extensions\":{},\"operationName\":null,\"query\": \"subscription {\\n  liftStatusChange {\\n name\\n id\\n status\\n night\\n capacity\\n }\\n}\\n\"}}";
        socket.sendMessage(textMessage);
        this.waitForReply(socket);
        Assert.assertFalse((boolean)StringUtils.isEmpty((String)socket.getResponseMessage()), (String)"Client did not receive response from server");
        String errorMessage = socket.getResponseMessage();
        Assert.assertNotNull((Object)errorMessage);
        JSONParser jsonParser = new JSONParser();
        JSONObject errorJson = (JSONObject)jsonParser.parse(errorMessage);
        Assert.assertTrue((boolean)errorJson.containsKey((Object)"type"));
        Assert.assertEquals((Object)errorJson.get((Object)"type"), (Object)"error");
        Assert.assertTrue((boolean)errorJson.containsKey((Object)"id"));
        Assert.assertEquals((Object)errorJson.get((Object)"id"), (Object)"1");
        Assert.assertTrue((boolean)errorJson.containsKey((Object)"payload"));
        JSONObject payload = (JSONObject)((org.json.simple.JSONArray)errorJson.get((Object)"payload")).get(0);
        Assert.assertTrue((boolean)payload.containsKey((Object)"message"));
        Assert.assertTrue((boolean)payload.containsKey((Object)"code"));
        Assert.assertTrue((boolean)((String)payload.get((Object)"message")).contains("QUERY TOO COMPLEX"), (String)"Invalid query too complex error");
        Assert.assertTrue((boolean)((String)payload.get((Object)"message")).contains("maximum query complexity exceeded"), (String)"Invalid query too complex error");
        Assert.assertEquals((Object)payload.get((Object)"code"), (Object)4021L, (String)"Received response code is a invalid response code");
    }

    private void invokeGraphQLSubscriptionForDepthError(WebSocketClient client, String accessToken) throws Exception {
        SubscriptionWSClientImpl socket = new SubscriptionWSClientImpl();
        client.start();
        ClientUpgradeRequest request = new ClientUpgradeRequest();
        URI echoUri = new URI(this.apiEndPoint);
        request.setHeader("Authorization", "Bearer " + accessToken);
        request.setSubProtocols(new String[]{"graphql-ws"});
        client.connect((Object)socket, echoUri, request);
        if (!socket.getLatch().await(30L, TimeUnit.SECONDS)) {
            throw new APIManagerIntegrationTestException("Unable to create client connection");
        }
        String textMessage = "{\"type\":\"connection_init\",\"payload\":{}}";
        Thread.sleep(40000L);
        socket.sendMessage(textMessage);
        Thread.sleep(30000L);
        this.waitForReply(socket);
        Thread.sleep(30000L);
        Assert.assertFalse((boolean)StringUtils.isEmpty((String)socket.getResponseMessage()), (String)"Client did not receive response from server");
        Assert.assertEquals((String)socket.getResponseMessage(), (String)"{\"type\":\"connection_ack\"}", (String)"Received response in not a Connection Ack response");
        socket.setResponseMessage(null);
        textMessage = "{\"id\":\"1\",\"type\":\"start\",\"payload\":{\"variables\":{},\"extensions\":{},\"operationName\":null,\"query\": \"subscription {\\n  liftStatusChange {\\n name\\n}\\n}\\n\"}}";
        socket.sendMessage(textMessage);
        this.waitForReply(socket);
        Assert.assertFalse((boolean)StringUtils.isEmpty((String)socket.getResponseMessage()), (String)"Client did not receive response from server");
        String errorMessage = socket.getResponseMessage();
        Assert.assertNotNull((Object)errorMessage);
        JSONParser jsonParser = new JSONParser();
        JSONObject errorJson = (JSONObject)jsonParser.parse(errorMessage);
        Assert.assertTrue((boolean)errorJson.containsKey((Object)"type"));
        Assert.assertEquals((Object)errorJson.get((Object)"type"), (Object)"error");
        Assert.assertTrue((boolean)errorJson.containsKey((Object)"id"));
        Assert.assertEquals((Object)errorJson.get((Object)"id"), (Object)"1");
        Assert.assertTrue((boolean)errorJson.containsKey((Object)"payload"));
        JSONObject payload = (JSONObject)((org.json.simple.JSONArray)errorJson.get((Object)"payload")).get(0);
        Assert.assertTrue((boolean)payload.containsKey((Object)"message"));
        Assert.assertTrue((boolean)payload.containsKey((Object)"code"));
        Assert.assertTrue((boolean)((String)payload.get((Object)"message")).contains("QUERY TOO DEEP"), (String)"Invalid query too deep error");
        Assert.assertTrue((boolean)((String)payload.get((Object)"message")).contains("maximum query depth exceeded 2 > 1"), (String)"Invalid query too deep error message");
        Assert.assertEquals((Object)payload.get((Object)"code"), (Object)4020L, (String)"Received response code is a invalid response code");
    }

    private void invokeGraphQLSubscriptionForInvalidPayloadError(WebSocketClient client, String accessToken) throws Exception {
        SubscriptionWSClientImpl socket = new SubscriptionWSClientImpl();
        client.start();
        ClientUpgradeRequest request = new ClientUpgradeRequest();
        URI echoUri = new URI(this.apiEndPoint);
        request.setHeader("Authorization", "Bearer " + accessToken);
        request.setSubProtocols(new String[]{"graphql-ws"});
        client.connect((Object)socket, echoUri, request);
        if (!socket.getLatch().await(30L, TimeUnit.SECONDS)) {
            throw new APIManagerIntegrationTestException("Unable to create client connection");
        }
        String textMessage = "{\"type\":\"connection_init\",\"payload\":{}}";
        Thread.sleep(40000L);
        socket.sendMessage(textMessage);
        Thread.sleep(30000L);
        this.waitForReply(socket);
        Thread.sleep(30000L);
        Assert.assertFalse((boolean)StringUtils.isEmpty((String)socket.getResponseMessage()), (String)"Client did not receive response from server");
        Assert.assertEquals((String)socket.getResponseMessage(), (String)"{\"type\":\"connection_ack\"}", (String)"Received response in not a Connection Ack response");
        socket.setResponseMessage(null);
        textMessage = "{\"id\":\"1\",\"type\":\"start\",\"payload\":{\"variables\":{},\"extensions\":{},\"operationName\":null,\"query\": \"subscription {\\n  liftStatusChange {\\n name\\n invalidField\\n }\\n}\\n\"}}";
        socket.sendMessage(textMessage);
        this.waitForReply(socket);
        Assert.assertFalse((boolean)StringUtils.isEmpty((String)socket.getResponseMessage()), (String)"Client did not receive response from server");
        String errorMessage = socket.getResponseMessage();
        Assert.assertNotNull((Object)errorMessage);
        JSONParser jsonParser = new JSONParser();
        JSONObject errorJson = (JSONObject)jsonParser.parse(errorMessage);
        Assert.assertTrue((boolean)errorJson.containsKey((Object)"type"));
        Assert.assertEquals((Object)errorJson.get((Object)"type"), (Object)"error");
        Assert.assertTrue((boolean)errorJson.containsKey((Object)"id"));
        Assert.assertEquals((Object)errorJson.get((Object)"id"), (Object)"1");
        Assert.assertTrue((boolean)errorJson.containsKey((Object)"payload"));
        JSONObject payload = (JSONObject)((org.json.simple.JSONArray)errorJson.get((Object)"payload")).get(0);
        Assert.assertTrue((boolean)payload.containsKey((Object)"message"));
        Assert.assertTrue((boolean)payload.containsKey((Object)"code"));
        Assert.assertTrue((boolean)((String)payload.get((Object)"message")).contains("INVALID QUERY"), (String)"Invalid query payload error not received");
        Assert.assertEquals((Object)payload.get((Object)"code"), (Object)4022L, (String)"Received response code is a invalid response code");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testThrottling(String accessToken) throws Exception {
        GraphqlSubscriptionTestCase.waitUntilClockHour();
        int startingDistinctUnitTime = LocalDateTime.now().getMinute();
        int limit = 4;
        WebSocketClient client = new WebSocketClient();
        SubscriptionWSClientImpl socket = new SubscriptionWSClientImpl();
        client.start();
        URI echoUri = new URI(this.apiEndPoint);
        ClientUpgradeRequest request = new ClientUpgradeRequest();
        request.setHeader("Authorization", "Bearer " + accessToken);
        request.setSubProtocols(new String[]{"graphql-ws"});
        client.connect((Object)socket, echoUri, request);
        socket.getLatch().await(3L, TimeUnit.SECONDS);
        try {
            String textMessage = "{\"type\":\"connection_init\",\"payload\":{}}";
            Thread.sleep(10000L);
            socket.sendMessage(textMessage);
            this.waitForReply(socket);
            Assert.assertFalse((boolean)StringUtils.isEmpty((String)socket.getResponseMessage()), (String)"Client did not receive response from server");
            Assert.assertEquals((String)socket.getResponseMessage(), (String)"{\"type\":\"connection_ack\"}", (String)"Received response in not a Connection Ack response");
            socket.setResponseMessage(null);
            for (int count = 1; count <= limit; ++count) {
                if (count == 1) {
                    textMessage = "{\"id\":\"2\",\"type\":\"start\",\"payload\":{\"variables\":{},\"extensions\":{},\"operationName\":null,\"query\": \"subscription {\\n  liftStatusChange {\\n name\\n }\\n}\\n\"}}";
                    socket.sendMessage(textMessage);
                }
                this.waitForReply(socket);
                String responseMessage = socket.getResponseMessage();
                log.info((Object)("Count :" + count + " Message :" + responseMessage));
                if (count == limit) {
                    if (LocalDateTime.now().getMinute() != startingDistinctUnitTime) {
                        log.info((Object)"Repeating the test as throttling testing time duration is dispersed into two separate units of time");
                        this.testThrottling(accessToken);
                    }
                    Assert.assertNotNull((Object)responseMessage);
                    JSONParser jsonParser = new JSONParser();
                    JSONObject errorJson = (JSONObject)jsonParser.parse(responseMessage);
                    Assert.assertTrue((boolean)errorJson.containsKey((Object)"type"));
                    Assert.assertEquals((Object)errorJson.get((Object)"type"), (Object)"error");
                    Assert.assertTrue((boolean)errorJson.containsKey((Object)"id"));
                    Assert.assertEquals((Object)errorJson.get((Object)"id"), (Object)"2");
                    Assert.assertTrue((boolean)errorJson.containsKey((Object)"payload"));
                    JSONObject payload = (JSONObject)((org.json.simple.JSONArray)errorJson.get((Object)"payload")).get(0);
                    Assert.assertTrue((boolean)payload.containsKey((Object)"message"));
                    Assert.assertTrue((boolean)payload.containsKey((Object)"code"));
                    Assert.assertTrue((boolean)((String)payload.get((Object)"message")).contains("Websocket frame throttled out"), (String)"Received response is not matching");
                    Assert.assertEquals((Object)payload.get((Object)"code"), (Object)4003L, (String)"Received response code is a invalid response code");
                }
                socket.setResponseMessage(null);
            }
        }
        catch (Exception ex) {
            log.error((Object)"Error occurred while calling API.", (Throwable)ex);
            Assert.fail((String)"Client cannot connect to server");
        }
        finally {
            client.stop();
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.userManagementClient.deleteRole(GRAPHQL_ROLE);
        this.userManagementClient.deleteUser("graphqlSubUser");
        this.restAPIStore.deleteApplication(this.appJWTId);
        this.restAPIStore.deleteApplication(this.complexAppId);
        this.restAPIStore.deleteApplication(this.depthAppId);
        this.restAPIStore.deleteApplication(this.throttleAppId);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.graphqlApiId, this.restAPIPublisher);
        this.executorService.shutdownNow();
        super.cleanUp();
    }

    private static enum AUTH_IN {
        HEADER,
        QUERY;

    }
}

