/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.graphql.websocket.client;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;

@WebSocket
public class SubscriptionWSClientImpl {
    private Session session;
    private final Log log = LogFactory.getLog(SubscriptionWSClientImpl.class);
    private String responseMessage;
    private final CountDownLatch latch = new CountDownLatch(1);

    @OnWebSocketMessage
    public void onText(Session session, String message) {
        this.setResponseMessage(message);
        this.log.info((Object)("Client received message:" + message));
    }

    @OnWebSocketConnect
    public void onConnect(Session session) {
        this.log.info((Object)"Connected to server");
        this.session = session;
        this.latch.countDown();
    }

    public void sendMessage(String str) throws APIManagerIntegrationTestException {
        try {
            if (this.session == null) {
                throw new APIManagerIntegrationTestException("Client session is null");
            }
            this.session.getRemote().sendString(str);
        }
        catch (IOException e) {
            this.log.error((Object)"Error while sending message from client: ", (Throwable)e);
        }
    }

    public CountDownLatch getLatch() {
        return this.latch;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public void setResponseMessage(String responseMessage) {
        this.responseMessage = responseMessage;
    }
}

