/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.graphql.websocket.server;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.testng.Assert;

@WebSocket
public class SubscriptionWSServerImpl {
    private final Log log = LogFactory.getLog(SubscriptionWSServerImpl.class);

    @OnWebSocketMessage
    public void onText(Session session, String message) throws IOException {
        this.log.info((Object)("Server received message:" + message));
        String response = message;
        if (session.isOpen()) {
            JSONParser jsonParser = new JSONParser();
            try {
                boolean isThrottleInitRequest = false;
                JSONObject clientMessage = (JSONObject)jsonParser.parse(message);
                if (clientMessage.containsKey((Object)"type")) {
                    String messageType = (String)clientMessage.get((Object)"type");
                    if ("connection_init".equals(messageType)) {
                        response = "{\"type\":\"connection_ack\"}";
                    } else if ("start".equals(messageType)) {
                        String messageId = (String)clientMessage.get((Object)"id");
                        if ("2".equals(messageId)) {
                            isThrottleInitRequest = true;
                            for (int i = 1; i < 5; ++i) {
                                response = "{\"type\":\"data\",\"id\":\"2\",\"payload\":{\"data\":{\"liftStatusChange\":{\"name\":\"Astra Express\"}}}}";
                                Thread.sleep(1000L);
                                session.getRemote().sendString(response);
                            }
                        } else {
                            response = "{\"type\":\"data\",\"id\":\"1\",\"payload\":{\"data\":{\"liftStatusChange\":{\"name\":\"Astra Express\"}}}}";
                        }
                    }
                } else {
                    response = "Invalid message type";
                }
                if (!isThrottleInitRequest) {
                    session.getRemote().sendString(response);
                }
            }
            catch (ParseException e) {
                this.log.error((Object)("Invalid json message received to GraphQL Subscription backend: " + message));
                Assert.fail((String)"Invalid json message received to GraphQL Subscription backend");
            }
            catch (InterruptedException e) {
                Assert.fail((String)"Error handling response for throttling");
            }
        }
    }

    @OnWebSocketConnect
    public void onConnect(Session session) {
        session.getUpgradeResponse().setAcceptedSubProtocol("graphql-ws");
        this.log.info((Object)(session.getRemoteAddress().getHostName() + " connected!"));
    }

    @OnWebSocketClose
    public void onClose(Session session, int status, String reason) {
        this.log.info((Object)(session.getRemoteAddress().getHostName() + " closed!"));
    }
}

