/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.header;

import java.io.File;
import java.util.HashMap;
import org.apache.axiom.om.OMElement;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.am.integration.tests.header.util.SimpleSocketServer;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.admin.client.AuthenticatorClient;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class APIMANAGER3614DuplicateTransferEncodingHeaderTestCase
extends APIMIntegrationBaseTest {
    private SimpleSocketServer simpleSocketServer;

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init();
        AuthenticatorClient login = new AuthenticatorClient(this.gatewayContextWrk.getContextUrls().getBackEndUrl());
        String session = login.login("admin", "admin", "localhost");
        String file = "artifacts" + File.separator + "AM" + File.separator + "synapseconfigs" + File.separator + "property" + File.separator + "duplicate_transfer_encoding.xml";
        OMElement synapseConfig = APIMTestCaseUtils.loadResource((String)file);
        APIMTestCaseUtils.updateSynapseConfiguration((OMElement)synapseConfig, (String)this.gatewayContextWrk.getContextUrls().getBackEndUrl(), (String)session);
        int port = 9785;
        String expectedResponse = "HTTP/1.0 200 OK\r\nServer: testServer\r\nContent-Type: text/html\r\nTransfer-Encoding: chunked\r\nTransfer-Encoding: chunked\r\n\r\n<HTML>\n<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n<HEAD>\n <TITLE>Test Server Results</TITLE>\n</HEAD>\n\n<BODY BGCOLOR=\"#FDF5E6\">\n<H1 ALIGN=\"CENTER\"> Results</H1>\nHere is the request line and request headers\nsent by your browser:\n<PRE>\r\n0\r\n";
        this.simpleSocketServer = new SimpleSocketServer(port, expectedResponse);
        this.simpleSocketServer.start();
        Thread.sleep(10000L);
    }

    @Test(groups={"wso2.am"}, description="Test for reading the duplicate transfer-encoding header in the response")
    public void testDuplicateTransferEncodingPropertyTest() throws Exception {
        String endPoint = this.getAPIInvocationURLHttp("helloService");
        HttpResponse httpResponse = HttpRequestUtil.doGet((String)endPoint, new HashMap());
        Assert.assertNotNull((Object)httpResponse, (String)"Response should be available");
        Assert.assertEquals((int)httpResponse.getResponseCode(), (int)200, (String)"Response should be success");
    }

    @AfterClass(alwaysRun=true)
    public void stop() throws Exception {
        this.simpleSocketServer.shutdown();
        super.cleanUp();
    }
}

