/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.header;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.ws.rs.core.Response;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.json.JSONException;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO;
import org.wso2.am.integration.clients.store.api.ApiException;
import org.wso2.am.integration.clients.store.api.ApiResponse;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APILifeCycleAction;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.engine.context.beans.User;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class CORSAccessControlAllowCredentialsHeaderTestCase
extends APIManagerLifecycleBaseTest {
    private static final String API_NAME_2 = "CorsACACHeadersTestAPI_2";
    private static final String APPLICATION_NAME_2 = "CorsACACApp_2";
    private static final String API_CONTEXT_2 = "corsACACHeadersTestAPI_2";
    private static final String API_VERSION = "1.0.0";
    private static final String TAGS = "ACAC, cors, test";
    private static final String DESCRIPTION = "This is test API create by API manager integration test";
    private static final String ACCESS_CONTROL_ALLOW_ORIGIN_HEADER = "Access-Control-Allow-Origin";
    private static final String ACCESS_CONTROL_ALLOW_ORIGIN_HEADER_VALUE_LOCALHOST = "http://localhost";
    private static final String ACCESS_CONTROL_ALLOW_CREDENTIALS_HEADER = "Access-Control-Allow-Credentials";
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private String accessToken;
    private String apiId;
    private String applicationId;
    Log log = LogFactory.getLog(CORSAccessControlAllowCredentialsHeaderTestCase.class);

    @BeforeClass(alwaysRun=true)
    public void initialize() throws Exception {
        super.init(this.userMode);
    }

    @Test(groups={"wso2.am"}, description="Checking Access-Control-Allow-Credentials header in response when Access-Control-Allow-Origin is 'http://localhost'")
    public void CheckAccessControlAllowCredentialsHeadersWithSpecificOrigin() throws Exception {
        this.accessToken = this.createPublishAndSubscribeToApi(this.user, API_NAME_2, API_CONTEXT_2, API_VERSION, APPLICATION_NAME_2);
        this.waitForAPIDeploymentSync(this.user.getUserName(), API_NAME_2, API_VERSION, "\"isApiExists\":true");
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(this.getAPIInvocationURLHttps(API_CONTEXT_2, API_VERSION) + "/customers/123");
        get.addHeader("Origin", ACCESS_CONTROL_ALLOW_ORIGIN_HEADER_VALUE_LOCALHOST);
        get.addHeader("Authorization", "Bearer " + this.accessToken);
        HttpResponse response = httpclient.execute((HttpUriRequest)get);
        ArrayList<Integer> responseCodes = new ArrayList<Integer>();
        responseCodes.add(HTTP_RESPONSE_CODE_OK);
        responseCodes.add(HTTP_RESPONSE_CODE_CREATED);
        Assert.assertTrue((boolean)responseCodes.contains(response.getStatusLine().getStatusCode()), (String)"Response code mismatch.");
        Header[] responseHeaders = response.getAllHeaders();
        this.log.info((Object)"Response Headers: CheckAccessControlAllowCredentialsHeadersWithAnyOrigin");
        for (Header header : responseHeaders) {
            this.log.info((Object)(header.getName() + " : " + header.getValue()));
        }
        Header header = this.pickHeader(responseHeaders, ACCESS_CONTROL_ALLOW_ORIGIN_HEADER);
        Assert.assertNotNull((Object)header, (String)"Access-Control-Allow-Origin header is not available in the response.");
        Assert.assertNotNull((Object)this.pickHeader(responseHeaders, ACCESS_CONTROL_ALLOW_CREDENTIALS_HEADER), (String)"Access-Control-Allow-Credentials header is not available in the response.");
    }

    private String createPublishAndSubscribeToApi(User user, String apiName, String apiContext, String apiVersion, String appName) throws APIManagerIntegrationTestException, XPathExpressionException, MalformedURLException, org.wso2.am.integration.clients.publisher.api.ApiException, ApiException, JSONException {
        String providerName = user.getUserName();
        String apiEndPointUrl = this.backEndServerUrl.getWebAppURLHttps() + "jaxrs_basic/services/customers/customerservice/";
        APIRequest apiRequest = new APIRequest(apiName, apiContext, new URL(apiEndPointUrl), true);
        apiRequest.setTags(TAGS);
        apiRequest.setDescription(DESCRIPTION);
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setProvider(providerName);
        APIOperationsDTO apiOperationsDTO1 = new APIOperationsDTO();
        apiOperationsDTO1.setVerb("GET");
        apiOperationsDTO1.setTarget("/customers/{id}");
        apiOperationsDTO1.setAuthType("Application & Application User");
        apiOperationsDTO1.setThrottlingPolicy("Unlimited");
        ArrayList<APIOperationsDTO> operationsDTOS = new ArrayList<APIOperationsDTO>();
        operationsDTOS.add(apiOperationsDTO1);
        apiRequest.setOperationsDTOS(operationsDTOS);
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse apiResponse = this.restAPIPublisher.addAPI(apiRequest);
        this.apiId = apiResponse.getData();
        this.createAPIRevisionAndDeployUsingRest(this.apiId, this.restAPIPublisher);
        this.waitForAPIDeployment();
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, APILifeCycleAction.PUBLISH.getAction(), null);
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse applicationResponse = this.restAPIStore.createApplication(appName, "50PerMin", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
        this.applicationId = applicationResponse.getData();
        this.restAPIStore.createSubscription(this.apiId, this.applicationId, "Unlimited");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("password");
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.applicationId, "36000", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        this.accessToken = applicationKeyDTO.getToken().getAccessToken();
        return this.accessToken;
    }

    @Test(groups={"wso2.am"}, description="Test generation of all supported SDKs", dependsOnMethods={"CheckAccessControlAllowCredentialsHeadersWithSpecificOrigin"})
    public void testAllSupportedSDKGeneration() throws Exception {
        String[] languages;
        for (String language : languages = new String[]{"android", "java", "csharp", "dart", "groovy", "javascript", "jmeter", "perl", "php", "python", "ruby", "swift5", "clojure"}) {
            ApiResponse sdkGenerationResponse = this.restAPIStore.generateSDKUpdated(this.apiId, language, this.user.getUserDomain());
            Assert.assertEquals((int)sdkGenerationResponse.getStatusCode(), (int)Response.Status.OK.getStatusCode(), (String)("Error when generating SDK for the " + language + " language"));
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIStore.deleteApplication(this.applicationId);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.apiId, this.restAPIPublisher);
        this.restAPIPublisher.deleteAPI(this.apiId);
        super.cleanUp();
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @Factory(dataProvider="userModeDataProvider")
    public CORSAccessControlAllowCredentialsHeaderTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }
}

